/*
 * Decompiled with CFR 0.152.
 */
package com.tenginekit;

import android.graphics.Bitmap;
import com.tenginekit.AndroidConfig;
import com.tenginekit.KitCore;
import com.tenginekit.jni.FaceSchedule;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class Image {
    private static AndroidConfig.ImageFormat _InputImageFormat = null;
    private static AndroidConfig.ImageFormat _OutputImageFormat = null;

    private static synchronized void createHandler(AndroidConfig.ImageFormat imageInputFormat, AndroidConfig.ImageFormat imageOutputFormat) {
        FaceSchedule.createHandler(imageInputFormat.toString(), imageOutputFormat.toString());
    }

    public static synchronized Bitmap convertImage(Bitmap bitmap, int inputX1, int inputY1, int inputX2, int inputY2, int outputW, int outputH, int rotation, boolean mirror) {
        if (bitmap == null) {
            return null;
        }
        int imageWidth = bitmap.getWidth();
        int imageHeight = bitmap.getHeight();
        byte[] imageDate = Image.getPixelsRGBA(bitmap);
        byte[] result = Image.convertImage(imageDate, AndroidConfig.ImageFormat.RGBA, AndroidConfig.ImageFormat.RGBA, imageWidth, imageHeight, inputX1, inputY1, inputX2, inputY2, outputW, outputH, rotation, mirror);
        Bitmap OutputBitmap = Image.setPixelsRGBA(result, outputW, outputH);
        return OutputBitmap;
    }

    public static synchronized byte[] convertCameraYUVData(byte[] data, AndroidConfig.ImageFormat imageOutputFormat, int inputW, int inputH, int outputW, int outputH, int rotation, boolean mirror) {
        return Image.convertImage(data, AndroidConfig.ImageFormat.YUV_NV21, imageOutputFormat, inputW, inputH, 0, 0, inputW, inputH, outputW, outputH, rotation, mirror);
    }

    public static synchronized Bitmap convertCameraYUVData(byte[] data, int inputW, int inputH, int outputW, int outputH, int rotation, boolean mirror) {
        byte[] result = Image.convertImage(data, AndroidConfig.ImageFormat.YUV_NV21, AndroidConfig.ImageFormat.RGBA, inputW, inputH, 0, 0, inputW, inputH, outputW, outputH, rotation, mirror);
        if (result == null) {
            return null;
        }
        Bitmap OutputBitmap = Image.setPixelsRGBA(result, outputW, outputH);
        return OutputBitmap;
    }

    public static synchronized byte[] convertImage(byte[] data, AndroidConfig.ImageFormat imageInputFormat, AndroidConfig.ImageFormat imageOutputFormat, int inputW, int inputH, int inputX1, int inputY1, int inputX2, int inputY2, int outputW, int outputH, int rotation, boolean mirror) {
        if (!KitCore.getInit()) {
            throw new RuntimeException("SDK not init");
        }
        if (data == null || data.length == 0) {
            return null;
        }
        if (inputW == 0 || inputH == 0) {
            return null;
        }
        if (outputW == 0 || outputH == 0) {
            return null;
        }
        if (inputX1 >= inputX2 || inputY1 >= inputY2) {
            return null;
        }
        if (_InputImageFormat != imageInputFormat || _OutputImageFormat != imageOutputFormat) {
            _InputImageFormat = imageInputFormat;
            _OutputImageFormat = imageOutputFormat;
            Image.createHandler(_InputImageFormat, _OutputImageFormat);
        }
        byte[] result = FaceSchedule.handleImage(data, inputW, inputH, inputX1, inputY1, inputX2, inputY2, outputW, outputH, rotation, mirror);
        return result;
    }

    private static byte[] getPixelsRGBA(Bitmap image) {
        int bytes = image.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        image.copyPixelsToBuffer((Buffer)buffer);
        byte[] temp = buffer.array();
        return temp;
    }

    private static Bitmap setPixelsRGBA(byte[] byteArray, int ImageW, int ImageH) {
        Bitmap image1 = Bitmap.createBitmap((int)ImageW, (int)ImageH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.get(byteArray);
        Buffer temp = buffer.rewind();
        image1.copyPixelsFromBuffer(temp);
        return image1;
    }
}

