/*
 * Decompiled with CFR 0.152.
 */
package com.tenginekit;

import androidx.annotation.Keep;
import java.util.ArrayList;
import java.util.List;

public class AndroidConfig {
    public List<Func> openFuncList = new ArrayList<Func>();
    public int inputImageW;
    public int inputImageH;
    public int outputImageW;
    public int outputImageH;
    public ImageFormat imageFormat = ImageFormat.RGB;
    public HandleMode handleMode = HandleMode.Camera;

    public AndroidConfig openFunc(Func func) {
        this.openFuncList.add(func);
        return this;
    }

    public AndroidConfig setInputImageSize(int w, int h) {
        this.inputImageW = w;
        this.inputImageH = h;
        return this;
    }

    public AndroidConfig setOutputImageSize(int w, int h) {
        this.outputImageW = w;
        this.outputImageH = h;
        return this;
    }

    public AndroidConfig setInputImageFormat(ImageFormat imageFormat) {
        this.imageFormat = imageFormat;
        return this;
    }

    public AndroidConfig setDefaultFunc() {
        this.openFunc(Func.Detect);
        this.openFunc(Func.Landmark);
        return this;
    }

    public AndroidConfig setDefaultInputImageFormat() {
        this.setInputImageFormat(ImageFormat.YUV_NV21);
        return this;
    }

    public AndroidConfig setCameraMode() {
        this.handleMode = HandleMode.Camera;
        return this;
    }

    public AndroidConfig setNormalMode() {
        this.handleMode = HandleMode.Normal;
        return this;
    }

    public static AndroidConfig create() {
        return new AndroidConfig();
    }

    @Keep
    public static enum ImageFormat {
        YUV_NV21,
        RGB,
        RGBA,
        GRAY;

    }

    @Keep
    public static enum HandleMode {
        Normal,
        Camera;

    }

    @Keep
    public static enum Func {
        Detect,
        Landmark,
        Attribution,
        BlazeFace,
        FaceMesh,
        Iris,
        BodyDetect,
        BlazePoseDetect,
        BlazePoseLandmark,
        HandDetect,
        HandLandmark3d;

    }
}

