package com.tenginekit;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;

import com.tenginekit.jni.FaceSchedule;
import com.tenginekit.utils.DeviceUtil;

import static android.content.Context.MODE_PRIVATE;

public class KitCore {
    static private Context mContext;
    static private String UUID = "unknow";
    static private String PACKAGENAME = "unknow";
    static private boolean inited = false;

    static private void setContext(Context context)
    {
        mContext = context;
    }

    static private Context getContext()
    {
        return mContext;
    }

    static private void setUUID(String uuid)
    {
        UUID = uuid;
    }

    static private String getUUID()
    {
        return UUID;
    }

    static private void setPackageName(String name)
    {
        PACKAGENAME = name;
    }

    static private String getPackageName()
    {
        return PACKAGENAME;
    }

    static private void setInit(boolean is)
    {
        inited = is;
    }

    static public boolean getInit()
    {
        return inited;
    }

    synchronized public static void init(Context context, AndroidConfig config) {
        if (KitCore.getInit()) return;
        if (context == null){
            throw new RuntimeException("Context is NULL");
        }
        KitCore.setContext(context);
        getID();
        if (config.openFuncList != null) {
            for (int i = 0; i < config.openFuncList.size(); i++) {
                String funcName = config.openFuncList.get(i).toString();
                FaceSchedule.setFunc(funcName);
            }
        }

        FaceSchedule.init(context.getAssets(), config.inputImageW, config.inputImageH,
                config.outputImageW, config.outputImageH, config.imageFormat.toString(), String.valueOf(config.handleMode), KitCore.getPackageName(), KitCore.getUUID());
        KitCore.setInit(true);
    }

    synchronized public static void release() {
        if (!KitCore.getInit()) return;
        FaceSchedule.release();
        KitCore.setInit(false);
    }

    public static class Camera{
        synchronized static public void setRotation(int ori, boolean isScreenRotate, int outputW, int outputH) {
            if (!KitCore.getInit()) return;
            FaceSchedule.setOri(ori, isScreenRotate, outputW, outputH);
        }
        /**
         * Switch cameras
         */
        synchronized static public void switchCamera(boolean back) {
            if (!KitCore.getInit()) return;
            if (back)
                FaceSchedule.switchCamera(1);
            else
                FaceSchedule.switchCamera(0);
        }
    }



    static private void getID() {
        try {
            String readDeviceID = DeviceUtil.readDeviceID(KitCore.getContext());
            SharedPreferences mShare = KitCore.getContext().getSharedPreferences("uuid", MODE_PRIVATE);
            String string = mShare.getString("uuid", "");
            if (string != null) {
                if (readDeviceID == null && !TextUtils.equals(string, readDeviceID)) {
                    if (TextUtils.isEmpty(readDeviceID) && !TextUtils.isEmpty(string)) {
                        readDeviceID = string;
                        DeviceUtil.saveDeviceID(readDeviceID, KitCore.getContext());
                    }
                }
            }
            if (readDeviceID == null) {
                //保存设备id
                readDeviceID = DeviceUtil.getDeviceId(KitCore.getContext());
            }
            mShare.edit().putString("uuid", readDeviceID).apply();

            PackageManager packageManager = KitCore.getContext().getPackageManager();
            int flag = PackageManager.GET_UNINSTALLED_PACKAGES;

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                flag = PackageManager.MATCH_UNINSTALLED_PACKAGES;
            }
            String _packageName = "";
            try {
                PackageManager packageManager1 = KitCore.getContext().getPackageManager();
                PackageInfo packageInfo = packageManager1.getPackageInfo(KitCore.getContext().getPackageName(), 0);
                _packageName = packageInfo.packageName;

            } catch (Exception e) {

                e.printStackTrace();
            }
            KitCore.setUUID(readDeviceID);
            KitCore.setPackageName(_packageName);
        } catch (Exception e) {
            KitCore.setUUID("unknow");
            KitCore.setPackageName("unknow");
            e.printStackTrace();
        }
    }
}
