package com.tenginekit;

import android.graphics.Bitmap;

import com.tenginekit.jni.FaceSchedule;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class Image {
    static private AndroidConfig.ImageFormat _InputImageFormat = null;
    static private AndroidConfig.ImageFormat _OutputImageFormat = null;

    synchronized static private void createHandler(AndroidConfig.ImageFormat imageInputFormat, AndroidConfig.ImageFormat imageOutputFormat) {
        FaceSchedule.createHandler(imageInputFormat.toString(), imageOutputFormat.toString());
    }

    synchronized static public Bitmap convertImage(Bitmap bitmap,
                                                   int inputX1, int inputY1, int inputX2, int inputY2,
                                                   int outputW, int outputH, int rotation, boolean mirror) {
        if(bitmap == null){
            return null;
        }
        int imageWidth = bitmap.getWidth();
        int imageHeight = bitmap.getHeight();
        byte[] imageDate = getPixelsRGBA(bitmap);
        byte[] result = Image.convertImage(
                imageDate,
                AndroidConfig.ImageFormat.RGBA, AndroidConfig.ImageFormat.RGBA,
                imageWidth, imageHeight,
                inputX1, inputY1, inputX2, inputY2,
                outputW, outputH,
                rotation, mirror);
        Bitmap OutputBitmap = setPixelsRGBA(result, outputW, outputH);
        return OutputBitmap;
    }

    synchronized static public byte[] convertCameraYUVData(byte[] data,
                                                           AndroidConfig.ImageFormat imageOutputFormat,
                                                           int inputW, int inputH,
                                                           int outputW, int outputH, int rotation, boolean mirror
    ){
        return Image.convertImage(
                data,
                AndroidConfig.ImageFormat.YUV_NV21, imageOutputFormat,
                inputW, inputH,
                0, 0, inputW, inputH,
                outputW, outputH,
                rotation, mirror
        );
    }

    synchronized static public Bitmap convertCameraYUVData(byte[] data,
                                                           int inputW, int inputH,
                                                           int outputW, int outputH,
                                                           int rotation, boolean mirror
    ){

        byte[] result = Image.convertImage(
                data,
                AndroidConfig.ImageFormat.YUV_NV21, AndroidConfig.ImageFormat.RGBA,
                inputW, inputH,
                0, 0, inputW, inputH,
                outputW, outputH,
                rotation, mirror
        );
        if(result == null){
            return null;
        }
        Bitmap OutputBitmap = setPixelsRGBA(result, outputW, outputH);
        return OutputBitmap;
    }

    synchronized static public byte[] convertImage(byte[] data,
                                                   AndroidConfig.ImageFormat imageInputFormat, AndroidConfig.ImageFormat imageOutputFormat,
                                                   int inputW, int inputH,
                                                   int inputX1, int inputY1, int inputX2, int inputY2,
                                                   int outputW, int outputH, int rotation, boolean mirror
    ){
        if (!KitCore.getInit()){
            throw new RuntimeException("SDK not init");
        }
        if(data == null || data.length == 0){
            return null;
        }
        if(inputW == 0 || inputH == 0){
            return null;
        }
        if(outputW == 0 || outputH == 0){
            return null;
        }
        if(inputX1 >= inputX2 || inputY1 >= inputY2){
            return null;
        }
        if (_InputImageFormat != imageInputFormat || _OutputImageFormat != imageOutputFormat)
        {
            _InputImageFormat = imageInputFormat;
            _OutputImageFormat = imageOutputFormat;
            createHandler(_InputImageFormat, _OutputImageFormat);
        }
        byte[] result = FaceSchedule.handleImage(data, inputW, inputH, inputX1, inputY1, inputX2, inputY2, outputW, outputH, rotation, mirror);
        return result;
    }

    static private byte[] getPixelsRGBA(Bitmap image) {
        // calculate how many bytes our image consists of
        int bytes = image.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes); // Create a new buffer
        image.copyPixelsToBuffer(buffer); // Move the byte data to the buffer
        byte[] temp = buffer.array(); // Get the underlying array containing the
        return temp;
    }

    static private Bitmap setPixelsRGBA(byte[] byteArray, int ImageW, int ImageH) {
        Bitmap image1 = Bitmap.createBitmap(ImageW,ImageH, Bitmap.Config.ARGB_8888);
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.get(byteArray);
        Buffer temp = buffer.rewind();

        image1.copyPixelsFromBuffer(temp);
        return image1;
    }
}
