package com.tenginekit;

import androidx.annotation.Keep;

import java.util.ArrayList;
import java.util.List;

public class AndroidConfig {
    @Keep
    public enum Func
    {
        Detect,
        Landmark,
        Attribution,
        BlazeFace,
        FaceMesh,
        Iris,
        BodyDetect,
        BlazePoseDetect,
        BlazePoseLandmark,
        HandDetect,
        HandLandmark3d,
    }

    @Keep
    public enum ImageFormat
    {
        YUV_NV21,
        RGB,
        RGBA,
        GRAY,
    }

    @Keep
    public enum HandleMode{
        Normal,
        Camera
    }

    public List<Func> openFuncList = new ArrayList<>();
    public int inputImageW;
    public int inputImageH;

    public int outputImageW;
    public int outputImageH;

    public ImageFormat imageFormat = ImageFormat.RGB;

    public HandleMode handleMode = HandleMode.Camera;

    public AndroidConfig openFunc(Func func){
        openFuncList.add(func);
        return this;
    }

    public AndroidConfig setInputImageSize(int w, int h){
        inputImageW = w;
        inputImageH = h;
        return this;
    }

    public AndroidConfig setOutputImageSize(int w, int h){
        outputImageW = w;
        outputImageH = h;
        return this;
    }

    public AndroidConfig setInputImageFormat(ImageFormat imageFormat){
        this.imageFormat = imageFormat;
        return this;
    }

    public AndroidConfig setDefaultFunc(){
        openFunc(Func.Detect);
        openFunc(Func.Landmark);
        return this;
    }

    public AndroidConfig setDefaultInputImageFormat(){
        setInputImageFormat(ImageFormat.YUV_NV21);
        return this;
    }

    public AndroidConfig setCameraMode(){
        handleMode = HandleMode.Camera;
        return this;
    }

    public AndroidConfig setNormalMode(){
        handleMode = HandleMode.Normal;
        return this;
    }

    public static AndroidConfig create(){
        return new AndroidConfig();
    }
}
