/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast.audio;

import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.audio.ContextUtils;
import com.tencent.xcast.audio.QLog;
import com.tencent.xcast.audio.TelephoneObserver;
import com.tencent.xcast.audio.TraeAudioManager;
import com.tencent.xcast.audio.TraeAudioSession;
import com.tencent.xcast.audio.WebRtcAudioUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private static boolean useStereoOutput;
    private static boolean useStereoInput;
    private static boolean blacklistDeviceForOpenSLESUsage;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private static String[] mDeviceList;
    public static final int OUTPUT_MODE_HEADSET = 1;
    public static final int OUTPUT_MODE_SPEAKER = 0;
    private final long nativeAudioManager;
    private final AudioManager audioManager;
    private boolean initialized;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private boolean lowLatencyInput;
    private boolean proAudio;
    private boolean aAudio;
    private int sampleRate;
    private int outputChannels;
    private int inputChannels;
    private int outputBufferSize;
    private int inputBufferSize;
    private final VolumeLogger volumeLogger;
    private TraeAudioSession _asAudioManager;
    private int switchState;
    private int init_play_dev;
    private String deviceConnectedName;
    private TraeAudioSession _as;
    private ReentrantLock _prelock;
    private Condition _precon;
    private boolean _preDone;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean bl) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = bl;
    }

    public static synchronized void setStereoOutput(boolean bl) {
        Log.w((String)TAG, (String)("Overriding default output behavior: setStereoOutput(" + bl + ')'));
        useStereoOutput = bl;
    }

    public static synchronized void setStereoInput(boolean bl) {
        Log.w((String)TAG, (String)("Overriding default input behavior: setStereoInput(" + bl + ')'));
        useStereoInput = bl;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    WebRtcAudioManager(long l2) {
        WebRtcAudioManager webRtcAudioManager = this;
        WebRtcAudioManager webRtcAudioManager2 = this;
        webRtcAudioManager2._asAudioManager = null;
        webRtcAudioManager2.switchState = 0;
        webRtcAudioManager2.init_play_dev = 0;
        webRtcAudioManager2.deviceConnectedName = "";
        webRtcAudioManager2._as = null;
        webRtcAudioManager2._prelock = new ReentrantLock();
        webRtcAudioManager2._precon = webRtcAudioManager2._prelock.newCondition();
        webRtcAudioManager2._preDone = false;
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        webRtcAudioManager.nativeAudioManager = l2;
        webRtcAudioManager.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        webRtcAudioManager.volumeLogger = new VolumeLogger(this.audioManager);
        webRtcAudioManager.storeAudioParameters();
        webRtcAudioManager.nativeCacheAudioParameters(webRtcAudioManager.sampleRate, this.outputChannels, this.inputChannels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.aAudio, this.outputBufferSize, this.inputBufferSize, l2);
        WebRtcAudioUtils.logAudioState(TAG);
    }

    private boolean init() {
        Log.d((String)TAG, (String)("init" + WebRtcAudioUtils.getThreadInfo()));
        if (this.initialized) {
            return true;
        }
        Log.d((String)TAG, (String)("audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode())));
        this.initialized = true;
        this.volumeLogger.start();
        return true;
    }

    private void dispose() {
        Log.d((String)TAG, (String)("dispose" + WebRtcAudioUtils.getThreadInfo()));
        if (!this.initialized) {
            return;
        }
        this.volumeLogger.stop();
    }

    private int InitAudioPlayDev(int n2) {
        if (n2 != 1 && n2 != 2) {
            QLog.w("TRAE", "init_play_dev set failed!!,not correct param:" + n2);
            return 0;
        }
        this.init_play_dev = n2;
        QLog.w("TRAE", "init_play_dev set:" + this.init_play_dev);
        return 0;
    }

    private int InitSetting(int n2, int n3) {
        if (n2 == 1) {
            TraeAudioManager.IsMusicScene = true;
            TraeAudioManager.IsEarPhoneSupported = false;
        } else {
            TraeAudioManager.IsMusicScene = false;
            TraeAudioManager.IsEarPhoneSupported = true;
        }
        TraeAudioManager.IsUpdateSceneFlag = true;
        TraeAudioManager.nSceneMode = n2;
        this.InitAudioPlayDev(n3);
        QLog.w(TAG, "InitSetting: sceneMode:" + n2 + ",init_play_dev:" + n3);
        return 0;
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl) {
            Log.d((String)TAG, (String)(Build.MODEL + " is blacklisted for OpenSL ES usage!"));
        }
        return bl;
    }

    private void storeAudioParameters() {
        int n2 = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.outputChannels = n2;
        n2 = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.inputChannels = n2;
        webRtcAudioManager.sampleRate = webRtcAudioManager.getNativeOutputSampleRate();
        webRtcAudioManager.hardwareAEC = true;
        webRtcAudioManager.hardwareAGC = false;
        webRtcAudioManager.hardwareNS = true;
        webRtcAudioManager.lowLatencyOutput = webRtcAudioManager.isLowLatencyOutputSupported();
        webRtcAudioManager.lowLatencyInput = webRtcAudioManager.isLowLatencyInputSupported();
        webRtcAudioManager.proAudio = webRtcAudioManager.isProAudioSupported();
        webRtcAudioManager.aAudio = webRtcAudioManager.isAAudioSupported();
        n2 = webRtcAudioManager.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.outputChannels);
        this.outputBufferSize = n2;
        n2 = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.inputChannels);
        this.inputBufferSize = n2;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private boolean isProAudioSupported() {
        return Build.VERSION.SDK_INT >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Log.w((String)TAG, (String)"AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Log.d((String)TAG, (String)"Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Log.d((String)TAG, (String)("Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz"));
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n2 = this.getSampleRateForApiLevel();
        Log.d((String)TAG, (String)("Sample rate is set to " + n2 + " Hz"));
        return n2;
    }

    private int getSampleRateForApiLevel() {
        if (Build.VERSION.SDK_INT < 17) {
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string2 == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(string2);
    }

    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(((WebRtcAudioManager)((Object)string2)).isLowLatencyOutputSupported());
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string2 == null ? 256 : Integer.parseInt(string2);
    }

    private static int getMinOutputFrameSize(int n2, int n3) {
        int n4 = n3;
        n3 = n4 * 2;
        int n5 = n4 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n2, (int)n5, (int)2) / n3;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager webRtcAudioManager = this;
        WebRtcAudioManager.assertTrue(webRtcAudioManager.isLowLatencyInputSupported());
        return webRtcAudioManager.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int n2, int n3) {
        int n4 = n3;
        n3 = n4 * 2;
        int n5 = n4 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n2, (int)n5, (int)2) / n3;
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, long var13);

    private native void nativeNotifyAudioRouteSwitch(String var1, int var2, long var3);

    private native void nativeNotifyDeviceListUpdate(String var1, String var2, int var3, int var4, long var5);

    private void setAudioManagerMode(int n2, int n3) {
        Log.d((String)TAG, (String)("setAudioManagerMode, setMode: " + n2 + ", isStop:" + n3));
        if (n3 == 0) {
            this.startTRAEService();
            this.call_preprocess(n2);
        } else if (n3 == 1) {
            WebRtcAudioManager webRtcAudioManager = this;
            webRtcAudioManager.call_postprocess();
            webRtcAudioManager.stopTRAEService();
        }
    }

    private void onOutputChanage(String string2, String string3) {
        if (TelephoneObserver.getPhoneInterruptFlag()) {
            QLog.w(TAG, "phoneInterrupt do nothing, onOutputChanage:" + string2);
            return;
        }
        QLog.w(TAG, " onOutputChanage:" + string2);
        if (string2.equals("DEVICE_EARPHONE")) {
            this.switchState = 1;
        } else if (string2.equals("DEVICE_SPEAKERPHONE")) {
            this.switchState = 2;
        } else if (string2.equals("DEVICE_WIREDHEADSET")) {
            this.switchState = 3;
        } else if (string2.equals("DEVICE_BLUETOOTHHEADSET")) {
            this.switchState = 4;
            if (!string3.equals("")) {
                this.deviceConnectedName = string3;
            }
        } else {
            this.switchState = 0;
        }
        if (this.switchState != 4 && !string3.equals("")) {
            this.deviceConnectedName = string2;
        }
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.nativeNotifyAudioRouteSwitch(webRtcAudioManager.deviceConnectedName, this.switchState, this.nativeAudioManager);
    }

    private void onDeviceListUpdateNotify(String[] stringArray, String string2, String string3) {
        String string4 = "";
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if ("DEVICE_EARPHONE".equals(stringArray[i2])) {
                string4 = string4 + "1;";
                ++n2;
                continue;
            }
            if ("DEVICE_SPEAKERPHONE".equals(stringArray[i2])) {
                string4 = string4 + "2;";
                ++n2;
                continue;
            }
            if ("DEVICE_WIREDHEADSET".equals(stringArray[i2])) {
                string4 = string4 + "3;";
                ++n2;
                continue;
            }
            if (!"DEVICE_BLUETOOTHHEADSET".equals(stringArray[i2])) continue;
            string4 = string4 + "4;";
            ++n2;
        }
        int n3 = 0;
        if ("DEVICE_EARPHONE".equals(string2)) {
            n3 = 1;
        } else if ("DEVICE_SPEAKERPHONE".equals(string2)) {
            n3 = 2;
        } else if ("DEVICE_WIREDHEADSET".equals(string2)) {
            n3 = 3;
        } else if ("DEVICE_BLUETOOTHHEADSET".equals(string2)) {
            n3 = 4;
        }
        this.nativeNotifyDeviceListUpdate(string4, string3, n2, n3, this.nativeAudioManager);
    }

    private void initTRAEAudioManager() {
        if (ContextUtils.getApplicationContext() != null) {
            TraeAudioManager.init(ContextUtils.getApplicationContext());
            QLog.w(TAG, "initTRAEAudioManager , TraeAudioSession create");
            if (this._asAudioManager == null) {
                this._asAudioManager = new TraeAudioSession(ContextUtils.getApplicationContext(), new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean bl) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] stringArray, String string2, String string3, String string4) {
                        1 v0 = this;
                        WebRtcAudioManager.access$202(stringArray);
                        v0.WebRtcAudioManager.this.onOutputChanage(string2, string4);
                        v0.WebRtcAudioManager.this.onDeviceListUpdateNotify(stringArray, string2, string4);
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bl) {
                    }

                    @Override
                    public void onGetDeviceListRes(int n2, String[] stringArray, String string2, String string3, String string4) {
                        1 v0 = this;
                        WebRtcAudioManager.access$202(stringArray);
                        v0.WebRtcAudioManager.this.onOutputChanage(string2, string4);
                        v0.WebRtcAudioManager.this.onDeviceListUpdateNotify(stringArray, string2, string4);
                    }

                    @Override
                    public void onConnectDeviceRes(int n2, String string2, boolean bl) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int n2, boolean bl) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onRingCompletion(int n2, String string2) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int n2) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int n2, int n3) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int n2) {
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String string2, String string3) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String string2, long l2) {
                    }
                });
            }
            this._asAudioManager.startService("DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;");
        }
    }

    private int startService(String string2) {
        QLog.w(TAG, "TraeAudioSession startService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager) + " deviceConfig:" + string2);
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.startService(string2);
        }
        return -1;
    }

    private int stopService() {
        QLog.w(TAG, "TraeAudioSession stopService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager));
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.stopService();
        }
        return -1;
    }

    private int startTRAEService() {
        String string2 = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
        int n2 = ((WebRtcAudioManager)((Object)traeAudioSession)).init_play_dev;
        if (n2 != 0 ? n2 == 1 : ((WebRtcAudioManager)((Object)traeAudioSession)).switchState == 1) {
            string2 = "DEVICE_SPEAKERPHONE;DEVICE_EARPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
        }
        QLog.w(TAG, "TraeAudioSession startTRAEService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager) + " deviceConfig:" + string2);
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.startService(string2);
        }
        return -1;
    }

    private int stopTRAEService() {
        QLog.w(TAG, "TraeAudioSession stopTRAEService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager));
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.stopService();
        }
        return -1;
    }

    private int initConnectDevice() {
        if (this._asAudioManager != null) {
            this.reConnectDevice();
            if (TelephoneObserver.getPhoneInterruptFlag()) {
                TelephoneObserver.resetPhoneInterruptFlag();
            }
            this._asAudioManager.getDeviceList();
        }
        return 0;
    }

    private int reConnectDevice() {
        String string2 = "DEVICE_NONE";
        if (((WebRtcAudioManager)((Object)traeAudioSession)).init_play_dev != 0) {
            QLog.w(TAG, "TraeAudioSession init_play_dev !=0,reConnectDevice: " + string2);
            ((WebRtcAudioManager)((Object)traeAudioSession)).init_play_dev = 0;
        } else {
            int n2 = ((WebRtcAudioManager)((Object)traeAudioSession)).switchState;
            if (n2 == 1) {
                string2 = "DEVICE_EARPHONE";
            } else if (n2 == 2) {
                string2 = "DEVICE_SPEAKERPHONE";
            } else if (n2 == 3) {
                string2 = "DEVICE_WIREDHEADSET";
            } else if (n2 == 4) {
                string2 = "DEVICE_BLUETOOTHHEADSET";
            }
            QLog.w(TAG, "TraeAudioSession no init_play_dev,reConnectDevice: " + string2);
        }
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.forceConnectDevice(string2);
        }
        return -1;
    }

    private void uninitTRAEAudioManager() {
        if (ContextUtils.getApplicationContext() != null) {
            QLog.w(TAG, "uninitTRAEAudioManager , stopService");
            TraeAudioSession traeAudioSession = this._asAudioManager;
            if (traeAudioSession != null) {
                traeAudioSession.stopService();
                this._asAudioManager.release();
                this._asAudioManager = null;
            }
            TraeAudioManager.IsUpdateSceneFlag = false;
        } else {
            QLog.w(TAG, "uninitTRAEAudioManager , context null");
        }
    }

    private int SetAudioOutputMode(int n2) {
        int n3 = object.switchState;
        if (n3 != 3 && n3 != 4) {
            QLog.w("TRAE", "TraeAudioSession SetAudioOutputMode: " + n2);
            if (1 == n2) {
                if (mDeviceList != null && object._asAudioManager != null) {
                    n2 = 0;
                    block0: do {
                        String[] stringArray;
                        n3 = 0;
                        while (true) {
                            stringArray = mDeviceList;
                            if (n3 >= mDeviceList.length || n2 != 0) break;
                            if ("DEVICE_WIREDHEADSET".equals(stringArray[n3])) {
                                object._asAudioManager.connectDevice("DEVICE_WIREDHEADSET");
                                n2 = 1;
                                break;
                            }
                            ++n3;
                        }
                        n3 = 0;
                        while (true) {
                            stringArray = mDeviceList;
                            if (n3 >= mDeviceList.length || n2 != 0) break;
                            if ("DEVICE_BLUETOOTHHEADSET".equals(stringArray[n3])) {
                                object._asAudioManager.connectDevice("DEVICE_BLUETOOTHHEADSET");
                                n2 = 1;
                                break;
                            }
                            ++n3;
                        }
                        n3 = 0;
                        while (true) {
                            stringArray = mDeviceList;
                            if (n3 >= mDeviceList.length || n2 != 0) continue block0;
                            if ("DEVICE_EARPHONE".equals(stringArray[n3])) {
                                object._asAudioManager.connectDevice("DEVICE_EARPHONE");
                                n2 = 1;
                                continue block0;
                            }
                            ++n3;
                        }
                    } while (n2 == 0);
                    return 0;
                }
                return -1;
            }
            if (n2 == 0) {
                Object object = object._asAudioManager;
                if (object == null) {
                    return -1;
                }
                ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_SPEAKERPHONE");
                return 0;
            }
            return -1;
        }
        QLog.w("TRAE", "TraeAudioSession SetAudioOutputMode failed!!, bluetooth or wireheadset existed, outputMode: " + n2);
        return 0;
    }

    private int ConnectDevice(int n2) {
        Object object = object._asAudioManager;
        if (object == null) {
            QLog.e("TRAE", "[ERROR] TraeAudioSession ConnectDevice failed!!, _asAudioManager is null");
            return -1;
        }
        switch (n2) {
            default: {
                QLog.e("TRAE", "[ERROR] TraeAudioSession ConnectDevice failed!!, device error param: " + n2);
                break;
            }
            case 4: {
                ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_BLUETOOTHHEADSET");
                break;
            }
            case 3: {
                ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_WIREDHEADSET");
                break;
            }
            case 2: {
                ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_SPEAKERPHONE");
                break;
            }
            case 1: {
                ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_EARPHONE");
            }
        }
        return 0;
    }

    static /* synthetic */ String[] access$202(String[] stringArray) {
        mDeviceList = stringArray;
        return stringArray;
    }

    static /* synthetic */ boolean access$602(WebRtcAudioManager webRtcAudioManager, boolean bl) {
        webRtcAudioManager._preDone = bl;
        return bl;
    }

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    public int getAudioRouteSwitchState() {
        return this.switchState;
    }

    /*
     * Loose catch block
     */
    public int call_preprocess(int n2) {
        block13: {
            if (this._as == null) {
                this._as = new TraeAudioSession(ContextUtils.getApplicationContext(), new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean bl) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] stringArray, String string2, String string3, String string4) {
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bl) {
                    }

                    @Override
                    public void onGetDeviceListRes(int n2, String[] stringArray, String string2, String string3, String string4) {
                    }

                    @Override
                    public void onConnectDeviceRes(int n2, String string2, boolean bl) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int n2, boolean bl) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onRingCompletion(int n2, String string2) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int n2) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int n2, int n3) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int n2) {
                        WebRtcAudioManager webRtcAudioManager;
                        2 v2;
                        2 v1;
                        try {
                            2 v0 = this;
                            v1 = v0;
                            v2 = v0;
                            v0.WebRtcAudioManager.this._prelock.lock();
                            webRtcAudioManager = v0.WebRtcAudioManager.this;
                        }
                        catch (Exception exception) {}
                        WebRtcAudioManager.access$602(webRtcAudioManager, true);
                        QLog.w(WebRtcAudioManager.TAG, "onVoicecallPreprocessRes signalAll");
                        v1.WebRtcAudioManager.this._precon.signalAll();
                        v2.WebRtcAudioManager.this._prelock.unlock();
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String string2, String string3) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String string2, long l2) {
                    }
                });
            }
            this._preDone = false;
            if (this._as != null) {
                WebRtcAudioManager webRtcAudioManager = this;
                webRtcAudioManager._prelock.lock();
                int n3 = 0;
                webRtcAudioManager._as.voiceCallPreprocess(n2, n3);
                n2 = 7;
                while (true) {
                    int n4 = n2;
                    n2 = n4 + -1;
                    if (n4 <= 0) break;
                    if (this._preDone) break;
                    Condition condition = this._precon;
                    condition.await(1L, TimeUnit.SECONDS);
                    StringBuilder stringBuilder = new StringBuilder();
                    QLog.w(TAG, stringBuilder.append("call_preprocess waiting...  as:").append((Object)this._as).toString());
                    continue;
                    break;
                }
                try {
                    QLog.w(TAG, "call_preprocess done!");
                }
                catch (InterruptedException interruptedException) {}
                this._prelock.unlock();
                break block13;
                catch (Throwable throwable) {
                    this._prelock.unlock();
                    throw throwable;
                }
            }
        }
        return 0;
    }

    public int call_postprocess() {
        TraeAudioSession traeAudioSession = this._as;
        if (traeAudioSession != null) {
            traeAudioSession.voiceCallPostprocess();
            this._as.release();
            this._as = null;
            QLog.w(TAG, "call_postprocess done!");
        }
        return 0;
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        private static final int TIMER_PERIOD_IN_SECONDS = 30;
        private final AudioManager audioManager;
        @Nullable
        private Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        private void stop() {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
                this.timer = null;
            }
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            VolumeLogger volumeLogger = this;
            this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(volumeLogger.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;

            LogVolumeTask(int n2, int n3) {
                this.maxRingVolume = n2;
                this.maxVoiceCallVolume = n3;
            }

            @Override
            public void run() {
                int n2 = VolumeLogger.this.audioManager.getMode();
                if (n2 == 1) {
                    Log.d((String)WebRtcAudioManager.TAG, (String)("STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")"));
                } else if (n2 == 3) {
                    Log.d((String)WebRtcAudioManager.TAG, (String)("VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")"));
                }
            }
        }
    }
}

