/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.provider.Settings;
import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoCaptureContext {
    private static final String TAG = "VideoCaptureContext";
    private static final boolean gSupportQuitSafely;
    private static final boolean gDebug;
    private static final int DELAY_CLEANUP_MILLIS = 1000;
    static final /* synthetic */ boolean $assertionsDisabled;
    private Context mContext;
    private EGLCoreContext mEglCore;
    private CaptureThread mCaptureThread;
    private Handler mCaptureHandler;
    private DeviceAutoRotationObserver mAutoRotateObserver;
    private WindowManager mWindowMgr;
    private Display mDefaultDisplay;
    private List<CaptureRunnable> mPending;
    private final Object mPendingLock;
    private Cleanup mCleanup;
    private boolean mLocked;
    private boolean mDestroyed;

    private VideoCaptureContext(Context context) {
        Object[] objectArray;
        if (gSupportQuitSafely) {
            objectArray = null;
        } else {
            Object[] objectArray2;
            objectArray = objectArray2;
            objectArray2 = new Object();
        }
        VideoCaptureContext videoCaptureContext = this;
        videoCaptureContext.mPendingLock = objectArray;
        videoCaptureContext.mLocked = true;
        videoCaptureContext.mDestroyed = false;
        this.mContext = context;
        this.mCaptureThread = new CaptureThread("VideoCapture");
        this.mCaptureThread.start();
        this.mCaptureHandler = new Handler(this.mCaptureThread.getLooper());
        if (Platform.isDebugBuild) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = this.mCaptureThread;
            objectArray3[1] = this.mCaptureHandler;
            Platform.logDebug(String.format(Locale.CHINA, "mCaptureThread.%h.mCaptureHandler.%h", objectArray));
        }
        if (!gSupportQuitSafely) {
            this.mPending = new ArrayList<CaptureRunnable>();
        }
        this.mAutoRotateObserver = new DeviceAutoRotationObserver(this.mCaptureHandler, this.mContext);
        this.mAutoRotateObserver.startObserver();
        this.mWindowMgr = (WindowManager)context.getSystemService("window");
    }

    @WorkerThread
    private void cleanupOnCaptureThread() {
        Object object;
        if (Platform.isDebugBuild) {
            Platform.logInfo("cleanup start");
        }
        if ((object = this.mEglCore) != null) {
            object.release();
            this.mEglCore = null;
        }
        if ((object = this.mAutoRotateObserver) != null) {
            ((DeviceAutoRotationObserver)((Object)object)).stopObserver();
            this.mAutoRotateObserver = null;
        }
        VideoCaptureContext videoCaptureContext = this;
        videoCaptureContext.mCleanup = null;
        videoCaptureContext.mLocked = true;
        videoCaptureContext.mDestroyed = true;
        if (Platform.isDebugBuild) {
            Platform.logInfo("cleanup end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaptureRunnable runOnCaptureThreadInternal(CaptureThreadCallback object, Object object2, boolean bl) {
        CaptureRunnable captureRunnable;
        boolean bl2;
        block10: {
            CaptureRunnable captureRunnable2;
            if (gDebug && Thread.currentThread() == this.mCaptureThread) {
                throw new RuntimeException("can not called on capture thread.");
            }
            bl2 = false;
            captureRunnable = captureRunnable2;
            captureRunnable2 = new CaptureRunnable((CaptureThreadCallback)object, object2, bl);
            if (this.mCaptureHandler == null) break block10;
            if (!gSupportQuitSafely) {
                object = this.mPendingLock;
                synchronized (object) {
                    this.mPending.add(captureRunnable);
                }
            }
            if ((bl2 = this.mCaptureHandler.post((Runnable)captureRunnable)) || gSupportQuitSafely) break block10;
            VideoCaptureContext videoCaptureContext = this;
            object = videoCaptureContext.mPendingLock;
            synchronized (object) {
                videoCaptureContext.mPending.remove(captureRunnable);
                if (!videoCaptureContext.mPending.isEmpty()) break block10;
                this.mPendingLock.notify();
            }
        }
        if (!bl2) {
            captureRunnable = null;
        }
        return captureRunnable;
    }

    private synchronized int unlock() {
        Object[] objectArray;
        int n2 = -1;
        boolean bl = this.mLocked;
        if (!bl) {
            objectArray = this.mCleanup;
            if (this.mCleanup != null && (n2 = objectArray.hold() ? 0 : -1) == 0) {
                VideoCaptureContext videoCaptureContext = this;
                videoCaptureContext.mCleanup = null;
                videoCaptureContext.mLocked = true;
            }
        }
        Object[] objectArray2 = new Object[3];
        objectArray = objectArray2;
        objectArray[0] = this;
        objectArray[1] = n2;
        objectArray2[2] = bl;
        Platform.logInfo(String.format(Locale.CHINA, "%h.state.%d.locked.%b", objectArray));
        if (n2 == -1 && this.mDestroyed) {
            n2 = -2;
        }
        return n2;
    }

    protected static VideoCaptureContext create(Context context) {
        return new VideoCaptureContext(context);
    }

    protected static synchronized void cleanup() {
    }

    static /* synthetic */ EGLCoreContext access$102(VideoCaptureContext videoCaptureContext, EGLCoreContext eGLCoreContext) {
        videoCaptureContext.mEglCore = eGLCoreContext;
        return eGLCoreContext;
    }

    static /* synthetic */ void access$500(VideoCaptureContext videoCaptureContext) {
        videoCaptureContext.cleanupOnCaptureThread();
    }

    static {
        $assertionsDisabled = VideoCaptureContext.class.desiredAssertionStatus() ^ true;
        gSupportQuitSafely = Build.VERSION.SDK_INT >= 18;
        gDebug = Platform.debug();
    }

    protected synchronized boolean available() {
        return !this.mLocked && !this.mDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void destroy() {
        v0 = this;
        v1 = new Object[1];
        var1_1 /* !! */  = v1;
        v1[0] = this;
        Platform.logInfo(String.format(Locale.CHINA, "destroy.%h", (Object[])var1_1 /* !! */ ));
        var1_1 /* !! */  = null;
        synchronized (v0) {
            block20: {
                block21: {
                    block22: {
                        block19: {
                            block18: {
                                var2_2 = false;
                                if (v0.mCleanup != null && !(var2_2 = this.mCleanup.hold())) break block18;
                                if (VideoCaptureContext.gDebug) {
                                    Platform.logDebug(String.format(Locale.CHINA, "%h.hold.%b.mLocked.%b", new Object[]{this, var2_2, this.mLocked}));
                                }
                                if (this.mCaptureHandler == null || this.mCaptureHandler.getLooper() == null) break block18;
                                var1_1 /* !! */  = this.runOnCaptureThreadInternal(new Cleanup(), null, true);
                            }
                            this.mCleanup = null;
                            // ** MonitorExit[this] (shouldn't be in output)
                            if (var1_1 /* !! */  == null) break block19;
                            CaptureRunnable.access$800((CaptureRunnable)var1_1 /* !! */ );
                        }
                        if ((var1_1 /* !! */  = this.mCaptureHandler) == null) break block20;
                        if ((var1_1 /* !! */  = var1_1 /* !! */ .getLooper()) == null) break block21;
                        if (!VideoCaptureContext.gSupportQuitSafely) break block22;
                        var1_1 /* !! */ .quitSafely();
                        break block21;
                    }
                    var2_3 = this.mPendingLock;
                    synchronized (var2_3) {
                        ** try [egrp 4[TRYBLOCK] [13 : 175->206)] { 
lbl-1000:
                        // 3 sources

                        {
                            while (!this.mPending.isEmpty()) {
                                try {
                                    this.mPendingLock.wait();
                                }
                                catch (InterruptedException v3) {
                                    v3.printStackTrace();
                                }
                            }
                            // MONITOREXIT @DISABLED, blocks:[4, 7, 8] lbl39 : MonitorExitStatement: MONITOREXIT : var2_3
                            var1_1 /* !! */ .quit();
                        }
lbl45:
                        // 1 sources

                        catch (Throwable v4) {
                            throw v4;
                        }
                    }
                }
                this.mCaptureHandler = null;
            }
            if (Platform.isDebugBuild && !VideoCaptureContext.$assertionsDisabled && this.mCaptureThread == null) {
                throw new AssertionError();
            }
            var1_1 /* !! */  = this.mCaptureThread;
            if (var1_1 /* !! */  != null) {
                try {
                    if (!var1_1 /* !! */ .quit()) {
                        Platform.logInfo((Object)this.mCaptureThread + " has quit");
                    }
                    this.mCaptureThread.join();
                }
                catch (InterruptedException v5) {
                    v5.printStackTrace();
                }
                this.mCaptureThread = null;
            }
            v6 = this;
            v6.mContext = null;
            v6.mCleanup = null;
            return;
        }
    }

    @WorkerThread
    protected boolean isDeviceAutoRotate() {
        if (gDebug && !object.isCaptureThread()) {
            throw new RuntimeException("should called on capture thread.");
        }
        Object object = object.mAutoRotateObserver;
        if (object != null) {
            return ((DeviceAutoRotationObserver)((Object)object)).isAutoRotate();
        }
        return false;
    }

    @AnyThread
    protected Handler getHandler() {
        return this.mCaptureHandler;
    }

    @WorkerThread
    protected int getDeviceOrientation() {
        if (gDebug && !this.isCaptureThread()) {
            throw new RuntimeException("should called on capture thread.");
        }
        if (this.mDefaultDisplay == null) {
            this.mDefaultDisplay = this.mWindowMgr.getDefaultDisplay();
        }
        int n2 = 0;
        Display display = this.mDefaultDisplay;
        if (display != null) {
            int n3 = display.getRotation();
            if (n3 != 1) {
                if (n3 != 2) {
                    if (n3 == 3) {
                        n2 = 270;
                    }
                } else {
                    n2 = 180;
                }
            } else {
                n2 = 90;
            }
        }
        return n2;
    }

    @AnyThread
    protected boolean isCaptureThread() {
        return Thread.currentThread() == this.mCaptureThread;
    }

    @AnyThread
    protected boolean runOnCaptureThread(CaptureThreadCallback captureThreadCallback, Object object, boolean bl) {
        if ((this = ((VideoCaptureContext)this).runOnCaptureThreadInternal(captureThreadCallback, object, bl)) != null && bl) {
            ((CaptureRunnable)this).waitFor();
        }
        return this != null;
    }

    private static class DeviceOrientationEventListener
    extends OrientationEventListener {
        int mOrientation = 0;
        int mLastOrientation = -25;

        public DeviceOrientationEventListener(Context context, int n2) {
            super(context, n2);
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        public void onOrientationChanged(int n2) {
            int n3;
            if (n2 == -1) {
                this.mLastOrientation = n2;
                return;
            }
            if (this.mLastOrientation < 0) {
                this.mLastOrientation = 0;
            }
            if (n2 - (n3 = this.mLastOrientation) < 20 && n2 - n3 > -20) {
                return;
            }
            this.mLastOrientation = n2;
            this.mOrientation = n2 <= 314 && n2 >= 45 ? (n2 < 135 ? 90 : (n2 < 225 ? 180 : 270)) : 0;
        }
    }

    private static class DeviceAutoRotationObserver
    extends ContentObserver {
        ContentResolver mResolver;
        boolean mAutoRotate;

        DeviceAutoRotationObserver(Handler handler, Context context) {
            super(handler);
            this.mResolver = context.getContentResolver();
            this.mAutoRotate = this.getAutoRotate();
        }

        private boolean getAutoRotate() {
            return 1 == Settings.System.getInt((ContentResolver)this.mResolver, (String)"accelerometer_rotation", (int)0);
        }

        boolean isAutoRotate() {
            return this.mAutoRotate;
        }

        public void onChange(boolean bl) {
            DeviceAutoRotationObserver deviceAutoRotationObserver = this;
            super.onChange(bl);
            deviceAutoRotationObserver.mAutoRotate = deviceAutoRotationObserver.getAutoRotate();
        }

        void startObserver() {
            this.mResolver.registerContentObserver(Settings.System.getUriFor((String)"accelerometer_rotation"), false, (ContentObserver)this);
        }

        void stopObserver() {
            this.mResolver.unregisterContentObserver((ContentObserver)this);
        }
    }

    private class Cleanup
    implements CaptureThreadCallback {
        private boolean mReleased = false;
        private boolean mHolding = false;

        private Cleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hold() {
            Cleanup cleanup = this;
            synchronized (cleanup) {
                if (!cleanup.mReleased) {
                    this.mHolding = true;
                    // ** MonitorExit[this] (shouldn't be in output)
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        @WorkerThread
        public void onCaptureThreadCallback(VideoCaptureContext var1_1, Object var2_2) {
            v0 = this;
            var1_1 = v0.VideoCaptureContext.this;
            synchronized (var1_1) {
                ** synchronized (v0)
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
lbl9:
                    // 2 sources

                    v0.mReleased = true;
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (v0.mHolding) ** GOTO lbl17
                    {
                        catch (Throwable v2) {
                            // ** MonitorExit[this] (shouldn't be in output)
                            throw v2;
                        }
                    }
                    VideoCaptureContext.access$500(VideoCaptureContext.this);
lbl17:
                    // 2 sources

                    return;
                }
            }
        }
    }

    private class CaptureRunnable
    implements Runnable {
        CaptureThreadCallback c;
        boolean wake;
        Object obj;
        volatile boolean waitable;

        private CaptureRunnable(CaptureThreadCallback captureThreadCallback, Object object, boolean bl) {
            this.c = captureThreadCallback;
            this.obj = object;
            this.waitable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitFor() {
            if (!this.waitable) return;
            synchronized (this) {
                while (!this.wake) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                if (this.waitable) {
                    CaptureRunnable captureRunnable = this;
                    synchronized (captureRunnable) {
                        captureRunnable.c.onCaptureThreadCallback(VideoCaptureContext.this, this.obj);
                        captureRunnable.wake = true;
                        captureRunnable.notify();
                    }
                } else {
                    this.c.onCaptureThreadCallback(VideoCaptureContext.this, this.obj);
                }
                if (gSupportQuitSafely) break block10;
                CaptureRunnable captureRunnable = this;
                Object object = captureRunnable.VideoCaptureContext.this.mPendingLock;
                synchronized (object) {
                    captureRunnable.VideoCaptureContext.this.mPending.remove(this);
                    if (!captureRunnable.VideoCaptureContext.this.mPending.isEmpty()) break block10;
                    VideoCaptureContext.this.mPendingLock.notify();
                }
            }
        }
    }

    private class CaptureThread
    extends HandlerThread {
        private CaptureThread(String string2) {
            super(string2);
        }

        protected void onLooperPrepared() {
            CaptureThread captureThread = this;
            VideoCaptureContext.access$102(captureThread.VideoCaptureContext.this, new EGLCore());
            captureThread.VideoCaptureContext.this.mEglCore.createContext(EGLUtil.getOffscreenContext(), false);
            captureThread.VideoCaptureContext.this.mEglCore.createSurface(null);
        }
    }

    protected static interface CaptureThreadCallback {
        public void onCaptureThreadCallback(VideoCaptureContext var1, Object var2);
    }
}

