/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.Context;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class EGLUtil {
    private static final String TAG = "EGLUtil";
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)(\\.([0-9]+))?(\\.([0-9]+))?");
    static EGLCoreContext sOffscreenContext = null;
    static int sGLVersion = -1;
    static String sEGLExtensions = null;
    static String sGLESVendor = null;
    static String sGLESRender = null;
    static String sGLESExtensions = null;
    static int sAPILevel = Build.VERSION.SDK_INT;
    static final Map<String, DeviceMatcher> sMatchers = new HashMap<String, DeviceMatcher>(){
        {
            DeviceMatcher deviceMatcher;
            DeviceMatcher deviceMatcher2;
            DeviceMatcher deviceMatcher3;
            DeviceMatcher deviceMatcher4;
            DeviceMatcher deviceMatcher5;
            DeviceMatcher deviceMatcher6;
            1 v0 = this;
            DeviceMatcher deviceMatcher7 = deviceMatcher6;
            deviceMatcher6 = new DeviceMatcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    Class<EGLUtil> clazz = EGLUtil.class;
                    synchronized (EGLUtil.class) {
                        // ** MonitorExit[this] (shouldn't be in output)
                        return EGLUtil.isPropertyMismatch(jSONObject, "gl_vendor", sGLESVendor);
                    }
                }
            };
            v0.put("gl_vendor", deviceMatcher7);
            deviceMatcher7 = deviceMatcher5;
            deviceMatcher5 = new DeviceMatcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    Class<EGLUtil> clazz = EGLUtil.class;
                    synchronized (EGLUtil.class) {
                        // ** MonitorExit[this] (shouldn't be in output)
                        return EGLUtil.isPropertyMismatch(jSONObject, "gl_renderer", sGLESRender);
                    }
                }
            };
            v0.put("gl_renderer", deviceMatcher7);
            deviceMatcher7 = deviceMatcher4;
            deviceMatcher4 = new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    3 this_ = jSONObject.getJSONObject("os");
                    if (this_.has("type") && !"android".equals(this_.getString("type"))) {
                        return true;
                    }
                    if (this_.has("version")) {
                        return (this_ = this_.getJSONObject("version")).has("op") && this_.has("value") && EGLUtil.isVersionMismatch(this_.getString("op"), this_.getString("value"));
                    }
                    return false;
                }
            };
            v0.put("os", deviceMatcher7);
            deviceMatcher7 = deviceMatcher3;
            deviceMatcher3 = new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    sCodecPatterns.add(Pattern.compile(jSONObject.getString("codec_name")));
                    sCodecFeatures.add(new FeatureHolder().fromJSONObject(jSONObject));
                    return true;
                }
            };
            v0.put("codec_name", deviceMatcher7);
            deviceMatcher7 = deviceMatcher2;
            deviceMatcher2 = new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "vendor_name", Build.MANUFACTURER);
                }
            };
            v0.put("vendor_name", deviceMatcher7);
            deviceMatcher7 = deviceMatcher;
            deviceMatcher = new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "device_name", Build.MODEL);
                }
            };
            v0.put("device_name", deviceMatcher7);
        }
    };
    static final Map<String, FeatureSetter> sHolderSetters = new HashMap<String, FeatureSetter>(){
        {
            FeatureSetter featureSetter;
            FeatureSetter featureSetter2;
            FeatureSetter featureSetter3;
            FeatureSetter featureSetter4;
            FeatureSetter featureSetter5;
            FeatureSetter featureSetter6;
            FeatureSetter featureSetter7;
            FeatureSetter featureSetter8;
            FeatureSetter featureSetter9;
            FeatureSetter featureSetter10;
            FeatureSetter featureSetter11;
            FeatureSetter featureSetter12;
            FeatureSetter featureSetter13;
            FeatureSetter featureSetter14;
            FeatureSetter featureSetter15;
            2 v0 = this;
            FeatureSetter featureSetter16 = featureSetter15;
            featureSetter15 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseHardwareBuffer = true;
                }
            };
            v0.put("use_android_hardware_buffer", featureSetter16);
            featureSetter16 = featureSetter14;
            featureSetter14 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUsePBO = false;
                }
            };
            v0.put("disable_android_pbo", featureSetter16);
            featureSetter16 = featureSetter13;
            featureSetter13 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemDecoder = true;
                }
            };
            v0.put("enable_android_system_decoder", featureSetter16);
            featureSetter16 = featureSetter12;
            featureSetter12 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemEncoder = true;
                }
            };
            v0.put("enable_android_system_encoder", featureSetter16);
            featureSetter16 = featureSetter11;
            featureSetter11 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemDecoder = false;
                }
            };
            v0.put("disable_android_system_decoder", featureSetter16);
            featureSetter16 = featureSetter10;
            featureSetter10 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemEncoder = false;
                }
            };
            v0.put("disable_android_system_encoder", featureSetter16);
            featureSetter16 = featureSetter9;
            featureSetter9 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mDecoderOutputSurfaceTexture = true;
                }
            };
            v0.put("enable_android_decoder_surfacetexture", featureSetter16);
            featureSetter16 = featureSetter8;
            featureSetter8 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mDecoderOutputSurfaceTexture = false;
                }
            };
            v0.put("disable_android_decoder_surfacetexture", featureSetter16);
            featureSetter16 = featureSetter7;
            featureSetter7 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mEncoderInputSurfaceTexture = true;
                }
            };
            v0.put("enable_android_encoder_surfacetexture", featureSetter16);
            featureSetter16 = featureSetter6;
            featureSetter6 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mEncoderInputSurfaceTexture = false;
                }
            };
            v0.put("disable_android_encoder_surfacetexture", featureSetter16);
            featureSetter16 = featureSetter5;
            featureSetter5 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMinFormatSize = jSONObject.getInt("min_format_size");
                }
            };
            v0.put("min_format_size", featureSetter16);
            featureSetter16 = featureSetter4;
            featureSetter4 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMaxPendingFrames = jSONObject.getInt("max_pending_frames");
                }
            };
            v0.put("max_pending_frames", featureSetter16);
            featureSetter16 = featureSetter3;
            featureSetter3 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMaxDecoderSurfaceCount = jSONObject.getInt("max_decoder_surface_instance");
                }
            };
            v0.put("max_decoder_surface_instance", featureSetter16);
            featureSetter16 = featureSetter2;
            featureSetter2 = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMaxEncoderSurfaceCount = jSONObject.getInt("max_encoder_surface_instance");
                }
            };
            v0.put("max_encoder_surface_instance", featureSetter16);
            featureSetter16 = featureSetter;
            featureSetter = new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseGLClear = false;
                }
            };
            v0.put("gl_clear_broken", featureSetter16);
        }
    };
    static final FeatureHolder sFeatures = new FeatureHolder();
    static final List<Pattern> sCodecPatterns = new ArrayList<Pattern>();
    static final List<FeatureHolder> sCodecFeatures = new ArrayList<FeatureHolder>();

    public static synchronized EGLCoreContext getOffscreenContext() {
        if (sOffscreenContext == null) {
            EGLCore eGLCore;
            Object object = eGLCore;
            if (!new EGLCore().createContext(null, true)) {
                return null;
            }
            if (!object.createSurface(null)) {
                object.release();
                return null;
            }
            sOffscreenContext = object;
            sEGLExtensions = sOffscreenContext.eglQueryString(12373);
            sGLESVendor = GLES20.glGetString((int)7936);
            sGLESRender = GLES20.glGetString((int)7937);
            object = GLES20.glGetString((int)7938);
            sGLESExtensions = GLES20.glGetString((int)7939);
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = sEGLExtensions;
            Log.d((String)TAG, (String)String.format("EGL_EXTENSIONS.%s", objectArray2));
            Object[] objectArray3 = new Object[4];
            objectArray2 = objectArray3;
            objectArray3[0] = sGLESVendor;
            objectArray3[1] = sGLESRender;
            objectArray3[2] = object;
            objectArray3[3] = sGLESExtensions;
            Log.d((String)TAG, (String)String.format("GL_VENDOR.%s.\nGL_RENDERER.%s.\nGL_VERSION.%s.\nGL_EXTENSIONS.%s", objectArray2));
        }
        return sOffscreenContext;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadGPUFeatureListFromAsset(Context var0) {
        block18: {
            block19: {
                block17: {
                    v0 = var0;
                    var0 = null;
                    v1 = v0.getAssets().open("hardware_bug_workaround.json");
                    v2 = v1;
                    v3 = var1_6 = v1;
                    var0_1 = v3.available();
                    var2_9 = new byte[var0_1];
                    if (v2.read(var2_9) == var0_1) break block17;
                    if (var1_6 == null) return;
                    try {
                        var1_6.close();
                        return;
                    }
                    catch (IOException v4) {
                        Log.i((String)"EGLUtil", (String)v4.toString());
                    }
                    return;
                }
                var0_2 = v5;
                v5 = new String(var2_9);
                try {
                    EGLUtil.loadGPUFeatureListImpl(new JSONObject(var0_2));
                }
                catch (JSONException var0_3) {
                    Log.e((String)"EGLUtil", (String)("parse.json.failed." + var0_3.toString()));
                }
                if (var1_6 == null) return;
                try {}
                catch (IOException v6) {
                    Log.i((String)"EGLUtil", (String)v6.toString());
                    return;
                }
                break block19;
                catch (Throwable var1_7) {
                    break block18;
                }
                catch (IOException var1_8) {
                    // empty catch block
                    ** GOTO lbl-1000
                }
                catch (Throwable var0_4) {
                    var0 = var1_6;
                    var1_6 = var0_4;
                    break block18;
                }
                catch (IOException var0_5) {
                    var0 = var1_6;
                    var1_6 = var0_5;
                    ** GOTO lbl-1000
                }
            }
            var1_6.close();
            return;
lbl-1000:
            // 2 sources

            {
                Log.i((String)"EGLUtil", (String)("load.json.failed." + var1_6.toString()));
                if (var0 == null) return;
            }
            {
                var0.close();
                return;
            }
        }
        if (var0 == null) throw var1_6;
        try {
            var0.close();
            throw var1_6;
        }
        catch (IOException v7) {
            Log.i((String)"EGLUtil", (String)v7.toString());
        }
        throw var1_6;
    }

    private static boolean isPropertyMismatch(JSONObject jSONObject, String string2, String string3) {
        if (string3 == null) {
            return true;
        }
        if (!jSONObject.has(string2)) {
            return false;
        }
        return Pattern.compile(jSONObject.getString(string2)).matcher(string3).find() ^ true;
    }

    private static int androidVersionToApiLevel(String object) {
        if (object != null && ((String)object).length() != 0) {
            if (!((Matcher)(object = VERSION_PATTERN.matcher((CharSequence)object))).matches()) {
                return 15;
            }
            Object object2 = object;
            int n2 = Integer.parseInt(((Matcher)object2).group(1));
            int n3 = 0;
            String string2 = ((Matcher)object2).group(3);
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            block0 : switch (n2) {
                default: {
                    break;
                }
                case 10: {
                    return 29;
                }
                case 9: {
                    return 28;
                }
                case 8: {
                    return n3 >= 1 ? 27 : 26;
                }
                case 7: {
                    return n3 >= 1 ? 25 : 24;
                }
                case 6: {
                    return 23;
                }
                case 5: {
                    return n3 >= 1 ? 22 : 21;
                }
                case 4: {
                    switch (n3) {
                        default: {
                            break block0;
                        }
                        case 4: {
                            return 19;
                        }
                        case 3: {
                            return 18;
                        }
                        case 2: {
                            return 17;
                        }
                        case 1: {
                            return 16;
                        }
                        case 0: 
                    }
                    return 15;
                }
            }
            return 15;
        }
        return 15;
    }

    private static boolean isVersionMismatch(String string2, String string3) {
        int n2 = EGLUtil.androidVersionToApiLevel(string3);
        if (string2 != null && string3 != null) {
            int n3 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1983: {
                    if (!string2.equals(">=")) break;
                    n3 = 1;
                    break;
                }
                case 1952: {
                    if (!string2.equals("==")) break;
                    n3 = 4;
                    break;
                }
                case 1921: {
                    if (!string2.equals("<=")) break;
                    n3 = 3;
                    break;
                }
                case 1084: {
                    if (!string2.equals("!=")) break;
                    n3 = 5;
                    break;
                }
                case 62: {
                    if (!string2.equals(">")) break;
                    n3 = 0;
                    break;
                }
                case 60: {
                    if (!string2.equals("<")) break;
                    n3 = 2;
                }
            }
            switch (n3) {
                default: {
                    return false;
                }
                case 5: {
                    return sAPILevel == n2;
                }
                case 4: {
                    return sAPILevel != n2;
                }
                case 3: {
                    return sAPILevel > n2;
                }
                case 2: {
                    return sAPILevel >= n2;
                }
                case 1: {
                    return sAPILevel < n2;
                }
                case 0: 
            }
            return sAPILevel <= n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadGPUFeatureListImpl(JSONObject objectArray) {
        long l2;
        block5: {
            EGLUtil.getOffscreenContext();
            l2 = System.currentTimeMillis();
            try {
                objectArray = objectArray.getJSONArray("entries");
                for (int i2 = 0; i2 < objectArray.length(); ++i2) {
                    JSONObject jSONObject = objectArray.getJSONObject(i2);
                    boolean bl = false;
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!sMatchers.containsKey(string2) || !sMatchers.get(string2).isMismatch(jSONObject)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    sFeatures.fromJSONObject(jSONObject);
                }
                break block5;
            }
            catch (PatternSyntaxException throwable) {
            }
            catch (JSONException throwable) {
                // empty catch block
            }
            Log.e((String)TAG, (String)throwable.toString());
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = System.currentTimeMillis() - l2;
        Log.i((String)TAG, (String)String.format(Locale.CHINA, "loadGPUFeatureListImpl.json.parser.%dms", objectArray));
    }

    @Nullable
    private static FeatureHolder getCodecFeatures(@Nullable String string2) {
        if (sCodecPatterns.size() != sCodecFeatures.size()) {
            return null;
        }
        if (string2 != null && string2.length() != 0) {
            for (int i2 = sCodecPatterns.size() - 1; i2 >= 0; --i2) {
                if (!sCodecPatterns.get(i2).matcher(string2).find()) continue;
                return sCodecFeatures.get(i2);
            }
            return null;
        }
        return null;
    }

    public static boolean isSystemDecoderAvailable(@Nullable String object) {
        if (EGLUtil.sFeatures.mUseSystemDecoder) {
            return true;
        }
        return (object = EGLUtil.getCodecFeatures((String)object)) != null && ((FeatureHolder)object).mUseSystemDecoder;
    }

    public static boolean isSystemEncoderAvailable(@Nullable String object) {
        if (EGLUtil.sFeatures.mUseSystemEncoder) {
            return true;
        }
        return (object = EGLUtil.getCodecFeatures((String)object)) != null && ((FeatureHolder)object).mUseSystemEncoder;
    }

    public static boolean isDecoderSurfaceTextureAvailable(@Nullable String object) {
        if (EGLUtil.sFeatures.mDecoderOutputSurfaceTexture) {
            return true;
        }
        return (object = EGLUtil.getCodecFeatures((String)object)) != null && ((FeatureHolder)object).mDecoderOutputSurfaceTexture;
    }

    public static int maxDecoderSurfaceInstance() {
        return EGLUtil.sFeatures.mMaxDecoderSurfaceCount;
    }

    public static boolean isEncoderSurfaceTextureAvailable(@Nullable String object) {
        if (EGLUtil.sFeatures.mEncoderInputSurfaceTexture) {
            return true;
        }
        return (object = EGLUtil.getCodecFeatures((String)object)) != null && ((FeatureHolder)object).mEncoderInputSurfaceTexture;
    }

    public static int maxEncoderSurfaceInstance() {
        return EGLUtil.sFeatures.mMaxEncoderSurfaceCount;
    }

    public static int getCodecMinFormatSize(@Nullable String object) {
        if ((object = EGLUtil.getCodecFeatures((String)object)) == null) {
            object = sFeatures;
        }
        return ((FeatureHolder)object).mMinFormatSize;
    }

    public static int getCodecMaxPendingFrames(@Nullable String object) {
        if ((object = EGLUtil.getCodecFeatures((String)object)) == null) {
            object = sFeatures;
        }
        return ((FeatureHolder)object).mMaxPendingFrames;
    }

    public static boolean isVAOAvailable() {
        return EGLUtil.getGLMajorVersion() >= 3 || EGLUtil.hasGLESExtension("GL_OES_vertex_array_object");
    }

    public static boolean isPBOAvailable() {
        return EGLUtil.sFeatures.mUsePBO && EGLUtil.getGLMajorVersion() >= 3;
    }

    public static boolean isHardwareBufferExtensionAvailable() {
        return EGLUtil.sFeatures.mUseHardwareBuffer && EGLUtil.hasEGLExtension("EGL_KHR_image_base") && (Build.VERSION.SDK_INT < 26 || EGLUtil.hasEGLExtension("EGL_ANDROID_get_native_client_buffer"));
    }

    public static synchronized boolean isGLClearAvailable() {
        if (sGLESExtensions == null) {
            EGLUtil.getOffscreenContext();
        }
        return EGLUtil.sFeatures.mUseGLClear;
    }

    public static synchronized boolean hasEGLExtension(String string2) {
        String string3;
        if (sEGLExtensions == null) {
            EGLUtil.getOffscreenContext();
        }
        return (string3 = sEGLExtensions) != null && string3.contains(string2);
    }

    public static synchronized boolean hasGLESExtension(String string2) {
        String string3;
        if (sGLESExtensions == null) {
            EGLUtil.getOffscreenContext();
        }
        return (string3 = sGLESExtensions) != null && string3.contains(string2);
    }

    public static int getGLMajorVersion() {
        return EGLUtil.getGLVersion() >> 16 & 0xFFFF;
    }

    public static int getGLMinorVersion() {
        return EGLUtil.getGLVersion() & 0xFFFF;
    }

    public static synchronized int getGLVersion() {
        if (sGLVersion <= 0) {
            Object[] objectArray;
            sGLVersion = 131072;
            long l2 = System.currentTimeMillis();
            Object[] objectArray2 = objectArray;
            if (new EGLCore(2).createContext(null, false) && objectArray2.createSurface(null)) {
                Object object = GLES10.glGetString((int)7938);
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = object;
                Log.i((String)TAG, (String)String.format("glVersion.versionString.%s", objectArray4));
                object = Pattern.compile("OpenGL\\s?(ES)?\\s?([0-9]+)(\\.([0-9]+))?.*").matcher((CharSequence)object);
                if (((Matcher)object).matches()) {
                    Object object2 = object;
                    sGLVersion = Integer.parseInt(((Matcher)object2).group(2)) << 16;
                    object = ((Matcher)object2).group(4);
                    if (object != null) {
                        sGLVersion |= Integer.parseInt((String)object);
                    }
                }
            }
            objectArray2.release();
            Object[] objectArray5 = new Object[2];
            objectArray2 = objectArray5;
            objectArray5[0] = sGLVersion;
            objectArray5[1] = System.currentTimeMillis() - l2;
            Log.i((String)TAG, (String)String.format(Locale.CHINA, "glVersion.version.%d.time.%dms", objectArray2));
        }
        return sGLVersion;
    }

    @NonNull
    public static String checkGlError(String string2) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string2;
            objectArray2[1] = GLU.gluErrorString((int)n2);
            objectArray[2] = n2;
            return String.format(Locale.CHINA, "%s: glError %s(0x%X)", objectArray2);
        }
        return "";
    }

    @NonNull
    public static String checkEglError(EGLCoreContext eGLCoreContext) {
        int n2 = eGLCoreContext.eglGetError();
        if (n2 != 12288) {
            return EGLUtil.getEglErrorString(n2);
        }
        return "";
    }

    @NonNull
    public static String getEglErrorString(int n2) {
        String string2;
        switch (n2) {
            default: {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                string2 = String.format(Locale.CHINA, "%d", objectArray2);
                break;
            }
            case 12302: {
                string2 = "EGL_CONTEXT_LOST";
                break;
            }
            case 12301: {
                string2 = "EGL_BAD_SURFACE";
                break;
            }
            case 12300: {
                string2 = "EGL_BAD_PARAMETER";
                break;
            }
            case 12299: {
                string2 = "EGL_BAD_NATIVE_WINDOW";
                break;
            }
            case 12298: {
                string2 = "EGL_BAD_NATIVE_PIXMAP";
                break;
            }
            case 12297: {
                string2 = "EGL_BAD_MATCH";
                break;
            }
            case 12296: {
                string2 = "EGL_BAD_DISPLAY";
                break;
            }
            case 12295: {
                string2 = "EGL_BAD_CURRENT_SURFACE";
                break;
            }
            case 12294: {
                string2 = "EGL_BAD_CONTEXT";
                break;
            }
            case 12293: {
                string2 = "EGL_BAD_CONFIG";
                break;
            }
            case 12292: {
                string2 = "EGL_BAD_ATTRIBUTE";
                break;
            }
            case 12291: {
                string2 = "EGL_BAD_ALLOC";
                break;
            }
            case 12290: {
                string2 = "EGL_BAD_ACCESS";
                break;
            }
            case 12289: {
                string2 = "EGL_NOT_INITIALIZED";
                break;
            }
            case 12288: {
                string2 = "EGL_SUCCESS";
            }
        }
        return string2;
    }

    static final class FeatureHolder {
        boolean mUseHardwareBuffer = false;
        boolean mUsePBO = true;
        boolean mUseSystemDecoder = false;
        boolean mUseSystemEncoder = false;
        boolean mDecoderOutputSurfaceTexture = false;
        boolean mEncoderInputSurfaceTexture = false;
        boolean mUseGLClear = true;
        int mMaxPendingFrames = 4;
        int mMinFormatSize = 16;
        int mMaxDecoderSurfaceCount = 1;
        int mMaxEncoderSurfaceCount = 1;

        FeatureHolder() {
        }

        FeatureHolder fromJSONObject(JSONObject jSONObject) {
            Object object;
            if (jSONObject.has("features")) {
                object = jSONObject.getJSONArray("features");
                for (int i2 = 0; i2 < object.length(); ++i2) {
                    String string2 = object.getString(i2);
                    if (!sHolderSetters.containsKey(string2)) continue;
                    sHolderSetters.get(string2).set(this, jSONObject);
                }
            }
            if (jSONObject.has("default_parameters")) {
                jSONObject = jSONObject.getJSONObject("default_parameters");
                object = jSONObject.keys();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (!sHolderSetters.containsKey(string3)) continue;
                    sHolderSetters.get(string3).set(this, jSONObject);
                }
            }
            return this;
        }
    }

    private static interface FeatureSetter {
        public void set(FeatureHolder var1, JSONObject var2);
    }

    private static interface DeviceMatcher {
        public boolean isMismatch(JSONObject var1);
    }
}

