package com.tencent.wecast.utils;

import android.os.Build;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * 当 WebView在共享了系统进程的app上时 会进行安全性检测
 * 在创建WebView之前 创建 sProviderInstance 对象
 */

public class WebViewSecurityCheckUtil {
    public static final String TAG = "WebViewSecurityCheckUtil";

    public static void hookWebView() {
        int sdkInt = Build.VERSION.SDK_INT;
        try {
            Class<?> factoryClass = Class.forName("android.webkit.WebViewFactory");
            Field field = factoryClass.getDeclaredField("sProviderInstance");
            field.setAccessible(true);
            Object sProviderInstance = field.get(null);
            if (null != sProviderInstance) {
                Logger.t(TAG).d("sProviderInstance isn't null");
                return;
            }
            Method getProviderClassMethod;
            if (sdkInt > 22) {  // above 22
                getProviderClassMethod = factoryClass.getDeclaredMethod("getProviderClass");
            } else if (sdkInt == 22) {  // method name is a little different
                getProviderClassMethod = factoryClass.getDeclaredMethod("getFactoryClass");
            } else {  // no security check below 22
                Logger.t(TAG).d("no need to Hook WebView");
                return;
            }
            getProviderClassMethod.setAccessible(true);
            Class<?> providerClass = (Class<?>) getProviderClassMethod.invoke(factoryClass);
            Class<?> delegateClass = Class.forName("android.webkit.WebViewDelegate");
            if(providerClass!=null){
                Constructor<?> providerConstructor = providerClass.getConstructor(delegateClass);
                if (null != providerConstructor) {
                    providerConstructor.setAccessible(true);
                    Constructor<?> declaredConstructor = delegateClass.getDeclaredConstructor();
                    declaredConstructor.setAccessible(true);
                    sProviderInstance =
                            providerConstructor.newInstance(declaredConstructor.newInstance());
                    Logger.t(TAG).d("sProviderInstance: " + sProviderInstance);
                    field.set("sProviderInstance", sProviderInstance);
                }
                Logger.t(TAG).d("Hook WebView done!");
            }
        } catch (Throwable e) {
            Logger.t(TAG).e("Throwable is " + e.toString());
        }
    }
}
