package com.tencent.wecast.utils;

import android.content.Context;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 获取接收端启动时，运行中系统内核日志
 */
public class SysLogcatUtil {

    private static final String TAG = "SysLogcatUtil";

    private ExecutorService mThread = Executors.newCachedThreadPool();

    private static volatile SysLogcatUtil mInstance;

    private String mPackageName;

    private SysLogcatUtil() {
    }

    public static SysLogcatUtil getInstance(){
        if(mInstance == null){
            synchronized (SysLogcatUtil.class){
                if (mInstance == null){
                    mInstance = new SysLogcatUtil();
                }
            }
        }
        return mInstance;
    }

    /**
     * 获取系统Logcat
     */
    public void getSysLogcat() {
        mThread.execute(mGetSysLogcatRunnable);
        mThread.execute(mRunningKernelLogRunnable);
    }

    /**
     * 初始化系统日志路径
     * @param context Application Context
     */
    public void initSysLogPath(Context context){
        mPackageName = context.getPackageName();
        saveStartKernelLog();
        getSysLogcat();
    }

    /**
     *保存启动内核日志
     */
    private void saveStartKernelLog() {
        mThread.execute(mInitKernelLogRunnable);
    }

    /**
     *系统日志
     */
    private Runnable mGetSysLogcatRunnable = new Runnable() {
        @Override
        public void run() {
            try {
                String curLogcatFileName = SysLogPathUtil.getCurWmpSysLogcatFileName(SysLogPathUtil.TYPE_LOGCAT,mPackageName).toString();
                List<String> commandLine = new ArrayList<>();
                commandLine.add("logcat");
                commandLine.add("-d");
                commandLine.add("-v");
                commandLine.add("time");
                commandLine.add("-f");
                commandLine.add(curLogcatFileName);
                Logger.t(TAG).d("exec the command is %s", commandLine.toString());
                Runtime.getRuntime().exec(commandLine.toArray(new String[0]));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    };

    /**
     * app运行中捞取的kernel日志
     */
    private Runnable mRunningKernelLogRunnable = new Runnable() {
        @Override
        public void run() {
            try {
                String kernelLogOutPath = SysLogPathUtil.getCurWmpSysLogcatFileName(SysLogPathUtil.TYPE_ERROR_KERNEL,mPackageName)
                        .getAbsolutePath();
                ShellUtils.execCmd(getSegmentShell(kernelLogOutPath),false);
                ShellUtils.execCmd("/system/bin/dmesg &>> " + kernelLogOutPath,false);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    /**
     *  app启动时kernel的log日志
     */
    private Runnable mInitKernelLogRunnable = new Runnable() {
        @Override
        public void run() {
            try {
                String kernelLogOutPath = SysLogPathUtil.getCurWmpSysLogcatFileName(SysLogPathUtil.TYPE_KERNEL_INIT,mPackageName).getAbsolutePath();
                ShellUtils.execCmd(getSegmentShell(kernelLogOutPath),false);
                ShellUtils.execCmd("/system/bin/dmesg &>> " + kernelLogOutPath,false);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private String getSegmentShell(String kernelLogOutPath) {
        String currTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault())
                .format(new Date());
        String msg = "===================================================================================\n" +
                "============================> " + currTime + " <============================\n"
                + "===================================================================================\n";
        return String.format("echo '%s' &>> %s", msg, kernelLogOutPath);
    }

}

