package com.tencent.wecast.sender.eb;

import com.google.gson.JsonObject;
import com.tencent.wecast.jni.ParamsPackage;
import com.tencent.wecast.utils.GsonUtil;

import java.io.IOException;

public class SenderEvents {
    public final static int TypeUIConfigUpdate = 0x2000;
    public final static int TypeLoginSuccess = 0x2001;
    public final static int TypeEnterLoading = 0x2002;
    public final static int TypeClearEdit = 0x2003;
    public final static int TypeEditFocus = 0x2004;
    public final static int TypeShowError = 0x2005;
    public final static int TypePushToCastingView = 0x2006;
    public final static int TypeAppUpdate = 0x2007;
    public final static int TypeAppHasNormalUpdate = 0x2008;    // @deprecated
    public final static int TypeLoginFailed = 0x2009;
    public final static int TypeCanRecover = 0x200a;
    public final static int TypeNetWorkStateTips = 0x2100;
    public final static int TypeNetworkStateGridChange = 0x2101;
    public final static int TypeExitCastView = 0x2102;
    public final static int TypeAddCastSuccess = 0x2103;
    public final static int TypeAddCastFailed = 0x2104;
    public final static int TypeMemberListViewRefresh = 0x2105;
    public final static int TypeUpdateReceiverMember = 0x2106;
    public final static int TypeMultiCastDiscovery = 0x2107;
    public final static int TypeC2CMessage = 0x2108;
    public final static int TypeShowTips = 0x2109;
    public final static int TypeXCastPause = 0x210a;
    public final static int TypeDisconnectPopup = 0x210b;
    public final static int TypeStreamReconnect = 0x210c;
    public final static int TypeAuthCodeError = 0x210d;

    public static class EUIConfigUpdate {
        public String uiConfig;
        public int castScheme;  // 1-局域网方案 2-公网方案

        public static EUIConfigUpdate from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EUIConfigUpdate event = new EUIConfigUpdate();
            event.uiConfig = (String) params.getNext();
            event.castScheme = (int) params.getNext();
            return event;
        }
    }

    public static class ELoginSuccess {
        public static ELoginSuccess from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new ELoginSuccess();
        }
    }

    public static class EEnterLoading {
        public boolean isLoading;

        public static EEnterLoading from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EEnterLoading event = new EEnterLoading();
            event.isLoading = (boolean) params.getNext();
            return event;
        }
    }

    public static class EClearEdit {
        public static EClearEdit from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EClearEdit();
        }
    }

    public static class EEditFocus {
        public static EEditFocus from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EEditFocus();
        }
    }

    public static class EStopCast{
        public static EStopCast from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EStopCast();
        }
    }

    public static class EShowError {
        public int errorCode;   // 见mvc/error.h中定义

        public static EShowError from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EShowError event = new EShowError();
            event.errorCode = (int) params.getNext();
            return event;
        }
    }

    public static class EPushToCastingView {
        public static EPushToCastingView from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EPushToCastingView();
        }
    }

    public static class EAppUpdate {
        public boolean needUpdate;
        public boolean forceUpdate;
        public String url;
        public String forceUrl;
        public String md5;
        public String msg;

        public static EAppUpdate from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EAppUpdate event = new EAppUpdate();
            event.needUpdate = (boolean) params.getNext();
            event.forceUpdate = (boolean) params.getNext();
            event.url = (String) params.getNext();
            event.forceUrl = (String) params.getNext();
            event.md5 = (String) params.getNext();
            event.msg = (String) params.getNext();
            return event;
        }
    }

    public static class ELoginFailed {
        public int errorCode;

        public static ELoginFailed from(ParamsPackage.ParamsFromCpp params) throws IOException {
            ELoginFailed event = new ELoginFailed();
            event.errorCode = (int) params.getNext();
            return event;
        }
    }

    public static class ECanRecover {
        public Boolean reInvite;
        public String inviteeId;
        public String inviteeDeviceName;
        public Long lastExitTime;

        public static ECanRecover from(ParamsPackage.ParamsFromCpp params) throws IOException {
            ECanRecover event = new ECanRecover();
            event.reInvite = (Boolean) params.getNext();
            event.inviteeId = (String) params.getNext();
            event.inviteeDeviceName = (String) params.getNext();
            event.lastExitTime = (Long) params.getNext();
            return event;
        }
    }

    public static class ENetWorkStateTips {
        public boolean isDisconnected;

        public static ENetWorkStateTips from(ParamsPackage.ParamsFromCpp params) throws IOException {
            ENetWorkStateTips event = new ENetWorkStateTips();
            event.isDisconnected = (boolean) params.getNext();
            return event;
        }
    }

    public static class EDisconnectPopup {
        public String msg;

        public static EDisconnectPopup from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EDisconnectPopup event = new EDisconnectPopup();
            event.msg = (String) params.getNext();
            return event;
        }
    }

    public static class EStreamReconnect {
        public String msg;

        public static EStreamReconnect from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EStreamReconnect event = new EStreamReconnect();
            event.msg = (String) params.getNext();
            return event;
        }
    }

    public static class ENetworkStateGridChange {
        public static ENetworkStateGridChange from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new ENetworkStateGridChange();
        }
    }

    public static class EExitCastView {
        public int exitReason;

        public static EExitCastView from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EExitCastView event = new EExitCastView();
            event.exitReason = (int) params.getNext();
            return event;
        }
    }

    public static class EAddCastSuccess {
        public static EAddCastSuccess from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EAddCastSuccess();
        }
    }

    public static class EAddCastFailed {
        public int errorCode;

        public static EAddCastFailed from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EAddCastFailed event = new EAddCastFailed();
            event.errorCode = (int) params.getNext();
            return event;
        }
    }

    public static class EMemberListViewRefresh {
        public static EMemberListViewRefresh from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EMemberListViewRefresh();
        }
    }

    public static class EUpdateReceiverMember {
        public String memberListJsonStr;

        public static EUpdateReceiverMember from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EUpdateReceiverMember event = new EUpdateReceiverMember();
            event.memberListJsonStr = (String) params.getNext();
            return event;
        }
    }

    public static class EMultiCastDiscovery {
        public String mEMultiCastDiscoveryDLNARsp = "";
        public String mEMultiCastDiscoveryGoogleCastRsp = "";

        public static EMultiCastDiscovery from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EMultiCastDiscovery event = new EMultiCastDiscovery();
            String content = (String) params.getNext();
            if (!content.isEmpty()) {
                JsonObject jsonObj = GsonUtil.getGson().fromJson(content, JsonObject.class);
                if (jsonObj.has("dlna")) {
                    event.mEMultiCastDiscoveryDLNARsp = jsonObj.get("dlna").getAsString();
                }
                if (jsonObj.has("googlecast")) {
                    event.mEMultiCastDiscoveryGoogleCastRsp = jsonObj.get("googlecast").getAsString();
                }
            }
            return event;
        }
    }

    public static class EC2CMessage {
        public int cmd;
        public String data;

        public static EC2CMessage from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EC2CMessage event = new EC2CMessage();
            event.cmd = (int) params.getNext();
            event.data = (String) params.getNext();
            return event;
        }
    }

    public static class EShowTips {
        public String tips;

        public static EShowTips from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EShowTips event = new EShowTips();
            event.tips = (String) params.getNext();
            return event;
        }
    }

    public static class EXCastPause {
        public boolean isPause;

        public static EXCastPause from(ParamsPackage.ParamsFromCpp params) throws IOException {
            EXCastPause event = new EXCastPause();
            event.isPause = (boolean) params.getNext();
            return event;
        }
    }

    public static class EAuthCodeError{
        public static EAuthCodeError from(ParamsPackage.ParamsFromCpp params) throws IOException {
            return new EAuthCodeError();
        }
    }

    public static class ERequestAuthCode{
        public final int SUCCESS = 0;
        public final int ERROR = 1;
        public String corpId;
        public String authCode;
        public String corpName;
        public int eventCode;
        public Integer requestCode;
        public boolean isChangeCorp;
        public boolean isNewCorp;
    }

    public static class EStopSplashEvent{
        public final int SUCCESS = 0;
        public final int ERROR = 1;
        public int eventCode;
    }

    public static class EShowCantChangeCorp{}
}
