package com.tencent.wecast.sender.cloud.service

import android.app.*
import android.content.Intent
import android.graphics.Color
import android.os.IBinder
import android.support.v4.app.NotificationCompat
import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.activity.CloudMainActivity1
import com.tencent.wecast.sender.cloud.activity.CloudMainActivity2
import com.tencent.wecast.utils.Logger


class NotificationService : Service() {
    companion object {
        const val TAG = "NotificationService"
        const val NOTIFICATION_NAME = "WeCastNotification"
        const val NOTIFICATION_ID = 999
        const val CHANNEL_ID = "com.tencent.wecast.sender.cloud"
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        Logger.t(TAG).d("Notification Server onStartCommand")

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            var notificationChannel: NotificationChannel? = null
            notificationChannel = NotificationChannel(CHANNEL_ID,
                    NOTIFICATION_NAME, NotificationManager.IMPORTANCE_HIGH)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = Color.RED
            notificationChannel.setShowBadge(true)
            notificationChannel.lockscreenVisibility = Notification.VISIBILITY_PUBLIC
            val manager = getSystemService(NOTIFICATION_SERVICE) as NotificationManager
            manager.createNotificationChannel(notificationChannel)
        }
        val notificationBuilder = NotificationCompat.Builder(this, NOTIFICATION_NAME)
        notificationBuilder.setSmallIcon(R.mipmap.wecast_ic_launcher)
        notificationBuilder.setWhen(System.currentTimeMillis())
        notificationBuilder.setContentTitle(getString(R.string.wecast_main_in_room_casting_text_2))
        notificationBuilder.setContentText(getString(R.string.wecast_click_jump_to_wecast))
        notificationBuilder.setChannelId(CHANNEL_ID)
        val notificationIntent: Intent = if (WeCastConfigManager.getInstance().isLanScheme) {
            Intent(this.applicationContext, CloudMainActivity1::class.java)
        } else {
            Intent(this.applicationContext, CloudMainActivity2::class.java)
        }
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        val id = (System.currentTimeMillis() / 1000).toInt()
        val contentIntent = PendingIntent.getActivity(this.applicationContext, id,
                notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT)
        notificationBuilder.setContentIntent(contentIntent)
        val notification = notificationBuilder.build() // 获取构建好的Notification
        startForeground(NOTIFICATION_ID, notification)// 开始前台服务
        return super.onStartCommand(intent, flags, startId)
    }

    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    override fun onDestroy() {
        super.onDestroy()
        Logger.t(TAG).d("Notification Server onDestroy")
        stopForeground(true)
    }
}