package com.tencent.wecast.sender.cloud.activity

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.text.TextUtils
import android.util.Base64
import android.view.View
import android.webkit.*
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.activity.CloudLoginActivity.Companion.CORP_NAME
import com.tencent.wecast.sender.cloud.activity.CloudLoginActivity.Companion.TOKEN_KEY
import com.tencent.wecast.utils.Logger
import com.tencent.wecast.utils.NetworkUtil
import java.net.URLDecoder


class CloudWebViewActivity : BaseActivity() {

    companion object {
        const val TAG = "CloudWebViewActivity"
        const val TITLE = "title"
        const val WEB_URL = "webUrl"
        const val PRIVACY_POLICY = "https://tcd.tencent.com/privacypolicy.html"
        const val SERVICE_AGREEMENT = "https://tcd.tencent.com/eula.html"
        const val FEEDBACK = "https://support.qq.com/products/41782"
        const val CORP_TOKEN = "corpToken"
        const val CONFIG_CENTER_URL = "configCenterUrl"
        const val CORP_AUTH_URL = "corpAuthUrl"
        const val CHANGE_CROP = "changeCrop"
        const val TOKEN_SIGN = "tokenSign"
        const val CLICK_CHANGE_CORP = "clickChangeCorp"//非扫码ChangeCorp
        const val INIT_TEXT_HTML = "textHtml"
    }

    private var mBtnClose: ImageView? = null
    private var mTvTitle: TextView? = null
    private var mWebView: WebView? = null
    private var mProgressBar: ProgressBar? = null

    private var mUrl: String? = null
    private var mIsChangeCorp = false
    private var mIsClickChangeCorp = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.wecast_activity_webview)
        mIsClickChangeCorp = intent.getBooleanExtra(CLICK_CHANGE_CORP, false)
        mIsChangeCorp = intent.getBooleanExtra(CHANGE_CROP, false)
        mUrl = intent.getStringExtra(WEB_URL)
        if (!TextUtils.isEmpty(intent.getStringExtra(TITLE))) {
            mTvTitle?.text = intent.getStringExtra(TITLE)
        }
        initView()
        initWebView()
        if (intent.getBooleanExtra(INIT_TEXT_HTML, false)) {
            val mimeType = "text/html"
            val enCoding = "utf-8"
            val stringHtml = "<html>\n" +
                    "    <head>\n" +
                    "        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n" +
                    "        <title>$mTvTitle</title>\n" +
                    "    </head>\n" +
                    "    <body>\n" +
                    "        <p style=\"font-size:40px\">$mUrl</p> " +
                    "    </body>\n" +
                    "</html>"
            Logger.d("webview html content: $stringHtml")
            mWebView?.loadDataWithBaseURL(null, stringHtml, mimeType, enCoding, null)
        } else {
            Logger.d("webview url: $mUrl")
            mWebView?.loadUrl(mUrl)
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun initView() {
        mBtnClose = findViewById(R.id.btn_wv_close)
        mTvTitle = findViewById(R.id.tv_webview_title)
        mWebView = findViewById(R.id.wv_wecast)
        mProgressBar = findViewById(R.id.pb_webview)
        mBtnClose?.setOnClickListener {
            this.onBackPressed()
        }
    }

    private fun initWebView() {
        // 设置可以支持缩放
        mWebView?.settings?.setSupportZoom(true)
        // 设置出现缩放工具
        mWebView?.settings?.builtInZoomControls = false
        //扩大比例的缩放
        mWebView?.settings?.useWideViewPort = true
        //自适应屏幕
        mWebView?.settings?.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN
        mWebView?.settings?.loadWithOverviewMode = true
        //支持js
        mWebView?.settings?.javaScriptEnabled = true
        mWebView?.settings?.domStorageEnabled = true
        val appCachePath = applicationContext.cacheDir.absolutePath
        mWebView?.settings?.setAppCachePath(appCachePath)
        mWebView?.settings?.setAppCacheEnabled(true)
        mWebView?.webViewClient = object : WebViewClient() {
            @Override
            override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
                if (url != null) {
                    if (url.startsWith("wecast://bind")) {
                        val uri = Uri.parse(url)
                        val corpToken: String?
                        var corpAuthUrl: String? = null
                        var configCenterUrl: String? = null
                        var corpName: String? = null
                        var tokenKey: String? = null
                        if (uri != null) {
                            // 完整的url信息
                            Logger.t(TAG).d("url: $uri")
                            corpToken = decodeSchemeParam(uri.getQueryParameter("ct"))
                            corpName = decodeSchemeParam(uri.getQueryParameter("cn"))
                            tokenKey = decodeSchemeParam(uri.getQueryParameter("tk"))
                            val privateFlag: Int? = decodeSchemeParam(uri.getQueryParameter("pf"))?.toInt()
                            if (corpToken != null && privateFlag != null) {
                                if (privateFlag == 1) {
                                    corpAuthUrl = decodeSchemeParam(uri.getQueryParameter("cau"))
                                    configCenterUrl = decodeSchemeParam(uri.getQueryParameter("ccu"))
                                }
                                val intent = Intent()
                                intent.putExtra(CHANGE_CROP, mIsChangeCorp)
                                intent.putExtra(CLICK_CHANGE_CORP, mIsClickChangeCorp)
                                intent.putExtra(CORP_TOKEN, corpToken)
                                intent.putExtra(CORP_NAME, corpName)
                                intent.putExtra(TOKEN_KEY, tokenKey)
                                if (!TextUtils.isEmpty(configCenterUrl)) {
                                    intent.putExtra(CONFIG_CENTER_URL, configCenterUrl)
                                }
                                if (!TextUtils.isEmpty(corpAuthUrl)) {
                                    intent.putExtra(CORP_AUTH_URL, corpAuthUrl)
                                }
                                if (!mIsChangeCorp) {
                                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK)
                                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                                }
                                setResult(Activity.RESULT_OK, intent)
                                finish()
                                return true
                            } else {
                                Logger.t(TAG).e("scheme url error")
                            }
                        }
                    }
                }
                return false
            }

            override fun onReceivedError(view: WebView?, request: WebResourceRequest?, error: WebResourceError?) {
                super.onReceivedError(view, request, error)
                mProgressBar?.visibility = View.GONE
            }
        }

        mWebView?.webChromeClient = object : WebChromeClient() {
            override fun onProgressChanged(view: WebView?, newProgress: Int) {
                if (newProgress == 100) {
                    mProgressBar?.visibility = View.GONE
                } else {
                    mProgressBar?.visibility = View.VISIBLE
                    mProgressBar?.progress = newProgress
                }
                super.onProgressChanged(view, newProgress)
            }
        }
    }

    private fun decodeSchemeParam(sourceStr: String?): String? {
        if (sourceStr == null) {
            return null
        }
        return URLDecoder.decode(String(Base64.decode(URLDecoder.decode(sourceStr, "UTF-8")
                , Base64.NO_WRAP))
                , "UTF-8")
    }

    override fun onBackPressed() {
        val originalUrl = mWebView?.copyBackForwardList()?.currentItem?.originalUrl
        if (NetworkUtil.isNetworkConnected(applicationContext)
                && mWebView != null && mWebView!!.canGoBack()
                && !originalUrl.equals(mUrl)) {
            mWebView?.goBack()
        } else {
            super.onBackPressed()
        }
    }
}