package com.tencent.wecast.c2c;

import com.tencent.wecast.jni.JniHelper;
import com.tencent.wecast.utils.Logger;

public class WeCastC2CUtil {
    public static void send(C2CMessage message) {
        Logger.kp().d("Send C2C Msg: " + message.toString());
        JniHelper.callJniFunc("sendC2CMessage",
                message.type().getCmd(),
                message.getData());
    }

    public static C2CMessage parse(int cmd, String data) {
        switch (cmd) {
            case 1: { // C2C_S2R_GUIDE
                // @warning: 不用处理,底层直接给出了接口
                break;
            }
            case 2: { // C2C_R2S_PAUSE_XCAST
                return new C2CPauseXCastMsg(data);
            }
            case 3: { // C2C_R2S_PUSH_UPDATE
                return new C2CPushUpdateMsg(data);
            }
            case 4: { // C2C_S2R_QUERY
                return new C2CQueryMsg(data);
            }
            case 5: { // C2C_S2R_IOS_REPLY_KIT_READY
                return new C2CIOSReplayKitReadyMsg(data);
            }
            case 6: { // C2C_R2S_SSDP_SOURCE_QUERY
                return new C2CQuerySsdpIpMsg();
            }
            case 7: { // C2C_S2R_SSDP_SOURCE_IP_NOTIFY
                return new C2CSsdpIpMsg(data);
            }
            case 8: { // C2C_S2R_SSDP_DISCOVERY
                return new C2CSsdpDiscoveryMsg(data);
            }
            default:
                return new C2CMessage();
        }
        return new C2CMessage();
    }

}
