package com.tencent.wecast;

import com.tencent.wecast.jni.JniHelper;
import com.tencent.wecast.jni.ParamsPackage;

import java.io.IOException;

public abstract class BaseEBHandle {
    private final static String TAG = "BaseEBHandle";

    public void registerHandle() {
        JniHelper.registerFunc4Cpp("postEvent",
                new JniHelper.OnCppCall() {
                    @Override
                    public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                        try {
                            int eventType = (int) params.getNext();
                            handleEvent(eventType, params);
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
    }

    protected abstract void handleEvent(int eventType,
                                        ParamsPackage.ParamsFromCpp params) throws IOException;
}
