package com.tencent.wecast.utils;

import com.tencent.wecast.jni.JniHelper;

public class ReportUtils {

    // ---------- Receiver Event ----------
    // AirPlay和Dlna相关事件
    public static final int EVENT_AIRPLAY_STREAM_START = 167;        //AirPlay流开始
    public static final int EVENT_AIRPLAY_STREAM_END = 168;          //AirPlay流结束
    public static final int EVENT_DLNA_STREAM_START = 169;           //Dlna流开启
    public static final int EVENT_DLNA_STREAM_END = 170;             //Dlna流结束
    public static final int EVENT_PLAYER_START = 171;                //播放开始
    public static final int EVENT_PLAYER_STOP = 172;                 //播放停止
    public static final int EVENT_PLAYER_PAUSE = 173;                //播放暂停
    public static final int EVENT_DLNA_PLAYER_SEEK = 174;
    public static final int EVENT_AIRPLAY_PLAYER_SEEK = 175;

    public static final int EVENT_STORAGE_INFO = 200;

    // ---------- Sender Event ----------
    // 500~1000 按钮相关事件
    public static final int EVENT_TENCENT_VIDEO_CLICK = 513;          //点击了腾讯视频按钮
    public static final int EVENT_YOUKU_CLICK = 514;                  //点击了优酷按钮
    public static final int EVENT_YOUTUBE_CLICK = 515;                //点击了Youtube按钮
    public static final int EVENT_AIQIYI_CLICK = 516;                 //点击了爱奇艺按钮
    //问题排查事件（临时事件）
    public static final int EVENT_PROBLEM_SYSTEM_STUCK = 1503;        // 排查系统卡住的事件

    public static final int EVENT_PROBLEM_SYSTEM_UPTIME = 1504;       // 系统运行时长
    public static final int EVENT_PROBLEM_BLUETOOTH_ENABLE = 1505;    // 蓝牙是否可用

    // 熄屏相关
    public static final int EVENT_BTN_SCREEN_OUT = 506;                           // 熄屏-触发熄屏
    public static final int EVENT_BTN_SCREEN_OUT_CLICK_BAR = 507;                   // 熄屏-点击熄屏提示条（507）
    public static final int EVENT_BTN_SCREEN_OUT_SHOW_DIALOG = 508;                 // 熄屏-点击熄屏提示条弹出对话框（508）
    public static final int EVENT_BTN_SCREEN_OUT_DIALOG_CLICK_SETTING = 509;        // 熄屏-熄屏对话框点击前往设置（509）
    public static final int EVENT_BTN_SCREEN_OUT_FIRST_FORCE_SHOW_DIALOG = 510;     // 熄屏-首次强制弹出对话框（510）
    // 封版本点击事件
    public static final int EVENT_BTN_FORBIDDEN_VER_CONFIRM = 519;                   // 封版本升级点击确认按钮
    public static final int EVENT_BTN_FORBIDDEN_VER_UPDATE_NOW = 520;                // 封版本升级点击立即升级按钮

    /**
     * 添加事件上报
     *
     * @param event_key  事件码
     * @param error_code 错误码
     * @param extra      补充信熄
     */
    public static void AddEventReport(int event_key, int error_code, String extra) {
        JniHelper.callJniFunc("addEventReport", event_key, error_code, extra);
    }
}
