package com.tencent.wecast.c2c;

/**
 * 暂停XCast的消息
 * 形如：{"dataType": 2, "data":"1"}
 */
public class C2CPauseXCastMsg extends C2CMessage {
    private boolean pause = false;

    public C2CPauseXCastMsg(boolean pause) {
        this.pause = pause;
    }

    public C2CPauseXCastMsg(String data) {
        this.pause = "1".equals(data);
    }

    public boolean isPause() {
        return pause;
    }

    @Override
    public C2CMsgType type() {
        return C2CMsgType.C2C_R2S_PAUSE_XCAST;
    }

    @Override
    public String getData() {
        return pause ? "1" : "0";
    }

    @Override
    public String toString() {
        return "C2CPauseXCastMsg{" +
                "dataType:" + type().getCmd() +
                ", pause:" + pause +
                '}';
    }
}
