/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.graphics.SurfaceTexture;
import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.SurfaceTextureHolder;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class MediaCodecSurface {
    private static final String TAG = "MediaCodecSurface";
    private SurfaceTextureHolder mDecoderTextureHolder;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private final Semaphore mSemaphore = new Semaphore(0);

    @AnyThread
    private MediaCodecSurface(int n2, int n3) {
        this.mWidth = n2;
        this.mHeight = n3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public int createSurface() {
        Throwable throwable2;
        EGLCore eGLCore;
        EGLCore eGLCore2 = eGLCore;
        if (!new EGLCore().createContext(EGLUtil.getOffscreenContext(), true)) throw new IllegalArgumentException("createContext.failed");
        if (!eGLCore2.createSurface(null)) throw new IllegalArgumentException("createSurface.failed");
        this.mDecoderTextureHolder = new SurfaceTextureHolder(this.mWidth, this.mHeight, (SurfaceTextureHolder.EventCallback)new SurfaceHolderEvent(this.mSemaphore), eGLCore2);
        this.mSurface = this.mDecoderTextureHolder.getSurface();
        eGLCore2.release();
        return 0;
        {
            catch (Throwable throwable2) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            {
                Platform.logError("createMediaCodecSurface.failed");
                eGLCore2.release();
            }
            return -1;
        }
        eGLCore2.release();
        throw throwable2;
    }

    @AnyThread
    public Surface getSurface() {
        return this.mSurface;
    }

    @AnyThread
    public SurfaceTextureHolder getSurfaceHolder() {
        return this.mDecoderTextureHolder;
    }

    @AnyThread
    public void setSize(int n2, int n3) {
        this.mWidth = n2;
        this.mHeight = n3;
    }

    @AnyThread
    public int getFrameAvailable(long l2) {
        try {
            int n2 = this.mSemaphore.tryAcquire(l2, TimeUnit.MICROSECONDS) ? 0 : -2;
            if (this.mSurface == null) {
                n2 = -1;
            }
            return n2;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return -2;
        }
    }

    @AnyThread
    public void release() {
        MediaCodecSurface mediaCodecSurface = this;
        mediaCodecSurface.mSurface = null;
        mediaCodecSurface.mDecoderTextureHolder.release();
        mediaCodecSurface.mDecoderTextureHolder = null;
        mediaCodecSurface.mSemaphore.release();
    }

    private static class SurfaceHolderEvent
    implements SurfaceTextureHolder.EventCallback {
        private final Semaphore mParentSemaphore;

        SurfaceHolderEvent(Semaphore semaphore) {
            this.mParentSemaphore = semaphore;
        }

        @Override
        public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
            this.mParentSemaphore.release();
        }

        @Override
        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
        }
    }
}

