package com.tencent.wecast.sender.cloud.widget

import android.app.Activity
import android.app.Dialog
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import android.widget.ListView
import android.widget.RelativeLayout
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.adapter.FunctionListAdapter
import com.tencent.wecast.sender.cloud.bean.FunctionItemInfo

class FunctionDialog constructor(activity: Activity, functionItemList: List<FunctionItemInfo>, title: String?)
    : Dialog(activity, R.style.WeCastBottomSheetDialog) {

    private var mLvFunction: ListView? = null
    private var mRlCancel: RelativeLayout? = null
    private var mTvTitle: TextView? = null
    private val mFunctionItemList = functionItemList
    private val mTitle = title

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.wecast_dialog_function)
        val window = this.window
        window?.setGravity(Gravity.BOTTOM)
        val params = window?.attributes
        params?.width = WindowManager.LayoutParams.MATCH_PARENT
        params?.height = WindowManager.LayoutParams.WRAP_CONTENT
        window?.attributes = params
        initView()
    }

    private fun initView() {
        mLvFunction = findViewById(R.id.lv_function)
        mLvFunction?.adapter = FunctionListAdapter(context, mFunctionItemList)
        mRlCancel = findViewById(R.id.rl_cancel_function)
        mRlCancel?.setOnClickListener {
            this.dismiss()
        }
        mTvTitle = findViewById(R.id.tv_function_title)
        if (!TextUtils.isEmpty(mTitle)) {
            mTvTitle?.visibility = View.VISIBLE
            mTvTitle?.text = String.format(context.getString(R.string.wecast_bottom_sheet_dialog_title), mTitle)
        }else{
            mTvTitle?.visibility = View.GONE
        }
    }
}