package com.tencent.wecast.sender.cloud.config

import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.bean.WeCastInfo

/**
 * 发送端编译构建时修改配置
 */
class SenderCompileConfig {

    /**
     * 发送端编译构建时配置
     * @warning：RDM构建时会修改的代码，默认值修改了不可提交
     */
    companion object {

        @JvmStatic
        fun getDefaultTId(): WeCastUIConfigManager.UITemplateId {
            return if (!WeCastInfo.instance.usingMirror
                    || WeCastConfigManager.getInstance().isLanScheme) {
                WeCastUIConfigManager.UITemplateId.TEMPLATE_1
            } else {
                WeCastUIConfigManager.UITemplateId.TEMPLATE_2
            }
        }

        // RDM构建调整ui version
        const val SENDER_UI_VERSION = 1

        // 参考@class WeCastAppType 中类型（RDM构建时修改）
        // 云版本 4
        // 私有化版本 5
        const val SENDER_APP_TYPE_OPEN = 4
        const val SENDER_APP_TYPE_PRIVATE = 5
    }

}
