package com.tencent.wecast.sender;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.tencent.wecast.utils.WeCastUtil;

public class WeCastUserManager {
    private static final String SP_USER_INFO = "wecast_user";
    private static final String KEY_USER_NAME = "user_name";
    private static final String KEY_USER_PWD = "user_pwd";
    private static final String KEY_USER_NICK = "user_nick";

    private static final WeCastUserManager ourInstance = new WeCastUserManager();

    public static WeCastUserManager getInstance() {
        return ourInstance;
    }

    private UserInfo mUserInfo;

    private WeCastUserManager() {
        mUserInfo = new UserInfo();
    }

    public void init(Context context) {
        Context appContext = context.getApplicationContext();
        SharedPreferences sp = appContext.getSharedPreferences(SP_USER_INFO, Context.MODE_PRIVATE);
        mUserInfo.userName = sp.getString(KEY_USER_NAME, "");
        mUserInfo.userPwd = sp.getString(KEY_USER_PWD, "");
        mUserInfo.nickName = sp.getString(KEY_USER_NICK, "");

        if (TextUtils.isEmpty(mUserInfo.userName)
                || TextUtils.isEmpty(mUserInfo.userPwd)) {
            mUserInfo.userName = WeCastUtil.genUUID();
            mUserInfo.userPwd = WeCastUtil.genUUID();
        }
    }

    public UserInfo getUserInfo() {
        return mUserInfo;
    }

    public WeCastUserManager setUserNick(String nick) {
        mUserInfo.nickName = nick;
        return this;
    }

    public static class UserInfo {
        public String userName = "";
        public String userPwd = "";
        public String nickName = "";
    }
}
