/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.graphics.Matrix;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.view.MotionEvent;
import android.view.View;
import com.tencent.xcast.BasicTexture;
import com.tencent.xcast.GLCanvas;
import com.tencent.xcast.GLES20Canvas;
import com.tencent.xcast.GLRoot;
import com.tencent.xcast.GLStateHolder;
import com.tencent.xcast.GLThread;
import com.tencent.xcast.GLView;
import com.tencent.xcast.Log;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001e\b\u0016\u0018\u0000 K2\u00020\u0001:\u0001KB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020.H\u0003J\b\u00100\u001a\u00020.H\u0016J\b\u00101\u001a\u00020.H\u0007J\b\u00102\u001a\u00020.H\u0007J\b\u00103\u001a\u00020.H\u0007J\b\u00104\u001a\u00020.H\u0007J\b\u00105\u001a\u00020.H\u0007J\b\u00106\u001a\u00020.H\u0003J\u000e\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\nJ\b\u00109\u001a\u00020.H\u0007J\b\u0010:\u001a\u00020.H\u0007J\u0018\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fH\u0007J\u0018\u0010>\u001a\u00020.2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fH\u0007J\b\u0010?\u001a\u00020.H\u0007J\b\u0010@\u001a\u00020.H\u0007J\u0018\u0010A\u001a\u00020.2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fH\u0007J\b\u0010B\u001a\u00020.H\u0003J\b\u0010C\u001a\u00020.H\u0016J\b\u0010D\u001a\u00020.H\u0017J\u0010\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020\fH\u0003J\u0012\u0010G\u001a\u00020.2\b\u0010H\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010I\u001a\u00020.H\u0016J\b\u0010J\u001a\u00020.H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001eR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006L"}, d2={"Lcom/tencent/xcast/GLRootImpl;", "Lcom/tencent/xcast/GLRoot;", "viewCallback", "Lcom/tencent/xcast/GLStateHolder$ViewCallback;", "(Lcom/tencent/xcast/GLStateHolder$ViewCallback;)V", "_canvas", "Lcom/tencent/xcast/GLCanvas;", "_contentView", "Lcom/tencent/xcast/GLView;", "_firstDraw", "", "_flags", "", "_frameCount", "_frameCountingStart", "", "_freeze", "_freezeCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "_inDownState", "_lastDrawFinishTime", "_renderLock", "Ljava/util/concurrent/locks/ReentrantLock;", "_stateHolder", "Lcom/tencent/xcast/GLStateHolder;", "compensation", "getCompensation", "()I", "setCompensation", "(I)V", "compensationMatrix", "Landroid/graphics/Matrix;", "getCompensationMatrix", "()Landroid/graphics/Matrix;", "displayRotation", "getDisplayRotation", "setDisplayRotation", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "dispatchTouchEvent", "evt", "Landroid/view/MotionEvent;", "freeze", "", "layoutContentPane", "lockRenderThread", "onAttachedToWindow", "onContextCreated", "onContextDestroy", "onDetachedFromWindow", "onDrawFrame", "onDrawFrameLocked", "onLayout", "changed", "onPause", "onResume", "onSizeChanged", "width", "height", "onSurfaceAvailable", "onSurfaceDestroyed", "onSurfaceRedrawNeeded", "onSurfaceSizeChanged", "outputFps", "requestLayoutContentPane", "requestRender", "rotateCanvas", "degrees", "setContentPane", "content", "unfreeze", "unlockRenderThread", "Companion", "libxcast_release"})
public class GLRootImpl
implements GLRoot {
    private static final String TAG = "GLRootImpl";
    private static boolean LOG_ATTACH_DETACH;
    private static boolean DEBUG_FPS;
    private static boolean DEBUG_DRAWING_STAT;
    private static boolean DEBUG_PROFILE_SLOW_ONLY;
    private static final int FLAG_INITIALIZED = 1;
    private static final int FLAG_NEED_LAYOUT = 2;
    public static final Companion Companion;
    @NotNull
    private final View view;
    private final GLStateHolder _stateHolder;
    private int _frameCount;
    private long _frameCountingStart;
    private GLCanvas _canvas;
    private GLView _contentView;
    private int _flags;
    private final ReentrantLock _renderLock;
    private final Condition _freezeCondition;
    private boolean _freeze;
    private long _lastDrawFinishTime;
    private boolean _inDownState;
    private boolean _firstDraw;
    private int compensation;
    @NotNull
    private final Matrix compensationMatrix;
    private int displayRotation;

    @WorkerThread
    private final void layoutContentPane() {
        GLRootImpl gLRootImpl = this;
        gLRootImpl._flags &= 0xFFFFFFFD;
        int n2 = gLRootImpl.view.getMeasuredWidth();
        int n3 = gLRootImpl.view.getMeasuredHeight();
        int n4 = 0;
        int n5 = 0;
        if (gLRootImpl.getCompensation() != 0) {
            GLRootImpl gLRootImpl2 = this;
            gLRootImpl2.setCompensation(n5);
            if (gLRootImpl2.getCompensation() % 180 != 0) {
                GLRootImpl gLRootImpl3 = this;
                gLRootImpl3.getCompensationMatrix().setRotate((float)((GLRootImpl)this).getCompensation());
                gLRootImpl3.getCompensationMatrix().preTranslate((float)(-n2 / 2), (float)(-n3 / 2));
                gLRootImpl3.getCompensationMatrix().postTranslate((float)(n3 / 2), (float)(n2 / 2));
            } else {
                ((GLRootImpl)this).getCompensationMatrix().setRotate((float)((GLRootImpl)this).getCompensation(), (float)(n2 / 2), (float)(n3 / 2));
            }
        }
        GLRootImpl gLRootImpl4 = this;
        gLRootImpl4.setDisplayRotation(n4);
        if (gLRootImpl4.getCompensation() % 180 == 0) {
            int n6 = n2;
            n2 = n3;
            n3 = n6;
        }
        Log.INSTANCE.i(TAG, "render.layout.content.pane." + n3 + 'x' + n2 + ".compensation." + ((GLRootImpl)this).getCompensation());
        if (n3 != 0 && n2 != 0) {
            GLView gLView = ((GLRootImpl)this)._contentView;
            if (gLView != null) {
                gLView.measure$libxcast_release(n3, n2);
            }
            if ((this = ((GLRootImpl)this)._contentView) != null) {
                ((GLView)this).layout(0, 0, n3, n2);
            }
        }
    }

    @WorkerThread
    private final void outputFps() {
        long l2 = System.nanoTime();
        long l3 = this._frameCountingStart;
        if (l3 == 0L) {
            this._frameCountingStart = l2;
        } else if (l2 - l3 > 4000000000L) {
            GLRootImpl gLRootImpl = this;
            Log.INSTANCE.d(TAG, "fps." + (long)this._frameCount * 1000000000L / (l2 - this._frameCountingStart));
            gLRootImpl._frameCountingStart = l2;
            gLRootImpl._frameCount = 0;
        }
        GLRootImpl gLRootImpl = this;
        ++gLRootImpl._frameCount;
        int cfr_ignored_0 = gLRootImpl._frameCount;
    }

    @WorkerThread
    private final void onDrawFrameLocked() {
        Object object;
        if (DEBUG_FPS) {
            ((GLRootImpl)((Object)gLCanvas)).outputFps();
        }
        if ((object = ((GLRootImpl)((Object)gLCanvas))._canvas) == null) {
            Intrinsics.throwNpe();
        }
        object.deleteRecycledResources();
        if ((((GLRootImpl)((Object)gLCanvas))._flags & 2) != 0) {
            ((GLRootImpl)((Object)gLCanvas)).layoutContentPane();
        }
        if ((object = ((GLRootImpl)((Object)gLCanvas))._canvas) == null) {
            Intrinsics.throwNpe();
        }
        GLRootImpl gLRootImpl = gLCanvas;
        object.save(-1);
        gLRootImpl.rotateCanvas(-gLRootImpl.getCompensation());
        object = gLRootImpl._canvas;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        object.clearBuffer();
        object = ((GLRootImpl)((Object)gLCanvas))._contentView;
        if (object != null) {
            GLCanvas gLCanvas = ((GLRootImpl)((Object)gLCanvas))._canvas;
            if (gLCanvas == null) {
                Intrinsics.throwNpe();
            }
            ((GLView)object).render(gLCanvas);
        }
        if ((object = ((GLRootImpl)((Object)gLCanvas))._canvas) == null) {
            Intrinsics.throwNpe();
        }
        object.restore();
        if (DEBUG_DRAWING_STAT) {
            GLCanvas gLCanvas = ((GLRootImpl)((Object)gLCanvas))._canvas;
            if (gLCanvas == null) {
                Intrinsics.throwNpe();
            }
            gLCanvas.dumpStatisticsAndClear();
        }
    }

    @WorkerThread
    private final void rotateCanvas(int n2) {
        Object object;
        if (n2 == 0) {
            return;
        }
        GLRootImpl gLRootImpl = object;
        int n3 = gLRootImpl.view.getMeasuredWidth();
        n3 /= 2;
        int n4 = gLRootImpl.view.getMeasuredHeight() / 2;
        GLCanvas gLCanvas = gLRootImpl._canvas;
        if (gLCanvas == null) {
            Intrinsics.throwNpe();
        }
        gLCanvas.translate(n3, n4);
        gLCanvas = ((GLRootImpl)object)._canvas;
        if (gLCanvas == null) {
            Intrinsics.throwNpe();
        }
        gLCanvas.rotate(n2, 0.0f, 0.0f, 1.0f);
        if (n2 % 180 != 0) {
            object = ((GLRootImpl)object)._canvas;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            object.translate(-n4, -n3);
        } else {
            object = ((GLRootImpl)object)._canvas;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            object.translate(-n3, -n4);
        }
    }

    public GLRootImpl(@NotNull GLStateHolder.ViewCallback viewCallback) {
        GLRootImpl gLRootImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)viewCallback, (String)"viewCallback");
        gLRootImpl.view = viewCallback.getView();
        gLRootImpl._stateHolder = new GLStateHolder(viewCallback);
        gLRootImpl._flags = 2;
        gLRootImpl._renderLock = new ReentrantLock();
        gLRootImpl._freezeCondition = gLRootImpl._renderLock.newCondition();
        gLRootImpl._firstDraw = true;
        gLRootImpl.compensationMatrix = new Matrix();
        gLRootImpl._flags |= 1;
        if (Build.VERSION.SDK_INT >= 16) {
            this.view.setBackground(null);
        } else {
            this.view.setBackgroundDrawable(null);
        }
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @MainThread
    public static final native void nativeLockUpdate(boolean var0);

    @Override
    @NotNull
    public final View getView() {
        return this.view;
    }

    @Override
    public int getCompensation() {
        return this.compensation;
    }

    public void setCompensation(int n2) {
        this.compensation = n2;
    }

    @Override
    @NotNull
    public Matrix getCompensationMatrix() {
        return this.compensationMatrix;
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    public void setDisplayRotation(int n2) {
        this.displayRotation = n2;
    }

    @Override
    public void setContentPane(@Nullable GLView gLView) {
        GLView gLView2 = this._contentView;
        if (gLView2 == gLView) {
            return;
        }
        if (gLView2 != null) {
            if (this._inDownState) {
                long l2 = SystemClock.uptimeMillis();
                gLView2 = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
                GLView gLView3 = this._contentView;
                if (gLView3 == null) {
                    Intrinsics.throwNpe();
                }
                GLView gLView4 = gLView2;
                Intrinsics.checkExpressionValueIsNotNull((Object)gLView4, (String)"cancelEvent");
                gLView3.dispatchTouchEvent((MotionEvent)gLView4);
                gLView2.recycle();
                this._inDownState = false;
            }
            if ((gLView2 = this._contentView) == null) {
                Intrinsics.throwNpe();
            }
            gLView2.detachFromRoot();
            BasicTexture.Companion.yieldAllTextures(this._canvas);
        }
        this._contentView = gLView;
        if (gLView != null) {
            gLView.attachToRoot(this);
            this.requestLayoutContentPane();
        }
    }

    @Override
    public void requestLayoutContentPane() {
        block6: {
            block7: {
                GLRootImpl gLRootImpl = this;
                gLRootImpl._renderLock.lock();
                try {
                    if (gLRootImpl._contentView == null) break block6;
                }
                catch (Throwable throwable) {
                    this._renderLock.unlock();
                    throw throwable;
                }
                if ((this._flags & 2) != 0) break block6;
                if ((this._flags & 1) != 0) break block7;
                this._renderLock.unlock();
                return;
            }
            GLRootImpl gLRootImpl = this;
            GLRootImpl gLRootImpl2 = gLRootImpl;
            GLRootImpl gLRootImpl3 = gLRootImpl;
            GLRootImpl gLRootImpl4 = gLRootImpl;
            int n2 = gLRootImpl._flags;
            gLRootImpl2._flags = n2 | 2;
            gLRootImpl3.requestRender();
            gLRootImpl4._renderLock.unlock();
            return;
        }
        this._renderLock.unlock();
    }

    public final void onLayout(boolean bl) {
        if (bl) {
            this.requestLayoutContentPane();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void onContextCreated() {
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            Log.INSTANCE.i(TAG, this.hashCode() + ".onContextCreated");
        }
        GLRootImpl gLRootImpl = this;
        gLRootImpl._renderLock.lock();
        try {
            BasicTexture.Companion.invalidateAllTextures(this._canvas);
            GLCanvas gLCanvas = gLRootImpl._canvas;
            if (gLCanvas != null) {
                gLCanvas.release();
            }
            this._canvas = new GLES20Canvas();
            this._renderLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this._renderLock.unlock();
            throw throwable;
        }
    }

    @WorkerThread
    public final void onContextDestroy() {
        block5: {
            GLCanvas gLCanvas;
            if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
                Log.INSTANCE.i(TAG, this.hashCode() + ".onContextDestroy");
            }
            GLRootImpl gLRootImpl = this;
            gLRootImpl._renderLock.lock();
            try {
                BasicTexture.Companion.invalidateAllTextures(this._canvas);
                gLCanvas = gLRootImpl._canvas;
                if (gLCanvas == null) break block5;
            }
            catch (Throwable throwable) {
                this._renderLock.unlock();
                throw throwable;
            }
            gLCanvas.release();
        }
        this._canvas = null;
        this._renderLock.unlock();
    }

    @WorkerThread
    public final void onSizeChanged(int n2, int n3) {
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            Log.INSTANCE.i(TAG, this.hashCode() + ".onSurfaceChanged." + n2 + 'x' + n3);
        }
        if ((this = ((GLRootImpl)this)._canvas) != null) {
            this.setSize(n2, n3);
        }
    }

    @WorkerThread
    public final void onDrawFrame() {
        block6: {
            long l2 = 0L;
            if (DEBUG_PROFILE_SLOW_ONLY) {
                l2 = System.nanoTime();
            }
            this._renderLock.lock();
            while (this._freeze) {
                this._freezeCondition.awaitUninterruptibly();
            }
            try {
                GLRootImpl gLRootImpl = this;
                gLRootImpl.onDrawFrameLocked();
                gLRootImpl._renderLock.unlock();
                if (gLRootImpl._firstDraw) {
                    this._firstDraw = false;
                }
                if (!DEBUG_PROFILE_SLOW_ONLY) break block6;
            }
            catch (Throwable throwable) {
                this._renderLock.unlock();
                throw throwable;
            }
            long l3 = System.nanoTime();
            long l4 = 1000000;
            long l5 = (l3 - this._lastDrawFinishTime) / l4;
            long l6 = l3;
            l2 = (l6 - l2) / l4;
            this._lastDrawFinishTime = l6;
            if (l5 > (long)34) {
                Log.INSTANCE.v(TAG, "----- SLOW (" + l2 + '/' + l5 + ") -----");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final boolean dispatchTouchEvent(@NotNull MotionEvent var1_1) {
        block12: {
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"evt");
                if (!this.view.isEnabled()) {
                    return false;
                }
                var2_3 = var1_1.getAction();
                if (var2_3 != 3 && var2_3 != 1) {
                    if (!this._inDownState && var2_3 != 0) {
                        return false;
                    }
                } else {
                    this._inDownState = false;
                }
                if (this.getCompensation() != 0) {
                    var1_1 = MotionEvent.obtain((MotionEvent)var1_1);
                    var1_1.transform(this.getCompensationMatrix());
                    Intrinsics.checkExpressionValueIsNotNull((Object)var1_1, (String)"newEvent");
                }
                v0 = this;
                GLRootImpl.Companion.lockUpdate$libxcast_release(true);
                v0._renderLock.lock();
                try {
                    if (v0._contentView == null) break block11;
                }
                catch (Throwable v1) {
                    this._renderLock.unlock();
                    GLRootImpl.Companion.lockUpdate$libxcast_release(false);
                    throw v1;
                }
                var3_4 = this._contentView;
                if (var3_4 != null) ** GOTO lbl28
                Intrinsics.throwNpe();
lbl28:
                // 2 sources

                if (!var3_4.dispatchTouchEvent(var1_1)) break block11;
                var1_2 = true;
                break block12;
            }
            var1_2 = false;
        }
        if (var2_3 == 0 && var1_2) {
            this._inDownState = true;
        }
        this._renderLock.unlock();
        GLRootImpl.Companion.lockUpdate$libxcast_release(false);
        return var1_2;
    }

    @Override
    @AnyThread
    public void requestRender() {
        this._stateHolder.requestRenderNextFrame();
    }

    @Override
    public void lockRenderThread() {
        this._renderLock.lock();
    }

    @Override
    public void unlockRenderThread() {
        this._renderLock.unlock();
    }

    @Override
    public void freeze() {
        GLRootImpl gLRootImpl = this;
        gLRootImpl._renderLock.lock();
        gLRootImpl._freeze = true;
        gLRootImpl._renderLock.unlock();
    }

    @Override
    public void unfreeze() {
        GLRootImpl gLRootImpl = this;
        gLRootImpl._renderLock.lock();
        gLRootImpl._freeze = false;
        gLRootImpl._freezeCondition.signalAll();
        gLRootImpl._renderLock.unlock();
    }

    @MainThread
    public final void onSurfaceRedrawNeeded() {
        this._stateHolder.requestRenderAndWait();
    }

    @MainThread
    public final void onSurfaceAvailable(int n2, int n3) {
        this.unfreeze();
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            Log.INSTANCE.i(TAG, "onSurfaceAvailable." + this.hashCode() + ".w." + n2 + ".h." + n3);
        }
        this._stateHolder.surfaceCreated(n2, n3);
    }

    @MainThread
    public final void onSurfaceSizeChanged(int n2, int n3) {
        this.unfreeze();
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            Log.INSTANCE.i(TAG, "onSurfaceSizeChanged." + this.hashCode() + ".w." + n2 + ".h." + n3);
        }
        this._stateHolder.surfaceChanged(n2, n3);
    }

    @MainThread
    public final void onSurfaceDestroyed() {
        this.unfreeze();
        if (GLThread.INSTANCE.getLOG_SURFACE$libxcast_release()) {
            Log.INSTANCE.i(TAG, "onSurfaceDestroyed." + this.hashCode());
        }
        this._stateHolder.surfaceDestroyed();
    }

    @MainThread
    public final void onPause() {
        GLRootImpl gLRootImpl = this;
        gLRootImpl.unfreeze();
        gLRootImpl._stateHolder.pause();
    }

    @MainThread
    public final void onResume() {
        this._stateHolder.resume();
    }

    @MainThread
    public final void onAttachedToWindow() {
        if (LOG_ATTACH_DETACH) {
            Log.INSTANCE.d(TAG, "onAttachedToWindow." + this.hashCode() + ".holder." + this._stateHolder.hashCode());
        }
    }

    @MainThread
    public final void onDetachedFromWindow() {
        if (LOG_ATTACH_DETACH) {
            Log.INSTANCE.d(TAG, "onDetachedFromWindow." + this.hashCode() + ".holder." + this._stateHolder.hashCode());
        }
        this.unfreeze();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001aJ\u0011\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0087 R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tencent/xcast/GLRootImpl$Companion;", "", "()V", "DEBUG_DRAWING_STAT", "", "getDEBUG_DRAWING_STAT$libxcast_release", "()Z", "setDEBUG_DRAWING_STAT$libxcast_release", "(Z)V", "DEBUG_FPS", "getDEBUG_FPS$libxcast_release", "setDEBUG_FPS$libxcast_release", "DEBUG_PROFILE_SLOW_ONLY", "getDEBUG_PROFILE_SLOW_ONLY$libxcast_release", "setDEBUG_PROFILE_SLOW_ONLY$libxcast_release", "FLAG_INITIALIZED", "", "FLAG_NEED_LAYOUT", "LOG_ATTACH_DETACH", "getLOG_ATTACH_DETACH$libxcast_release", "setLOG_ATTACH_DETACH$libxcast_release", "TAG", "", "lockUpdate", "", "lock", "lockUpdate$libxcast_release", "nativeLockUpdate", "libxcast_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean getLOG_ATTACH_DETACH$libxcast_release() {
            return LOG_ATTACH_DETACH;
        }

        public final void setLOG_ATTACH_DETACH$libxcast_release(boolean bl) {
            LOG_ATTACH_DETACH = bl;
        }

        public final boolean getDEBUG_FPS$libxcast_release() {
            return DEBUG_FPS;
        }

        public final void setDEBUG_FPS$libxcast_release(boolean bl) {
            DEBUG_FPS = bl;
        }

        public final boolean getDEBUG_DRAWING_STAT$libxcast_release() {
            return DEBUG_DRAWING_STAT;
        }

        public final void setDEBUG_DRAWING_STAT$libxcast_release(boolean bl) {
            DEBUG_DRAWING_STAT = bl;
        }

        public final boolean getDEBUG_PROFILE_SLOW_ONLY$libxcast_release() {
            return DEBUG_PROFILE_SLOW_ONLY;
        }

        public final void setDEBUG_PROFILE_SLOW_ONLY$libxcast_release(boolean bl) {
            DEBUG_PROFILE_SLOW_ONLY = bl;
        }

        public final void lockUpdate$libxcast_release(boolean bl) {
            try {
                this.nativeLockUpdate(bl);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Log.INSTANCE.d(GLRootImpl.TAG, "onDetachedFromWindow." + unsatisfiedLinkError);
            }
        }

        @JvmStatic
        @MainThread
        public final void nativeLockUpdate(boolean bl) {
            GLRootImpl.nativeLockUpdate(bl);
        }
    }
}

