/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.WorkerThread;
import android.util.Size;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.AppLifecycle;
import com.tencent.xcast.SurfaceTextureHolder;
import com.tencent.xcast.VideoCapture;
import com.tencent.xcast.VideoCaptureContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class VideoCapture2
implements ImageReader.OnImageAvailableListener,
VideoCaptureContext.CaptureThreadCallback,
AppLifecycle.LifecycleObserver {
    private static final String TAG = "VideoCapture2";
    private static final int MSG_CONFIG_CAMERA = 2;
    private static final int CAPTURE_BUFFER_COUNT = 3;
    private Context mContext;
    private long mNativeCapture;
    private VideoCaptureContext mCaptureCtx;
    private String mCameraId;
    private CaptureStateCallback mStateCallback;
    private CameraDevice mCamera;
    private CameraCaptureSession mCaptureSession;
    private SessionCaptureCallback mSessionCaptureCallback;
    private List<SessionStateCallback> mSessionStateCallbacks;
    private int mSessionIndex;
    private final boolean mUseSurfaceTexture;
    private ImageReader mImageReader = null;
    private SurfaceTextureHolder mCaptureTextureHolder = null;
    private CameraManager mCameraMgr;
    private CameraCharacteristics mCharacteristics;
    private StreamConfigurationMap mConfigurationMap;
    private boolean mAsyncSuccess = false;
    private int mWidth;
    private int mHeight;
    private int mFps;
    private int mOptimalWidth;
    private int mOptimalHeight;
    private int mFacing;
    private int mSensorOrientation;
    private Integer mPreviewFormat;
    private int mFrameCount;
    private long mLastFrameElapsedTimeMs;
    private double mAvgFrameDurationMs;
    private AppLifecycle mAppLifecycle;
    private boolean mPaused;

    private static String cameraErrorToString(int n2) {
        switch (n2) {
            default: {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                return String.format(Locale.CHINA, "%d", objectArray2);
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
            case 1: 
        }
        return "ERROR_CAMERA_IN_USE";
    }

    private static boolean isSupportCamera2(Context context) {
        String[] stringArray;
        block10: {
            block9: {
                context = (CameraManager)context.getSystemService("camera");
                if (context != null) break block9;
                return false;
            }
            stringArray = context.getCameraIdList();
            if (stringArray.length != 0) break block10;
            return false;
        }
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CameraCharacteristics cameraCharacteristics = context.getCameraCharacteristics(stringArray[i2]);
            Integer n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (n3 == null) break;
            if (n3 == 2) break;
            cameraCharacteristics = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (cameraCharacteristics == null) continue;
            try {
                if (VideoCapture2.getSupportedPreviewFormat((StreamConfigurationMap)cameraCharacteristics) == null) break;
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
                break;
            }
            continue;
        }
        return false;
    }

    public static void getCameraInfos(Context context, long l2) {
        block7: {
            context = (CameraManager)context.getSystemService("camera");
            if (context != null) break block7;
            return;
        }
        String[] stringArray = context.getCameraIdList();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            String string2;
            block9: {
                block8: {
                    string2 = stringArray[i2];
                    CameraCharacteristics cameraCharacteristics = context.getCameraCharacteristics(string2);
                    Integer n4 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                    Integer cfr_ignored_0 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                    if (n4 == null) break block8;
                    n3 = n4;
                    break block9;
                }
                n3 = 1;
            }
            try {
                VideoCapture2.onCaptureEnum(l2, string2, n3);
                continue;
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
                break;
            }
        }
    }

    private static Integer getSupportedPreviewFormat(StreamConfigurationMap streamConfigurationMap) {
        StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap;
        int[] nArray = streamConfigurationMap2.getOutputFormats();
        Platform.logInfo("support formats:" + Arrays.asList(new int[][]{nArray}).toString());
        if (streamConfigurationMap2.isOutputSupportedFor(35)) {
            return 35;
        }
        if (streamConfigurationMap.isOutputSupportedFor(17)) {
            return 17;
        }
        if (streamConfigurationMap.isOutputSupportedFor(842094169)) {
            return 842094169;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Size getOptimalPreviewSize(StreamConfigurationMap streamConfigurationMap3, int n2, int n3, int n4) {
        void var1_8;
        void var1_5;
        void var3_10;
        void var2_9;
        void var4_11;
        Object var1_4 = null;
        Size[] sizeArray = streamConfigurationMap3.getOutputSizes((int)var4_11);
        Arrays.sort(sizeArray, new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                return size.getWidth() - size2.getWidth();
            }
        });
        for (Size size : sizeArray) {
            if (size.getWidth() >= var2_9 && size.getHeight() >= var3_10) break;
        }
        if (var1_5 == null) {
            Size size;
            Size size2 = size;
            size = new Size((int)var2_9, (int)var3_10);
        }
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = (int)var2_9;
        objectArray2[1] = (int)var3_10;
        objectArray2[2] = var1_8.getWidth();
        objectArray[3] = var1_8.getHeight();
        Platform.log(4, String.format(Locale.CHINA, "size: %dx%d, best match: %dx%d", objectArray2));
        return var1_8;
    }

    private VideoCapture2(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativeCapture = l2;
        this.mUseSurfaceTexture = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"MissingPermission"})
    private boolean startCaptureInternal() {
        try {
            if (this.mStateCallback == null) {
                this.mStateCallback = new CaptureStateCallback();
            }
            this.mCameraMgr.openCamera(this.mCameraId, (CameraDevice.StateCallback)this.mStateCallback, this.mCaptureCtx.getHandler());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        return true;
    }

    private void stopCaptureInternal() {
        Object object = this.mCaptureSession;
        if (object != null) {
            object.close();
            this.mCaptureSession = null;
        }
        if ((object = this.mCamera) != null) {
            object.close();
            this.mCamera = null;
        }
        if ((object = this.mImageReader) != null) {
            object.close();
            this.mImageReader = null;
        }
        if ((object = this.mSessionStateCallbacks) != null) {
            object.clear();
            this.mSessionStateCallbacks = null;
        }
        VideoCapture2 videoCapture2 = this;
        videoCapture2.mCameraMgr = null;
        videoCapture2.mCharacteristics = null;
        videoCapture2.mConfigurationMap = null;
    }

    private void closeCaptureSession() {
        CameraCaptureSession cameraCaptureSession = this.mCaptureSession;
        if (cameraCaptureSession != null) {
            try {
                cameraCaptureSession.abortCaptures();
                this.mCaptureSession.close();
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            this.mCaptureSession = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private boolean createCaptureSession(int n2, int n3) {
        Throwable throwable2;
        block8: {
            int n4;
            int n5;
            VideoCapture2 videoCapture2;
            SessionStateCallback sessionStateCallback;
            SessionStateCallback sessionStateCallback2;
            VideoCapture2 videoCapture22;
            VideoCapture2 videoCapture23;
            ArrayList<Surface> arrayList;
            try {
                SessionStateCallback sessionStateCallback3;
                ArrayList<Surface> arrayList2;
                VideoCapture2 videoCapture24 = this;
                videoCapture24.closeCaptureSession();
                arrayList = arrayList2;
                arrayList2 = new ArrayList<Surface>();
                if (videoCapture24.mUseSurfaceTexture) {
                    if (this.mCaptureTextureHolder != null) {
                        this.mCaptureTextureHolder.release();
                    }
                    this.mCaptureTextureHolder = new SurfaceTextureHolder(n2, n3, new SurfaceTextureHolder.EventCallback(){

                        @Override
                        public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
                            VideoCapture2.onCaptureFrameSurface(VideoCapture2.this.mNativeCapture, surfaceTextureHolder, VideoCapture2.this.mOptimalWidth, VideoCapture2.this.mOptimalHeight, VideoCapture2.this.getRotate());
                        }

                        @Override
                        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
                        }
                    }, new SurfaceTextureHolder.HandlerDestructorRunner(this.mCaptureCtx.getHandler()));
                    arrayList.add(this.mCaptureTextureHolder.getSurface());
                } else {
                    if (this.mImageReader != null) {
                        VideoCapture2 videoCapture25 = this;
                        videoCapture25.mImageReader.setOnImageAvailableListener(null, null);
                        videoCapture25.mImageReader.close();
                    }
                    VideoCapture2 videoCapture26 = this;
                    videoCapture26.mImageReader = ImageReader.newInstance((int)n2, (int)n3, (int)this.mPreviewFormat, (int)3);
                    VideoCapture2 videoCapture27 = this;
                    videoCapture26.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)videoCapture27, videoCapture27.mCaptureCtx.getHandler());
                    arrayList.add(videoCapture26.mImageReader.getSurface());
                }
                VideoCapture2 videoCapture28 = this;
                videoCapture23 = videoCapture28;
                videoCapture22 = videoCapture28;
                sessionStateCallback = sessionStateCallback2 = sessionStateCallback3;
                VideoCapture2 videoCapture29 = this;
                videoCapture2 = videoCapture29;
                int n6 = videoCapture29.mSessionIndex;
                n5 = n6;
                n4 = n6;
            }
            catch (IllegalArgumentException throwable2) {
                break block8;
            }
            catch (CameraAccessException throwable2) {
                // empty catch block
                break block8;
            }
            {
                this.mSessionIndex = n5 + 1;
                sessionStateCallback(n4);
                videoCapture23.mSessionStateCallbacks.add(sessionStateCallback2);
                videoCapture22.mCamera.createCaptureSession(arrayList, (CameraCaptureSession.StateCallback)sessionStateCallback2, this.mCaptureCtx.getHandler());
                return true;
            }
        }
        Platform.logError(throwable2.toString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean configOnCameraThread(int n2, int n3, int n4) {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            try {
                if (videoCapture2.mCamera != null && (this.mWidth != n2 || this.mHeight != n3)) {
                    VideoCapture2 videoCapture22 = this;
                    Size size = videoCapture22.getOptimalPreviewSize(videoCapture22.mConfigurationMap, n2, n3, this.mPreviewFormat);
                    if (videoCapture22.mOptimalWidth != size.getWidth() || this.mOptimalHeight != size.getHeight()) {
                        VideoCapture2 videoCapture23 = this;
                        this.mOptimalWidth = size.getWidth();
                        this.mOptimalHeight = size.getHeight();
                        videoCapture23.mFps = n4;
                        // ** MonitorExit[this] (shouldn't be in output)
                        return videoCapture23.createCaptureSession(videoCapture23.mOptimalWidth, this.mOptimalHeight);
                    }
                } else {
                    this.mWidth = n2;
                    this.mHeight = n3;
                    this.mFps = n4;
                    return this.mFps != 0;
                }
            }
            finally {
                Throwable throwable;
                // ** MonitorExit[this] (shouldn't be in output)
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean start(String string2) {
        if (string2 != null && string2.length() != 0) {
            Object object = VideoCapture.sLock;
            // MONITORENTER : object
            boolean bl = false;
            if (this.mCameraMgr == null) {
                VideoCapture2 videoCapture2 = this;
                videoCapture2.mCameraMgr = (CameraManager)videoCapture2.mContext.getSystemService("camera");
                if (videoCapture2.mCameraMgr != null) {
                    try {
                        VideoCapture2 videoCapture22 = this;
                        videoCapture22.mCharacteristics = videoCapture22.mCameraMgr.getCameraCharacteristics(string2);
                        videoCapture22.mConfigurationMap = (StreamConfigurationMap)videoCapture22.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                        Integer n2 = (Integer)videoCapture22.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
                        int n3 = n2 != null ? n2 : 1;
                        VideoCapture2 videoCapture23 = this;
                        videoCapture23.mFacing = n3;
                        videoCapture23.mPreviewFormat = VideoCapture2.getSupportedPreviewFormat(videoCapture23.mConfigurationMap);
                        Integer n4 = (Integer)videoCapture23.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                        int n5 = n4 != null ? n4 : 0;
                        this.mSensorOrientation = n5;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        String string3 = cameraAccessException.toString();
                        VideoCapture2 videoCapture24 = this;
                        Platform.logInfo(string3);
                        videoCapture24.mCharacteristics = null;
                        videoCapture24.mConfigurationMap = null;
                        videoCapture24.mPreviewFormat = null;
                    }
                }
            }
            if (this.mCameraMgr != null && this.mCharacteristics != null && this.mConfigurationMap != null && this.mPreviewFormat != null) {
                this.mSessionStateCallbacks = new ArrayList<SessionStateCallback>();
                this.mCameraId = string2;
                if (this.mCaptureCtx == null) {
                    this.mCaptureCtx = VideoCaptureContext.create(this.mContext);
                }
                if (this.mAppLifecycle == null) {
                    VideoCapture2 videoCapture2 = this;
                    videoCapture2.mAppLifecycle = AppLifecycle.create(videoCapture2.mContext, this.mCaptureCtx.getHandler());
                    videoCapture2.mAppLifecycle.addObserver(this);
                }
                this.mFrameCount = 0;
                this.mAvgFrameDurationMs = 33.33333206176758;
                bl = this.startCaptureInternal();
            }
            if (bl) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Platform.logError(interruptedException.toString());
                }
                bl = this.mAsyncSuccess;
                this.mAsyncSuccess = false;
            }
            if (!bl) {
                this.stopCaptureInternal();
            }
            boolean bl2 = bl;
            Object object2 = object;
            // MONITOREXIT : this
            {
                catch (Throwable throwable) {
                    // MONITOREXIT : this
                    throw throwable;
                }
            }
            // MONITOREXIT : object2
            return bl2;
        }
        Platform.logError("camera.id.null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stop() {
        Object object = VideoCapture.sLock;
        synchronized (object) {
            if (this.mAppLifecycle != null) {
                this.mAppLifecycle.destroy();
                this.mAppLifecycle = null;
            }
            VideoCapture2 videoCapture2 = this;
            VideoCapture2 videoCapture22 = videoCapture2;
            VideoCapture2 videoCapture23 = videoCapture2;
            synchronized (videoCapture2) {
            }
            {
                videoCapture23.stopCaptureInternal();
                if (videoCapture22.mCaptureTextureHolder != null) {
                    this.mCaptureTextureHolder.release();
                    this.mCaptureTextureHolder = null;
                }
                VideoCapture2 videoCapture24 = this;
                VideoCapture2 videoCapture25 = videoCapture24;
                VideoCapture2 videoCapture26 = videoCapture24;
                // ** MonitorExit[v4] (shouldn't be in output)
                {
                    catch (Throwable throwable) {
                        // ** MonitorExit[this] (shouldn't be in output)
                        throw throwable;
                    }
                    videoCapture26.mCaptureCtx.destroy();
                    videoCapture25.mCaptureCtx = null;
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean config(int n2, int n3, int n4) {
        block12: {
            VideoCapture.Params params;
            Object object = VideoCapture.sLock;
            // MONITORENTER : object
            if (this.mCaptureCtx == null || this.mCamera == null) break block12;
            VideoCapture2 videoCapture2 = this;
            VideoCapture.Params params2 = params;
            params2();
            params2.what = 2;
            params2.w = n2;
            params2.h = n3;
            params.f = n4;
            n2 = videoCapture2.mCaptureCtx.runOnCaptureThread(this, params2, false) ? 1 : 0;
            try {
                videoCapture2.wait();
            }
            catch (InterruptedException interruptedException) {
                Platform.logError(interruptedException.toString());
            }
            if (n2 != 0) {
                n2 = this.mAsyncSuccess ? 1 : 0;
                this.mAsyncSuccess = false;
            }
            boolean bl = n2;
            Object object2 = object;
            // MONITOREXIT : this
            // MONITOREXIT : object2
            return bl;
        }
        this.mWidth = n2;
        this.mHeight = n3;
        this.mFps = n4;
        // MONITOREXIT : this
        {
            catch (Throwable throwable) {
                // MONITOREXIT : this
                throw throwable;
            }
        }
        // MONITOREXIT : object
        return true;
    }

    private int getRotate() {
        int n2 = this.mCaptureCtx.isDeviceAutoRotate() ? this.mCaptureCtx.getDeviceOrientation() : 0;
        return (this.mFacing == 0 ? this.mSensorOrientation % 360 : (this.mSensorOrientation - n2 + 360) % 360) / 90;
    }

    private static native void onCaptureEnum(long var0, String var2, int var3);

    private static native void onCaptureFrame(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureFrame2(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5);

    static /* synthetic */ CameraCaptureSession access$202(VideoCapture2 videoCapture2, CameraCaptureSession cameraCaptureSession) {
        videoCapture2.mCaptureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ SessionCaptureCallback access$602(VideoCapture2 videoCapture2, SessionCaptureCallback sessionCaptureCallback) {
        videoCapture2.mSessionCaptureCallback = sessionCaptureCallback;
        return sessionCaptureCallback;
    }

    static /* synthetic */ boolean access$902(VideoCapture2 videoCapture2, boolean bl) {
        videoCapture2.mAsyncSuccess = bl;
        return bl;
    }

    static /* synthetic */ CameraDevice access$002(VideoCapture2 videoCapture2, CameraDevice cameraDevice) {
        videoCapture2.mCamera = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ int access$1502(VideoCapture2 videoCapture2, int n2) {
        videoCapture2.mOptimalWidth = n2;
        return n2;
    }

    static /* synthetic */ int access$1602(VideoCapture2 videoCapture2, int n2) {
        videoCapture2.mOptimalHeight = n2;
        return n2;
    }

    @WorkerThread
    public void onImageAvailable(ImageReader imageReader) {
        if (imageReader != this.mImageReader) {
            return;
        }
        if ((imageReader = imageReader.acquireLatestImage()) != null) {
            VideoCapture2 videoCapture2 = this;
            ++videoCapture2.mFrameCount;
            long l2 = SystemClock.elapsedRealtime();
            int n2 = videoCapture2.mFrameCount;
            if (n2 > 0) {
                double d2 = l2 - this.mLastFrameElapsedTimeMs;
                this.mAvgFrameDurationMs = this.mAvgFrameDurationMs * 0.9 + d2 * 0.1;
                if (n2 % 30 == 0) {
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = l2;
                    objectArray2[1] = (int)d2;
                    d2 = this.mAvgFrameDurationMs;
                    objectArray[2] = (int)(1000.0 / d2 + 0.5);
                    Platform.logDebug(String.format(Locale.CHINA, "Camera TS %dms, Duration %dms, FPS %d", objectArray2));
                }
            }
            this.mLastFrameElapsedTimeMs = l2;
            Image.Plane[] planeArray = imageReader.getPlanes();
            Image.Plane plane = planeArray[0];
            ByteBuffer byteBuffer = plane.getBuffer();
            ByteBuffer byteBuffer2 = null;
            ByteBuffer byteBuffer3 = null;
            int n3 = plane.getPixelStride();
            int n4 = 0;
            int n5 = 0;
            int n6 = plane.getRowStride();
            int n7 = 0;
            int n8 = 0;
            if (planeArray.length >= 2) {
                Image.Plane plane2 = planeArray[1];
                byteBuffer2 = plane2.getBuffer();
                n4 = plane2.getPixelStride();
                n7 = plane2.getRowStride();
            }
            if (planeArray.length >= 3) {
                Image.Plane plane3 = planeArray[2];
                byteBuffer3 = plane3.getBuffer();
                n5 = plane3.getPixelStride();
                n8 = plane3.getRowStride();
            }
            VideoCapture2.onCaptureFrame2(this.mNativeCapture, byteBuffer, n3, n6, byteBuffer2, n4, n7, byteBuffer3, n5, n8, imageReader.getWidth(), imageReader.getHeight(), this.getRotate(), imageReader.getFormat());
            imageReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @WorkerThread
    public void onCaptureThreadCallback(VideoCaptureContext object, Object object2) {
        if (!(object2 instanceof VideoCapture.Params)) return;
        object = (VideoCapture.Params)object2;
        if (((VideoCapture.Params)object).what != 2) return;
        VideoCapture2 videoCapture2 = this;
        synchronized (this) {
            videoCapture2.mAsyncSuccess = videoCapture2.configOnCameraThread(((VideoCapture.Params)object).w, ((VideoCapture.Params)object).h, ((VideoCapture.Params)object).f);
            videoCapture2.notify();
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public void onAppBackgrounded() {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            if (videoCapture2.mCamera == null) {
                Platform.logInfo("camera is not open");
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            if (this.mCaptureSession == null) {
                Platform.logInfo("camera is not running");
            } else if (!this.mPaused) {
                this.closeCaptureSession();
                this.mPaused = true;
                Platform.logInfo("pause camera");
            } else {
                Platform.logInfo("camera is already paused");
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public void onAppForegrounded() {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            if (videoCapture2.mCamera == null) {
                Platform.logInfo("camera is not open");
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            if (this.mCaptureSession != null) {
                Platform.logInfo("camera is running");
            } else if (this.mPaused) {
                VideoCapture2 videoCapture22 = this;
                boolean bl = videoCapture22.createCaptureSession(videoCapture22.mOptimalWidth, this.mOptimalHeight);
                videoCapture22.mPaused = false;
                Platform.logInfo("resume camera " + bl);
            } else {
                Platform.logInfo("camera is not running");
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    private class CaptureStateCallback
    extends CameraDevice.StateCallback {
        private CaptureStateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onOpened(@NonNull CameraDevice cameraDevice) {
            block3: {
                Object[] objectArray2;
                VideoCapture2 videoCapture2 = objectArray2.VideoCapture2.this;
                synchronized (videoCapture2) {
                    VideoCapture2.access$002(objectArray2.VideoCapture2.this, cameraDevice);
                    Size size = objectArray2.VideoCapture2.this.getOptimalPreviewSize(objectArray2.VideoCapture2.this.mConfigurationMap, objectArray2.VideoCapture2.this.mWidth, objectArray2.VideoCapture2.this.mHeight, objectArray2.VideoCapture2.this.mPreviewFormat);
                    VideoCapture2.access$1502(objectArray2.VideoCapture2.this, size.getWidth());
                    VideoCapture2.access$1602(objectArray2.VideoCapture2.this, size.getHeight());
                    objectArray2.VideoCapture2.this.createCaptureSession(objectArray2.VideoCapture2.this.mOptimalWidth, objectArray2.VideoCapture2.this.mOptimalHeight);
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : videoCapture2
                    if (!Platform.isDebugBuild) break block3;
                }
                Object[] objectArray = new Object[1];
                objectArray2 = objectArray;
                objectArray[0] = cameraDevice;
                Platform.logInfo(String.format(Locale.CHINA, "onOpened.cam.%h", objectArray2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            block3: {
                VideoCapture2 videoCapture2 = VideoCapture2.this;
                CaptureStateCallback captureStateCallback = this;
                synchronized (videoCapture2) {
                    cameraDevice.close();
                    VideoCapture2.access$002(captureStateCallback.VideoCapture2.this, null);
                    VideoCapture2.access$902(captureStateCallback.VideoCapture2.this, false);
                    captureStateCallback.VideoCapture2.this.notify();
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : videoCapture2
                    if (!Platform.isDebugBuild) break block3;
                }
                Platform.logInfo("onDisconnected");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onError(@NonNull CameraDevice cameraDevice, int n2) {
            Object[] objectArray2;
            VideoCapture2 videoCapture2 = objectArray2.VideoCapture2.this;
            Object[] objectArray = objectArray2;
            synchronized (videoCapture2) {
                cameraDevice.close();
                VideoCapture2.access$002(objectArray.VideoCapture2.this, null);
                VideoCapture2.access$902(objectArray.VideoCapture2.this, false);
                objectArray2.VideoCapture2.this.notify();
            }
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = VideoCapture2.cameraErrorToString(n2);
            Platform.logInfo(String.format(Locale.CHINA, "onError: %s", objectArray2));
        }

        @WorkerThread
        public void onClosed(@NonNull CameraDevice cameraDevice) {
            Platform.logInfo("onClosed ");
        }
    }

    private class SessionStateCallback
    extends CameraCaptureSession.StateCallback {
        int mIndex;

        SessionStateCallback(int n2) {
            this.mIndex = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
            SessionStateCallback sessionStateCallback = this;
            Platform.logInfo("onConfigured");
            VideoCapture2 videoCapture2 = sessionStateCallback.VideoCapture2.this;
            synchronized (videoCapture2) {
                if (sessionStateCallback.VideoCapture2.this.mCamera == null) {
                    Platform.logInfo("mCamera.null");
                    return;
                }
                if (VideoCapture2.this.mSessionStateCallbacks == null) {
                    return;
                }
                SessionStateCallback sessionStateCallback2 = this;
                sessionStateCallback2.VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                if (!sessionStateCallback2.VideoCapture2.this.mSessionStateCallbacks.isEmpty()) {
                    return;
                }
                SessionStateCallback sessionStateCallback3 = this;
                VideoCapture2.access$202(sessionStateCallback3.VideoCapture2.this, cameraCaptureSession);
                try {
                    cameraCaptureSession = sessionStateCallback3.VideoCapture2.this.mCamera.createCaptureRequest(1);
                    if (sessionStateCallback3.VideoCapture2.this.mUseSurfaceTexture) {
                        cameraCaptureSession.addTarget(VideoCapture2.this.mCaptureTextureHolder.getSurface());
                    } else {
                        cameraCaptureSession.addTarget(VideoCapture2.this.mImageReader.getSurface());
                    }
                    CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
                    cameraCaptureSession2.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                    cameraCaptureSession = cameraCaptureSession2.build();
                    if (VideoCapture2.this.mSessionCaptureCallback == null) {
                        VideoCapture2.access$602(VideoCapture2.this, new SessionCaptureCallback());
                    }
                    SessionStateCallback sessionStateCallback4 = this;
                    sessionStateCallback4.VideoCapture2.this.mCaptureSession.setRepeatingRequest((CaptureRequest)cameraCaptureSession, (CameraCaptureSession.CaptureCallback)VideoCapture2.this.mSessionCaptureCallback, VideoCapture2.this.mCaptureCtx.getHandler());
                    VideoCapture2.access$902(sessionStateCallback4.VideoCapture2.this, true);
                }
                catch (CameraAccessException cameraAccessException) {
                    cameraAccessException.printStackTrace();
                    VideoCapture2.access$902(VideoCapture2.this, false);
                }
                VideoCapture2.this.notify();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onConfigureFailed(@NonNull CameraCaptureSession object) {
            SessionStateCallback sessionStateCallback = this;
            Platform.logInfo("onConfigureFailed");
            VideoCapture2 videoCapture2 = sessionStateCallback.VideoCapture2.this;
            synchronized (videoCapture2) {
                if (sessionStateCallback.VideoCapture2.this.mSessionStateCallbacks == null) {
                    return;
                }
                SessionStateCallback sessionStateCallback2 = this;
                sessionStateCallback2.VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                if (!sessionStateCallback2.VideoCapture2.this.mSessionStateCallbacks.isEmpty()) {
                    return;
                }
                SessionStateCallback sessionStateCallback3 = this;
                sessionStateCallback3.VideoCapture2.this.notify();
                VideoCapture2.access$902(sessionStateCallback3.VideoCapture2.this, false);
                return;
            }
        }

        @WorkerThread
        public void onReady(@NonNull CameraCaptureSession cameraCaptureSession) {
            Platform.logInfo("onReady");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onClosed(@NonNull CameraCaptureSession object) {
            SessionStateCallback sessionStateCallback = this;
            VideoCapture2 videoCapture2 = sessionStateCallback.VideoCapture2.this;
            synchronized (videoCapture2) {
                if (sessionStateCallback.VideoCapture2.this.mSessionStateCallbacks != null) {
                    VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                }
                return;
            }
        }
    }

    private class SessionCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private SessionCaptureCallback() {
        }

        @WorkerThread
        public void onCaptureStarted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, long l2, long l3) {
            super.onCaptureStarted(cameraCaptureSession, captureRequest, l2, l3);
        }

        @WorkerThread
        public void onCaptureProgressed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureResult captureResult) {
        }

        @WorkerThread
        public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
        }
    }
}

