/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.avlab.utils.QLog;
import com.tencent.sharp.jni.AudioDeviceInterface;
import com.tencent.sharp.jni.TraeAudioSession;
import com.tencent.sharp.jni.TraeAudioSessionHost;
import com.tencent.sharp.jni.TraeMediaPlayer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class TraeAudioManager
extends BroadcastReceiver {
    public static final String ACTION_TRAEAUDIOMANAGER_REQUEST = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST";
    public static final String ACTION_TRAEAUDIOMANAGER_RES = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES";
    public static final String ACTION_TRAEAUDIOMANAGER_NOTIFY = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_NOTIFY";
    public static final String PARAM_OPERATION = "PARAM_OPERATION";
    public static final String PARAM_SESSIONID = "PARAM_SESSIONID";
    public static final String PARAM_ISHOSTSIDE = "PARAM_ISHOSTSIDE";
    public static final String PARAM_RES_ERRCODE = "PARAM_RES_ERRCODE";
    public static final int RES_ERRCODE_NONE = 0;
    public static final int RES_ERRCODE_SERVICE_OFF = 1;
    public static final int RES_ERRCODE_VOICECALL_EXIST = 2;
    public static final int RES_ERRCODE_VOICECALL_NOT_EXIST = 3;
    public static final int RES_ERRCODE_STOPRING_INTERRUPT = 4;
    public static final int RES_ERRCODE_RING_NOT_EXIST = 5;
    public static final int RES_ERRCODE_VOICECALLPOST_INTERRUPT = 6;
    public static final int RES_ERRCODE_DEVICE_UNKOWN = 7;
    public static final int RES_ERRCODE_DEVICE_NOT_VISIABLE = 8;
    public static final int RES_ERRCODE_DEVICE_UNCHANGEABLE = 9;
    public static final int RES_ERRCODE_DEVICE_BTCONNCECTED_TIMEOUT = 10;
    public static final String PARAM_STATUS = "PARAM_STATUS";
    public static final String PARAM_DEVICE = "PARAM_DEVICE";
    public static final String PARAM_ERROR = "PARAM_ERROR";
    public static final String PARAM_MODEPOLICY = "PARAM_MODEPOLICY";
    public static final String PARAM_STREAMTYPE = "PARAM_STREAMTYPE";
    public static final String PARAM_RING_DATASOURCE = "PARAM_RING_DATASOURCE";
    public static final String PARAM_RING_RSID = "PARAM_RING_RSID";
    public static final String PARAM_RING_URI = "PARAM_RING_URI";
    public static final String PARAM_RING_FILEPATH = "PARAM_RING_FILEPATH";
    public static final String PARAM_RING_LOOP = "PARAM_RING_LOOP";
    public static final String PARAM_RING_LOOPCOUNT = "PARAM_RING_LOOPCOUNT";
    public static final String PARAM_RING_MODE = "PARAM_RING_MODE";
    public static final String PARAM_RING_USERDATA_STRING = "PARAM_RING_USERDATA_STRING";
    public static final String OPERATION_STARTSERVICE = "OPERATION_STARTSERVICE";
    public static final String EXTRA_DATA_DEVICECONFIG = "EXTRA_DATA_DEVICECONFIG";
    public static final String OPERATION_STOPSERVICE = "OPERATION_STOPSERVICE";
    public static final String OPERATION_REGISTERAUDIOSESSION = "OPERATION_REGISTERAUDIOSESSION";
    public static final String REGISTERAUDIOSESSION_ISREGISTER = "REGISTERAUDIOSESSION_ISREGISTER";
    public static final String OPERATION_GETDEVICELIST = "OPERATION_GETDEVICELIST";
    public static final String OPERATION_GETSTREAMTYPE = "OPERATION_GETSTREAMTYPE";
    public static final String OPERATION_CONNECTDEVICE = "OPERATION_CONNECTDEVICE";
    public static final String CONNECTDEVICE_DEVICENAME = "CONNECTDEVICE_DEVICENAME";
    public static final String CONNECTDEVICE_RESULT_DEVICENAME = "CONNECTDEVICE_RESULT_DEVICENAME";
    public static final String OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE = "OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE";
    public static final String OPERATION_ISDEVICECHANGABLED = "OPERATION_ISDEVICECHANGABLED";
    public static final String ISDEVICECHANGABLED_RESULT_ISCHANGABLED = "ISDEVICECHANGABLED_REULT_ISCHANGABLED";
    public static final String OPERATION_GETCONNECTEDDEVICE = "OPERATION_GETCONNECTEDDEVICE";
    public static final String GETCONNECTEDDEVICE_RESULT_LIST = "GETCONNECTEDDEVICE_REULT_LIST";
    public static final String OPERATION_GETCONNECTINGDEVICE = "OPERATION_GETCONNECTINGDEVICE";
    public static final String GETCONNECTINGDEVICE_RESULT_LIST = "GETCONNECTINGDEVICE_REULT_LIST";
    public static final String EXTRA_DATA_STREAMTYPE = "EXTRA_DATA_STREAMTYPE";
    public static final String OPERATION_VOICECALL_PREPROCESS = "OPERATION_VOICECALL_PREPROCESS";
    public static final String OPERATION_VOICECALL_POSTPROCESS = "OPERATION_VOICECALL_POSTROCESS";
    public static final String OPERATION_STARTRING = "OPERATION_STARTRING";
    public static final String OPERATION_STOPRING = "OPERATION_STOPRING";
    public static final String OPERATION_REQUEST_RELEASE_AUDIO_FOCUS = "OPERATION_REQUEST_RELEASE_AUDIO_FOCUS";
    public static final String OPERATION_RECOVER_AUDIO_FOCUS = "OPERATION_RECOVER_AUDIO_FOCUS";
    public static final String OPERATION_VOICECALL_AUDIOPARAM_CHANGED = "OPERATION_VOICECALL_AUDIOPARAM_CHANGED";
    public static final String NOTIFY_SERVICE_STATE = "NOTIFY_SERVICE_STATE";
    public static final String NOTIFY_SERVICE_STATE_DATE = "NOTIFY_SERVICE_STATE_DATE";
    public static final String NOTIFY_DEVICELIST_UPDATE = "NOTIFY_DEVICELISTUPDATE";
    public static final String EXTRA_DATA_AVAILABLEDEVICE_LIST = "EXTRA_DATA_AVAILABLEDEVICE_LIST";
    public static final String EXTRA_DATA_PREV_CONNECTEDDEVICE = "EXTRA_DATA_PREV_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_CONNECTEDDEVICE = "EXTRA_DATA_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME = "EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE = "NOTIFY_DEVICECHANGABLE_UPDATE";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE_DATE = "NOTIFY_DEVICECHANGABLE_UPDATE_DATE";
    public static final String NOTIFY_RING_COMPLETION = "NOTIFY_RING_COMPLETION";
    public static final String NOTIFY_STREAMTYPE_UPDATE = "NOTIFY_STREAMTYPE_UPDATE";
    public static final String NOTIFY_ROUTESWITCHSTART = "NOTIFY_ROUTESWITCHSTART";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_FROM = "EXTRA_DATA_ROUTESWITCHSTART_FROM";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_TO = "EXTRA_DATA_ROUTESWITCHSTART_TO";
    public static final String NOTIFY_ROUTESWITCHEND = "NOTIFY_ROUTESWITCHEND";
    public static final String EXTRA_DATA_ROUTESWITCHEND_DEV = "EXTRA_DATA_ROUTESWITCHEND_DEV";
    public static final String EXTRA_DATA_ROUTESWITCHEND_TIME = "EXTRA_DATA_ROUTESWITCHEND_TIME";
    public static final int EARACTION_AWAY = 0;
    public static final int EARACTION_CLOSE = 1;
    public static final String OPERATION_EARACTION = "OPERATION_EARACTION";
    public static final String EXTRA_EARACTION = "EXTRA_EARACTION";
    public static final String DEVICE_NONE = "DEVICE_NONE";
    public static final String DEVICE_EARPHONE = "DEVICE_EARPHONE";
    public static final String DEVICE_SPEAKERPHONE = "DEVICE_SPEAKERPHONE";
    public static final String DEVICE_WIREDHEADSET = "DEVICE_WIREDHEADSET";
    public static final String DEVICE_BLUETOOTHHEADSET = "DEVICE_BLUETOOTHHEADSET";
    public static final int DEVICE_STATUS_ERROR = -1;
    public static final int DEVICE_STATUS_DISCONNECTED = 0;
    public static final int DEVICE_STATUS_CONNECTING = 1;
    public static final int DEVICE_STATUS_CONNECTED = 2;
    public static final int DEVICE_STATUS_DISCONNECTING = 3;
    public static final int DEVICE_STATUS_UNCHANGEABLE = 4;
    public static final int AUDIO_MANAGER_ACTIVE_NONE = 0;
    public static final int AUDIO_MANAGER_ACTIVE_VOICECALL = 1;
    public static final int AUDIO_MANAGER_ACTIVE_RING = 2;
    public static final int MODE_VOICE_CHAT = 0;
    public static final int MODE_MUSIC_PLAY_RECORD = 1;
    public static final int MODE_MUSIC_PLAYBACK = 2;
    public static final int MODE_MUSIC_PLAY_RECORD_HIGH_QUALITY = 3;
    public static final int MODE_VOICE_PLAYBACK = 4;
    public static final int MODE_MUSIC_PLAY_RECORD_LOW_QUALITY = 5;
    public static boolean IsMusicScene = false;
    public static boolean IsEarPhoneSupported = false;
    public static boolean IsUpdateSceneFlag = false;
    public static final String VOICECALL_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_EARPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String VIDEO_CONFIG = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String MUSIC_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_WIREDHEADSET;DEVICE_BLUETOOTHHEADSET;";
    public static String CurConnectedDevice = "DEVICE_NONE";
    static ReentrantLock _glock = new ReentrantLock();
    static TraeAudioManager _ginstance = null;
    static int _gHostProcessId = -1;
    static final String AUDIO_PARAMETER_STREAM_ROUTING = "routing";
    static final int AUDIO_DEVICE_OUT_EARPIECE = 1;
    static final int AUDIO_DEVICE_OUT_SPEAKER = 2;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADSET = 4;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADPHONE = 8;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO = 16;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP = 128;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    public static final int FORCE_BT_CAR_DOCK = 6;
    public static final int FORCE_BT_DESK_DOCK = 7;
    public static final int FORCE_ANALOG_DOCK = 8;
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    private static final int NUM_FORCE_CONFIG = 11;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    private static final int NUM_FORCE_USE = 4;
    static final String[] forceName = new String[]{"FORCE_NONE", "FORCE_SPEAKER", "FORCE_HEADPHONES", "FORCE_BT_SCO", "FORCE_BT_A2DP", "FORCE_WIRED_ACCESSORY", "FORCE_BT_CAR_DOCK", "FORCE_BT_DESK_DOCK", "FORCE_ANALOG_DOCK", "FORCE_NO_BT_A2DP", "FORCE_DIGITAL_DOCK"};
    AudioManager _am = null;
    Context _context = null;
    int _activeMode = 0;
    int _prevMode = 0;
    int _streamType = 0;
    int _modePolicy = -1;
    private int bluetoothState = 4;
    boolean IsBluetoothA2dpExisted = true;
    TraeAudioSessionHost _audioSessionHost = null;
    DeviceConfigManager _deviceConfigManager = null;
    BluetoohHeadsetCheckInterface _bluetoothCheck = null;
    String sessionConnectedDev = "DEVICE_NONE";
    TraeAudioManagerLooper mTraeAudioManagerLooper = null;
    ReentrantLock _lock = new ReentrantLock();
    switchThread _switchThread = null;

    public static String getConnectedDevice() {
        return CurConnectedDevice;
    }

    public static boolean checkDevName(String string) {
        if (string == null) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(string) || DEVICE_EARPHONE.equals(string) || DEVICE_WIREDHEADSET.equals(string) || DEVICE_BLUETOOTHHEADSET.equals(string);
    }

    public static boolean isHandfree(String string) {
        if (!TraeAudioManager.checkDevName(string)) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(string);
    }

    static boolean isCloseSystemAPM(int n2) {
        if (n2 != -1) {
            return false;
        }
        if (Build.MANUFACTURER.equals("Xiaomi")) {
            if (Build.MODEL.equals("MI 2")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2A")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2S")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2SC")) {
                return true;
            }
        } else if (Build.MANUFACTURER.equals("samsung") && Build.MODEL.equals("SCH-I959")) {
            return true;
        }
        return false;
    }

    public static boolean IsEabiLowVersionByAbi(String string) {
        if (string == null) {
            return true;
        }
        if (string.contains("x86")) {
            return false;
        }
        if (string.contains("mips")) {
            return false;
        }
        if (string.equalsIgnoreCase("armeabi")) {
            return true;
        }
        if (string.equalsIgnoreCase("armeabi-v7a")) {
            return false;
        }
        return !string.equalsIgnoreCase("arm64-v8a");
    }

    static boolean IsEabiLowVersion() {
        String string = Build.CPU_ABI;
        String string2 = "unknown";
        if (Build.VERSION.SDK_INT >= 8) {
            Class<Build> clazz;
            try {
                clazz = Build.class;
            }
            catch (Exception exception) {
                return TraeAudioManager.IsEabiLowVersionByAbi(string);
            }
            Field field = clazz.getDeclaredField("CPU_ABI2");
            string2 = (String)field.get(null);
        }
        if (QLog.isColorLevel()) {
            String string3 = "IsEabiVersion CPU_ABI:" + string + " CPU_ABI2:" + string2;
            QLog.w("TRAE", 0, string3);
        }
        return TraeAudioManager.IsEabiLowVersionByAbi(string) && TraeAudioManager.IsEabiLowVersionByAbi(string2);
    }

    static int getAudioSource(int n2) {
        int n3 = 0;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                String string = "[Config] armeabi low Version, getAudioSource _audioSourcePolicy:" + n2 + " source:" + n3;
                QLog.w("TRAE", 0, string);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            if (QLog.isColorLevel()) {
                String string = "[Config] getAudioSource _audioSourcePolicy:" + n2 + " source:" + n2;
                QLog.w("TRAE", 0, string);
            }
            return n2;
        }
        if (n4 >= 11) {
            n3 = 7;
        }
        if (QLog.isColorLevel()) {
            String string = "[Config] getAudioSource _audioSourcePolicy:" + n2 + " source:" + n3;
            QLog.w("TRAE", 0, string);
        }
        return n3;
    }

    static int getAudioStreamType(int n2) {
        int n3 = 3;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                String string = "[Config] armeabi low Version, getAudioStreamType audioStreamTypePolicy:" + n2 + " streamType:" + n3;
                QLog.w("TRAE", 0, string);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            n3 = n2;
        } else if (n4 >= 9) {
            n3 = 0;
        }
        if (QLog.isColorLevel()) {
            String string = "[Config] getAudioStreamType audioStreamTypePolicy:" + n2 + " streamType:" + n3;
            QLog.w("TRAE", 0, string);
        }
        return n3;
    }

    static int getCallAudioMode(int n2) {
        int n3 = 0;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                String string = "[Config] armeabi low Version, getCallAudioMode modePolicy:" + n2 + " mode:" + n3;
                QLog.w("TRAE", 0, string);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            if (QLog.isColorLevel()) {
                String string = "[Config] getCallAudioMode modePolicy:" + n2 + " mode:" + n2;
                QLog.w("TRAE", 0, string);
            }
            return n2;
        }
        if (n4 >= 11) {
            n3 = 3;
        }
        if (QLog.isColorLevel()) {
            String string = "[Config] getCallAudioMode _modePolicy:" + n2 + " mode:" + n3 + "facturer:" + Build.MANUFACTURER + " model:" + Build.MODEL;
            QLog.w("TRAE", 0, string);
        }
        return n3;
    }

    public static int SetSpeakerForTest(Context context, boolean bl) {
        int n2 = -1;
        _glock.lock();
        TraeAudioManager traeAudioManager = _ginstance;
        if (traeAudioManager != null) {
            n2 = traeAudioManager.InternalSetSpeaker(context, bl);
        } else if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "TraeAudioManager|static SetSpeakerForTest|null == _ginstance");
        }
        _glock.unlock();
        return n2;
    }

    public static int registerAudioSession(TraeAudioSession traeAudioSession, boolean bl, long l2, Context context) {
        int n2 = -1;
        _glock.lock();
        TraeAudioManager traeAudioManager = _ginstance;
        if (traeAudioManager != null) {
            if (bl) {
                traeAudioManager._audioSessionHost.add(traeAudioSession, l2, context);
            } else {
                traeAudioManager._audioSessionHost.remove(l2);
            }
            n2 = 0;
        }
        _glock.unlock();
        return n2;
    }

    public static int sendMessage(int n2, HashMap<String, Object> hashMap) {
        int n3 = -1;
        _glock.lock();
        TraeAudioManager traeAudioManager = _ginstance;
        if (traeAudioManager != null) {
            n3 = traeAudioManager.internalSendMessage(n2, hashMap);
        }
        _glock.unlock();
        return n3;
    }

    public static int init(Context context) {
        if (_ginstance == null) {
            Log.w((String)"TRAE", (String)("TraeAudioManager first init _ginstance:" + (Object)((Object)_ginstance)));
        }
        _glock.lock();
        if (_ginstance == null) {
            _ginstance = new TraeAudioManager(context);
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public static void uninit() {
        Log.w((String)"TRAE", (String)("TraeAudioManager uninit _ginstance:" + (Object)((Object)_ginstance)));
        AudioDeviceInterface.LogTraceEntry(" _ginstance:" + (Object)((Object)_ginstance));
        _glock.lock();
        TraeAudioManager traeAudioManager = _ginstance;
        if (traeAudioManager != null) {
            traeAudioManager.release();
            _ginstance = null;
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
    }

    TraeAudioManager(Context context) {
        AudioDeviceInterface.LogTraceEntry(" context:" + context);
        if (context == null) {
            return;
        }
        this._context = context;
        TraeAudioManager traeAudioManager = this;
        this.mTraeAudioManagerLooper = traeAudioManager.new TraeAudioManagerLooper(traeAudioManager);
        AudioDeviceInterface.LogTraceExit();
    }

    static int getDeviceList(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32774, hashMap2);
    }

    static int getStreamType(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32784, hashMap2);
    }

    static int startService(String string, long l2, boolean bl, String string2) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        if (string2.length() <= 0) {
            return -1;
        }
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(EXTRA_DATA_DEVICECONFIG, string2);
        return TraeAudioManager.sendMessage(32772, hashMap2);
    }

    static int stopService(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32773, hashMap2);
    }

    static int connectDevice(String string, long l2, boolean bl, String string2) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        if (string2 == null) {
            return -1;
        }
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(CONNECTDEVICE_DEVICENAME, string2);
        hashMap.put(PARAM_DEVICE, string2);
        return TraeAudioManager.sendMessage(32775, hashMap2);
    }

    static int connectHighestPriorityDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32789, hashMap2);
    }

    static int earAction(String string, long l2, boolean bl, int n2) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        if (n2 != 0 && n2 != 1) {
            return -1;
        }
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap2.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(EXTRA_EARACTION, n2);
        return TraeAudioManager.sendMessage(32776, hashMap2);
    }

    static int isDeviceChangabled(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32777, hashMap2);
    }

    static int getConnectedDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32778, hashMap2);
    }

    static int getConnectingDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32779, hashMap2);
    }

    static int voicecallPreprocess(String string, long l2, boolean bl, int n2, int n3) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap2.put(PARAM_ISHOSTSIDE, bl);
        hashMap2.put(PARAM_MODEPOLICY, n2);
        hashMap.put(PARAM_STREAMTYPE, n3);
        return TraeAudioManager.sendMessage(32780, hashMap2);
    }

    static int voicecallPostprocess(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32781, hashMap2);
    }

    static int voiceCallAudioParamChanged(String string, long l2, boolean bl, int n2, int n3) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap2.put(PARAM_ISHOSTSIDE, bl);
        hashMap2.put(PARAM_MODEPOLICY, n2);
        hashMap.put(PARAM_STREAMTYPE, n3);
        return TraeAudioManager.sendMessage(32788, hashMap2);
    }

    static int startRing(String string, long l2, boolean bl, int n2, int n3, Uri uri, String string2, boolean bl2, int n4, String string3, boolean bl3) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        HashMap<String, Object> hashMap4 = hashMap2;
        hashMap2();
        hashMap4.put(PARAM_SESSIONID, l2);
        hashMap4.put(PARAM_OPERATION, string);
        hashMap2.put(PARAM_ISHOSTSIDE, bl);
        hashMap2.put(PARAM_RING_DATASOURCE, n2);
        hashMap3.put(PARAM_RING_RSID, n3);
        hashMap3.put(PARAM_RING_URI, uri);
        hashMap3.put(PARAM_RING_FILEPATH, string2);
        hashMap2.put(PARAM_RING_LOOP, bl2);
        hashMap2.put(PARAM_RING_LOOPCOUNT, n4);
        hashMap.put(PARAM_RING_MODE, bl3);
        hashMap.put(PARAM_RING_USERDATA_STRING, string3);
        return TraeAudioManager.sendMessage(32782, hashMap2);
    }

    static int stopRing(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32783, hashMap2);
    }

    static int requestReleaseAudioFocus(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32790, hashMap2);
    }

    static int recoverAudioFocus(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put(PARAM_SESSIONID, l2);
        hashMap3.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32791, hashMap2);
    }

    static String getForceConfigName(int n2) {
        if (n2 >= 0) {
            String[] stringArray = forceName;
            if (n2 < forceName.length) {
                return stringArray[n2];
            }
        }
        return "unknow";
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) {
        Object var4_5 = null;
        try {
            object = object.getClass().getMethod(string, classArray).invoke(object, objectArray);
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                object = "invokeMethod Exception:" + exception.getMessage();
                QLog.w("TRAE", 0, (String)object);
            }
            object = var4_5;
        }
        return object;
    }

    public static Object invokeStaticMethod(String string, String string2, Object[] object, Class[] classArray) {
        block13: {
            Object var4_6;
            block14: {
                var4_6 = null;
                Method method = Class.forName(string).getMethod(string2, classArray);
                try {
                    object = method.invoke(null, object);
                    break block13;
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        String string3 = "invokeStaticMethod Exception:" + exception.getMessage();
                        QLog.w("TRAE", 0, string3);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (QLog.isColorLevel()) {
                        string = "InvocationTarget:" + string2;
                        QLog.w("TRAE", 0, string);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (QLog.isColorLevel()) {
                        string = "IllegalAccess:" + string2;
                        QLog.w("TRAE", 0, string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        string = "IllegalArgument:" + string2;
                        QLog.w("TRAE", 0, string);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (QLog.isColorLevel()) {
                        string = "NoSuchMethod:" + string2;
                        QLog.w("TRAE", 0, string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!QLog.isColorLevel()) break block14;
                    string = "ClassNotFound:" + string;
                    QLog.w("TRAE", 0, string);
                }
            }
            object = var4_6;
        }
        return object;
    }

    static void setParameters(String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = classArray;
        classArray[0] = String.class;
        if (QLog.isColorLevel()) {
            string = "setParameters  :" + string;
            QLog.w("TRAE", 0, string);
        }
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setParameters", objectArray2, classArray2);
    }

    static void setPhoneState(int n2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = classArray;
        classArray[0] = Integer.TYPE;
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setPhoneState", objectArray2, classArray2);
    }

    static void setForceUse(int n2, int n3) {
        Class<Integer> clazz;
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = n2;
        objectArray[1] = n3;
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = classArray;
        classArray[0] = clazz = Integer.TYPE;
        classArray[1] = clazz;
        object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setForceUse", object, classArray2);
        if (QLog.isColorLevel()) {
            String string = "setForceUse  usage:" + n2 + " config:" + n3 + " ->" + TraeAudioManager.getForceConfigName(n3) + " res:" + object;
            QLog.w("TRAE", 0, string);
        }
    }

    static int getForceUse(int n2) {
        Integer n3 = 0;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = n2;
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = classArray;
        classArray[0] = Integer.TYPE;
        if ((object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "getForceUse", object, classArray2)) != null) {
            n3 = (Integer)object;
        }
        if (QLog.isColorLevel()) {
            String string = "getForceUse  usage:" + n2 + " config:" + n3 + " ->" + TraeAudioManager.getForceConfigName(n3);
            QLog.w("TRAE", 0, string);
        }
        return n3;
    }

    static void forceVolumeControlStream(AudioManager object, int n2) {
        if (Build.MANUFACTURER.equals("Google")) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "forceVolumeControlStream, Google phone nothing to do");
            }
            return;
        }
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[1];
        object = objectArray2;
        objectArray2[0] = n2;
        Class[] classArray = new Class[objectArray2.length];
        Class[] classArray2 = classArray;
        classArray[0] = Integer.TYPE;
        object = TraeAudioManager.invokeMethod(objectArray, "forceVolumeControlStream", object, classArray2);
        if (QLog.isColorLevel()) {
            object = "forceVolumeControlStream  streamType:" + n2 + " res:" + object;
            QLog.w("TRAE", 0, (String)object);
        }
    }

    static /* synthetic */ int access$002(TraeAudioManager traeAudioManager, int n2) {
        traeAudioManager.bluetoothState = n2;
        return n2;
    }

    void printDevices() {
        String string;
        String string2;
        AudioDeviceInterface.LogTraceEntry("");
        int n2 = this._deviceConfigManager.getDeviceNumber();
        if (QLog.isColorLevel()) {
            string2 = "   ConnectedDevice:" + this._deviceConfigManager.getConnectedDevice();
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            string2 = "   ConnectingDevice:" + this._deviceConfigManager.getConnectingDevice();
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            string2 = "   prevConnectedDevice:" + this._deviceConfigManager.getPrevConnectedDevice();
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            string2 = "   AHPDevice:" + this._deviceConfigManager.getAvailabledHighestPriorityDevice();
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            string2 = "   deviceNamber:" + n2;
            QLog.w("TRAE", 0, string2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            string = this._deviceConfigManager.getDeviceName(i2);
            if (!QLog.isColorLevel()) continue;
            string = "      " + i2 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string);
            QLog.w("TRAE", 0, string);
        }
        String[] stringArray = this._deviceConfigManager.getAvailableDeviceList().toArray(new String[0]);
        if (QLog.isColorLevel()) {
            String string3 = "   AvailableNamber:" + stringArray.length;
            QLog.w("TRAE", 0, string3);
        }
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            string = stringArray[i3];
            if (!QLog.isColorLevel()) continue;
            string = "      " + i3 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string);
            QLog.w("TRAE", 0, string);
        }
        AudioDeviceInterface.LogTraceExit();
    }

    void updateDeviceStatus() {
        int n2 = this._deviceConfigManager.getDeviceNumber();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            String string = this._deviceConfigManager.getDeviceName(i2);
            if (string != null) {
                if (string.equals(DEVICE_BLUETOOTHHEADSET)) {
                    BluetoohHeadsetCheckInterface bluetoohHeadsetCheckInterface = this._bluetoothCheck;
                    bl = bluetoohHeadsetCheckInterface == null ? this._deviceConfigManager.setVisible(string, false) : this._deviceConfigManager.setVisible(string, bluetoohHeadsetCheckInterface.isConnected());
                } else if (string.equals(DEVICE_WIREDHEADSET)) {
                    bl = this._deviceConfigManager.setVisible(string, this._am.isWiredHeadsetOn());
                } else if (string.equals(DEVICE_SPEAKERPHONE)) {
                    this._deviceConfigManager.setVisible(string, true);
                }
            }
            if (!bl || !QLog.isColorLevel()) continue;
            String string2 = "pollUpdateDevice dev:" + string + " Visible:" + this._deviceConfigManager.getVisible(string);
            QLog.w("TRAE", 0, string2);
        }
        this.checkAutoDeviceListUpdate();
    }

    void _updateEarphoneVisable() {
        if (this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, " detected headset plugin,so disable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, false);
        } else {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, " detected headset plugout,so enable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, true);
        }
    }

    void checkAutoDeviceListUpdate() {
        if (object._deviceConfigManager.getVisiableUpdateFlag()) {
            HashMap hashMap;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "checkAutoDeviceListUpdate got update!");
            }
            TraeAudioManager traeAudioManager = object;
            traeAudioManager._updateEarphoneVisable();
            traeAudioManager._deviceConfigManager.resetVisiableUpdateFlag();
            Object object = hashMap;
            hashMap = new HashMap();
            traeAudioManager.internalSendMessage(32785, (HashMap<String, Object>)object);
        }
    }

    void checkDevicePlug(String string, boolean bl) {
        if (object._deviceConfigManager.getVisiableUpdateFlag()) {
            Object object;
            if (QLog.isColorLevel()) {
                String string2 = "TRAE";
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder().append("checkDevicePlug got update dev:").append(string);
                String string3 = bl ? " piugin" : " plugout";
                QLog.w(string2, n2, stringBuilder.append(string3).append(" connectedDev:").append(object._deviceConfigManager.getConnectedDevice()).toString());
            }
            TraeAudioManager traeAudioManager = object;
            traeAudioManager._updateEarphoneVisable();
            traeAudioManager._deviceConfigManager.resetVisiableUpdateFlag();
            if (bl) {
                HashMap<String, String> hashMap;
                TraeAudioManager traeAudioManager2 = object;
                object = hashMap;
                new HashMap<String, String>().put(PARAM_DEVICE, string);
                traeAudioManager2.internalSendMessage(32786, (HashMap<String, Object>)object);
            } else {
                String string4 = object._deviceConfigManager.getConnectedDevice();
                if (!string4.equals(string) && !string4.equals(DEVICE_NONE)) {
                    HashMap hashMap;
                    if (QLog.isColorLevel()) {
                        string = " ---No switch,plugout:" + string + " connectedDev:" + string4;
                        QLog.w("TRAE", 0, string);
                    }
                    TraeAudioManager traeAudioManager3 = object;
                    object = hashMap;
                    hashMap = new HashMap();
                    traeAudioManager3.internalSendMessage(32785, (HashMap<String, Object>)object);
                } else {
                    HashMap<String, String> hashMap;
                    TraeAudioManager traeAudioManager4 = object;
                    object = hashMap;
                    new HashMap<String, String>().put(PARAM_DEVICE, string);
                    traeAudioManager4.internalSendMessage(32787, (HashMap<String, Object>)object);
                }
            }
        }
    }

    int InternalSetSpeaker(Context object, boolean bl) {
        if (object == null) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "Could not InternalSetSpeaker - no context");
            }
            return -1;
        }
        if ((object = (AudioManager)object.getSystemService("audio")) == null) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "Could not InternalSetSpeaker - no audio manager");
            }
            return -1;
        }
        if (QLog.isColorLevel()) {
            String string = "TRAE";
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder().append("InternalSetSpeaker entry:speaker:");
            String string2 = object.isSpeakerphoneOn() ? "Y" : "N";
            stringBuilder = stringBuilder.append(string2).append("-->:");
            string2 = bl ? "Y" : "N";
            QLog.w(string, n2, stringBuilder.append(string2).toString());
        }
        if (TraeAudioManager.isCloseSystemAPM(this._modePolicy) && this._activeMode != 2) {
            return this.InternalSetSpeakerSpe((AudioManager)object, bl);
        }
        if (object.isSpeakerphoneOn() != bl) {
            object.setSpeakerphoneOn(bl);
        }
        int n3 = object.isSpeakerphoneOn() == bl ? 0 : -1;
        if (QLog.isColorLevel()) {
            object = "InternalSetSpeaker exit:" + bl + " res:" + n3 + " mode:" + object.getMode();
            QLog.w("TRAE", 0, (String)object);
        }
        return n3;
    }

    int InternalSetSpeakerSpe(AudioManager object, boolean bl) {
        if (QLog.isColorLevel()) {
            String string = "InternalSetSpeakerSpe fac:" + Build.MANUFACTURER + " model:" + Build.MODEL + " st:" + this._streamType + " media_force_use:" + TraeAudioManager.getForceUse(1);
            QLog.w("TRAE", 0, string);
        }
        if (bl) {
            this.InternalSetMode(0);
            object.setSpeakerphoneOn(true);
            TraeAudioManager.setForceUse(1, 1);
        } else {
            this.InternalSetMode(3);
            object.setSpeakerphoneOn(false);
            TraeAudioManager.setForceUse(1, 0);
        }
        int n2 = object.isSpeakerphoneOn() == bl ? 0 : -1;
        if (QLog.isColorLevel()) {
            object = "InternalSetSpeakerSpe exit:" + bl + " res:" + n2 + " mode:" + object.getMode();
            QLog.w("TRAE", 0, (String)object);
        }
        return n2;
    }

    void InternalSetMode(int n2) {
        Object object;
        Object object2;
        if (QLog.isColorLevel()) {
            object2 = "SetMode entry:" + n2;
            QLog.w("TRAE", 0, (String)object2);
        }
        if ((object2 = object._am) == null) {
            if (QLog.isColorLevel()) {
                object = "setMode:" + n2 + " fail am=null";
                QLog.w("TRAE", 0, (String)object);
            }
            return;
        }
        object2.setMode(n2);
        if (QLog.isColorLevel()) {
            TraeAudioManager traeAudioManager = object;
            object = "TRAE";
            int n3 = 0;
            StringBuilder stringBuilder = new StringBuilder().append("setMode:").append(n2);
            String string = traeAudioManager._am.getMode() != n2 ? "fail" : "success";
            QLog.w((String)object, n3, stringBuilder.append(string).toString());
        }
    }

    public void release() {
        AudioDeviceInterface.LogTraceEntry("");
        TraeAudioManagerLooper traeAudioManagerLooper = this.mTraeAudioManagerLooper;
        if (traeAudioManagerLooper != null) {
            traeAudioManagerLooper.quit();
            this.mTraeAudioManagerLooper = null;
        }
        AudioDeviceInterface.LogTraceExit();
    }

    /*
     * Unable to fully structure code
     */
    public void onReceive(Context var1_4, Intent var2_8) {
        block109: {
            block91: {
                block108: {
                    block107: {
                        block106: {
                            block105: {
                                block104: {
                                    block103: {
                                        block102: {
                                            block101: {
                                                block100: {
                                                    block99: {
                                                        block98: {
                                                            block97: {
                                                                block96: {
                                                                    block95: {
                                                                        block94: {
                                                                            block93: {
                                                                                block92: {
                                                                                    block89: {
                                                                                        block90: {
                                                                                            if (var2_8 == null || var1_4 == null) break block109;
                                                                                            try {
                                                                                                v0 = var2_8;
                                                                                                v1 = v0;
                                                                                                var3_9 = v0.getAction();
                                                                                            }
                                                                                            catch (Exception v2) {}
                                                                                            var4_10 = v1.getStringExtra("PARAM_OPERATION");
                                                                                            if (!QLog.isColorLevel()) ** GOTO lbl14
                                                                                            v3 = new StringBuilder();
                                                                                            QLog.w("TRAE", 0, v3.append("TraeAudioManager|onReceive::Action:").append(var2_8.getAction()).toString());
lbl14:
                                                                                            // 2 sources

                                                                                            if (this._deviceConfigManager != null) ** GOTO lbl20
                                                                                            if (!QLog.isColorLevel()) ** GOTO lbl19
                                                                                            QLog.d("TRAE", 0, "_deviceConfigManager null!");
lbl19:
                                                                                            // 2 sources

                                                                                            return;
lbl20:
                                                                                            // 1 sources

                                                                                            v4 = this;
                                                                                            v5 = v4;
                                                                                            v6 = v4._deviceConfigManager;
                                                                                            var5_12 = v6.getVisible("DEVICE_WIREDHEADSET");
                                                                                            v7 = v5._deviceConfigManager;
                                                                                            var6_14 = v7.getVisible("DEVICE_BLUETOOTHHEADSET");
                                                                                            if (!"android.intent.action.HEADSET_PLUG".equals(var2_8.getAction())) break block89;
                                                                                            this.onHeadsetPlug(var1_4, var2_8);
                                                                                            if (var5_12) break block90;
                                                                                            v8 = this._deviceConfigManager;
                                                                                            if (!v8.getVisible("DEVICE_WIREDHEADSET")) break block90;
                                                                                            this.checkDevicePlug("DEVICE_WIREDHEADSET", true);
                                                                                        }
                                                                                        if (!var5_12) break block91;
                                                                                        v9 = this._deviceConfigManager;
                                                                                        if (v9.getVisible("DEVICE_WIREDHEADSET")) break block91;
                                                                                        this.checkDevicePlug("DEVICE_WIREDHEADSET", false);
                                                                                        break block91;
                                                                                    }
                                                                                    if ("android.media.AUDIO_BECOMING_NOISY".equals(var2_8.getAction())) break block91;
                                                                                    if (!"com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST".equals(var3_9)) ** GOTO lbl221
                                                                                    if (!QLog.isColorLevel()) break block92;
                                                                                    v10 = new StringBuilder();
                                                                                    QLog.w("TRAE", 0, v10.append("   OPERATION:").append(var4_10).toString());
                                                                                }
                                                                                if (!"OPERATION_STARTSERVICE".equals(var4_10)) break block93;
                                                                                v11 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                                                TraeAudioManager.startService(var4_10, v11, false, var2_8.getStringExtra("EXTRA_DATA_DEVICECONFIG"));
                                                                                break block91;
                                                                            }
                                                                            if (!"OPERATION_STOPSERVICE".equals(var4_10)) break block94;
                                                                            v12 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                                            TraeAudioManager.stopService(var4_10, v12, false);
                                                                            break block91;
                                                                        }
                                                                        if (!"OPERATION_GETDEVICELIST".equals(var4_10)) break block95;
                                                                        v13 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                                        TraeAudioManager.getDeviceList(var4_10, v13, false);
                                                                        break block91;
                                                                    }
                                                                    if (!"OPERATION_GETSTREAMTYPE".equals(var4_10)) break block96;
                                                                    v14 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                                    TraeAudioManager.getStreamType(var4_10, v14, false);
                                                                    break block91;
                                                                }
                                                                if (!"OPERATION_CONNECTDEVICE".equals(var4_10)) break block97;
                                                                v15 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                                TraeAudioManager.connectDevice(var4_10, v15, false, var2_8.getStringExtra("CONNECTDEVICE_DEVICENAME"));
                                                                break block91;
                                                            }
                                                            if (!"OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE".equals(var4_10)) break block98;
                                                            v16 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                            TraeAudioManager.connectHighestPriorityDevice(var4_10, v16, false);
                                                            break block91;
                                                        }
                                                        if (!"OPERATION_EARACTION".equals(var4_10)) break block99;
                                                        v17 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                        TraeAudioManager.earAction(var4_10, v17, false, var2_8.getIntExtra("EXTRA_EARACTION", -1));
                                                        break block91;
                                                    }
                                                    if (!"OPERATION_ISDEVICECHANGABLED".equals(var4_10)) break block100;
                                                    v18 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                    TraeAudioManager.isDeviceChangabled(var4_10, v18, false);
                                                    break block91;
                                                }
                                                if (!"OPERATION_GETCONNECTEDDEVICE".equals(var4_10)) break block101;
                                                v19 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                                TraeAudioManager.getConnectedDevice(var4_10, v19, false);
                                                break block91;
                                            }
                                            if (!"OPERATION_GETCONNECTINGDEVICE".equals(var4_10)) break block102;
                                            v20 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                            TraeAudioManager.getConnectingDevice(var4_10, v20, false);
                                            break block91;
                                        }
                                        if (!"OPERATION_VOICECALL_PREPROCESS".equals(var4_10)) break block103;
                                        v21 = var2_8;
                                        var0_1 = v21.getIntExtra("PARAM_MODEPOLICY", -1);
                                        var1_5 = v21.getIntExtra("PARAM_STREAMTYPE", -1);
                                        v22 = v21.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                        TraeAudioManager.voicecallPreprocess(var4_10, v22, false, var0_1, var1_5);
                                        break block91;
                                    }
                                    if (!"OPERATION_VOICECALL_POSTROCESS".equals(var4_10)) break block104;
                                    v23 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                    TraeAudioManager.voicecallPostprocess(var4_10, v23, false);
                                    break block91;
                                }
                                if (!"OPERATION_VOICECALL_AUDIOPARAM_CHANGED".equals(var4_10)) break block105;
                                v24 = var2_8;
                                var0_2 = v24.getIntExtra("PARAM_MODEPOLICY", -1);
                                var1_6 = v24.getIntExtra("PARAM_STREAMTYPE", -1);
                                v25 = v24.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                                TraeAudioManager.voiceCallAudioParamChanged(var4_10, v25, false, var0_2, var1_6);
                                break block91;
                            }
                            if (!"OPERATION_STARTRING".equals(var4_10)) break block106;
                            v26 = var2_8;
                            var0_3 = v26.getIntExtra("PARAM_RING_DATASOURCE", -1);
                            var1_7 = v26.getIntExtra("PARAM_RING_RSID", -1);
                            var2_8 = (Uri)v26.getParcelableExtra("PARAM_RING_URI");
                            var3_9 = v26.getStringExtra("PARAM_RING_FILEPATH");
                            var4_11 = v26.getBooleanExtra("PARAM_RING_LOOP", false);
                            var5_13 = v26.getStringExtra("PARAM_RING_USERDATA_STRING");
                            var6_14 = v26.getIntExtra("PARAM_RING_LOOPCOUNT", 1);
                            var7_15 = v26.getBooleanExtra("PARAM_RING_MODE", false);
                            v27 = v26.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                            TraeAudioManager.startRing(var4_10, v27, false, var0_3, var1_7, (Uri)var2_8, var3_9, var4_11, var6_14, var5_13, var7_15);
                            break block91;
                        }
                        if (!"OPERATION_STOPRING".equals(var4_10)) break block91;
                        v28 = var2_8.getLongExtra("PARAM_SESSIONID", -9223372036854775808L);
                        TraeAudioManager.stopRing(var4_10, v28, false);
                        break block91;
lbl221:
                        // 1 sources

                        if (this._deviceConfigManager == null) break block91;
                        if (this._bluetoothCheck == null) break block107;
                        this._bluetoothCheck.onReceive(var1_4, var2_8, this._deviceConfigManager);
                    }
                    if (var6_14 == 0) {
                        v29 = this._deviceConfigManager;
                        if (!v29.getVisible("DEVICE_BLUETOOTHHEADSET")) break block108;
                        this.checkDevicePlug("DEVICE_BLUETOOTHHEADSET", true);
                    }
                }
                if (var6_14 != 1) break block91;
                v30 = this._deviceConfigManager;
                if (v30.getVisible("DEVICE_BLUETOOTHHEADSET")) break block91;
                this.checkDevicePlug("DEVICE_BLUETOOTHHEADSET", false);
            }
            return;
        }
        if (QLog.isColorLevel()) {
            QLog.d("TRAE", 0, "onReceive intent or context is null!");
        }
    }

    void onHeadsetPlug(Context object, Intent intent) {
        object = "";
        String string = intent.getStringExtra("name");
        if (string == null) {
            string = "unkonw";
        }
        object = (String)object + " [" + string + "] ";
        int n2 = intent.getIntExtra("state", -1);
        if (n2 != -1) {
            object = new StringBuilder().append((String)object);
            String string2 = n2 == 0 ? "unplugged" : "plugged";
            object = ((StringBuilder)object).append(string2).toString();
        }
        object = (String)object + " mic:";
        int n3 = intent.getIntExtra("microphone", -1);
        if (n3 != -1) {
            object = new StringBuilder().append((String)object);
            String string3 = n3 == 1 ? "Y" : "unkown";
            object = ((StringBuilder)object).append(string3).toString();
        }
        if (QLog.isColorLevel()) {
            object = "onHeadsetPlug:: " + (String)object;
            QLog.w("TRAE", 0, (String)object);
        }
        DeviceConfigManager deviceConfigManager = ((TraeAudioManager)((Object)deviceConfigManager))._deviceConfigManager;
        object = DEVICE_WIREDHEADSET;
        boolean bl = 1 == n2;
        deviceConfigManager.setVisible((String)object, bl);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "onHeadsetPlug exit");
        }
    }

    int internalSendMessage(int n2, HashMap<String, Object> hashMap) {
        int n3 = -1;
        TraeAudioManagerLooper traeAudioManagerLooper = this.mTraeAudioManagerLooper;
        if (traeAudioManagerLooper != null) {
            n3 = traeAudioManagerLooper.sendMessage(n2, hashMap);
        }
        return n3;
    }

    int InternalSessionConnectDevice(HashMap<String, Object> hashMap) {
        AudioDeviceInterface.LogTraceEntry("");
        if (hashMap != null && ((TraeAudioManager)((Object)object))._context != null) {
            Object object;
            if (IsMusicScene) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "MusicScene: InternalSessionConnectDevice failed");
                }
                return -1;
            }
            String string = (String)hashMap.get(PARAM_DEVICE);
            Log.w((String)"TRAE", (String)("ConnectDevice: " + string));
            if (!IsEarPhoneSupported && string.equals(DEVICE_EARPHONE)) {
                if (QLog.isColorLevel()) {
                    object = "InternalSessionConnectDevice IsEarPhoneSupported = false, Connect device:" + string + " failed";
                    QLog.e("TRAE", 0, (String)object);
                }
                return -1;
            }
            int n2 = 0;
            boolean bl = ((TraeAudioManager)((Object)object)).InternalIsDeviceChangeable();
            if (!TraeAudioManager.checkDevName(string)) {
                n2 = 7;
            } else if (!((TraeAudioManager)((Object)object))._deviceConfigManager.getVisible(string)) {
                n2 = 8;
            } else if (!bl) {
                n2 = 9;
            }
            if (QLog.isColorLevel()) {
                String string2 = "TRAE";
                int n3 = 0;
                StringBuilder stringBuilder = new StringBuilder().append("sessonID:").append((Long)hashMap.get(PARAM_SESSIONID)).append(" devName:").append(string).append(" bChangabled:");
                String string3 = bl ? "Y" : "N";
                QLog.w(string2, n3, stringBuilder.append(string3).append(" err:").append(n2).toString());
            }
            if (n2 != 0) {
                Intent intent;
                Object object2 = object;
                object = intent;
                object();
                object.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)hashMap.get(PARAM_DEVICE));
                ((TraeAudioManager)((Object)object2)).sendResBroadcast(intent, hashMap, n2);
                return -1;
            }
            if (string.equals(((TraeAudioManager)((Object)object))._deviceConfigManager.getConnectedDevice())) {
                Intent intent;
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " --has connected!");
                }
                Object object3 = object;
                object = intent;
                object();
                object.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)hashMap.get(PARAM_DEVICE));
                ((TraeAudioManager)((Object)object3)).sendResBroadcast(intent, hashMap, n2);
                return 0;
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, " --connecting...");
            }
            ((TraeAudioManager)((Object)object)).InternalConnectDevice(string, hashMap, false);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }
        return -1;
    }

    int InternalSessionEarAction(HashMap<String, Object> hashMap) {
        return 0;
    }

    int InternalConnectDevice(String object, HashMap<String, Object> hashMap, boolean bl) {
        Object object2;
        AudioDeviceInterface.LogTraceEntry(" devName:" + (String)object);
        if (object == null) {
            return -1;
        }
        if (IsMusicScene && ((String)object).equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                object2 = "MusicScene, Connect device:" + (String)object + " failed";
                QLog.e("TRAE", 0, (String)object2);
            }
            return -1;
        }
        if (!IsEarPhoneSupported && ((String)object).equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                object2 = "IsEarPhoneSupported = false, Connect device:" + (String)object + " failed";
                QLog.e("TRAE", 0, (String)object2);
            }
            return -1;
        }
        if (!bl && !object2._deviceConfigManager.getConnectedDevice().equals(DEVICE_NONE) && ((String)object).equals(object2._deviceConfigManager.getConnectedDevice())) {
            return 0;
        }
        if (TraeAudioManager.checkDevName((String)object) && object2._deviceConfigManager.getVisible((String)object)) {
            if (!object2.InternalIsDeviceChangeable()) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " InternalIsDeviceChangeable fail");
                }
                return -1;
            }
            Object object3 = object2;
            object3._deviceConfigManager.setConnecting((String)object);
            if (object3._switchThread != null) {
                if (QLog.isColorLevel()) {
                    String string = "_switchThread:" + object2._switchThread.getDeviceName();
                    QLog.w("TRAE", 0, string);
                }
                object2._switchThread.quit();
                object2._switchThread = null;
            }
            if (((String)object).equals(DEVICE_EARPHONE)) {
                object2._switchThread = (TraeAudioManager)((Object)object2).new earphoneSwitchThread();
            } else if (((String)object).equals(DEVICE_SPEAKERPHONE)) {
                object2._switchThread = (TraeAudioManager)((Object)object2).new speakerSwitchThread();
            } else if (((String)object).equals(DEVICE_WIREDHEADSET)) {
                object2._switchThread = (TraeAudioManager)((Object)object2).new headsetSwitchThread();
            } else if (((String)object).equals(DEVICE_BLUETOOTHHEADSET)) {
                object2._switchThread = (TraeAudioManager)((Object)object2).new bluetoothHeadsetSwitchThread();
            }
            object = object2._switchThread;
            if (object != null) {
                ((switchThread)object).setDeviceConnectParam(hashMap);
                object2._switchThread.start();
            }
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.e("TRAE", 0, " checkDevName fail");
        }
        return -1;
    }

    int InternalSessionIsDeviceChangabled(HashMap<String, Object> hashMap) {
        Intent intent;
        Intent intent2 = intent;
        intent2();
        intent2.putExtra(ISDEVICECHANGABLED_RESULT_ISCHANGABLED, this.InternalIsDeviceChangeable());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    boolean InternalIsDeviceChangeable() {
        String string = ((TraeAudioManager)((Object)string))._deviceConfigManager.getConnectingDevice();
        return string == null || string.equals(DEVICE_NONE) || string.equals("");
        {
        }
    }

    int InternalSessionGetConnectedDevice(HashMap<String, Object> hashMap) {
        Intent intent;
        Intent intent2 = intent;
        intent2();
        intent2.putExtra(GETCONNECTEDDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectedDevice());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    int InternalSessionGetConnectingDevice(HashMap<String, Object> hashMap) {
        Intent intent;
        Intent intent2 = intent;
        intent2();
        intent2.putExtra(GETCONNECTINGDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectingDevice());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    int sendResBroadcast(final Intent intent, HashMap<String, Object> serializable, int n2) {
        if (((TraeAudioManager)((Object)traeAudioSessionHost))._context == null) {
            return -1;
        }
        Object object = (Long)serializable.get(PARAM_SESSIONID);
        if (QLog.isColorLevel()) {
            String string = " sessonID:" + object + " " + (String)serializable.get(PARAM_OPERATION);
            QLog.w("TRAE", 0, string);
        }
        if (object != null && (Long)object != Long.MIN_VALUE) {
            HashMap<String, Object> hashMap = serializable;
            serializable = (Long)hashMap.get(PARAM_SESSIONID);
            object = (String)hashMap.get(PARAM_OPERATION);
            if (OPERATION_VOICECALL_PREPROCESS.equals(object)) {
                Intent intent2 = intent;
                intent2.setAction(ACTION_TRAEAUDIOMANAGER_RES);
                intent2.putExtra(PARAM_SESSIONID, serializable);
                intent2.putExtra(PARAM_OPERATION, (String)object);
                intent2.putExtra(PARAM_RES_ERRCODE, n2);
                TraeAudioSessionHost traeAudioSessionHost = ((TraeAudioManager)((Object)traeAudioSessionHost))._audioSessionHost;
                if (traeAudioSessionHost != null) {
                    traeAudioSessionHost.sendToAudioSessionMessage(intent);
                }
            } else {
                new Handler(Looper.getMainLooper()).post(new Runnable((Long)serializable, (String)object, n2){
                    final /* synthetic */ Long val$TAMSessionId;
                    final /* synthetic */ String val$TAMOperation;
                    final /* synthetic */ int val$TAMerr;
                    {
                        this.val$TAMSessionId = l2;
                        this.val$TAMOperation = string;
                        this.val$TAMerr = n2;
                    }

                    @Override
                    public void run() {
                        1 v0 = this;
                        v0.intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_RES);
                        v0.intent.putExtra(TraeAudioManager.PARAM_SESSIONID, (Serializable)this.val$TAMSessionId);
                        v0.intent.putExtra(TraeAudioManager.PARAM_OPERATION, this.val$TAMOperation);
                        v0.intent.putExtra(TraeAudioManager.PARAM_RES_ERRCODE, this.val$TAMerr);
                        Context context = v0.TraeAudioManager.this._context;
                        if (context != null) {
                            context.sendBroadcast(intent);
                        }
                    }
                });
            }
            return 0;
        }
        ((TraeAudioManager)((Object)traeAudioSessionHost)).InternalNotifyDeviceListUpdate();
        if (QLog.isColorLevel()) {
            QLog.e("TRAE", 0, "sendResBroadcast sid null,don't send res");
        }
        return -1;
    }

    int InternalNotifyDeviceListUpdate() {
        AudioDeviceInterface.LogTraceEntry("");
        if (this._context == null) {
            return -1;
        }
        TraeAudioManager traeAudioManager = this;
        HashMap<String, Object> hashMap = traeAudioManager._deviceConfigManager.getSnapParams();
        final ArrayList arrayList = (ArrayList)hashMap.get(EXTRA_DATA_AVAILABLEDEVICE_LIST);
        final String string = (String)hashMap.get(EXTRA_DATA_CONNECTEDDEVICE);
        final String string2 = (String)hashMap.get(EXTRA_DATA_PREV_CONNECTEDDEVICE);
        final String string3 = traeAudioManager._deviceConfigManager.getBluetoothName();
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Intent intent;
                Intent intent2;
                Intent intent3 = intent2 = intent;
                intent3();
                intent3.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent3.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICELIST_UPDATE);
                intent2.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, this_.arrayList.toArray(new String[0]));
                intent2.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, this_.string);
                intent2.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, this_.string2);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, this_.string3);
                2 this_ = this_.TraeAudioManager.this._context;
                if (this_ != null) {
                    this_.sendBroadcast(intent2);
                }
            }
        });
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalNotifyDeviceChangableUpdate() {
        if (this._context == null) {
            return -1;
        }
        final boolean bl = this.InternalIsDeviceChangeable();
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Intent intent;
                Intent intent2;
                Intent intent3 = intent2 = intent;
                intent3();
                intent3.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent3.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE);
                intent.putExtra(TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE_DATE, this_.bl);
                3 this_ = this_.TraeAudioManager.this._context;
                if (this_ != null) {
                    this_.sendBroadcast(intent2);
                }
            }
        });
        return 0;
    }

    public BluetoohHeadsetCheckInterface CreateBluetoothCheck(Context context, DeviceConfigManager object) {
        BluetoohHeadsetCheckInterface bluetoohHeadsetCheckInterface;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 11) {
            BluetoohHeadsetCheck bluetoohHeadsetCheck;
            bluetoohHeadsetCheckInterface = bluetoohHeadsetCheck;
            bluetoohHeadsetCheck = (TraeAudioManager)((Object)object2).new BluetoohHeadsetCheck();
        } else if (n2 != 18) {
            BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x;
            bluetoohHeadsetCheckInterface = bluetoohHeadsetCheckFor2x;
            bluetoohHeadsetCheckFor2x = (TraeAudioManager)((Object)object2).new BluetoohHeadsetCheckFor2x();
        } else {
            BluetoohHeadsetCheckFake bluetoohHeadsetCheckFake;
            bluetoohHeadsetCheckInterface = bluetoohHeadsetCheckFake;
            bluetoohHeadsetCheckFake = (TraeAudioManager)((Object)object2).new BluetoohHeadsetCheckFake();
        }
        if (!bluetoohHeadsetCheckInterface.init(context, (DeviceConfigManager)object)) {
            BluetoohHeadsetCheckFake bluetoohHeadsetCheckFake;
            bluetoohHeadsetCheckInterface = bluetoohHeadsetCheckFake;
            bluetoohHeadsetCheckFake = (TraeAudioManager)((Object)object2).new BluetoohHeadsetCheckFake();
        }
        if (QLog.isColorLevel()) {
            Object object2 = "TRAE";
            int n3 = 0;
            object = new StringBuilder().append("CreateBluetoothCheck:").append(bluetoohHeadsetCheckInterface.interfaceDesc()).append(" skip android4.3:");
            String string = Build.VERSION.SDK_INT == 18 ? "Y" : "N";
            QLog.w((String)object2, n3, ((StringBuilder)object).append(string).toString());
        }
        return bluetoohHeadsetCheckInterface;
    }

    class BluetoohHeadsetCheckFor2x
    extends BluetoohHeadsetCheckInterface {
        public static final String ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED = "android.bluetooth.headset.action.AUDIO_STATE_CHANGED";
        public static final String ACTION_BLUETOOTHHEADSET_STATE_CHANGED = "android.bluetooth.headset.action.STATE_CHANGED";
        static final int STATE_CONNECTED = 2;
        static final int STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_CONNECTED = 1;
        Class<?> BluetoothHeadsetClass;
        Class<?> ListenerClass;
        Object BluetoothHeadsetObj;
        Method getCurrentHeadsetMethod;
        Context _ctx;
        DeviceConfigManager _devCfg;

        BluetoohHeadsetCheckFor2x() {
            this.BluetoothHeadsetClass = null;
            this.ListenerClass = null;
            this.BluetoothHeadsetObj = null;
            this.getCurrentHeadsetMethod = null;
            this._ctx = null;
            this._devCfg = null;
        }

        @Override
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            AudioDeviceInterface.LogTraceEntry("");
            this._ctx = context;
            this._devCfg = deviceConfigManager;
            if (this._ctx != null && this._devCfg != null) {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                try {
                                    this.BluetoothHeadsetClass = Class.forName("android.bluetooth.BluetoothHeadset");
                                }
                                catch (Exception exception) {
                                    if (!QLog.isColorLevel()) break block29;
                                    QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset class not found");
                                }
                            }
                            if (this.BluetoothHeadsetClass == null) {
                                return false;
                            }
                            try {
                                this.ListenerClass = Class.forName("android.bluetooth.BluetoothHeadset$ServiceListener");
                            }
                            catch (Exception exception) {
                                if (!QLog.isColorLevel()) break block30;
                                String string = "BTLooperThread BluetoothHeadset.ServiceListener class not found:" + exception;
                                QLog.e("TRAE", 0, string);
                            }
                        }
                        BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x = this;
                        Class<?> cfr_ignored_0 = bluetoohHeadsetCheckFor2x.ListenerClass;
                        Class<?> clazz = bluetoohHeadsetCheckFor2x.BluetoothHeadsetClass;
                        try {
                            bluetoohHeadsetCheckFor2x.getCurrentHeadsetMethod = clazz.getDeclaredMethod("getCurrentHeadset", new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (!QLog.isColorLevel()) break block31;
                            QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset method getCurrentHeadset NoSuchMethodException");
                        }
                    }
                    if (this.getCurrentHeadsetMethod == null) {
                        return false;
                    }
                    BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x = this;
                    BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x2 = bluetoohHeadsetCheckFor2x;
                    Class<?> clazz = bluetoohHeadsetCheckFor2x.BluetoothHeadsetClass;
                    Class[] classArray = new Class[2];
                    classArray[0] = Context.class;
                    classArray[1] = this.ListenerClass;
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[2];
                    objectArray[0] = context;
                    try {
                        objectArray[1] = null;
                        bluetoohHeadsetCheckFor2x2.BluetoothHeadsetObj = constructor.newInstance(objectArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (QLog.isColorLevel()) {
                            QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset getConstructor NoSuchMethodException");
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (QLog.isColorLevel()) {
                            QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset getConstructor InvocationTargetException");
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (QLog.isColorLevel()) {
                            QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset getConstructor IllegalAccessException");
                        }
                    }
                    catch (InstantiationException instantiationException) {
                        if (QLog.isColorLevel()) {
                            QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset getConstructor InstantiationException");
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!QLog.isColorLevel()) break block32;
                        QLog.e("TRAE", 0, "BTLooperThread BluetoothHeadset getConstructor IllegalArgumentException");
                    }
                }
                if (this.BluetoothHeadsetObj == null) {
                    return false;
                }
                BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x = this;
                bluetoohHeadsetCheckFor2x._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, this.isConnected());
                if (bluetoohHeadsetCheckFor2x.isConnected()) {
                    BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x3 = this;
                    bluetoohHeadsetCheckFor2x3._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    bluetoohHeadsetCheckFor2x3.TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            return false;
        }

        @Override
        public void release() {
            Method method;
            AudioDeviceInterface.LogTraceEntry("");
            Method method2 = null;
            if (this.BluetoothHeadsetObj == null) {
                return;
            }
            Class<?> clazz = this.BluetoothHeadsetClass;
            try {
                method = clazz.getDeclaredMethod("close", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "BTLooperThread _uninitHeadsetfor2x method close NoSuchMethodException");
                }
                method = method2;
            }
            if (method == null) {
                return;
            }
            Method method3 = method;
            Object object = this.BluetoothHeadsetObj;
            try {
                method3.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            BluetoohHeadsetCheckFor2x bluetoohHeadsetCheckFor2x = this;
            bluetoohHeadsetCheckFor2x.BluetoothHeadsetClass = null;
            bluetoohHeadsetCheckFor2x.ListenerClass = null;
            bluetoohHeadsetCheckFor2x.BluetoothHeadsetObj = null;
            bluetoohHeadsetCheckFor2x.getCurrentHeadsetMethod = null;
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        public boolean isConnected() {
            String string = null;
            Method method = ((BluetoohHeadsetCheckFor2x)object).getCurrentHeadsetMethod;
            if (method != null && method != null) {
                block9: {
                    Object object;
                    block10: {
                        Method method2 = method;
                        Object object2 = ((BluetoohHeadsetCheckFor2x)object).BluetoothHeadsetObj;
                        try {
                            object = method2.invoke(object2, new Object[0]);
                            break block9;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 0, "BTLooperThread BluetoothHeadset method getCurrentHeadset InvocationTargetException");
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 0, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalAccessException");
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (!QLog.isColorLevel()) break block10;
                            QLog.w("TRAE", 0, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalArgumentException");
                        }
                    }
                    object = string;
                }
                if (QLog.isColorLevel()) {
                    string = "TRAE";
                    int n2 = 0;
                    StringBuilder stringBuilder = new StringBuilder().append("BTLooperThread BluetoothHeadset method getCurrentHeadset res:");
                    String string2 = object != null ? " Y" : "N";
                    QLog.w(string, n2, stringBuilder.append(string2).toString());
                }
                return object != null;
            }
            return false;
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
            if (QLog.isColorLevel()) {
                String string = " " + ((BluetoohHeadsetCheckFor2x)((Object)string)).interfaceDesc() + " _addAction";
                QLog.w("TRAE", 0, string);
            }
            IntentFilter intentFilter2 = intentFilter;
            intentFilter2.addAction(ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED);
            intentFilter2.addAction(ACTION_BLUETOOTHHEADSET_STATE_CHANGED);
        }

        @Override
        void _onReceive(Context context, Intent intent) {
            if (ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED.equals(intent.getAction())) {
                Intent intent2 = intent;
                int n2 = intent2.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                int n3 = intent2.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                int n4 = intent2.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    String string = "++ AUDIO_STATE_CHANGED|  STATE " + n2;
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "       PREVIOUS_STATE " + n3;
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "       AUDIO_STATE " + n4;
                    QLog.w("TRAE", 0, string);
                }
                if (n4 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n4 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if (ACTION_BLUETOOTHHEADSET_STATE_CHANGED.equals(intent.getAction())) {
                Intent intent3 = intent;
                int n5 = intent3.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                int n6 = intent3.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                int n7 = intent3.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    String string = "++ STATE_CHANGED|  STATE " + n5;
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "       PREVIOUS_STATE " + n6;
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "       AUDIO_STATE " + n7;
                    QLog.w("TRAE", 0, string);
                }
                if (n7 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n7 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFor2x";
        }
    }

    @TargetApi(value=11)
    class BluetoohHeadsetCheck
    extends BluetoohHeadsetCheckInterface
    implements BluetoothProfile.ServiceListener {
        Context _ctx;
        DeviceConfigManager _devCfg;
        BluetoothAdapter _adapter;
        BluetoothProfile _profile;
        private final ReentrantLock _profileLock;

        BluetoohHeadsetCheck() {
            this._ctx = null;
            this._devCfg = null;
            this._adapter = null;
            this._profile = null;
            this._profileLock = new ReentrantLock();
        }

        @Override
        @TargetApi(value=11)
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            AudioDeviceInterface.LogTraceEntry("");
            if (context != null && deviceConfigManager != null) {
                block11: {
                    block12: {
                        this._ctx = context;
                        this._devCfg = deviceConfigManager;
                        this._adapter = BluetoothAdapter.getDefaultAdapter();
                        if (this._adapter == null) {
                            if (QLog.isColorLevel()) {
                                QLog.e("TRAE", 0, " err getDefaultAdapter fail!");
                            }
                            return false;
                        }
                        BluetoohHeadsetCheck bluetoohHeadsetCheck = this;
                        bluetoohHeadsetCheck._profileLock.lock();
                        try {
                            if (!bluetoohHeadsetCheck._adapter.isEnabled()) break block11;
                        }
                        catch (Throwable throwable) {
                            this._profileLock.unlock();
                            throw throwable;
                        }
                        if (this._profile != null) break block11;
                        BluetoothAdapter bluetoothAdapter = this._adapter;
                        Context context2 = this._ctx;
                        if (bluetoothAdapter.getProfileProxy(context2, (BluetoothProfile.ServiceListener)this, 1)) break block11;
                        if (!QLog.isColorLevel()) break block12;
                        QLog.e("TRAE", 0, "BluetoohHeadsetCheck: getProfileProxy HEADSET fail!");
                    }
                    this._profileLock.unlock();
                    return false;
                }
                this._profileLock.unlock();
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, " err ctx==null||_devCfg==null");
            }
            return false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void release() {
            block7: {
                v0 = this;
                AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile);
                v0._profileLock.lock();
                if (v0._adapter != null) {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                    }
                    this._profile = null;
                }
lbl9:
                // 5 sources

                while (true) {
                    this._profileLock.unlock();
                    break;
                }
                {
                    catch (Throwable v1) {
                        break block7;
                    }
                    catch (Exception var1_1) {}
                    {
                        if (!QLog.isColorLevel()) ** GOTO lbl9
                        QLog.w("TRAE", 0, " closeProfileProxy:e:" + var1_1.getMessage());
                        ** continue;
                    }
                }
                AudioDeviceInterface.LogTraceExit();
                return;
            }
            this._profileLock.unlock();
            throw v1;
        }

        @Override
        public boolean isConnected() {
            boolean bl;
            block4: {
                List list;
                block5: {
                    BluetoohHeadsetCheck bluetoohHeadsetCheck = this;
                    bl = false;
                    bluetoohHeadsetCheck._profileLock.lock();
                    try {
                        if (bluetoohHeadsetCheck._profile == null) break block4;
                    }
                    catch (Throwable throwable) {
                        this._profileLock.unlock();
                        throw throwable;
                    }
                    list = this._profile.getConnectedDevices();
                    if (list != null) break block5;
                    this._profileLock.unlock();
                    return false;
                }
                bl = list.size() > 0;
            }
            this._profileLock.unlock();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @TargetApi(value=11)
        public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
            block19: {
                Object object;
                block17: {
                    AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + n2 + " proxy:" + bluetoothProfile);
                    if (n2 != 1) break block19;
                    BluetoohHeadsetCheck bluetoohHeadsetCheck = this;
                    bluetoohHeadsetCheck._profileLock.lock();
                    try {
                        if (bluetoohHeadsetCheck._profile != null && this._profile != bluetoothProfile) {
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 0, "BluetoohHeadsetCheck: HEADSET Connected proxy:" + bluetoothProfile + " _profile:" + this._profile);
                            }
                            this._adapter.closeProfileProxy(1, this._profile);
                            this._profile = null;
                        }
                        this._profile = bluetoothProfile;
                        object = null;
                        if (this._profile != null) {
                            object = this._profile.getConnectedDevices();
                        }
                        if (object == null || this._profile == null) break block17;
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 0, "TRAEBluetoohProxy: HEADSET Connected devs:" + object.size() + " _profile:" + this._profile);
                        }
                        for (int i2 = 0; i2 < object.size(); ++i2) {
                            int n3;
                            int n4;
                            BluetoothDevice bluetoothDevice;
                            block18: {
                                bluetoothDevice = (BluetoothDevice)object.get(i2);
                                n4 = 0;
                                try {
                                    if (this._profile == null) break block18;
                                    n3 = this._profile.getConnectionState(bluetoothDevice);
                                }
                                catch (Exception exception) {}
                            }
                            n3 = n4;
                            if (n3 == 2) {
                                this._devCfg.setBluetoothName(bluetoothDevice.getName());
                            }
                            if (!QLog.isColorLevel()) continue;
                            QLog.w("TRAE", 0, "   " + i2 + " " + bluetoothDevice.getName() + " ConnectionState:" + n3);
                        }
                    }
                    catch (Throwable throwable) {
                        this._profileLock.unlock();
                        throw throwable;
                    }
                }
                BluetoohHeadsetCheck bluetoohHeadsetCheck = this;
                bluetoohHeadsetCheck._profileLock.unlock();
                if (bluetoohHeadsetCheck._devCfg == null) break block19;
                object = null;
                DeviceConfigManager deviceConfigManager = TraeAudioManager.this._deviceConfigManager;
                if (deviceConfigManager != null) {
                    object = deviceConfigManager.getBluetoothName();
                }
                if (TextUtils.isEmpty((CharSequence)object)) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                } else if (this.isConnected()) {
                    BluetoohHeadsetCheck bluetoohHeadsetCheck2 = this;
                    bluetoohHeadsetCheck2._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    bluetoohHeadsetCheck2.TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @TargetApi(value=11)
        public void onServiceDisconnected(int n2) {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + n2);
            if (n2 == 1) {
                block8: {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 0, "TRAEBluetoohProxy: HEADSET Disconnected");
                    }
                    if (this.isConnected()) {
                        TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    }
                    BluetoohHeadsetCheck bluetoohHeadsetCheck = this;
                    bluetoohHeadsetCheck._profileLock.lock();
                    try {
                        if (bluetoohHeadsetCheck._profile == null) break block8;
                    }
                    catch (Throwable throwable) {
                        this._profileLock.unlock();
                        throw throwable;
                    }
                    BluetoohHeadsetCheck bluetoohHeadsetCheck2 = this;
                    BluetoohHeadsetCheck bluetoohHeadsetCheck3 = bluetoohHeadsetCheck2;
                    BluetoothAdapter bluetoothAdapter = bluetoohHeadsetCheck2._adapter;
                    bluetoothAdapter.closeProfileProxy(1, this._profile);
                    bluetoohHeadsetCheck3._profile = null;
                }
                this._profileLock.unlock();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
            if (QLog.isColorLevel()) {
                String string = " " + ((BluetoohHeadsetCheck)((Object)string)).interfaceDesc() + " _addAction";
                QLog.w("TRAE", 0, string);
            }
            IntentFilter intentFilter2 = intentFilter;
            intentFilter2.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
            intentFilter2.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            intentFilter2.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter2.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        }

        @Override
        void _onReceive(Context context, Intent intent) {
            Object object;
            if ("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED".equals(intent.getAction())) {
                int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                if (n2 == 12) {
                    if (((BluetoohHeadsetCheck)object).TraeAudioManager.this.bluetoothState == 6) {
                        QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread ACTION_AUDIO_STATE_CHANGED +++ Bluetooth audio SCO is now connected, SCO_CONNECTED");
                        TraeAudioManager.access$002(((BluetoohHeadsetCheck)object).TraeAudioManager.this, 7);
                    }
                } else if (n2 != 11 && n2 == 10) {
                    QLog.w("TRAE", 0, "ACTION_AUDIO_STATE_CHANGED +++ Bluetooth audio SCO is STATE_AUDIO_DISCONNECTED");
                }
            } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int n3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                if (n3 != 0) {
                    if (n3 != 1 && n3 == 2) {
                        BluetoohHeadsetCheck bluetoohHeadsetCheck = object;
                        TraeAudioManager.access$002(bluetoohHeadsetCheck.TraeAudioManager.this, 4);
                        bluetoohHeadsetCheck._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 0, "jeringtest  BluetoothHeadset ACTION_CONNECTION_STATE_CHANGED BluetoothProfile.STATE_CONNECTED");
                        }
                    }
                } else {
                    BluetoohHeadsetCheck bluetoohHeadsetCheck = object;
                    TraeAudioManager.access$002(bluetoohHeadsetCheck.TraeAudioManager.this, 3);
                    bluetoohHeadsetCheck._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 0, "jeringtest BluetoothHeadset ACTION_CONNECTION_STATE_CHANGED BluetoothProfile.STATE_DISCONNECTED");
                    }
                }
            } else if ("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                Intent intent2 = intent;
                int n4 = intent2.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", -1);
                int n5 = intent2.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", -1);
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent2.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (QLog.isColorLevel()) {
                    String string = "BT ACTION_CONNECTION_STATE_CHANGED|   EXTRA_CONNECTION_STATE " + ((BluetoohHeadsetCheckInterface)object).getBTAdapterConnectionState(n4);
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "    EXTRA_PREVIOUS_CONNECTION_STATE " + ((BluetoohHeadsetCheckInterface)object).getBTAdapterConnectionState(n5);
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "TRAE";
                    int n6 = 0;
                    StringBuilder stringBuilder = new StringBuilder().append("    EXTRA_DEVICE ").append(bluetoothDevice).append(" ");
                    String string2 = bluetoothDevice != null ? bluetoothDevice.getName() : " ";
                    QLog.w(string, n6, stringBuilder.append(string2).toString());
                }
                if (n4 == 2) {
                    if (QLog.isColorLevel()) {
                        String string = "   dev:" + bluetoothDevice.getName() + " connected,start sco...";
                        QLog.w("TRAE", 0, string);
                    }
                    BluetoohHeadsetCheck bluetoohHeadsetCheck = object;
                    bluetoohHeadsetCheck._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    object = bluetoohHeadsetCheck._devCfg;
                    String string = bluetoothDevice != null ? bluetoothDevice.getName() : "unkown";
                    ((DeviceConfigManager)object).setBluetoothName(string);
                } else if (n4 == 0) {
                    ((BluetoohHeadsetCheck)object)._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if ("android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(intent.getAction())) {
                Intent intent3 = intent;
                int n7 = intent3.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                int n8 = intent3.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -1);
                Object object2 = (BluetoothDevice)intent3.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (QLog.isColorLevel()) {
                    object2 = "BT ACTION_SCO_AUDIO_STATE_UPDATED|   EXTRA_CONNECTION_STATE  dev:" + object2;
                    QLog.w("TRAE", 0, (String)object2);
                }
                if (QLog.isColorLevel()) {
                    String string = "   EXTRA_SCO_AUDIO_STATE " + ((BluetoohHeadsetCheckInterface)object).getSCOAudioStateExtraString(n7);
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    object = "   EXTRA_SCO_AUDIO_PREVIOUS_STATE " + ((BluetoohHeadsetCheckInterface)object).getSCOAudioStateExtraString(n8);
                    QLog.w("TRAE", 0, (String)object);
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheck";
        }
    }

    class BluetoohHeadsetCheckFake
    extends BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckFake() {
        }

        @Override
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
        }

        @Override
        void _onReceive(Context context, Intent intent) {
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFake";
        }
    }

    abstract class BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckInterface() {
        }

        public abstract String interfaceDesc();

        public abstract boolean init(Context var1, DeviceConfigManager var2);

        public abstract void release();

        public abstract boolean isConnected();

        public void addAction(IntentFilter intentFilter) {
            IntentFilter intentFilter2 = intentFilter;
            intentFilter2.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            intentFilter2.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            intentFilter2.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            this._addAction(intentFilter2);
        }

        abstract void _addAction(IntentFilter var1);

        abstract void _onReceive(Context var1, Intent var2);

        public void onReceive(Context context, Intent intent, DeviceConfigManager deviceConfigManager) {
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                Intent intent2 = intent;
                int n2 = intent2.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                int n3 = intent2.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                if (QLog.isColorLevel()) {
                    String string = "BT ACTION_STATE_CHANGED|   EXTRA_STATE " + ((BluetoohHeadsetCheckInterface)((Object)string)).getBTActionStateChangedExtraString(n2);
                    QLog.w("TRAE", 0, string);
                }
                if (QLog.isColorLevel()) {
                    String string = "BT ACTION_STATE_CHANGED|   EXTRA_PREVIOUS_STATE " + ((BluetoohHeadsetCheckInterface)((Object)string)).getBTActionStateChangedExtraString(n3);
                    QLog.w("TRAE", 0, string);
                }
                if (n2 == 10) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 0, "    BT off");
                    }
                    deviceConfigManager.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                } else if (n2 == 12 && QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "BT OFF-->ON,Visiable it...");
                }
            } else if (!("android.bluetooth.device.action.ACL_CONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11 || "android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11)) {
                ((BluetoohHeadsetCheckInterface)((Object)string))._onReceive(context, intent);
            }
        }

        String getBTActionStateChangedExtraString(int n2) {
            switch (n2) {
                default: {
                    Object object = "unknow";
                    break;
                }
                case 13: {
                    Object object = "STATE_TURNING_OFF";
                    break;
                }
                case 12: {
                    Object object = "STATE_ON";
                    break;
                }
                case 11: {
                    Object object = "STATE_TURNING_ON";
                    break;
                }
                case 10: {
                    Object object = "STATE_OFF";
                }
            }
            return (String)object + ":" + n2;
        }

        String getSCOAudioStateExtraString(int n2) {
            switch (n2) {
                default: {
                    Object object = "unknow";
                    break;
                }
                case 2: {
                    Object object = "SCO_AUDIO_STATE_CONNECTING";
                    break;
                }
                case 1: {
                    Object object = "SCO_AUDIO_STATE_CONNECTED";
                    break;
                }
                case 0: {
                    Object object = "SCO_AUDIO_STATE_DISCONNECTED";
                    break;
                }
                case -1: {
                    Object object = "SCO_AUDIO_STATE_ERROR";
                }
            }
            return (String)object + ":" + n2;
        }

        String getBTAdapterConnectionState(int n2) {
            switch (n2) {
                default: {
                    Object object = "unknow";
                    break;
                }
                case 3: {
                    Object object = "STATE_DISCONNECTING";
                    break;
                }
                case 2: {
                    Object object = "STATE_CONNECTED";
                    break;
                }
                case 1: {
                    Object object = "STATE_CONNECTING";
                    break;
                }
                case 0: {
                    Object object = "STATE_DISCONNECTED";
                }
            }
            return (String)object + ":" + n2;
        }

        String getBTHeadsetConnectionState(int n2) {
            switch (n2) {
                default: {
                    Object object = "unknow";
                    break;
                }
                case 3: {
                    Object object = "STATE_DISCONNECTING";
                    break;
                }
                case 2: {
                    Object object = "STATE_CONNECTED";
                    break;
                }
                case 1: {
                    Object object = "STATE_CONNECTING";
                    break;
                }
                case 0: {
                    Object object = "STATE_DISCONNECTED";
                }
            }
            return (String)object + ":" + n2;
        }

        String getBTHeadsetAudioState(int n2) {
            String string = n2 != 10 ? (n2 != 12 ? "unknow:" + n2 : "STATE_AUDIO_CONNECTED") : "STATE_AUDIO_DISCONNECTED";
            return (String)string + ":" + n2;
        }
    }

    class bluetoothHeadsetSwitchThread
    extends switchThread {
        bluetoothHeadsetSwitchThread() {
        }

        @Override
        public void _run() {
            if (!IsMusicScene && IsUpdateSceneFlag) {
                try {
                    QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread sleep 1000");
                }
                catch (InterruptedException interruptedException) {}
                Thread.sleep(1000L);
                if (TraeAudioManager.this.bluetoothState == 7) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 0, "WIREDHEADSET plugout, bluetoothState == Bluetooth_State.SCO_CONNECTED force to HEADSET_AVAILABLE, reconnect");
                    }
                    TraeAudioManager.access$002(TraeAudioManager.this, 4);
                }
                int n2 = 0;
                while (TraeAudioManager.this.bluetoothState != 4 && n2++ < 10) {
                    if (QLog.isColorLevel()) {
                        String string = "bluetoothHeadsetSwitchThread waiting Bluetooth_State HEADSET_AVAILABLE, " + TraeAudioManager.this.bluetoothState;
                        QLog.w("TRAE", 0, string);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                n2 = 0;
                boolean bl = false;
                if (TraeAudioManager.this.bluetoothState != 4) {
                    n2 = 1;
                }
                if (n2 == 0) {
                    bluetoothHeadsetSwitchThread bluetoothHeadsetSwitchThread2 = this;
                    TraeAudioManager.access$002(bluetoothHeadsetSwitchThread2.TraeAudioManager.this, 6);
                    bluetoothHeadsetSwitchThread2._startBluetoothSco();
                    bl = true;
                    QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread _startBluetoothSco");
                }
                int n3 = 0;
                while (this._running && n3++ < 10 && n2 == 0) {
                    if (QLog.isColorLevel()) {
                        String string = "TRAE";
                        int n4 = 0;
                        StringBuilder stringBuilder = new StringBuilder().append("bluetoothHeadsetSwitchThread i:").append(n3).append(" sco:");
                        String string2 = TraeAudioManager.this._am.isBluetoothScoOn() ? "Y" : "N";
                        QLog.w(string, n4, stringBuilder.append(string2).append(" :").append(TraeAudioManager.this._deviceConfigManager.getBluetoothName()).toString());
                    }
                    if (TraeAudioManager.this.bluetoothState == 7) {
                        QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 1");
                        this.updateStatus();
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (TraeAudioManager.this.bluetoothState == 7) {
                        QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 2");
                        this.updateStatus();
                        break;
                    }
                    if (!bl) continue;
                    bluetoothHeadsetSwitchThread bluetoothHeadsetSwitchThread3 = this;
                    bluetoothHeadsetSwitchThread3._stopBluetoothSco();
                    bluetoothHeadsetSwitchThread3._startBluetoothSco();
                    QLog.w("TRAE", 0, "bluetoothHeadsetSwitchThread retry start sco");
                }
                if (TraeAudioManager.this.bluetoothState != 7) {
                    if (QLog.isColorLevel() && n2 == 0) {
                        QLog.e("TRAE", 0, "bluetoothHeadsetSwitchThread sco fail,remove btheadset");
                    }
                    bluetoothHeadsetSwitchThread bluetoothHeadsetSwitchThread4 = this;
                    bluetoothHeadsetSwitchThread4.TraeAudioManager.this._deviceConfigManager.setVisible(this.getDeviceName(), false);
                    bluetoothHeadsetSwitchThread4.processDeviceConnectRes(10);
                    bluetoothHeadsetSwitchThread4.TraeAudioManager.this.checkAutoDeviceListUpdate();
                }
                return;
            }
            if (QLog.isColorLevel()) {
                String string = "connect bluetoothHeadset: do nothing, IsMusicScene:" + IsMusicScene + " ,IsUpdateSceneFlag:" + IsUpdateSceneFlag;
                QLog.w("TRAE", 0, string);
            }
            this.updateStatus();
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_BLUETOOTHHEADSET;
        }

        @Override
        @TargetApi(value=8)
        public void _quit() {
            if (TraeAudioManager.this._am == null) {
                return;
            }
            this._stopBluetoothSco();
        }

        @TargetApi(value=8)
        void _startBluetoothSco() {
            TraeAudioManager.this._am.setBluetoothScoOn(true);
            if (Build.VERSION.SDK_INT > 8) {
                TraeAudioManager.this._am.startBluetoothSco();
            }
        }

        @TargetApi(value=8)
        void _stopBluetoothSco() {
            if (Build.VERSION.SDK_INT > 8) {
                TraeAudioManager.this._am.stopBluetoothSco();
            }
            TraeAudioManager.this._am.setBluetoothScoOn(false);
        }
    }

    class headsetSwitchThread
    extends switchThread {
        headsetSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag) {
                headsetSwitchThread headsetSwitchThread2 = this;
                TraeAudioManager traeAudioManager = headsetSwitchThread2.TraeAudioManager.this;
                traeAudioManager.InternalSetSpeaker(traeAudioManager._context, false);
                headsetSwitchThread2.TraeAudioManager.this._am.setWiredHeadsetOn(true);
            }
            this.updateStatus();
            if (!IsMusicScene && IsUpdateSceneFlag) {
                while (this._running) {
                    if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                        TraeAudioManager traeAudioManager = TraeAudioManager.this;
                        traeAudioManager.InternalSetSpeaker(traeAudioManager._context, false);
                    }
                    long l2 = n2 < 5 ? 1000L : 4000L;
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n2;
                }
                return;
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "connect headset: do nothing");
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_WIREDHEADSET;
        }

        @Override
        public void _quit() {
        }
    }

    class speakerSwitchThread
    extends switchThread {
        speakerSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag) {
                TraeAudioManager traeAudioManager = TraeAudioManager.this;
                traeAudioManager.InternalSetSpeaker(traeAudioManager._context, true);
            }
            this.updateStatus();
            if (!IsMusicScene && IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    String string = " _run:" + this.getDeviceName() + " _running:" + this._running;
                    QLog.w("TRAE", 0, string);
                }
                while (this._running) {
                    if (!TraeAudioManager.this._am.isSpeakerphoneOn()) {
                        TraeAudioManager traeAudioManager = TraeAudioManager.this;
                        traeAudioManager.InternalSetSpeaker(traeAudioManager._context, true);
                    }
                    long l2 = n2 < 5 ? 1000L : 4000L;
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n2;
                }
                return;
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "connect speakerPhone: do nothing");
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    class earphoneSwitchThread
    extends switchThread {
        earphoneSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (IsUpdateSceneFlag) {
                TraeAudioManager traeAudioManager = TraeAudioManager.this;
                traeAudioManager.InternalSetSpeaker(traeAudioManager._context, false);
            }
            this.updateStatus();
            if (!IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "connect earphone: do nothing");
                }
                return;
            }
            while (this._running) {
                if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager traeAudioManager = TraeAudioManager.this;
                    traeAudioManager.InternalSetSpeaker(traeAudioManager._context, false);
                }
                long l2 = n2 < 5 ? 1000L : 4000L;
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {}
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_EARPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    abstract class switchThread
    extends Thread {
        boolean _running = true;
        boolean[] _exited = new boolean[]{false};
        HashMap<String, Object> _params = null;
        long _usingtime = 0L;

        switchThread() {
            if (QLog.isColorLevel()) {
                String string = " ++switchThread:" + ((switchThread)((Object)string)).getDeviceName();
                QLog.w("TRAE", 0, string);
            }
        }

        public void setDeviceConnectParam(HashMap<String, Object> hashMap) {
            this._params = hashMap;
        }

        void updateStatus() {
            switchThread switchThread2 = this;
            switchThread2.TraeAudioManager.this._deviceConfigManager.setConnected(this.getDeviceName());
            switchThread2.processDeviceConnectRes(0);
        }

        void processDeviceConnectRes(int n2) {
            switchThread switchThread2 = this;
            switchThread2.TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName() + " err:" + n2);
            if (switchThread2._params == null) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                return;
            }
            switchThread switchThread3 = this;
            switchThread3.TraeAudioManager.this.sessionConnectedDev = switchThread3.TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
            Long l2 = (Long)switchThread3._params.get(TraeAudioManager.PARAM_SESSIONID);
            if (QLog.isColorLevel()) {
                String string = " sessonID:" + l2;
                QLog.w("TRAE", 0, string);
            }
            if (l2 != null && l2 != Long.MIN_VALUE) {
                Intent intent;
                l2 = intent;
                l2();
                intent.putExtra(TraeAudioManager.CONNECTDEVICE_RESULT_DEVICENAME, (String)this._params.get(TraeAudioManager.PARAM_DEVICE));
                if (TraeAudioManager.this.sendResBroadcast((Intent)l2, this._params, n2) == 0) {
                    TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                }
                AudioDeviceInterface.LogTraceExit();
                return;
            }
            TraeAudioManager.this.InternalNotifyDeviceListUpdate();
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "processDeviceConnectRes sid null,don't send res");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            switchThread switchThread2 = this;
            AudioDeviceInterface.LogTraceEntry(switchThread2.getDeviceName());
            switchThread2.TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            switchThread2._run();
            boolean[] blArray = switchThread2._exited;
            switchThread switchThread3 = this;
            synchronized (blArray) {
                boolean[] blArray2 = switchThread3._exited;
                blArray2[0] = true;
                switchThread3._exited.notifyAll();
                // ** MonitorExit[v0._exited] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            Object object;
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            this._running = false;
            if (QLog.isColorLevel()) {
                object = " quit:" + this.getDeviceName() + " _running:" + this._running;
                QLog.w("TRAE", 0, (String)object);
            }
            switchThread switchThread2 = this;
            switchThread2.interrupt();
            switchThread2._quit();
            object = switchThread2._exited;
            synchronized (switchThread2._exited) {
                block9: {
                    boolean[] blArray = switchThread2._exited;
                    if (blArray[0]) break block9;
                    boolean[] blArray2 = this._exited;
                    try {
                        blArray2.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public abstract String getDeviceName();

        public abstract void _run();

        public abstract void _quit();
    }

    class TraeAudioManagerLooper
    extends Thread {
        public static final int MESSAGE_BEGIN = 32768;
        public static final int MESSAGE_ENABLE = 32772;
        public static final int MESSAGE_DISABLE = 32773;
        public static final int MESSAGE_GETDEVICELIST = 32774;
        public static final int MESSAGE_CONNECTDEVICE = 32775;
        public static final int MESSAGE_EARACTION = 32776;
        public static final int MESSAGE_ISDEVICECHANGABLED = 32777;
        public static final int MESSAGE_GETCONNECTEDDEVICE = 32778;
        public static final int MESSAGE_GETCONNECTINGDEVICE = 32779;
        public static final int MESSAGE_VOICECALLPREPROCESS = 32780;
        public static final int MESSAGE_VOICECALLPOSTPROCESS = 32781;
        public static final int MESSAGE_STARTRING = 32782;
        public static final int MESSAGE_STOPRING = 32783;
        public static final int MESSAGE_GETSTREAMTYPE = 32784;
        public static final int MESSAGE_AUTO_DEVICELIST_UPDATE = 32785;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE = 32786;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE = 32787;
        public static final int MESSAGE_VOICECALL_AUIDOPARAM_CHANGED = 32788;
        public static final int MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE = 32789;
        public static final int MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS = 32790;
        public static final int MESSAGE_RECOVER_AUDIO_FOCUS = 32791;
        Handler mMsgHandler = null;
        TraeMediaPlayer _ringPlayer = null;
        long _ringSessionID = -1L;
        String _ringOperation = "";
        String _ringUserdata = "";
        final boolean[] _started = new boolean[]{false};
        boolean _enabled = false;
        TraeAudioManager _parent = null;
        String _lastCfg = "";
        int _preServiceMode = 0;
        int _preRingMode = 0;
        boolean IsFirstConnectDeviceFlag = true;
        long _voiceCallSessionID = -1L;
        String _voiceCallOperation = "";
        AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener = null;
        int _focusSteamType = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraeAudioManagerLooper(TraeAudioManager traeAudioManager2) {
            ((TraeAudioManagerLooper)((Object)string))._parent = traeAudioManager2;
            long l2 = SystemClock.elapsedRealtime();
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "TraeAudioManagerLooper start...");
            }
            TraeAudioManagerLooper traeAudioManagerLooper = string;
            traeAudioManagerLooper.start();
            boolean[] blArray = traeAudioManagerLooper._started;
            synchronized (traeAudioManagerLooper._started) {
                block10: {
                    boolean[] blArray2 = traeAudioManagerLooper._started;
                    if (blArray2[0]) break block10;
                    boolean[] blArray3 = ((TraeAudioManagerLooper)((Object)string))._started;
                    try {
                        blArray3.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    String string = "  start used:" + (SystemClock.elapsedRealtime() - l2) + "ms";
                    QLog.e("TRAE", 0, string);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry("");
            if (this.mMsgHandler == null) {
                return;
            }
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            long l2 = SystemClock.elapsedRealtime();
            traeAudioManagerLooper.mMsgHandler.getLooper().quit();
            boolean[] blArray = traeAudioManagerLooper._started;
            synchronized (traeAudioManagerLooper._started) {
                block10: {
                    boolean[] blArray2 = traeAudioManagerLooper._started;
                    if (!blArray2[0]) break block10;
                    boolean[] blArray3 = this._started;
                    try {
                        blArray3.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    String string = "  quit used:" + (SystemClock.elapsedRealtime() - l2) + "ms";
                    QLog.e("TRAE", 0, string);
                }
                this.mMsgHandler = null;
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public int sendMessage(int n2, HashMap<String, Object> serializable) {
            Object object = traeAudioManagerLooper.mMsgHandler;
            if (object == null) {
                serializable = new StringBuilder().append(" fail mMsgHandler==null _enabled:");
                object = traeAudioManagerLooper._enabled ? "Y" : "N";
                AudioDeviceInterface.LogTraceEntry(((StringBuilder)serializable).append((String)object).append(" activeMode:").append(traeAudioManagerLooper.TraeAudioManager.this._activeMode).append(" msg:").append(n2).toString());
                return -1;
            }
            TraeAudioManagerLooper traeAudioManagerLooper = Message.obtain((Handler)object, (int)n2, serializable);
            return traeAudioManagerLooper.mMsgHandler.sendMessage((Message)traeAudioManagerLooper) ? 0 : -1;
        }

        void startService(HashMap<String, Object> object) {
            object = (String)((HashMap)object).get(TraeAudioManager.EXTRA_DATA_DEVICECONFIG);
            Log.w((String)"TRAE", (String)("startService cfg:" + (String)object));
            CharSequence charSequence = new StringBuilder().append(" _enabled:");
            String string = this._enabled ? "Y" : "N";
            AudioDeviceInterface.LogTraceEntry(charSequence.append(string).append(" activeMode:").append(TraeAudioManager.this._activeMode).append(" cfg:").append((String)object).toString());
            if (TraeAudioManager.this._context == null) {
                return;
            }
            if (((String)object).equals("resume service")) {
                object = this._lastCfg;
            }
            charSequence = "   startService:" + (String)object;
            QLog.w("TRAE", 0, (String)charSequence);
            if (this._enabled && this._lastCfg.equals(object) || TraeAudioManager.this._activeMode != 0) {
                return;
            }
            if (this._enabled) {
                this.stopService();
            }
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            traeAudioManagerLooper._prev_startService();
            AudioManager cfr_ignored_0 = (AudioManager)traeAudioManagerLooper.TraeAudioManager.this._context.getSystemService("audio");
            traeAudioManagerLooper.TraeAudioManager.this._deviceConfigManager.clearConfig();
            traeAudioManagerLooper.TraeAudioManager.this._deviceConfigManager.init((String)object);
            this._lastCfg = object;
            object = TraeAudioManager.this._am;
            if (object != null) {
                this._preServiceMode = object.getMode();
            }
            this._enabled = true;
            if (this._ringPlayer == null) {
                this._ringPlayer = new TraeMediaPlayer(TraeAudioManager.this._context, new TraeMediaPlayer.OnCompletionListener(){

                    @Override
                    public void onCompletion() {
                        HashMap<String, Boolean> hashMap;
                        if (QLog.isColorLevel()) {
                            String string = "_ringPlayer onCompletion _activeMode:" + hashMap2.TraeAudioManager.this._activeMode + " _preRingMode:" + hashMap2.TraeAudioManagerLooper.this._preRingMode;
                            QLog.w("TRAE", 0, string);
                        }
                        1 v0 = hashMap2;
                        HashMap<String, Boolean> hashMap2 = hashMap;
                        new HashMap<String, Boolean>().put(TraeAudioManager.PARAM_ISHOSTSIDE, true);
                        v0.TraeAudioManagerLooper.this.sendMessage(32783, (HashMap<String, Object>)hashMap2);
                        v0.TraeAudioManagerLooper.this.notifyRingCompletion();
                    }
                });
            }
            TraeAudioManagerLooper traeAudioManagerLooper2 = this;
            traeAudioManagerLooper2.notifyServiceState(traeAudioManagerLooper2._enabled);
            traeAudioManagerLooper2.TraeAudioManager.this.updateDeviceStatus();
            AudioDeviceInterface.LogTraceExit();
        }

        boolean isNeedForceVolumeType() {
            if (Build.MANUFACTURER.equals("Xiaomi")) {
                if (Build.MODEL.equals("MI 5")) {
                    return true;
                }
                if (Build.MODEL.equals("MI 5s")) {
                    return true;
                }
                if (Build.MODEL.equals("MI 5s Plus")) {
                    return true;
                }
            }
            return false;
        }

        void stopService() {
            block13: {
                Object object;
                StringBuilder stringBuilder = new StringBuilder().append(" _enabled:");
                String string = this._enabled ? "Y" : "N";
                AudioDeviceInterface.LogTraceEntry(stringBuilder.append(string).append(" activeMode:").append(TraeAudioManager.this._activeMode).toString());
                if (!this._enabled) {
                    return;
                }
                int n2 = TraeAudioManager.this._activeMode;
                if (n2 == 1) {
                    this.interruptVoicecallPostprocess();
                } else if (n2 == 2) {
                    this.interruptRing();
                }
                if (TraeAudioManager.this._switchThread != null) {
                    if (QLog.isColorLevel()) {
                        String string2 = "_switchThread:" + TraeAudioManager.this._switchThread.getDeviceName();
                        QLog.w("TRAE", 0, string2);
                    }
                    TraeAudioManager.this._switchThread.quit();
                    TraeAudioManager.this._switchThread = null;
                }
                if ((object = this._ringPlayer) != null) {
                    ((TraeMediaPlayer)object).stopRing();
                }
                TraeAudioManagerLooper traeAudioManagerLooper = this;
                traeAudioManagerLooper._ringPlayer = null;
                traeAudioManagerLooper._enabled = false;
                traeAudioManagerLooper.notifyServiceState(traeAudioManagerLooper._enabled);
                object = traeAudioManagerLooper.TraeAudioManager.this;
                if (((TraeAudioManager)((Object)object))._am != null && ((TraeAudioManager)((Object)object))._context != null) {
                    try {
                        ((TraeAudioManager)((Object)object)).InternalSetMode(0);
                    }
                    catch (Exception exception) {}
                    this.IsFirstConnectDeviceFlag = true;
                    if (!this.isNeedForceVolumeType()) break block13;
                    QLog.w("TRAE", 0, "NeedForceVolumeType: AudioManager.STREAM_MUSIC");
                    AudioManager audioManager = TraeAudioManager.this._am;
                    TraeAudioManager.forceVolumeControlStream(audioManager, 3);
                }
            }
            this._post_stopService();
            AudioDeviceInterface.LogTraceExit();
        }

        int notifyServiceState(boolean bl) {
            Intent intent;
            if (traeAudioManagerLooper2.TraeAudioManager.this._context == null) {
                return -1;
            }
            TraeAudioManagerLooper traeAudioManagerLooper = traeAudioManagerLooper2;
            TraeAudioManagerLooper traeAudioManagerLooper2 = intent;
            new Intent().setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
            traeAudioManagerLooper2.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_SERVICE_STATE);
            traeAudioManagerLooper2.putExtra(TraeAudioManager.NOTIFY_SERVICE_STATE_DATE, bl);
            Context context = traeAudioManagerLooper.TraeAudioManager.this._context;
            if (context != null) {
                context.sendBroadcast((Intent)traeAudioManagerLooper2);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            AudioDeviceInterface.LogTraceEntry("");
            Looper.prepare();
            traeAudioManagerLooper.mMsgHandler = new Handler(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void handleMessage(Message message) {
                    int n2;
                    int n3;
                    Object object;
                    Object object2 = null;
                    try {
                        object = (HashMap)message.obj;
                    }
                    catch (Exception exception) {
                        object = object2;
                    }
                    if (QLog.isColorLevel()) {
                        object2 = "TRAE";
                        int n4 = 0;
                        StringBuilder stringBuilder = new StringBuilder().append("TraeAudioManagerLooper msg:").append(message.what).append(" _enabled:");
                        String string = this_.TraeAudioManagerLooper.this._enabled ? "Y" : "N";
                        QLog.w((String)object2, n4, stringBuilder.append(string).toString());
                    }
                    if ((n3 = message.what) == 32772) {
                        this_.TraeAudioManagerLooper.this.startService((HashMap<String, Object>)object);
                        return;
                    }
                    object2 = this_.TraeAudioManagerLooper.this;
                    if (!((TraeAudioManagerLooper)object2)._enabled) {
                        Intent intent;
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 0, "******* disabled ,skip msg******");
                        }
                        2 v1 = this_;
                        2 this_ = intent;
                        intent = new Intent();
                        n2 = v1.TraeAudioManager.this.sendResBroadcast((Intent)this_, (HashMap<String, Object>)object, 1);
                        return;
                    }
                    switch (n3) {
                        default: {
                            return;
                        }
                        case 32791: {
                            Object object3 = object2;
                            ((TraeAudioManagerLooper)object3).requestAudioFocus(((TraeAudioManagerLooper)object3).TraeAudioManager.this._streamType);
                            return;
                        }
                        case 32790: {
                            ((TraeAudioManagerLooper)object2).abandonAudioFocus();
                            return;
                        }
                        case 32788: {
                            Integer n5 = (Integer)((HashMap)object).get(TraeAudioManager.PARAM_STREAMTYPE);
                            if (n5 == null) {
                                if (!QLog.isColorLevel()) return;
                                QLog.e("TRAE", 0, " MESSAGE_VOICECALL_AUIDOPARAM_CHANGED params.get(PARAM_STREAMTYPE)==null!!");
                                return;
                            }
                            this_.TraeAudioManager.this._streamType = n5;
                            n2 = this_.TraeAudioManagerLooper.this.InternalNotifyStreamTypeUpdate(n5);
                            return;
                        }
                        case 32787: {
                            TraeAudioManager traeAudioManager = ((TraeAudioManagerLooper)object2).TraeAudioManager.this;
                            if (traeAudioManager.InternalConnectDevice(traeAudioManager.sessionConnectedDev, null, false) == 0) return;
                            String string = (String)((HashMap)object).get(TraeAudioManager.PARAM_DEVICE);
                            if (QLog.isColorLevel()) {
                                string = " plugout dev:" + string + " sessionConnectedDev:" + this_.TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!";
                                QLog.w("TRAE", 0, string);
                            }
                            TraeAudioManager traeAudioManager2 = this_.TraeAudioManager.this;
                            n2 = traeAudioManager2.InternalConnectDevice(traeAudioManager2._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                            return;
                        }
                        case 32786: {
                            String string = (String)((HashMap)object).get(TraeAudioManager.PARAM_DEVICE);
                            if (this_.TraeAudioManager.this.InternalConnectDevice(string, null, false) == 0) return;
                            if (QLog.isColorLevel()) {
                                string = " plugin dev:" + string + " sessionConnectedDev:" + this_.TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!";
                                QLog.w("TRAE", 0, string);
                            }
                            TraeAudioManager traeAudioManager = this_.TraeAudioManager.this;
                            n2 = traeAudioManager.InternalConnectDevice(traeAudioManager._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                            return;
                        }
                        case 32785: 
                        case 32789: {
                            String string = ((TraeAudioManagerLooper)object2).TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice();
                            object2 = this_.TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
                            if (QLog.isColorLevel()) {
                                object = "MESSAGE_AUTO_DEVICELIST_UPDATE  connectedDev:" + (String)object2 + " highestDev" + string;
                                QLog.w("TRAE", 0, (String)object);
                            }
                            if (IsUpdateSceneFlag) {
                                object = this_.TraeAudioManagerLooper.this;
                                if (((TraeAudioManagerLooper)object).IsFirstConnectDeviceFlag) {
                                    ((TraeAudioManagerLooper)object).IsFirstConnectDeviceFlag = false;
                                    if (IsMusicScene) {
                                        object2 = ((TraeAudioManagerLooper)object).TraeAudioManager.this;
                                        if (!((TraeAudioManager)((Object)object2)).IsBluetoothA2dpExisted) {
                                            Object object4 = object2;
                                            n2 = ((TraeAudioManager)((Object)object4)).InternalConnectDevice(((TraeAudioManager)((Object)object4))._deviceConfigManager.getAvailabledHighestPriorityDevice(TraeAudioManager.DEVICE_BLUETOOTHHEADSET), null, true);
                                            return;
                                        }
                                    }
                                    n2 = this_.TraeAudioManager.this.InternalConnectDevice(string, null, true);
                                    return;
                                }
                            }
                            if (!string.equals(object2)) {
                                n2 = this_.TraeAudioManager.this.InternalConnectDevice(string, null, false);
                                return;
                            }
                            n2 = this_.TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                            return;
                        }
                        case 32784: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalGetStreamType((HashMap<String, Object>)object);
                            return;
                        }
                        case 32783: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalStopRing((HashMap<String, Object>)object);
                            return;
                        }
                        case 32782: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalStartRing((HashMap<String, Object>)object);
                            return;
                        }
                        case 32781: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalVoicecallPostprocess((HashMap<String, Object>)object);
                            return;
                        }
                        case 32780: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalVoicecallPreprocess((HashMap<String, Object>)object);
                            return;
                        }
                        case 32779: {
                            n2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this.InternalSessionGetConnectingDevice((HashMap<String, Object>)object);
                            return;
                        }
                        case 32778: {
                            n2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this.InternalSessionGetConnectedDevice((HashMap<String, Object>)object);
                            return;
                        }
                        case 32777: {
                            n2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this.InternalSessionIsDeviceChangabled((HashMap<String, Object>)object);
                            return;
                        }
                        case 32776: {
                            n2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this.InternalSessionEarAction((HashMap<String, Object>)object);
                            return;
                        }
                        case 32775: {
                            n2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this.InternalSessionConnectDevice((HashMap<String, Object>)object);
                            return;
                        }
                        case 32774: {
                            n2 = ((TraeAudioManagerLooper)object2).InternalSessionGetDeviceList((HashMap<String, Object>)object);
                            return;
                        }
                        case 32773: 
                    }
                    ((TraeAudioManagerLooper)object2).stopService();
                }
            };
            traeAudioManagerLooper._init();
            boolean[] blArray = traeAudioManagerLooper._started;
            TraeAudioManagerLooper traeAudioManagerLooper2 = this;
            synchronized (blArray) {
                boolean[] blArray2 = traeAudioManagerLooper2._started;
                blArray2[0] = true;
                traeAudioManagerLooper2._started.notifyAll();
                // ** MonitorExit[v0._started] (shouldn't be in output)
                Looper.loop();
                traeAudioManagerLooper._uninit();
                boolean[] blArray3 = traeAudioManagerLooper._started;
                TraeAudioManagerLooper traeAudioManagerLooper3 = this;
                synchronized (blArray3) {
                    boolean[] blArray4 = traeAudioManagerLooper3._started;
                    blArray4[0] = false;
                    traeAudioManagerLooper3._started.notifyAll();
                    // ** MonitorExit[v0._started] (shouldn't be in output)
                    AudioDeviceInterface.LogTraceExit();
                    return;
                }
            }
        }

        void _init() {
            block6: {
                IntentFilter intentFilter;
                IntentFilter intentFilter2;
                TraeAudioManagerLooper traeAudioManagerLooper = this;
                AudioDeviceInterface.LogTraceEntry("");
                traeAudioManagerLooper.TraeAudioManager.this._audioSessionHost = new TraeAudioSessionHost();
                traeAudioManagerLooper.TraeAudioManager.this._deviceConfigManager = new DeviceConfigManager();
                _gHostProcessId = Process.myPid();
                TraeAudioManager traeAudioManager = traeAudioManagerLooper.TraeAudioManager.this;
                Context context = TraeAudioManager.this._context;
                traeAudioManager._am = (AudioManager)context.getSystemService("audio");
                traeAudioManagerLooper.TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                IntentFilter intentFilter3 = intentFilter2 = intentFilter;
                TraeAudioManagerLooper traeAudioManagerLooper2 = this;
                IntentFilter intentFilter4 = intentFilter2;
                IntentFilter intentFilter5 = intentFilter4;
                IntentFilter intentFilter6 = intentFilter4;
                intentFilter4();
                intentFilter6.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter5.addAction("android.media.AUDIO_BECOMING_NOISY");
                traeAudioManagerLooper2.TraeAudioManager.this._bluetoothCheck.addAction(intentFilter2);
                try {
                    intentFilter3.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                    traeAudioManagerLooper.TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter2);
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block6;
                    QLog.w("TRAE", 0, "======7");
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void _prev_startService() {
            try {
                IntentFilter intentFilter;
                IntentFilter intentFilter2;
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                if (TraeAudioManager.this._bluetoothCheck == null) {
                    TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                }
                TraeAudioManagerLooper traeAudioManagerLooper = this;
                traeAudioManagerLooper.TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                IntentFilter intentFilter3 = intentFilter2 = intentFilter;
                intentFilter3();
                intentFilter3.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter3.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(intentFilter2);
                intentFilter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                traeAudioManagerLooper.TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter2);
                return;
            }
            catch (Exception exception) {}
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void _post_stopService() {
            try {
                IntentFilter intentFilter;
                if (TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (TraeAudioManager.this._context == null) return;
                TraeAudioManagerLooper traeAudioManagerLooper = this;
                traeAudioManagerLooper.TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                IntentFilter intentFilter2 = intentFilter;
                new IntentFilter().addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                traeAudioManagerLooper.TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter2);
                return;
            }
            catch (Exception exception) {}
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void _uninit() {
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            AudioDeviceInterface.LogTraceEntry("");
            try {
                traeAudioManagerLooper.stopService();
                if (traeAudioManagerLooper.TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (TraeAudioManager.this._context != null) {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    TraeAudioManager.this._context = null;
                }
                if (TraeAudioManager.this._deviceConfigManager != null) {
                    TraeAudioManager.this._deviceConfigManager.clearConfig();
                }
                TraeAudioManager.this._deviceConfigManager = null;
            }
            catch (Exception exception) {}
            AudioDeviceInterface.LogTraceExit();
        }

        int InternalSessionGetDeviceList(HashMap<String, Object> hashMap) {
            Intent intent;
            TraeAudioManagerLooper traeAudioManagerLooper = object2;
            Intent intent2 = intent;
            TraeAudioManagerLooper traeAudioManagerLooper2 = object2;
            Intent intent3 = intent2;
            intent2();
            HashMap<String, Object> hashMap2 = ((TraeAudioManagerLooper)object2).TraeAudioManager.this._deviceConfigManager.getSnapParams();
            Object object = object2 = hashMap2;
            Object object2 = (String)((HashMap)object).get(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE);
            String string = (String)((HashMap)object).get(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE);
            intent3.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, ((ArrayList)hashMap2.get(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST)).toArray(new String[0]));
            intent3.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, (String)object2);
            intent3.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, string);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, traeAudioManagerLooper2.TraeAudioManager.this._deviceConfigManager.getBluetoothName());
            traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast(intent2, hashMap, 0);
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @TargetApi(value=8)
        void requestAudioFocus(int n2) {
            if (Build.VERSION.SDK_INT <= 8) {
                return;
            }
            if (this.mAudioFocusChangeListener != null) return;
            this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                @TargetApi(value=8)
                public void onAudioFocusChange(int n2) {
                    if (QLog.isColorLevel()) {
                        String string = "focusChange:" + n2 + " _focusSteamType:" + string.TraeAudioManagerLooper.this._focusSteamType + " currMode:" + string.TraeAudioManager.this._am.getMode() + " _activeMode:" + string.TraeAudioManager.this._activeMode;
                        QLog.w("TRAE", 0, string);
                    }
                    if (n2 != -1 && n2 != -2) {
                    }
                }
            };
            AudioManager audioManager = TraeAudioManager.this._am;
            if (audioManager == null) return;
            try {
                int n3 = audioManager.requestAudioFocus(this.mAudioFocusChangeListener, n2, 1);
                if (n3 != 1 && QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "request audio focus fail. " + n3 + " mode:" + TraeAudioManager.this._am.getMode());
                }
                this._focusSteamType = n2;
                if (!QLog.isColorLevel()) return;
                QLog.w("TRAE", 0, "-------requestAudioFocus _focusSteamType:" + this._focusSteamType);
                return;
            }
            catch (SecurityException securityException) {
                if (!QLog.isColorLevel()) return;
                String string = "request audio focus exception. " + securityException;
                QLog.e("TRAE", 0, string);
            }
        }

        @TargetApi(value=8)
        void abandonAudioFocus() {
            if (Build.VERSION.SDK_INT <= 8) {
                return;
            }
            if (TraeAudioManager.this._am != null && this.mAudioFocusChangeListener != null) {
                if (QLog.isColorLevel()) {
                    String string = "-------abandonAudioFocus _focusSteamType:" + this._focusSteamType;
                    QLog.w("TRAE", 0, string);
                }
                TraeAudioManager.this._am.abandonAudioFocus(this.mAudioFocusChangeListener);
                this.mAudioFocusChangeListener = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        int InternalVoicecallPreprocess(HashMap<String, Object> var1_1) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (var1_1 == null) {
                return -1;
            }
            var2_2 = TraeAudioManager.this;
            if (var2_2._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " InternalVoicecallPreprocess am==null!!");
                }
                return -1;
            }
            if (var2_2._activeMode == 1) {
                v0 = this;
                this = v1;
                v1 = new Intent();
                v0.TraeAudioManager.this.sendResBroadcast((Intent)this, var1_1, 2);
                return -1;
            }
            this._voiceCallSessionID = (Long)var1_1.get("PARAM_SESSIONID");
            this._voiceCallOperation = (String)var1_1.get("PARAM_OPERATION");
            TraeAudioManager.this._activeMode = 1;
            TraeAudioManager.this._prevMode = TraeAudioManager.this._am.getMode();
            Integer.valueOf(-1);
            Integer.valueOf(0);
            var2_2 = (Integer)var1_1.get("PARAM_MODEPOLICY");
            if (var2_2 == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " params.get(PARAM_MODEPOLICY)==null!!");
                }
                TraeAudioManager.this._modePolicy = -1;
            } else {
                TraeAudioManager.this._modePolicy = var2_2.intValue();
            }
            if (QLog.isColorLevel()) {
                var2_2 = "  _modePolicy:" + TraeAudioManager.this._modePolicy;
                QLog.e("TRAE", 0, (String)var2_2);
            }
            if ((var2_2 = (Integer)var1_1.get("PARAM_STREAMTYPE")) == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " params.get(PARAM_STREAMTYPE)==null!!");
                }
                TraeAudioManager.this._streamType = 0;
            } else {
                TraeAudioManager.this._streamType = var2_2.intValue();
            }
            if (!TraeAudioManager.isCloseSystemAPM(TraeAudioManager.this._modePolicy)) ** GOTO lbl-1000
            var2_2 = TraeAudioManager.this;
            if (var2_2._activeMode != 2 && (var2_2 = var2_2._deviceConfigManager) != null) {
                if (var2_2.getConnectedDevice().equals("DEVICE_SPEAKERPHONE")) {
                    v2 = this;
                    v2.TraeAudioManager.this.InternalSetMode(0);
                    v2.requestAudioFocus(3);
                } else {
                    v3 = this;
                    v3.TraeAudioManager.this.InternalSetMode(3);
                    v3.requestAudioFocus(0);
                }
            } else lbl-1000:
            // 2 sources

            {
                v4 = this;
                v5 = v4.TraeAudioManager.this;
                v5.InternalSetMode(TraeAudioManager.getCallAudioMode(v5._modePolicy));
                v4.requestAudioFocus(v4.TraeAudioManager.this._streamType);
            }
            v6 = this;
            this = v7;
            v7 = new Intent();
            v6.TraeAudioManager.this.sendResBroadcast((Intent)this, var1_1, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalVoicecallPostprocess(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + traeAudioManagerLooper2.TraeAudioManager.this._activeMode);
            TraeAudioManager traeAudioManager = traeAudioManagerLooper2.TraeAudioManager.this;
            if (traeAudioManager._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " InternalVoicecallPostprocess am==null!!");
                }
                return -1;
            }
            if (traeAudioManager._activeMode != 1) {
                Intent intent;
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " not ACTIVE_VOICECALL!!");
                }
                TraeAudioManagerLooper traeAudioManagerLooper = traeAudioManagerLooper2;
                TraeAudioManagerLooper traeAudioManagerLooper2 = intent;
                intent = new Intent();
                traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast((Intent)traeAudioManagerLooper2, hashMap, 3);
                return -1;
            }
            traeAudioManager._activeMode = 0;
            traeAudioManagerLooper2.abandonAudioFocus();
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int interruptVoicecallPostprocess() {
            Intent intent;
            HashMap hashMap;
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + traeAudioManagerLooper2.TraeAudioManager.this._activeMode);
            Object object = traeAudioManagerLooper2.TraeAudioManager.this;
            if (((TraeAudioManager)((Object)object))._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " am==null!!");
                }
                return -1;
            }
            if (((TraeAudioManager)((Object)object))._activeMode != 1) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " not ACTIVE_RING!!");
                }
                return -1;
            }
            ((TraeAudioManager)((Object)object))._activeMode = 0;
            int n2 = ((TraeAudioManager)((Object)object))._prevMode;
            if (n2 != -1) {
                ((TraeAudioManager)((Object)object)).InternalSetMode(n2);
            }
            TraeAudioManagerLooper traeAudioManagerLooper = traeAudioManagerLooper2;
            object = hashMap;
            ((HashMap)object)();
            ((HashMap)object).put(TraeAudioManager.PARAM_SESSIONID, traeAudioManagerLooper2._voiceCallSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, traeAudioManagerLooper2._voiceCallOperation);
            TraeAudioManagerLooper traeAudioManagerLooper2 = intent;
            intent = new Intent();
            traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast((Intent)traeAudioManagerLooper2, (HashMap<String, Object>)object, 6);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStartRing(HashMap<String, Object> object) {
            Intent intent;
            int n2;
            block20: {
                AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
                TraeAudioManager traeAudioManager = TraeAudioManager.this;
                if (traeAudioManager._am == null) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 0, " InternalStartRing am==null!!");
                    }
                    return -1;
                }
                if (traeAudioManager._activeMode == 2) {
                    this.interruptRing();
                }
                try {
                    this._ringSessionID = (Long)((HashMap)object).get(TraeAudioManager.PARAM_SESSIONID);
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 0, " startRing err params");
                    }
                    return -1;
                }
                this._ringOperation = (String)((HashMap)object).get(TraeAudioManager.PARAM_OPERATION);
                this._ringUserdata = (String)((HashMap)object).get(TraeAudioManager.PARAM_RING_USERDATA_STRING);
                n2 = (Integer)((HashMap)object).get(TraeAudioManager.PARAM_RING_DATASOURCE);
                if (!QLog.isColorLevel()) break block20;
                StringBuilder stringBuilder = new StringBuilder();
                QLog.w("TRAE", 0, stringBuilder.append("  dataSource:").append(n2).toString());
            }
            HashMap<String, Object> hashMap = object;
            int n3 = (Integer)hashMap.get(TraeAudioManager.PARAM_RING_RSID);
            Uri uri = (Uri)hashMap.get(TraeAudioManager.PARAM_RING_URI);
            String string = (String)hashMap.get(TraeAudioManager.PARAM_RING_FILEPATH);
            boolean bl = (Boolean)hashMap.get(TraeAudioManager.PARAM_RING_LOOP);
            int n4 = (Integer)hashMap.get(TraeAudioManager.PARAM_RING_LOOPCOUNT);
            boolean bl2 = (Boolean)hashMap.get(TraeAudioManager.PARAM_RING_MODE);
            TraeAudioManager traeAudioManager = TraeAudioManager.this;
            if (traeAudioManager._activeMode != 1) {
                traeAudioManager._activeMode = 2;
            }
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            traeAudioManager = intent;
            traeAudioManager();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast((Intent)traeAudioManager, (HashMap<String, Object>)object, 0);
            traeAudioManagerLooper._preRingMode = traeAudioManagerLooper.TraeAudioManager.this._am.getMode();
            object = traeAudioManagerLooper._ringPlayer;
            boolean bl3 = traeAudioManagerLooper.TraeAudioManager.this._activeMode == 1;
            ((TraeMediaPlayer)object).playRing(n2, n3, uri, string, bl, n4, bl2, bl3, TraeAudioManager.this._streamType);
            if (QLog.isColorLevel()) {
                object = " _ringUserdata:" + this._ringUserdata + " DurationMS:" + this._ringPlayer.getDuration();
                QLog.w("TRAE", 0, (String)object);
            }
            if (!this._ringPlayer.hasCall()) {
                TraeAudioManagerLooper traeAudioManagerLooper2 = this;
                traeAudioManagerLooper2.requestAudioFocus(traeAudioManagerLooper2._ringPlayer.getStreamType());
            }
            TraeAudioManagerLooper traeAudioManagerLooper3 = this;
            traeAudioManagerLooper3.InternalNotifyStreamTypeUpdate(traeAudioManagerLooper3._ringPlayer.getStreamType());
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStopRing(HashMap<String, Object> hashMap) {
            TraeMediaPlayer traeMediaPlayer;
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am != null && (traeMediaPlayer = this._ringPlayer) != null) {
                Intent intent;
                traeMediaPlayer.stopRing();
                if (!this._ringPlayer.hasCall() && TraeAudioManager.this._activeMode == 2) {
                    this.abandonAudioFocus();
                    TraeAudioManager.this._activeMode = 0;
                }
                traeMediaPlayer = intent;
                traeMediaPlayer();
                intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
                TraeAudioManager.this.sendResBroadcast((Intent)traeMediaPlayer, hashMap, 0);
                AudioDeviceInterface.LogTraceExit();
                return 0;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, " InternalStopRing am==null!!");
            }
            return -1;
        }

        int InternalGetStreamType(HashMap<String, Object> hashMap) {
            Intent intent;
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + traeAudioManagerLooper2.TraeAudioManager.this._activeMode + " _preRingMode:" + traeAudioManagerLooper2._preRingMode);
            TraeAudioManager traeAudioManager = traeAudioManagerLooper2.TraeAudioManager.this;
            if (traeAudioManager._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " InternalStopRing am==null!!");
                }
                return -1;
            }
            int n2 = traeAudioManager._activeMode == 2 ? traeAudioManagerLooper2._ringPlayer.getStreamType() : traeAudioManager._streamType;
            TraeAudioManagerLooper traeAudioManagerLooper = traeAudioManagerLooper2;
            TraeAudioManagerLooper traeAudioManagerLooper2 = intent;
            new Intent().putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, n2);
            traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast((Intent)traeAudioManagerLooper2, hashMap, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalNotifyStreamTypeUpdate(final int n2) {
            if (TraeAudioManager.this._context == null) {
                return -1;
            }
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Intent intent;
                    Intent intent2;
                    Intent intent3 = intent2 = intent;
                    intent3();
                    intent3.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                    intent3.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_STREAMTYPE_UPDATE);
                    intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, this_.n2);
                    4 this_ = this_.TraeAudioManager.this._context;
                    if (this_ != null) {
                        this_.sendBroadcast(intent2);
                    }
                }
            });
            return 0;
        }

        int interruptRing() {
            Intent intent;
            HashMap hashMap;
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            Object object = TraeAudioManager.this;
            if (((TraeAudioManager)((Object)object))._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " interruptRing am==null!!");
                }
                return -1;
            }
            if (((TraeAudioManager)((Object)object))._activeMode != 2) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, " not ACTIVE_RING!!");
                }
                return -1;
            }
            TraeAudioManagerLooper traeAudioManagerLooper = this;
            traeAudioManagerLooper._ringPlayer.stopRing();
            traeAudioManagerLooper.abandonAudioFocus();
            traeAudioManagerLooper.TraeAudioManager.this._activeMode = 0;
            object = hashMap;
            ((HashMap)object)();
            ((HashMap)object).put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, this._ringOperation);
            Intent intent2 = intent;
            intent2();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            traeAudioManagerLooper.TraeAudioManager.this.sendResBroadcast(intent2, (HashMap<String, Object>)object, 4);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        void notifyRingCompletion() {
            Intent intent;
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap2();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_RING_COMPLETION);
            Intent intent2 = intent;
            intent2();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent2, hashMap2, 0);
        }
    }

    class DeviceConfigManager {
        HashMap<String, DeviceConfig> deviceConfigs = new HashMap();
        String prevConnectedDevice = "DEVICE_NONE";
        String connectedDevice = "DEVICE_NONE";
        String connectingDevice = "DEVICE_NONE";
        ReentrantLock mLock = new ReentrantLock();
        boolean visiableUpdate = false;
        String _bluetoothDevName = "unknow";

        public boolean init(String object) {
            AudioDeviceInterface.LogTraceEntry(" strConfigs:" + (String)object);
            if (object != null && object.length() > 0) {
                if ((object = object.replace("\n", "").replace("\r", "")) != null && object.length() > 0) {
                    if (object.indexOf(";") < 0) {
                        object = (String)object + ";";
                    }
                    if ((object = object.split(";")) != null && 1 <= ((String[])object).length) {
                        this.mLock.lock();
                        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                            this._addConfig(object[i2], i2);
                        }
                        DeviceConfigManager deviceConfigManager = this;
                        deviceConfigManager.mLock.unlock();
                        deviceConfigManager.TraeAudioManager.this.printDevices();
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        boolean _addConfig(String string, int n2) {
            DeviceConfig deviceConfig;
            AudioDeviceInterface.LogTraceEntry(" devName:" + string + " priority:" + n2);
            DeviceConfig deviceConfig2 = deviceConfig;
            deviceConfig2();
            if (deviceConfig.init(string, n2)) {
                if (((DeviceConfigManager)((Object)string2)).deviceConfigs.containsKey(string)) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 0, "err dev exist!");
                    }
                    return false;
                }
                ((DeviceConfigManager)((Object)string2)).deviceConfigs.put(string, deviceConfig2);
                ((DeviceConfigManager)((Object)string2)).visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    String string2 = " n" + ((DeviceConfigManager)((Object)string2)).getDeviceNumber() + " 0:" + ((DeviceConfigManager)((Object)string2)).getDeviceName(0);
                    QLog.w("TRAE", 0, string2);
                }
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, " err dev init!");
            }
            return false;
        }

        public void clearConfig() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            deviceConfigManager.deviceConfigs.clear();
            deviceConfigManager.prevConnectedDevice = TraeAudioManager.DEVICE_NONE;
            deviceConfigManager.connectedDevice = TraeAudioManager.DEVICE_NONE;
            CurConnectedDevice = TraeAudioManager.DEVICE_NONE;
            deviceConfigManager.connectingDevice = TraeAudioManager.DEVICE_NONE;
            deviceConfigManager.mLock.unlock();
        }

        public boolean getVisiableUpdateFlag() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            boolean bl = deviceConfigManager.visiableUpdate;
            this.mLock.unlock();
            return bl;
        }

        public void resetVisiableUpdateFlag() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            deviceConfigManager.visiableUpdate = false;
            deviceConfigManager.mLock.unlock();
        }

        public boolean setVisible(String charSequence, boolean bl) {
            DeviceConfigManager deviceConfigManager = this;
            int n2 = 0;
            deviceConfigManager.mLock.lock();
            Object object = deviceConfigManager.deviceConfigs.get(charSequence);
            if (object != null && ((DeviceConfig)object).getVisible() != bl) {
                ((DeviceConfig)object).setVisible(bl);
                this.visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    String string = "TRAE";
                    n2 = 0;
                    charSequence = new StringBuilder().append(" ++setVisible:").append((String)charSequence);
                    object = bl ? " Y" : " N";
                    QLog.w(string, n2, ((StringBuilder)charSequence).append((String)object).toString());
                }
                n2 = 1;
            }
            this.mLock.unlock();
            return n2 != 0;
        }

        public void setBluetoothName(String string) {
            if (string == null) {
                this._bluetoothDevName = "unknow";
                return;
            }
            this._bluetoothDevName = string.isEmpty() ? "unknow" : string;
        }

        public String getBluetoothName() {
            return this._bluetoothDevName;
        }

        public boolean getVisible(String object) {
            DeviceConfigManager deviceConfigManager = this;
            boolean bl = false;
            deviceConfigManager.mLock.lock();
            object = deviceConfigManager.deviceConfigs.get(object);
            if (object != null) {
                bl = ((DeviceConfig)object).getVisible();
            }
            this.mLock.unlock();
            return bl;
        }

        public int getPriority(String object) {
            DeviceConfigManager deviceConfigManager = this;
            int n2 = -1;
            deviceConfigManager.mLock.lock();
            object = deviceConfigManager.deviceConfigs.get(object);
            if (object != null) {
                n2 = ((DeviceConfig)object).getPriority();
            }
            this.mLock.unlock();
            return n2;
        }

        public int getDeviceNumber() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            int n2 = deviceConfigManager.deviceConfigs.size();
            this.mLock.unlock();
            return n2;
        }

        public String getDeviceName(int n2) {
            DeviceConfigManager deviceConfigManager = this;
            String string = TraeAudioManager.DEVICE_NONE;
            int n3 = 0;
            deviceConfigManager.mLock.lock();
            DeviceConfig deviceConfig = null;
            for (Map.Entry<String, DeviceConfig> entry : deviceConfigManager.deviceConfigs.entrySet()) {
                if (n3 == n2) {
                    deviceConfig = entry.getValue();
                    break;
                }
                ++n3;
            }
            if (deviceConfig != null) {
                string = deviceConfig.getDeviceName();
            }
            this.mLock.unlock();
            return string;
        }

        public String getAvailabledHighestPriorityDevice(String string) {
            DeviceConfigManager deviceConfigManager = this;
            DeviceConfig deviceConfig = null;
            deviceConfigManager.mLock.lock();
            for (Map.Entry<String, DeviceConfig> entry : deviceConfigManager.deviceConfigs.entrySet()) {
                entry.getKey();
                entry.getValue();
                DeviceConfig deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible() || deviceConfig2.getDeviceName().equals(string)) continue;
                if (deviceConfig != null && deviceConfig2.getPriority() < deviceConfig.getPriority()) {
                    deviceConfig2 = deviceConfig;
                }
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getAvailabledHighestPriorityDevice() {
            DeviceConfigManager deviceConfigManager = this;
            DeviceConfig deviceConfig = null;
            deviceConfigManager.mLock.lock();
            for (Map.Entry<String, DeviceConfig> entry : deviceConfigManager.deviceConfigs.entrySet()) {
                entry.getKey();
                entry.getValue();
                DeviceConfig deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible()) continue;
                if (deviceConfig != null && deviceConfig2.getPriority() < deviceConfig.getPriority()) {
                    deviceConfig2 = deviceConfig;
                }
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getConnectingDevice() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            String string = null;
            DeviceConfig deviceConfig = deviceConfigManager.deviceConfigs.get(this.connectingDevice);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                string = this.connectingDevice;
            }
            this.mLock.unlock();
            return string;
        }

        public String getConnectedDevice() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            String string = deviceConfigManager._getConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public String getPrevConnectedDevice() {
            DeviceConfigManager deviceConfigManager = this;
            deviceConfigManager.mLock.lock();
            String string = deviceConfigManager._getPrevConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public boolean setConnecting(String string) {
            DeviceConfigManager deviceConfigManager = this;
            boolean bl = false;
            deviceConfigManager.mLock.lock();
            DeviceConfig deviceConfig = deviceConfigManager.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                this.connectingDevice = string;
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean setConnected(String string) {
            DeviceConfigManager deviceConfigManager = this;
            boolean bl = false;
            deviceConfigManager.mLock.lock();
            DeviceConfig deviceConfig = deviceConfigManager.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                String string2 = this.connectedDevice;
                if (string2 != null && !string2.equals(string)) {
                    this.prevConnectedDevice = this.connectedDevice;
                }
                this.connectedDevice = string;
                CurConnectedDevice = string;
                this.connectingDevice = "";
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean isConnected(String string) {
            DeviceConfigManager deviceConfigManager = this;
            boolean bl = false;
            deviceConfigManager.mLock.lock();
            DeviceConfig deviceConfig = deviceConfigManager.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                bl = this.connectedDevice.equals(string);
            }
            this.mLock.unlock();
            return bl;
        }

        public HashMap<String, Object> getSnapParams() {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            DeviceConfigManager deviceConfigManager = this;
            hashMap2();
            deviceConfigManager.mLock.lock();
            hashMap2.put(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, deviceConfigManager._getAvailableDeviceList());
            hashMap2.put(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, this._getConnectedDevice());
            hashMap2.put(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, this._getPrevConnectedDevice());
            this.mLock.unlock();
            return hashMap;
        }

        public ArrayList<String> getAvailableDeviceList() {
            DeviceConfigManager deviceConfigManager = this;
            new ArrayList();
            deviceConfigManager.mLock.lock();
            ArrayList<String> arrayList = deviceConfigManager._getAvailableDeviceList();
            this.mLock.unlock();
            return arrayList;
        }

        ArrayList<String> _getAvailableDeviceList() {
            ArrayList arrayList;
            DeviceConfigManager deviceConfigManager = arrayList2;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            Iterator<Map.Entry<String, DeviceConfig>> iterator = deviceConfigManager.deviceConfigs.entrySet().iterator();
            while (iterator.hasNext()) {
                DeviceConfig deviceConfig = iterator.next().getValue();
                if (deviceConfig == null || !deviceConfig.getVisible()) continue;
                arrayList2.add(deviceConfig.getDeviceName());
            }
            return arrayList2;
        }

        String _getConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.connectedDevice);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                string = this.connectedDevice;
            }
            return string;
        }

        String _getPrevConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.prevConnectedDevice);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                string = this.prevConnectedDevice;
            }
            return string;
        }

        public class DeviceConfig {
            String deviceName = "DEVICE_NONE";
            boolean visible = false;
            int priority = 0;

            public boolean init(String string, int n2) {
                if (string != null && string.length() > 0) {
                    if (!TraeAudioManager.checkDevName(string)) {
                        return false;
                    }
                    this.deviceName = string;
                    this.priority = n2;
                    return true;
                }
                return false;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public int getPriority() {
                return this.priority;
            }

            public void setVisible(boolean bl) {
                this.visible = bl;
            }
        }
    }

    public static interface Bluetooth_State {
        public static final int UNINITIALIZED = 1;
        public static final int ERROR = 2;
        public static final int HEADSET_UNAVAILABLE = 3;
        public static final int HEADSET_AVAILABLE = 4;
        public static final int SCO_DISCONNECTING = 5;
        public static final int SCO_CONNECTING = 6;
        public static final int SCO_CONNECTED = 7;
    }

    public class Parameters {
        public static final String CONTEXT = "com.tencent.sharp.TraeAudioManager.Parameters.CONTEXT";
        public static final String MODEPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.MODEPOLICY";
        public static final String BLUETOOTHPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.BLUETOOTHPOLICY";
        public static final String DEVICECONFIG = "com.tencent.sharp.TraeAudioManager.Parameters.DEVICECONFIG";
    }
}

