/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast.audio;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.audio.ContextUtils;
import com.tencent.xcast.audio.ThreadUtils;
import com.tencent.xcast.audio.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE;
    private static int usageAttribute;
    private static volatile boolean speakerMute;
    @Nullable
    private static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    private static ErrorCallback errorCallback;
    private int _contentType;
    private int _streamType;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private byte[] emptyBytes;

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    private void setStreamType(int n2) {
        this._streamType = n2;
        if (this._streamType == 0) {
            this.setAudioTrackUsageAttribute(2);
            this._contentType = 1;
        } else {
            this._streamType = 3;
            this.setAudioTrackUsageAttribute(1);
            this._contentType = 2;
        }
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback) {
        Log.d((String)TAG, (String)"Set error callback (deprecated");
        errorCallbackOld = webRtcAudioTrackErrorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        Log.d((String)TAG, (String)"Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback;
    }

    WebRtcAudioTrack(long l2) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2._contentType = 1;
        webRtcAudioTrack2._streamType = 0;
        webRtcAudioTrack2.threadChecker = new ThreadUtils.ThreadChecker();
        webRtcAudioTrack2.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        webRtcAudioTrack.nativeAudioTrack = l2;
        webRtcAudioTrack.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initPlayout(int n2, int n3) {
        block5: {
            AudioTrack audioTrack;
            WebRtcAudioTrack webRtcAudioTrack = this;
            this.threadChecker.checkIsOnValidThread();
            Log.d((String)TAG, (String)("initPlayout(sampleRate=" + n2 + ", channels=" + n3 + ")"));
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n3 * 2 * (n2 / 100));
            Log.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            webRtcAudioTrack.nativeCacheDirectBufferAddress(webRtcAudioTrack.byteBuffer, this.nativeAudioTrack);
            n3 = this.channelCountToConfiguration(n3);
            int n4 = AudioTrack.getMinBufferSize((int)n2, (int)n3, (int)2);
            Log.d((String)TAG, (String)("AudioTrack.getMinBufferSize: " + n4));
            if (n4 < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                this.audioTrack = Build.VERSION.SDK_INT >= 21 ? this.createAudioTrackOnLollipopOrHigher(n2, n3, n4) : this.createAudioTrackOnLowerThanLollipop(n2, n3, n4);
                audioTrack = this.audioTrack;
                if (audioTrack == null) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                webRtcAudioTrack2.reportWebRtcAudioTrackInitError(string2);
                webRtcAudioTrack2.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.logMainParameters();
                webRtcAudioTrack3.logMainParametersExtended();
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    private boolean startPlayout() {
        block2: {
            WebRtcAudioTrack webRtcAudioTrack;
            WebRtcAudioTrack webRtcAudioTrack2 = this;
            webRtcAudioTrack2.threadChecker.checkIsOnValidThread();
            Log.d((String)TAG, (String)"startPlayout");
            WebRtcAudioTrack.assertTrue(webRtcAudioTrack2.audioTrack != null);
            WebRtcAudioTrack.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.audioTrack.play();
                if (webRtcAudioTrack3.audioTrack.getPlayState() == 3) break block2;
                webRtcAudioTrack = this;
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + illegalStateException.getMessage());
                webRtcAudioTrack4.releaseAudioResources();
                return false;
            }
            webRtcAudioTrack.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            webRtcAudioTrack.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)"stopPlayout");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.logUnderrunCount();
        webRtcAudioTrack2.audioThread.stopThread();
        Log.d((String)TAG, (String)"Stopping the AudioTrackThread...");
        webRtcAudioTrack2.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioTrack2.audioThread, 2000L)) {
            Log.e((String)TAG, (String)"Join of AudioTrackThread timed out.");
        }
        Log.d((String)TAG, (String)"AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    private int getStreamMaxVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)"getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int n2) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)("setStreamVolume(" + n2 + ")"));
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        if (this.isVolumeFixed()) {
            Log.e((String)TAG, (String)"The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n2, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)"getStreamVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Log.d((String)TAG, (String)("AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume()));
    }

    @TargetApi(value=21)
    private AudioTrack createAudioTrackOnLollipopOrHigher(int n2, int n3, int n4) {
        Log.d((String)TAG, (String)"createAudioTrackOnLollipopOrHigher");
        int n5 = AudioTrack.getNativeOutputSampleRate((int)0);
        Log.d((String)TAG, (String)("nativeOutputSampleRate: " + n5));
        if (n2 != n5) {
            Log.w((String)TAG, (String)"Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Log.w((String)TAG, (String)("A non default usage attribute is used: " + usageAttribute));
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(this._contentType).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n2).setChannelMask(n3).build(), n4, 1, 0);
    }

    private AudioTrack createAudioTrackOnLowerThanLollipop(int n2, int n3, int n4) {
        return new AudioTrack(this._streamType, n2, n3, 2, n4, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Log.d((String)TAG, (String)("AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames()));
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Log.d((String)TAG, (String)("AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames()));
        }
    }

    private void logMainParametersExtended() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logBufferSizeInFrames();
        webRtcAudioTrack.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Log.d((String)TAG, (String)("underrun count: " + this.audioTrack.getUnderrunCount()));
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n2) {
        return n2 == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean bl) {
        Log.w((String)TAG, (String)("setSpeakerMute(" + bl + ")"));
        speakerMute = bl;
    }

    private void releaseAudioResources() {
        Log.d((String)TAG, (String)"releaseAudioResources");
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string2) {
        Log.e((String)TAG, (String)("Init playout error: " + string2));
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackInitError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackInitError(string2);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode audioTrackStartErrorCode, String string2) {
        Log.e((String)TAG, (String)("Start playout error: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string2));
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackStartError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackStartError(audioTrackStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioTrackError(String string2) {
        Log.e((String)TAG, (String)("Run-time playback error: " + string2));
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackError(string2);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackError(string2);
        }
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    }

    public void setAudioTrackUsageAttribute(int n2) {
        Log.w((String)TAG, (String)("Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + n2));
        usageAttribute = n2;
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int n2) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, n2, 0);
            }
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Log.d((String)WebRtcAudioTrack.TAG, (String)("AudioTrackThread" + WebRtcAudioUtils.getThreadInfo()));
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n2 = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                AudioTrackThread audioTrackThread = this;
                WebRtcAudioTrack webRtcAudioTrack = audioTrackThread.WebRtcAudioTrack.this;
                webRtcAudioTrack.nativeGetPlayoutData(n2, webRtcAudioTrack.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n2 <= audioTrackThread.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    AudioTrackThread audioTrackThread2 = this;
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread3 = this;
                int n3 = audioTrackThread3.writeBytes(audioTrackThread3.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n2);
                if (n3 != n2) {
                    Log.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.write played invalid number of bytes: " + n3));
                    if (n3 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n3);
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Log.d((String)WebRtcAudioTrack.TAG, (String)"Calling AudioTrack.stop...");
                WebRtcAudioTrack.this.audioTrack.stop();
                try {
                    Log.d((String)WebRtcAudioTrack.TAG, (String)"AudioTrack.stop is done.");
                }
                catch (IllegalStateException illegalStateException) {
                    Log.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.stop failed: " + illegalStateException.getMessage()));
                }
            }
        }

        public void stopThread() {
            Log.d((String)WebRtcAudioTrack.TAG, (String)"stopThread");
            this.keepAlive = false;
        }
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

