/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.WorkerThread;
import android.util.Size;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.AppLifecycle;
import com.tencent.xcast.SurfaceTextureHolder;
import com.tencent.xcast.VideoCapture;
import com.tencent.xcast.VideoCaptureContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class VideoCapture2
implements ImageReader.OnImageAvailableListener,
AppLifecycle.LifecycleObserver,
VideoCaptureContext.CaptureThreadCallback {
    private static final String TAG = "VideoCapture2";
    private static final int MSG_CONFIG_CAMERA = 2;
    private static final int CAPTURE_BUFFER_COUNT = 3;
    private Context mContext;
    private long mNativeCapture;
    private VideoCaptureContext mCaptureCtx;
    private String mCameraId;
    private CaptureStateCallback mStateCallback;
    private CameraDevice mCamera;
    private CameraCaptureSession mCaptureSession;
    private SessionCaptureCallback mSessionCaptureCallback;
    private List<SessionStateCallback> mSessionStateCallbacks;
    private int mSessionIndex;
    private final boolean mUseSurfaceTexture;
    private ImageReader mImageReader = null;
    private SurfaceTextureHolder mCaptureTextureHolder = null;
    private CameraManager mCameraMgr;
    private CameraCharacteristics mCharacteristics;
    private StreamConfigurationMap mConfigurationMap;
    private boolean mAsyncSuccess = false;
    private int mWidth;
    private int mHeight;
    private int mFps;
    private int mOptimalWidth;
    private int mOptimalHeight;
    private int mFacing;
    private int mSensorOrientation;
    private Integer mPreviewFormat;
    private int mFrameCount;
    private long mLastFrameElapsedTimeMs;
    private double mAvgFrameDurationMs;
    private AppLifecycle mAppLifecycle;
    private boolean mPaused;

    private static String cameraErrorToString(int n2) {
        switch (n2) {
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return String.format(Locale.CHINA, "%d", n2);
    }

    private static boolean isSupportCamera2(Context context) {
        boolean bl = false;
        try {
            CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
            if (cameraManager == null) {
                return false;
            }
            String[] stringArray = cameraManager.getCameraIdList();
            if (stringArray.length == 0) {
                return false;
            }
            for (String string : stringArray) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (n2 == null || n2 == 2) {
                    bl = false;
                } else {
                    StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    if (streamConfigurationMap == null) continue;
                    Integer n3 = VideoCapture2.getSupportedPreviewFormat(streamConfigurationMap);
                    if (n3 != null) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                break;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
            bl = false;
        }
        return false;
    }

    public static void getCameraInfos(Context context, long l2) {
        try {
            String[] stringArray;
            CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
            if (cameraManager == null) {
                return;
            }
            for (String string : stringArray = cameraManager.getCameraIdList()) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                Integer n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                VideoCapture2.onCaptureEnum(l2, string, n2 != null ? n2 : 1);
            }
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    @WorkerThread
    public void onImageAvailable(ImageReader imageReader) {
        if (imageReader != this.mImageReader) {
            return;
        }
        Image image = imageReader.acquireLatestImage();
        if (image != null) {
            ++this.mFrameCount;
            long l2 = SystemClock.elapsedRealtime();
            if (this.mFrameCount > 0) {
                double d2 = l2 - this.mLastFrameElapsedTimeMs;
                this.mAvgFrameDurationMs = 0.9 * this.mAvgFrameDurationMs + 0.1 * d2;
                if (this.mFrameCount % 30 == 0) {
                    Platform.logDebug(String.format(Locale.CHINA, "Camera TS %dms, Duration %dms, FPS %d", l2, (int)d2, (int)(1000.0 / this.mAvgFrameDurationMs + 0.5)));
                }
            }
            this.mLastFrameElapsedTimeMs = l2;
            Image.Plane[] planeArray = image.getPlanes();
            Image.Plane plane = planeArray[0];
            ByteBuffer byteBuffer = plane.getBuffer();
            ByteBuffer byteBuffer2 = null;
            ByteBuffer byteBuffer3 = null;
            int n2 = plane.getPixelStride();
            int n3 = 0;
            int n4 = 0;
            int n5 = plane.getRowStride();
            int n6 = 0;
            int n7 = 0;
            if (planeArray.length >= 2) {
                Image.Plane plane2 = planeArray[1];
                byteBuffer2 = plane2.getBuffer();
                n3 = plane2.getPixelStride();
                n6 = plane2.getRowStride();
            }
            if (planeArray.length >= 3) {
                Image.Plane plane3 = planeArray[2];
                byteBuffer3 = plane3.getBuffer();
                n4 = plane3.getPixelStride();
                n7 = plane3.getRowStride();
            }
            VideoCapture2.onCaptureFrame2(this.mNativeCapture, byteBuffer, n2, n5, byteBuffer2, n3, n6, byteBuffer3, n4, n7, image.getWidth(), image.getHeight(), this.getRotate(), image.getFormat());
            image.close();
        }
    }

    private static Integer getSupportedPreviewFormat(StreamConfigurationMap streamConfigurationMap) {
        int[] nArray = streamConfigurationMap.getOutputFormats();
        Platform.logInfo("support formats:" + Arrays.asList(new int[][]{nArray}).toString());
        if (streamConfigurationMap.isOutputSupportedFor(35)) {
            return 35;
        }
        if (streamConfigurationMap.isOutputSupportedFor(17)) {
            return 17;
        }
        if (streamConfigurationMap.isOutputSupportedFor(842094169)) {
            return 842094169;
        }
        return null;
    }

    private Size getOptimalPreviewSize(StreamConfigurationMap streamConfigurationMap, int n2, int n3, int n4) {
        Size size = null;
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(n4);
        Arrays.sort(sizeArray, new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                return size.getWidth() - size2.getWidth();
            }
        });
        Size[] sizeArray2 = sizeArray;
        int n5 = sizeArray2.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            Size size2;
            size = size2 = sizeArray2[i2];
            if (size2.getWidth() >= n2 && size2.getHeight() >= n3) break;
        }
        if (size == null) {
            size = new Size(n2, n3);
        }
        Platform.log(4, String.format(Locale.CHINA, "size: %dx%d, best match: %dx%d", n2, n3, size.getWidth(), size.getHeight()));
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onCaptureThreadCallback(VideoCaptureContext videoCaptureContext, Object object) {
        if (object instanceof VideoCapture.Params) {
            VideoCapture.Params params = (VideoCapture.Params)object;
            if (params.what == 2) {
                boolean bl = this.configOnCameraThread(params.w, params.h, params.f);
                VideoCapture2 videoCapture2 = this;
                synchronized (videoCapture2) {
                    this.mAsyncSuccess = bl;
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onAppBackgrounded() {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            if (this.mCamera == null) {
                Platform.logInfo("camera is not open");
                return;
            }
            if (this.mCaptureSession == null) {
                Platform.logInfo("camera is not running");
            } else if (!this.mPaused) {
                this.closeCaptureSession();
                this.mPaused = true;
                Platform.logInfo("pause camera");
            } else {
                Platform.logInfo("camera is already paused");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onAppForegrounded() {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            if (this.mCamera == null) {
                Platform.logInfo("camera is not open");
                return;
            }
            if (this.mCaptureSession != null) {
                Platform.logInfo("camera is running");
            } else if (this.mPaused) {
                boolean bl = this.createCaptureSession(this.mOptimalWidth, this.mOptimalHeight);
                this.mPaused = false;
                Platform.logInfo("resume camera " + bl);
            } else {
                Platform.logInfo("camera is not running");
            }
        }
    }

    private VideoCapture2(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativeCapture = l2;
        this.mUseSurfaceTexture = bl;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean startCaptureInternal() {
        try {
            if (this.mStateCallback == null) {
                this.mStateCallback = new CaptureStateCallback();
            }
            this.mCameraMgr.openCamera(this.mCameraId, (CameraDevice.StateCallback)this.mStateCallback, this.mCaptureCtx.getHandler());
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        return true;
    }

    private void stopCaptureInternal() {
        if (this.mCaptureSession != null) {
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        if (this.mCamera != null) {
            this.mCamera.close();
            this.mCamera = null;
        }
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mSessionStateCallbacks != null) {
            this.mSessionStateCallbacks.clear();
            this.mSessionStateCallbacks = null;
        }
        this.mCameraMgr = null;
        this.mCharacteristics = null;
        this.mConfigurationMap = null;
    }

    private void closeCaptureSession() {
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.abortCaptures();
                this.mCaptureSession.close();
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            this.mCaptureSession = null;
        }
    }

    @WorkerThread
    private boolean createCaptureSession(int n2, int n3) {
        try {
            this.closeCaptureSession();
            ArrayList<Surface> arrayList = new ArrayList<Surface>();
            if (this.mUseSurfaceTexture) {
                if (this.mCaptureTextureHolder != null) {
                    this.mCaptureTextureHolder.release();
                }
                this.mCaptureTextureHolder = new SurfaceTextureHolder(n2, n3, new SurfaceTextureHolder.EventCallback(){

                    @Override
                    public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
                        VideoCapture2.onCaptureFrameSurface(VideoCapture2.this.mNativeCapture, surfaceTextureHolder, VideoCapture2.this.mOptimalWidth, VideoCapture2.this.mOptimalHeight, VideoCapture2.this.getRotate());
                    }

                    @Override
                    public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
                    }
                }, new SurfaceTextureHolder.HandlerDestructorRunner(this.mCaptureCtx.getHandler()));
                arrayList.add(this.mCaptureTextureHolder.getSurface());
            } else {
                if (this.mImageReader != null) {
                    this.mImageReader.setOnImageAvailableListener(null, null);
                    this.mImageReader.close();
                }
                this.mImageReader = ImageReader.newInstance((int)n2, (int)n3, (int)this.mPreviewFormat, (int)3);
                this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.mCaptureCtx.getHandler());
                arrayList.add(this.mImageReader.getSurface());
            }
            SessionStateCallback sessionStateCallback = new SessionStateCallback(this.mSessionIndex++);
            this.mSessionStateCallbacks.add(sessionStateCallback);
            this.mCamera.createCaptureSession(arrayList, (CameraCaptureSession.StateCallback)sessionStateCallback, this.mCaptureCtx.getHandler());
        }
        catch (CameraAccessException | IllegalArgumentException throwable) {
            Platform.logError(throwable.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean configOnCameraThread(int n2, int n3, int n4) {
        VideoCapture2 videoCapture2 = this;
        synchronized (videoCapture2) {
            if (this.mCamera != null && (this.mWidth != n2 || this.mHeight != n3)) {
                Size size = this.getOptimalPreviewSize(this.mConfigurationMap, n2, n3, this.mPreviewFormat);
                if (this.mOptimalWidth != size.getWidth() || this.mOptimalHeight != size.getHeight()) {
                    this.mOptimalWidth = size.getWidth();
                    this.mOptimalHeight = size.getHeight();
                    this.mFps = n4;
                    return this.createCaptureSession(this.mOptimalWidth, this.mOptimalHeight);
                }
            } else {
                this.mWidth = n2;
                this.mHeight = n3;
                this.mFps = n4;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(String string) {
        if (string == null || string.length() == 0) {
            Platform.logError("camera.id.null");
            return false;
        }
        Object object = VideoCapture.sLock;
        synchronized (object) {
            boolean bl = false;
            VideoCapture2 videoCapture2 = this;
            synchronized (videoCapture2) {
                if (this.mCameraMgr == null) {
                    this.mCameraMgr = (CameraManager)this.mContext.getSystemService("camera");
                    if (this.mCameraMgr != null) {
                        try {
                            this.mCharacteristics = this.mCameraMgr.getCameraCharacteristics(string);
                            this.mConfigurationMap = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                            Integer n2 = (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
                            this.mFacing = n2 != null ? n2 : 1;
                            this.mPreviewFormat = VideoCapture2.getSupportedPreviewFormat(this.mConfigurationMap);
                            Integer n3 = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                            this.mSensorOrientation = n3 != null ? n3 : 0;
                        }
                        catch (CameraAccessException cameraAccessException) {
                            Platform.logInfo(cameraAccessException.toString());
                            this.mCharacteristics = null;
                            this.mConfigurationMap = null;
                            this.mPreviewFormat = null;
                        }
                    }
                }
                if (this.mCameraMgr != null && this.mCharacteristics != null && this.mConfigurationMap != null && this.mPreviewFormat != null) {
                    this.mSessionStateCallbacks = new ArrayList<SessionStateCallback>();
                    this.mCameraId = string;
                    if (this.mCaptureCtx == null) {
                        this.mCaptureCtx = VideoCaptureContext.create(this.mContext);
                    }
                    if (this.mAppLifecycle == null) {
                        this.mAppLifecycle = AppLifecycle.create(this.mContext, this.mCaptureCtx.getHandler());
                        this.mAppLifecycle.addObserver(this);
                    }
                    this.mFrameCount = 0;
                    this.mAvgFrameDurationMs = 33.33333206176758;
                    bl = this.startCaptureInternal();
                }
                if (bl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Platform.logError(interruptedException.toString());
                    }
                    bl = this.mAsyncSuccess;
                    this.mAsyncSuccess = false;
                }
                if (!bl) {
                    this.stopCaptureInternal();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop() {
        Object object = VideoCapture.sLock;
        synchronized (object) {
            if (this.mAppLifecycle != null) {
                this.mAppLifecycle.destroy();
                this.mAppLifecycle = null;
            }
            VideoCapture2 videoCapture2 = this;
            synchronized (videoCapture2) {
                this.stopCaptureInternal();
                if (this.mCaptureTextureHolder != null) {
                    this.mCaptureTextureHolder.release();
                    this.mCaptureTextureHolder = null;
                }
            }
            this.mCaptureCtx.destroy();
            this.mCaptureCtx = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean config(int n2, int n3, int n4) {
        Object object = VideoCapture.sLock;
        synchronized (object) {
            VideoCapture2 videoCapture2 = this;
            synchronized (videoCapture2) {
                if (this.mCaptureCtx != null && this.mCamera != null) {
                    VideoCapture.Params params = new VideoCapture.Params();
                    params.what = 2;
                    params.w = n2;
                    params.h = n3;
                    params.f = n4;
                    boolean bl = this.mCaptureCtx.runOnCaptureThread(this, params, false);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Platform.logError(interruptedException.toString());
                    }
                    if (bl) {
                        bl = this.mAsyncSuccess;
                        this.mAsyncSuccess = false;
                    }
                    return bl;
                }
                this.mWidth = n2;
                this.mHeight = n3;
                this.mFps = n4;
            }
            return true;
        }
    }

    private int getRotate() {
        int n2 = this.mCaptureCtx.isDeviceAutoRotate() ? this.mCaptureCtx.getDeviceOrientation() : 0;
        int n3 = this.mFacing == 0 ? this.mSensorOrientation % 360 : (this.mSensorOrientation - n2 + 360) % 360;
        return n3 / 90;
    }

    private static native void onCaptureEnum(long var0, String var2, int var3);

    private static native void onCaptureFrame(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureFrame2(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5);

    private class CaptureStateCallback
    extends CameraDevice.StateCallback {
        private CaptureStateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onOpened(@NonNull CameraDevice cameraDevice) {
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                VideoCapture2.this.mCamera = cameraDevice;
                Size size = VideoCapture2.this.getOptimalPreviewSize(VideoCapture2.this.mConfigurationMap, VideoCapture2.this.mWidth, VideoCapture2.this.mHeight, VideoCapture2.this.mPreviewFormat);
                VideoCapture2.this.mOptimalWidth = size.getWidth();
                VideoCapture2.this.mOptimalHeight = size.getHeight();
                VideoCapture2.this.createCaptureSession(VideoCapture2.this.mOptimalWidth, VideoCapture2.this.mOptimalHeight);
            }
            if (Platform.isDebugBuild) {
                Platform.logInfo(String.format(Locale.CHINA, "onOpened.cam.%h", cameraDevice));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                cameraDevice.close();
                VideoCapture2.this.mCamera = null;
                VideoCapture2.this.mAsyncSuccess = false;
                VideoCapture2.this.notify();
            }
            if (Platform.isDebugBuild) {
                Platform.logInfo("onDisconnected");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onError(@NonNull CameraDevice cameraDevice, int n2) {
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                cameraDevice.close();
                VideoCapture2.this.mCamera = null;
                VideoCapture2.this.mAsyncSuccess = false;
                VideoCapture2.this.notify();
            }
            Platform.logInfo(String.format(Locale.CHINA, "onError: %s", VideoCapture2.cameraErrorToString(n2)));
        }

        @WorkerThread
        public void onClosed(@NonNull CameraDevice cameraDevice) {
            Platform.logInfo("onClosed ");
        }
    }

    private class SessionStateCallback
    extends CameraCaptureSession.StateCallback {
        int mIndex;

        SessionStateCallback(int n2) {
            this.mIndex = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
            Platform.logInfo("onConfigured");
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                if (VideoCapture2.this.mCamera == null) {
                    Platform.logInfo("mCamera.null");
                    return;
                }
                if (VideoCapture2.this.mSessionStateCallbacks == null) {
                    return;
                }
                VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                if (!VideoCapture2.this.mSessionStateCallbacks.isEmpty()) {
                    return;
                }
                VideoCapture2.this.mCaptureSession = cameraCaptureSession;
                try {
                    CaptureRequest.Builder builder = VideoCapture2.this.mCamera.createCaptureRequest(1);
                    if (VideoCapture2.this.mUseSurfaceTexture) {
                        builder.addTarget(VideoCapture2.this.mCaptureTextureHolder.getSurface());
                    } else {
                        builder.addTarget(VideoCapture2.this.mImageReader.getSurface());
                    }
                    builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                    CaptureRequest captureRequest = builder.build();
                    if (VideoCapture2.this.mSessionCaptureCallback == null) {
                        VideoCapture2.this.mSessionCaptureCallback = new SessionCaptureCallback();
                    }
                    VideoCapture2.this.mCaptureSession.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)VideoCapture2.this.mSessionCaptureCallback, VideoCapture2.this.mCaptureCtx.getHandler());
                    VideoCapture2.this.mAsyncSuccess = true;
                }
                catch (CameraAccessException cameraAccessException) {
                    cameraAccessException.printStackTrace();
                    VideoCapture2.this.mAsyncSuccess = false;
                }
                VideoCapture2.this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
            Platform.logInfo("onConfigureFailed");
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                if (VideoCapture2.this.mSessionStateCallbacks == null) {
                    return;
                }
                VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                if (!VideoCapture2.this.mSessionStateCallbacks.isEmpty()) {
                    return;
                }
                VideoCapture2.this.notify();
                VideoCapture2.this.mAsyncSuccess = false;
            }
        }

        @WorkerThread
        public void onReady(@NonNull CameraCaptureSession cameraCaptureSession) {
            Platform.logInfo("onReady");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onClosed(@NonNull CameraCaptureSession cameraCaptureSession) {
            VideoCapture2 videoCapture2 = VideoCapture2.this;
            synchronized (videoCapture2) {
                if (VideoCapture2.this.mSessionStateCallbacks != null) {
                    VideoCapture2.this.mSessionStateCallbacks.remove((Object)this);
                }
            }
        }
    }

    private class SessionCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private SessionCaptureCallback() {
        }

        @WorkerThread
        public void onCaptureStarted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, long l2, long l3) {
            super.onCaptureStarted(cameraCaptureSession, captureRequest, l2, l3);
        }

        @WorkerThread
        public void onCaptureProgressed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureResult captureResult) {
        }

        @WorkerThread
        public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
        }
    }
}

