/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.AppLifecycle;
import com.tencent.xcast.SurfaceTextureHolder;
import com.tencent.xcast.VideoCaptureContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class VideoCapture
implements AppLifecycle.LifecycleObserver,
VideoCaptureContext.CaptureThreadCallback {
    private static final int MSG_OPEN_CAMERA = 1;
    private static final int MSG_CONFIG_CAMERA = 2;
    private static final int MSG_STOP_CAMERA = 3;
    static final Object sLock = new Object();
    private Context mContext;
    private long mNativeCapture;
    private VideoCaptureContext mCaptureCtx;
    private int mCameraId;
    private Camera mCamera;
    private CapturePreviewCallback mPreviewCallback;
    private final Object mLock = new Object();
    private Camera.CameraInfo mCameraInfo;
    private int mWidth;
    private int mHeight;
    private int mFps;
    private int mPreviewFormat;
    private final int mNumCaptureBuffers = 3;
    private List<byte[]> mCaptureBuffers;
    private int mFrameCount;
    private long mLastFrameElapsedTimeMs;
    private double mAvgFrameDurationMs;
    private AppLifecycle mAppLifecycle;
    private boolean mPaused;
    private volatile boolean mStop;
    private SurfaceTextureHolder mCaptureTextureHolder;
    private final boolean mUseSurfaceTexture;
    private int mAsyncResult = -1;
    private long mStartTs;
    private long mStartPreviewTs;

    public static void getCameraInfos(Context context, long l2) {
        int n2 = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                Camera.getCameraInfo((int)i2, (Camera.CameraInfo)cameraInfo);
                VideoCapture.onCaptureEnum(l2, String.valueOf(i2), cameraInfo.facing);
                continue;
            }
            catch (Exception exception) {
                Platform.logError(String.format(Locale.CHINA, "fail to get camera info %d", i2));
            }
        }
    }

    @Override
    @WorkerThread
    public void onCaptureThreadCallback(VideoCaptureContext videoCaptureContext, Object object) {
        Params params = (Params)object;
        switch (params.what) {
            case 1: {
                this.mAsyncResult = this.startOnCaptureThread();
                break;
            }
            case 3: {
                this.stopOnCaptureThread(videoCaptureContext);
                break;
            }
            case 2: {
                this.mAsyncResult = this.configOnCameraThread(params.w, params.h, params.f);
            }
        }
    }

    @Override
    @WorkerThread
    public void onAppBackgrounded() {
        if (this.mCamera == null) {
            Platform.logInfo("onAppBackgrounded camera is not running");
        } else if (!this.mPaused) {
            this.stopCaptureInternal();
            this.mPaused = true;
            Platform.logInfo("onAppBackgrounded pause camera");
        } else {
            Platform.logInfo("onAppBackgrounded camera is already paused");
        }
    }

    @Override
    @WorkerThread
    public void onAppForegrounded() {
        if (this.mCamera != null) {
            Platform.logInfo("onAppForegrounded camera is running");
        } else if (this.mPaused) {
            int n2 = this.startCaptureInternal();
            this.mPaused = false;
            Platform.logInfo(String.format(Locale.CHINA, "onAppForegrounded resume camera %d", n2));
        } else {
            Platform.logInfo("onAppForegrounded camera is not running");
        }
    }

    private void onPreviewFrame(byte[] byArray, Camera camera) {
        long l2;
        if (this.mUseSurfaceTexture) {
            return;
        }
        if (this.mStop) {
            if (Platform.isDebugLevel()) {
                Platform.logDebug(String.format(Locale.CHINA, "fast stop return %d", byArray.length));
            }
            return;
        }
        if (!this.mCaptureCtx.isCaptureThread()) {
            throw new RuntimeException("Camera callback not on camera thread");
        }
        if (byArray == null) {
            Platform.logInfo("no enough buffer.");
            int n2 = this.getBufferSize(this.mPreviewFormat, this.mWidth, this.mHeight);
            byte[] byArray2 = new byte[n2];
            for (int i2 = this.mCaptureBuffers.size() - 1; i2 >= 0; --i2) {
                if (this.mCaptureBuffers.get(i2).length >= n2) continue;
                this.mCaptureBuffers.remove(i2);
            }
            camera.addCallbackBuffer(byArray2);
            return;
        }
        if (camera == null) {
            return;
        }
        if (camera != this.mCamera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        if (this.mFrameCount == 0) {
            l2 = SystemClock.elapsedRealtime() - this.mStartPreviewTs;
            Platform.logInfo(String.format(Locale.CHINA, "capture %s first frame cost %dms", this.mCameraId, l2));
        }
        ++this.mFrameCount;
        l2 = SystemClock.elapsedRealtime();
        if (this.mFrameCount > 0) {
            double d2 = l2 - this.mLastFrameElapsedTimeMs;
            this.mAvgFrameDurationMs = 0.9 * this.mAvgFrameDurationMs + 0.1 * d2;
            if (this.mFrameCount % 100 == 0) {
                Platform.logDebug(String.format(Locale.CHINA, "Camera TS %dms,Duration: %dms,FPS: %d", l2, (int)d2, (int)(1000.0 / this.mAvgFrameDurationMs + 0.5)));
            }
        }
        this.mLastFrameElapsedTimeMs = l2;
        VideoCapture.onCaptureFrame(this.mNativeCapture, byArray, byArray.length, this.mWidth, this.mHeight, this.getRotate(), this.mPreviewFormat);
        this.mCamera.addCallbackBuffer(byArray);
    }

    private VideoCapture(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativeCapture = l2;
        this.mUseSurfaceTexture = bl;
    }

    private Camera.Size getOptimalPreviewSize(Camera.Parameters parameters, int n2, int n3) {
        Camera.Size size = null;
        List list = parameters.getSupportedPreviewSizes();
        Collections.sort(list, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size size, Camera.Size size2) {
                return size.width - size2.width;
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Camera.Size size2;
            size = size2 = (Camera.Size)iterator.next();
            if (size2.width < n2 || size2.height < n3) continue;
            break;
        }
        int n4 = size != null ? size.width : 0;
        int n5 = size != null ? size.height : 0;
        Platform.logInfo(String.format(Locale.CHINA, "size: %dx%d, best match: %dx%d", n2, n3, n4, n5));
        return size;
    }

    private int getOptimalFpsRate(Camera.Parameters parameters, int n2) {
        int n3 = n2;
        List list = parameters.getSupportedPreviewFrameRates();
        if (list != null) {
            Collections.sort(list);
            for (Integer n4 : list) {
                n3 = n4;
                if (n4 < n2) continue;
                break;
            }
        }
        Platform.logInfo(String.format(Locale.CHINA, "expectFps: %d, optimalFps: %d", n2, n3));
        return n3;
    }

    private List<byte[]> genCaptureBuffers(List<byte[]> list, int n2) {
        if (list == null) {
            list = new ArrayList<byte[]>(3);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (i2 < list.size()) {
                byte[] byArray = list.get(i2);
                if (n2 <= byArray.length) continue;
                list.set(i2, new byte[n2]);
                continue;
            }
            list.add(new byte[n2]);
        }
        return list;
    }

    private void updateCameraParameters(Camera camera, Camera.Parameters parameters) {
        Object object2;
        int n2 = 17;
        List list = parameters.getSupportedPreviewFormats();
        Platform.logInfo(Arrays.toString(list.toArray()));
        if (!list.contains(17)) {
            for (Object object2 : list) {
                if ((Integer)object2 != 842094169) continue;
                n2 = (Integer)object2;
                break;
            }
        }
        parameters.setPreviewFormat(n2);
        this.mPreviewFormat = parameters.getPreviewFormat();
        Camera.Size size = this.getOptimalPreviewSize(parameters, this.mWidth, this.mHeight);
        parameters.setPreviewSize(size.width, size.height);
        this.mWidth = size.width;
        this.mHeight = size.height;
        Platform.logInfo(String.format(Locale.CHINA, "isVideoStabilizationSupported: %b", parameters.isVideoStabilizationSupported()));
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (-1 != (object2 = parameters.getSupportedFocusModes()).indexOf("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        int n3 = this.getOptimalFpsRate(parameters, this.mFps);
        parameters.setPreviewFrameRate(n3);
        this.mFps = parameters.getPreviewFrameRate();
        camera.setParameters(parameters);
    }

    private int getBufferSize(int n2, int n3, int n4) {
        if (n2 == 842094169) {
            int n5 = (int)Math.ceil((double)n3 / 16.0) << 4;
            int n6 = (int)Math.ceil((double)(n5 >> 1) / 16.0) << 4;
            int n7 = n5 * n4;
            int n8 = n6 * n4 / 2;
            return n7 + n8 << 1;
        }
        return n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private int startCaptureInternal() {
        Camera.Parameters parameters = null;
        int n2 = -1;
        long l2 = SystemClock.elapsedRealtime();
        assert (this.mCamera == null);
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (RuntimeException runtimeException) {
            Platform.logError(Platform.getTrace(runtimeException));
            return n2;
        }
        if (this.mCamera == null) {
            Platform.logError(String.format(Locale.CHINA, "Camera.open returned null for camera %s", this.mCameraId));
            return n2;
        }
        if (this.mCaptureTextureHolder != null) {
            this.mCaptureTextureHolder.release();
        }
        try {
            this.mCaptureTextureHolder = new SurfaceTextureHolder(this.mWidth, this.mHeight, new SurfaceTextureHolder.EventCallback(){

                @Override
                public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
                    if (VideoCapture.this.mUseSurfaceTexture) {
                        VideoCapture.onCaptureFrameSurface(VideoCapture.this.mNativeCapture, surfaceTextureHolder, VideoCapture.this.mWidth, VideoCapture.this.mHeight, VideoCapture.this.getRotate());
                    }
                }

                @Override
                public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
                }
            }, new SurfaceTextureHolder.HandlerDestructorRunner(this.mCaptureCtx.getHandler()));
            this.mCamera.setPreviewTexture(this.mCaptureTextureHolder.getSurfaceTexture());
        }
        catch (IOException | RuntimeException exception) {
            Platform.logError(Platform.getTrace(exception));
            this.mCamera.release();
            this.mCamera = null;
            if (this.mCaptureTextureHolder != null) {
                this.mCaptureTextureHolder.release();
            }
            return n2;
        }
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Platform.logError(Platform.getTrace(runtimeException));
        }
        if (parameters == null) {
            Platform.logError(String.format(Locale.CHINA, "Camera.getParameters returned null for camera %s", this.mCameraId));
            this.mCamera.release();
            this.mCamera = null;
            if (this.mCaptureTextureHolder != null) {
                this.mCaptureTextureHolder.release();
            }
            return n2;
        }
        try {
            this.updateCameraParameters(this.mCamera, parameters);
        }
        catch (RuntimeException runtimeException) {
            Platform.logError(Platform.getTrace(runtimeException));
            Camera.Size size = parameters.getPreviewSize();
            this.mWidth = size.width;
            this.mHeight = size.height;
            this.mPreviewFormat = parameters.getPreviewFormat();
            this.mFps = parameters.getPreviewFrameRate();
        }
        int n3 = this.getBufferSize(this.mPreviewFormat, this.mWidth, this.mHeight);
        this.mCaptureBuffers = this.genCaptureBuffers(this.mCaptureBuffers, n3);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.mCamera.addCallbackBuffer(this.mCaptureBuffers.get(i2));
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPreviewCallback != null) {
                this.mPreviewCallback.clear();
            }
            this.mPreviewCallback = new CapturePreviewCallback(this);
        }
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.mPreviewCallback);
        try {
            this.mCamera.startPreview();
            n2 = 0;
            this.mFrameCount = 0;
            this.mAvgFrameDurationMs = 1000.0f / (float)this.mFps;
            this.mStartPreviewTs = SystemClock.elapsedRealtime();
        }
        catch (RuntimeException runtimeException) {
            Platform.logError(Platform.getTrace(runtimeException));
            this.stopCaptureInternal();
        }
        Platform.logInfo(String.format(Locale.CHINA, "%h start done %d spend %dms", this, n2, SystemClock.elapsedRealtime() - l2));
        return n2;
    }

    private void stopCaptureInternal() {
        long l2 = SystemClock.elapsedRealtime();
        Platform.logInfo("stop capture");
        if (this.mCamera != null) {
            Platform.logInfo("stop preview start");
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallbackWithBuffer(null);
            try {
                this.mCamera.setPreviewTexture(null);
            }
            catch (IOException iOException) {
                Platform.logInfo(Platform.getTrace(iOException));
            }
            this.mCamera.release();
            this.mCamera = null;
        }
        Platform.logInfo(String.format(Locale.CHINA, "%h stop done spend %dms", this, SystemClock.elapsedRealtime() - l2));
    }

    @WorkerThread
    private int startOnCaptureThread() {
        Platform.logInfo(String.format(Locale.CHINA, "start on camera thread wait %d", SystemClock.elapsedRealtime() - this.mStartTs));
        return this.startCaptureInternal();
    }

    @WorkerThread
    private int configOnCameraThread(int n2, int n3, int n4) {
        Platform.logInfo(String.format("configCaptureOnCameraThread mCamera %h ", this.mCamera));
        int n5 = -1;
        if (this.mCamera != null) {
            Camera.Parameters parameters;
            try {
                parameters = this.mCamera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                this.mWidth = n2;
                this.mHeight = n3;
                this.mFps = n4;
                return n5;
            }
            Camera.Size size = parameters.getPreviewSize();
            Camera.Size size2 = this.getOptimalPreviewSize(parameters, n2, n3);
            int n6 = parameters.getPreviewFrameRate();
            int n7 = this.getOptimalFpsRate(parameters, n4);
            if (!size.equals((Object)size2) || n6 != n7) {
                Platform.logInfo(String.format(Locale.CHINA, "oldFps: %d, optimalFps: %d, old size: (%d, %d), opt size: (%d, %d)", n6, n7, size.width, size.height, size2.width, size2.height));
                this.stopCaptureInternal();
                this.mWidth = n2;
                this.mHeight = n3;
                this.mFps = n4;
                n5 = this.startCaptureInternal();
            } else {
                n5 = 0;
            }
        } else {
            this.mWidth = n2;
            this.mHeight = n3;
            this.mFps = n4;
        }
        return n5;
    }

    @WorkerThread
    private void stopOnCaptureThread(VideoCaptureContext videoCaptureContext) {
        this.stopCaptureInternal();
        if (this.mCaptureBuffers != null) {
            this.mCaptureBuffers.clear();
            this.mCaptureBuffers = null;
        }
        if (this.mCaptureTextureHolder != null) {
            this.mCaptureTextureHolder.release();
        }
        this.mPaused = false;
        Platform.logInfo(String.format(Locale.CHINA, "frame count %d", this.mFrameCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(String string) {
        if (string == null || string.length() == 0) {
            Platform.logError("camera.id.null");
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            this.mStartTs = SystemClock.elapsedRealtime();
            try {
                this.mCameraId = Integer.parseInt(string);
                if (this.mCameraInfo == null) {
                    this.mCameraInfo = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)this.mCameraInfo);
                }
            }
            catch (RuntimeException runtimeException) {
                this.mCameraId = 0;
                this.mCameraInfo = null;
                Platform.logError(String.format("camera.id.%s.invalid", string));
                return false;
            }
            if (this.mCaptureCtx == null) {
                this.mCaptureCtx = VideoCaptureContext.create(this.mContext);
            }
            if (this.mAppLifecycle == null) {
                this.mAppLifecycle = AppLifecycle.create(this.mContext, this.mCaptureCtx.getHandler());
                this.mAppLifecycle.addObserver(this);
            }
            Params params = new Params();
            params.what = 1;
            this.mStop = false;
            boolean bl = false;
            if (this.mCaptureCtx.runOnCaptureThread(this, params, true)) {
                bl = this.mAsyncResult == 0;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop() {
        Object object = sLock;
        synchronized (object) {
            if (this.mCaptureCtx == null) {
                return false;
            }
            long l2 = SystemClock.elapsedRealtime();
            if (this.mAppLifecycle != null) {
                this.mAppLifecycle.destroy();
                this.mAppLifecycle = null;
            }
            Params params = new Params();
            params.what = 3;
            this.mStop = true;
            Object object2 = this.mLock;
            synchronized (object2) {
                if (this.mPreviewCallback != null) {
                    this.mPreviewCallback.clear();
                }
            }
            boolean bl = this.mCaptureCtx.runOnCaptureThread(this, params, true);
            Platform.logInfo(String.format(Locale.CHINA, "stop wait %dms", SystemClock.elapsedRealtime() - l2));
            this.mCaptureCtx.destroy();
            this.mCaptureCtx = null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean config(int n2, int n3, int n4) {
        Object object = sLock;
        synchronized (object) {
            if (!this.mStop && null != this.mCaptureCtx) {
                Params params = new Params();
                params.what = 2;
                params.w = n2;
                params.h = n3;
                params.f = n4;
                boolean bl = false;
                if (this.mCaptureCtx.runOnCaptureThread(this, params, true)) {
                    bl = this.mAsyncResult == 0;
                }
                return bl;
            }
            this.mWidth = n2;
            this.mHeight = n3;
            this.mFps = n4;
            return true;
        }
    }

    private int getRotate() {
        int n2;
        int n3 = n2 = this.mCaptureCtx.isDeviceAutoRotate() ? this.mCaptureCtx.getDeviceOrientation() : 0;
        if (this.mCameraInfo.facing == 0) {
            n2 = 360 - n2;
        }
        n2 = (this.mCameraInfo.orientation + n2) % 360;
        return n2 / 90;
    }

    private static native void onCaptureEnum(long var0, String var2, int var3);

    private static native void onCaptureFrame(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureFrame2(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5);

    private class CapturePreviewCallback
    implements Camera.PreviewCallback {
        @Nullable
        VideoCapture mCapture;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CapturePreviewCallback capturePreviewCallback = this;
            synchronized (capturePreviewCallback) {
                Platform.logError(String.format("clear capture %h", this.mCapture));
                this.mCapture = null;
            }
        }

        CapturePreviewCallback(@NonNull VideoCapture videoCapture2) {
            this.mCapture = videoCapture2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onPreviewFrame(byte[] byArray, Camera camera) {
            CapturePreviewCallback capturePreviewCallback = this;
            synchronized (capturePreviewCallback) {
                if (this.mCapture != null) {
                    this.mCapture.onPreviewFrame(byArray, camera);
                } else if (Platform.isDebugLevel()) {
                    Platform.logDebug(String.format(Locale.CHINA, "fast stop return %d", byArray.length));
                }
            }
        }
    }

    static class Params {
        int what;
        int w;
        int h;
        int f;

        Params() {
        }
    }
}

