/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.util.DisplayMetrics;
import android.view.Choreographer;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.SurfaceTextureHolder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;

@TargetApi(value=21)
public final class ScreenCapture
implements Choreographer.FrameCallback {
    protected static final String TAG = "ScreenCapture";
    private static final int MAX_IMAGES = 5;
    private static final int MSG_START_CAPTURE = 3;
    private static final int MSG_STOP_CAPTURE = 4;
    private static final int MSG_DETECT_ROTATE = 5;
    private static final int VIRTUAL_DISPLAY_CREATE_FAIL = -2;
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private int mDisplayIndex;
    private MediaProjectionManager mMediaProjectionManager;
    private Context mContext;
    private final Object mImageReaderLock = new Object();
    private final boolean mUseSurfaceTexture;
    private SurfaceTextureHolder mSurfaceTextureHolder = null;
    private boolean mTextureFrameAvailable = false;
    private ImageReader mImageReader = null;
    private Image mLastImage = null;
    private InternalImageReaderListener mReaderListener;
    private WindowManager mWindowMgr;
    private Point mScreenSize = new Point();
    private DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    private ConfigurationChangedReceiver mReceiver;
    private HandlerThread mImageHandlerThread;
    private Handler mImageHandler;
    private long mNativePtr;
    private int mCapWidth;
    private int mCapHeight;
    private int mCapFps = 15;
    private int mRotate;
    private final Object mRotateLock = new Object();
    private long mFpsFrameCount;
    private long mFpsLastFrameCount;
    private long mFpsLastFrameTimeNS;
    private long mFpsFirstFrameCost;
    private long mFpsTotalActualDelay;
    private long mFpsTotalFrameCount;
    private long mFpsMaxActualDelay;
    private long mFpsMinActualDelay = Integer.MAX_VALUE;
    private long mImageAvailableFrameCount;
    private long mImageAvailableFirstFrameCost;
    private long mDisplayCreateTime;
    private boolean mCaptureHasInit = false;
    private volatile boolean mCapturing = false;
    private int mPermissionRetCode;
    private Intent mPermissionRetData = null;
    private final Object mConfigureChangedLock = new Object();
    private Handler mMainLooper;
    private boolean mSupportConfigureChanged = false;
    private MediaProjection.Callback mMediaProjCallback = new MediaProjection.Callback(){

        @WorkerThread
        public void onStop() {
            Platform.logInfo("MediaProjection.onStop");
            ScreenCapture.this.onMediaProjectionStop();
        }
    };

    private boolean isAppForeground() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(this.mContext.getApplicationInfo().processName)) continue;
            return true;
        }
        return false;
    }

    private void releaseVirtualDisplay(VirtualDisplay virtualDisplay) {
        try {
            virtualDisplay.setSurface(null);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        try {
            virtualDisplay.release();
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
    }

    private synchronized void onMediaProjectionStop() {
        if (this.mVirtualDisplay != null) {
            this.releaseVirtualDisplay(this.mVirtualDisplay);
            this.mVirtualDisplay = null;
            Platform.logInfo("virtual.display.stop");
        }
        if (this.mMediaProjection != null) {
            MediaProjection mediaProjection = this.mMediaProjection;
            this.mMediaProjection = null;
            mediaProjection.unregisterCallback(this.mMediaProjCallback);
            mediaProjection.stop();
        }
    }

    @WorkerThread
    private ScreenCapture(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativePtr = l2;
        this.mUseSurfaceTexture = bl;
        this.mWindowMgr = (WindowManager)context.getSystemService("window");
        this.mMediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.mReaderListener = new InternalImageReaderListener();
        this.mRotate = this.mWindowMgr.getDefaultDisplay().getRotation();
        this.mMainLooper = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void onConfigurationChanged() {
        Object object = this.mRotateLock;
        synchronized (object) {
            Display display = this.mWindowMgr.getDefaultDisplay();
            int n2 = display.getRotation();
            ScreenCapture.onCaptureRotateChanged(this.mNativePtr, this.mRotate, n2);
            this.mRotate = n2;
            if (this.mVirtualDisplay != null && this.config(this.mCapHeight, this.mCapWidth) == -2) {
                Platform.log(3, "config.fail.while.screen.changed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectRotate() {
        Object object = this.mRotateLock;
        synchronized (object) {
            int n2 = this.mWindowMgr.getDefaultDisplay().getRotation();
            if (n2 != this.mRotate) {
                Platform.logInfo("detect.rotate.changed");
                this.mMainLooper.post(new Runnable(){

                    @Override
                    public void run() {
                        ScreenCapture.this.onConfigurationChanged();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void doFrame(long l2) {
        boolean bl;
        long l3 = 1000000000L / (long)this.mCapFps;
        long l4 = System.nanoTime();
        if (this.mFpsLastFrameTimeNS + l3 > l4) {
            boolean bl2;
            Object object = this.mImageReaderLock;
            synchronized (object) {
                bl2 = this.mCapturing;
            }
            if (bl2) {
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWindowMgr.getDefaultDisplay().getRealSize(this.mScreenSize);
        } else {
            this.mWindowMgr.getDefaultDisplay().getSize(this.mScreenSize);
        }
        Object object = this.mImageReaderLock;
        synchronized (object) {
            bl = this.mCapturing;
            if (bl) {
                if (this.mUseSurfaceTexture && this.mSurfaceTextureHolder != null) {
                    if (this.mTextureFrameAvailable) {
                        ScreenCapture.onCaptureFrameSurface(this.mNativePtr, this.mSurfaceTextureHolder, this.mCapWidth, this.mCapHeight, 0, this.mScreenSize.x, this.mScreenSize.y);
                        ++this.mFpsFrameCount;
                        this.mTextureFrameAvailable = false;
                    }
                } else {
                    Image image = this.mLastImage;
                    this.mLastImage = null;
                    if (image != null) {
                        int n2;
                        int n3 = image.getWidth();
                        if (n3 > (n2 = image.getHeight()) && this.mScreenSize.x > this.mScreenSize.y || n3 < n2 && this.mScreenSize.x < this.mScreenSize.y) {
                            if (this.mFpsFirstFrameCost == 0L) {
                                this.mFpsFirstFrameCost = System.currentTimeMillis() - this.mDisplayCreateTime;
                                Platform.logInfo(String.format(Locale.CHINA, "first.frame.cost.%dms", this.mFpsFirstFrameCost));
                            }
                            Image.Plane[] planeArray = image.getPlanes();
                            Image.Plane plane = planeArray[0];
                            ByteBuffer byteBuffer = plane.getBuffer();
                            int n4 = plane.getPixelStride();
                            int n5 = plane.getRowStride();
                            ScreenCapture.onCaptureFramesAvailable(this.mNativePtr, byteBuffer, n3, n2, n4, n5, 0, this.mScreenSize.x, this.mScreenSize.y);
                            ++this.mFpsFrameCount;
                        }
                        image.close();
                    }
                }
            }
        }
        long l5 = 0L;
        long l6 = System.nanoTime();
        long l7 = l6 - l4;
        if (this.mFpsLastFrameTimeNS > 0L) {
            long l8 = l4 - this.mFpsLastFrameTimeNS;
            l5 = l8 / 1000000L;
            if (l5 > this.mFpsMaxActualDelay) {
                this.mFpsMaxActualDelay = l5;
            }
            if (l5 < this.mFpsMinActualDelay) {
                this.mFpsMinActualDelay = l5;
            }
            this.mFpsTotalActualDelay += l5;
            ++this.mFpsTotalFrameCount;
        }
        if (Platform.isDebugBuild && this.mFpsTotalFrameCount % 100L == 0L) {
            Platform.logDebug(String.format(Locale.CHINA, "cost.%dms.actual_delay.%dms.vysnc_delay.%d.ms.fps.%d", l7 / 1000000L, l5, (l4 - l2) / 1000000L, this.mCapFps));
        }
        this.mFpsLastFrameTimeNS = l2;
        if (bl) {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private boolean createMediaProjection(int n2, Intent intent) {
        if (intent == null) {
            return false;
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection.unregisterCallback(this.mMediaProjCallback);
            this.mMediaProjection = null;
        }
        try {
            this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(n2, intent);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        if (this.mMediaProjection == null) {
            Platform.log(3, "get.media.projection.failed");
            return false;
        }
        return true;
    }

    private synchronized int setPermissionResult(int n2, Intent intent) {
        if (this.createMediaProjection(n2, intent)) {
            this.mPermissionRetCode = n2;
            this.mPermissionRetData = intent;
            return 0;
        }
        return -1;
    }

    @WorkerThread
    public synchronized int init() {
        if (!this.mCaptureHasInit) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
            this.mReceiver = new ConfigurationChangedReceiver();
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
            this.mCaptureHasInit = true;
        }
        return 0;
    }

    public synchronized void setFps(int n2) {
        this.mCapFps = Math.max(n2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createVirtualDisplay() {
        Surface surface;
        Object object;
        int n2 = this.mCapWidth;
        int n3 = this.mCapHeight;
        long l2 = System.currentTimeMillis();
        SurfaceTextureHolder surfaceTextureHolder = null;
        ImageReader imageReader = null;
        if (this.mUseSurfaceTexture) {
            object = new EGLCore();
            try {
                if (!object.createContext(EGLUtil.getOffscreenContext(), true)) {
                    throw new IllegalArgumentException("createContext.failed");
                }
                surfaceTextureHolder = new SurfaceTextureHolder(n2, n3, (SurfaceTextureHolder.EventCallback)new SurfaceTextureHandler(), (EGLCoreContext)object);
                surface = surfaceTextureHolder.getSurface();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Platform.logError(illegalArgumentException.toString());
                int n4 = -1;
                return n4;
            }
            finally {
                object.release();
            }
        } else {
            if (n2 <= 0 || n3 <= 0) {
                Platform.logError(String.format(Locale.CHINA, "size.invalid.w.%d.h.%d", n2, n3));
                return -1;
            }
            imageReader = ImageReader.newInstance((int)n2, (int)n3, (int)1, (int)5);
            imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this.mReaderListener, this.mImageHandler);
            surface = imageReader.getSurface();
        }
        object = this.mImageReaderLock;
        synchronized (object) {
            if (this.mUseSurfaceTexture) {
                if (this.mSurfaceTextureHolder != null) {
                    this.mSurfaceTextureHolder.release();
                }
            } else {
                if (this.mLastImage != null) {
                    this.mLastImage.close();
                    this.mLastImage = null;
                }
                if (this.mImageReader != null) {
                    this.mImageReader.setOnImageAvailableListener(null, null);
                    this.mImageReader.close();
                }
            }
            this.mSurfaceTextureHolder = surfaceTextureHolder;
            this.mImageReader = imageReader;
            this.mCapturing = true;
            this.mDisplayCreateTime = System.currentTimeMillis();
            this.mImageAvailableFirstFrameCost = 0L;
            this.mFpsFirstFrameCost = 0L;
            Platform.logInfo(String.format(Locale.CHINA, "create.image.reader.cost.%dms", System.currentTimeMillis() - l2));
            long l3 = System.currentTimeMillis();
            if (this.mVirtualDisplay != null) {
                this.releaseVirtualDisplay(this.mVirtualDisplay);
            }
            String string = String.format(Locale.CHINA, "ScreenCapture-%d", this.mDisplayIndex++);
            try {
                this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay(string, n2, n3, this.mDisplayMetrics.densityDpi, 1, surface, (VirtualDisplay.Callback)new InternalVirtualDisplayCallback(string, this), this.mImageHandler);
            }
            catch (Exception exception) {
                Platform.log(3, String.format("fail.to.create.virtual.display.%s", exception.toString()));
            }
            Platform.logInfo(String.format(Locale.CHINA, "create.virtual.display.%s.cost.%dms", string, System.currentTimeMillis() - l3));
            if (this.mVirtualDisplay == null) {
                Platform.logError(String.format(Locale.CHINA, "virtual.display.%s.null", string));
                return -3;
            }
            this.mImageHandler.sendEmptyMessage(3);
        }
        return 0;
    }

    @AnyThread
    private synchronized int config(int n2, int n3) {
        int n4 = 0;
        if (n2 < 1 || n3 < 1) {
            Platform.logInfo(String.format(Locale.CHINA, "invalid.capture.size.%d.%d", n2, n3));
            return n4;
        }
        if (n2 == this.mCapWidth && n3 == this.mCapHeight) {
            Platform.logInfo(String.format(Locale.CHINA, "size.%dx%d.not.changed", n2, n3));
            return n4;
        }
        if (!this.mCaptureHasInit || this.mMediaProjection == null) {
            Platform.logInfo("config.uninited.or.no.permission");
            return -1;
        }
        Display display = this.mWindowMgr.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(this.mDisplayMetrics);
        } else {
            display.getMetrics(this.mDisplayMetrics);
        }
        this.mCapWidth = n2;
        this.mCapHeight = n3;
        if (this.mImageHandler != null) {
            n4 = this.createVirtualDisplay();
        }
        Platform.logDebug(String.format(Locale.CHINA, "config.new.size.%dx%d.rotate.%d", n2, n3, display.getRotation()));
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized void uninit() {
        if (this.mReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mReceiver = null;
        }
        this.stopCapture();
        Object object = this.mImageReaderLock;
        synchronized (object) {
            if (this.mSurfaceTextureHolder != null) {
                if (Platform.isDebugBuild) {
                    int n2 = this.mSurfaceTextureHolder.release();
                    Platform.logInfo(String.format(Locale.CHINA, "mSurfaceTextureHolder.release.count.%d", n2));
                } else {
                    this.mSurfaceTextureHolder.release();
                }
                this.mSurfaceTextureHolder = null;
            }
            if (this.mLastImage != null) {
                this.mLastImage.close();
                this.mLastImage = null;
            }
            if (this.mImageReader != null) {
                this.mImageReader.setOnImageAvailableListener(null, null);
                this.mImageReader.close();
            }
        }
        this.mNativePtr = 0L;
        this.mImageHandlerThread = null;
        this.mImageHandler = null;
        this.mCaptureHasInit = false;
        this.mCapturing = false;
        this.mPermissionRetData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized int start() {
        boolean bl;
        if (this.mPermissionRetData == null) {
            return -1;
        }
        if (this.mMediaProjection == null && !this.createMediaProjection(this.mPermissionRetCode, this.mPermissionRetData)) {
            return -2;
        }
        this.mImageHandlerThread = new HandlerThread(this.getClass().getSimpleName(), 0);
        this.mImageHandlerThread.start();
        this.mImageHandler = new ImageThreadHandler(this.mImageHandlerThread.getLooper());
        this.mMediaProjection.registerCallback(this.mMediaProjCallback, this.mImageHandler);
        int n2 = this.createVirtualDisplay();
        if (n2 != 0) {
            this.stopCapture();
            Platform.logError(String.format(Locale.CHINA, "createVirtualDisplay.failed.%d", n2));
            return n2;
        }
        Object object = this.mConfigureChangedLock;
        synchronized (object) {
            bl = this.mSupportConfigureChanged;
        }
        if (!bl) {
            this.mImageHandler.sendEmptyMessage(5);
        }
        return 0;
    }

    @WorkerThread
    private void stopCapture() {
        if (this.mImageHandler != null) {
            this.mImageHandler.sendEmptyMessage(4);
        }
        if (this.mVirtualDisplay != null) {
            this.releaseVirtualDisplay(this.mVirtualDisplay);
            this.mVirtualDisplay = null;
        }
        if (this.mMediaProjection != null) {
            MediaProjection mediaProjection = this.mMediaProjection;
            this.mMediaProjection = null;
            mediaProjection.unregisterCallback(this.mMediaProjCallback);
            mediaProjection.stop();
        }
        if (this.mImageHandlerThread != null) {
            try {
                this.mImageHandlerThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.mImageHandlerThread = null;
            this.mImageHandler = null;
        }
        this.mCapHeight = 0;
        this.mCapWidth = 0;
        this.mImageAvailableFrameCount = 0L;
        this.mFpsTotalActualDelay = 0L;
        this.mFpsTotalFrameCount = 0L;
        this.mFpsMinActualDelay = Integer.MAX_VALUE;
        this.mFpsMaxActualDelay = 0L;
        this.mCapturing = false;
    }

    @WorkerThread
    public synchronized void stop() {
        Platform.logInfo(String.format(Locale.CHINA, "stop.min.delay.%dms.avg.delay.%dms.frame.count.%d.frame.available.count.%d", this.mFpsMinActualDelay, this.mFpsTotalActualDelay / Math.max(this.mFpsTotalFrameCount, 1L), this.mFpsFrameCount, this.mImageAvailableFrameCount));
        this.stopCapture();
    }

    @WorkerThread
    private static native void onCaptureFramesAvailable(long var0, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureRotateChanged(long var0, int var2, int var3);

    private class SurfaceTextureHandler
    implements SurfaceTextureHolder.EventCallback {
        private SurfaceTextureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
            Object object = ScreenCapture.this.mImageReaderLock;
            synchronized (object) {
                ScreenCapture.this.mTextureFrameAvailable = true;
                ScreenCapture.this.mImageAvailableFrameCount++;
            }
        }

        @Override
        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
        }
    }

    private class ImageThreadHandler
    extends Handler {
        ImageThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void handleMessage(Message message) {
            switch (message.what) {
                case 3: {
                    Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
                    break;
                }
                case 5: {
                    boolean bl;
                    Object object = ScreenCapture.this.mConfigureChangedLock;
                    synchronized (object) {
                        bl = ScreenCapture.this.mSupportConfigureChanged;
                    }
                    if (!bl) {
                        ScreenCapture.this.detectRotate();
                        this.sendEmptyMessageDelayed(5, 500L);
                        break;
                    }
                    Platform.logInfo("remove.rotate.detector");
                    break;
                }
                case 4: {
                    Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
                    this.removeMessages(5);
                    ScreenCapture.this.mImageHandlerThread.quitSafely();
                    ScreenCapture.this.mCapturing = false;
                }
            }
        }
    }

    private class InternalImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private long mLastAvailableTime = 0L;

        private InternalImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onImageAvailable(ImageReader imageReader) {
            if (ScreenCapture.this.mImageAvailableFirstFrameCost == 0L) {
                ScreenCapture.this.mImageAvailableFirstFrameCost = System.currentTimeMillis() - ScreenCapture.this.mDisplayCreateTime;
                Platform.logInfo(String.format(Locale.CHINA, "first.frame.cost.%dms", ScreenCapture.this.mImageAvailableFirstFrameCost));
            }
            if (Platform.isDebugBuild && Platform.isLogLevel(5)) {
                long l2 = System.currentTimeMillis();
                Platform.logInfo(String.format(Locale.CHINA, "actual.delay.%dms", l2 - this.mLastAvailableTime));
                this.mLastAvailableTime = l2;
            }
            Object object = ScreenCapture.this.mImageReaderLock;
            synchronized (object) {
                if (ScreenCapture.this.mImageReader != imageReader || !ScreenCapture.this.mCapturing) {
                    return;
                }
                if (ScreenCapture.this.mLastImage != null) {
                    ScreenCapture.this.mLastImage.close();
                }
                Image image = null;
                try {
                    image = ScreenCapture.this.mImageReader.acquireLatestImage();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                }
                ScreenCapture.this.mLastImage = image;
                if (image != null) {
                    ScreenCapture.this.mImageAvailableFrameCount++;
                }
            }
        }
    }

    private static class InternalVirtualDisplayCallback
    extends VirtualDisplay.Callback {
        String mDisplayName;

        InternalVirtualDisplayCallback(String string, ScreenCapture screenCapture) {
            this.mDisplayName = String.valueOf(string);
        }

        public void onPaused() {
            Platform.logInfo(String.format("virtual.display.%s.paused", this.mDisplayName));
        }

        public void onResumed() {
            Platform.logInfo(String.format("virtual.display.%s.resumed", this.mDisplayName));
        }

        public void onStopped() {
            Platform.logInfo(String.format("virtual.display.%s.stopped", this.mDisplayName));
        }
    }

    private class ConfigurationChangedReceiver
    extends BroadcastReceiver {
        private ConfigurationChangedReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction())) {
                if (!ScreenCapture.this.mSupportConfigureChanged) {
                    Object object = ScreenCapture.this.mConfigureChangedLock;
                    synchronized (object) {
                        if (!ScreenCapture.this.isAppForeground()) {
                            Platform.logInfo(String.format("SupportConfigureChanged.%b", ScreenCapture.this.mSupportConfigureChanged));
                            ScreenCapture.this.mSupportConfigureChanged = true;
                        }
                    }
                }
                ScreenCapture.this.onConfigurationChanged();
            }
        }
    }
}

