/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import java.util.StringTokenizer;

public class VivoKTVHelper {
    private static final String TAG = "VivoKTVHelper";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_SRC = "vivo_ktv_rec_source";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PRESET = "vivo_ktv_preset_effect";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private static final String KEY_EXT_SPKR = "vivo_ktv_ext_speaker";
    private final Object mParamLock = new Object();
    private AudioManager mAudioManager;
    private Context mContext;
    private static VivoKTVHelper mVivoKTVHelper;

    public VivoKTVHelper(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public static VivoKTVHelper getInstance(Context context) {
        if (mVivoKTVHelper == null) {
            mVivoKTVHelper = new VivoKTVHelper(context);
        }
        return mVivoKTVHelper;
    }

    public boolean isDeviceSupportKaraoke() {
        String string = Build.MODEL;
        if (string.trim().contains("vivo")) {
            String string2;
            int n2;
            String string3 = this.mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            int n3 = stringTokenizer.countTokens();
            if (n3 != 2) {
                return false;
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(KEY_MIC_TYPE) && ((n2 = Integer.parseInt(string2 = stringTokenizer.nextToken())) == 1 || n2 == 0)) {
                return true;
            }
        }
        return false;
    }

    public void openKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=1");
        this.isDeviceSupportKaraoke();
    }

    public void closeKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicVolParam(int n2) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(KEY_VOL_MIC).append("=").append(n2);
                this.mAudioManager.setParameters(stringBuilder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceOutParam(int n2) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_rec_source=" + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreModeParam(int n2) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_preset_effect=" + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayFeedbackParam(int n2) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_play_source=" + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtSpeakerParam(int n2) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(KEY_EXT_SPKR).append("=").append(n2);
                this.mAudioManager.setParameters(stringBuilder.toString());
            }
        }
    }

    public int getExtSpeakerParam() {
        return this.getKTVParam(KEY_EXT_SPKR);
    }

    public int getPlayFeedbackParam() {
        return this.getKTVParam(KEY_PLAY_SRC);
    }

    public int getPreModeParam() {
        return this.getKTVParam(KEY_PRESET);
    }

    public int getMicTypeParam() {
        return this.getKTVParam(KEY_MIC_TYPE);
    }

    public int getVoiceOutParam() {
        return this.getKTVParam(KEY_MIC_SRC);
    }

    public int getMicVolParam() {
        return this.getKTVParam(KEY_VOL_MIC);
    }

    private int getKTVParam(String string) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer;
        int n2;
        String string4 = Build.MODEL;
        if (string4.trim().contains("vivo") && (n2 = (stringTokenizer = new StringTokenizer(string3 = this.mAudioManager.getParameters(string), "=")).countTokens()) == 2 && string.equals(string2 = stringTokenizer.nextToken())) {
            String string5 = stringTokenizer.nextToken();
            return Integer.parseInt(string5.trim());
        }
        return 0;
    }
}

