/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avlab.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Platform {
    public static final boolean isDebugBuild = Platform.debug();
    private static int logLevel = -1;
    private static final int NETWORK_UNREACHABLE = 0;
    private static final int NETWORK_UNKNOWN = 1;
    private static final int NETWORK_2G = 2;
    private static final int NETWORK_3G = 3;
    private static final int NETWORK_4G = 4;
    private static final int NETWORK_5G = 5;
    private static final int NETWORK_WIFI = 6;
    private static final int NETWORK_WIRED = 7;

    private static native void callFunction(long var0);

    private static boolean runOnMainThread(long l2) {
        return Lazy.gHandler.post((Runnable)new MainThreadRunnable(l2));
    }

    private static Object getClassLoader() {
        return Platform.class.getClassLoader();
    }

    public static native boolean debug();

    private static native void log(int var0, String var1, int var2, String var3, int var4, String var5);

    public static void log(int n2, String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            Platform.log(n2, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.getMethodName(), 1, string);
        }
    }

    public static void logInfo(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            Platform.log(4, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.getMethodName(), 1, string);
        }
    }

    public static void logDebug(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            Platform.log(5, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.getMethodName(), 1, string);
        }
    }

    public static void logError(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            Platform.log(2, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.getMethodName(), 1, string);
        }
    }

    protected static native int logLevel();

    public static boolean isDebugLevel() {
        return Platform.isLogLevel(5);
    }

    public static boolean isLogLevel(int n2) {
        if (logLevel == -1) {
            logLevel = Platform.logLevel();
        }
        return n2 <= logLevel;
    }

    private static String getAppVersion(Context context) {
        String string = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            if (null != packageInfo && !TextUtils.isEmpty((CharSequence)packageInfo.versionName.trim())) {
                string = packageInfo.versionName.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String getTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static int getNetworkState(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connectivityManager) {
            return 0;
        }
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return 0;
            }
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
            return 1;
        }
        if (!networkInfo.isAvailable()) {
            return 0;
        }
        NetworkInfo.State state = networkInfo.getState();
        if (null == state || state != NetworkInfo.State.CONNECTED && state != NetworkInfo.State.CONNECTING) {
            return 0;
        }
        int n2 = networkInfo.getType();
        if (1 == n2) {
            return 6;
        }
        if (0 == n2) {
            switch (networkInfo.getSubtype()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return 2;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return 3;
                }
                case 13: {
                    return 4;
                }
            }
            String string = networkInfo.getSubtypeName();
            if ("TD-SCDMA".equalsIgnoreCase(string) || "WCDMA".equalsIgnoreCase(string) || "CDMA2000".equalsIgnoreCase(string)) {
                return 3;
            }
        } else if (9 == n2) {
            return 7;
        }
        return 1;
    }

    private static class Lazy {
        static final Handler gHandler = new Handler(Looper.getMainLooper());

        private Lazy() {
        }
    }

    private static class MainThreadRunnable
    implements Runnable {
        private long ptr;

        MainThreadRunnable(long l2) {
            this.ptr = l2;
        }

        @Override
        public void run() {
            Platform.callFunction(this.ptr);
        }
    }
}

