/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.LongSparseArray;
import com.tencent.av.mediacodec.AndroidCodec;
import com.tencent.av.mediacodec.DeviceCheck;
import com.tencent.av.mediacodec.HWColorFormat;
import com.tencent.av.mediacodec.IMediaCodecCallback;
import com.tencent.avlab.utils.ArrayUtils;
import com.tencent.avlab.utils.QLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=16)
public class NativeCodec
implements IMediaCodecCallback {
    private static final String TAG = "NativeCodec";
    private int mNativeContext = 0;
    AndroidCodec mCodec;
    long mTimeStamp = 0L;
    long mLastEncFrameTime = 0L;
    long mLastDecFrameTime = 0L;
    int mTryAgainLaterCount = 0;
    int mTryDecLaterCount = 0;
    int mTotalDecOutFrameNum = 0;
    int mTotalDecInFrameNum = 0;
    int mFirstFrameNum = 0;
    int mTryAgainLaterCount2 = 0;
    MediaFormat mFormat = null;
    String mMime;
    int mWidth = 320;
    int mHeight = 240;
    boolean misdecoder;
    int mColorFormat;
    int mFrameRate = 20;
    int mFrameInverval = 30000;
    int mBitRate;
    public static int TIMEOUTDECFIST_3US = 3000;
    public static int TIMEOUTDECFIST_8US = 8000;
    public static int TIMEOUTDECFIST_20US = 20000;
    public static boolean mUseAsyncAPI = false;
    List<AndroidCodec.InputBufferData> mPendingInputBuffers = new ArrayList<AndroidCodec.InputBufferData>();
    AtomicBoolean mCodersExit = new AtomicBoolean(false);
    boolean mDebugDelay = false;
    LongSparseArray<Long> mDebugDelayMap = null;
    LongSparseArray<Long> mDebugDelayMap2 = null;
    LongSparseArray<Long> mDebugIndexMap = null;
    String mDebugTag = null;
    public static String LEFT = "crop-left";
    public static String TOP = "crop-top";
    public static String RIGHT = "crop-right";
    public static String BOTTOM = "crop-bottom";
    public static String STRIDE = "stride";
    public static String AVCSPS = "csd-0";
    public static String AVCPPS = "csd-1";
    public static String HEVCVPSSPSPPS = "csd-0";
    public static String SLICEHEIGHT = "slice-height";
    static AVCCaps gAVCDecoderCaps;
    static AVCCaps gHEVCDecoderCaps;
    static AVCCaps gHEVCEncoderCaps;
    static AVCCaps gAVCEncoderCaps;
    int setBitRatePending = 0;
    boolean setIFramePending = false;

    public NativeCodec() {
    }

    @TargetApi(value=16)
    @SuppressLint(value={"NewApi"})
    public NativeCodec(String string, Map<String, Object> map, boolean bl) {
        this.mMime = string;
        this.misdecoder = bl;
        this.mWidth = (Integer)map.get("width");
        this.mHeight = (Integer)map.get("height");
        if (this.misdecoder) {
            try {
                ByteBuffer byteBuffer;
                int n2 = this.mWidth;
                int n3 = this.mHeight;
                this.mFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
                if (string.contains(AndroidCodec.AVC_CODEC_MIME)) {
                    this.mFormat.setInteger("max-input-size", n2 * n3);
                    this.mFormat.setInteger("color-format", 21);
                    this.mFormat.setInteger("frame-rate", 60);
                    this.mFormat.setInteger("low-latency", 1);
                    byteBuffer = (ByteBuffer)map.get(AVCSPS);
                    ByteBuffer byteBuffer2 = (ByteBuffer)map.get(AVCPPS);
                    this.mFormat.setByteBuffer(AVCSPS, byteBuffer);
                    this.mFormat.setByteBuffer(AVCPPS, byteBuffer2);
                }
                if (string.contains(AndroidCodec.HEVC_CODEC_MIME)) {
                    this.mFormat.setInteger("max-input-size", n2 * n3);
                    this.mFormat.setInteger("color-format", 21);
                    this.mFormat.setInteger("frame-rate", 60);
                    this.mFormat.setInteger("low-latency", 1);
                    byteBuffer = (ByteBuffer)map.get(HEVCVPSSPSPPS);
                    this.mFormat.setByteBuffer(HEVCVPSSPSPPS, byteBuffer);
                }
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "width =" + n2 + ", height =" + n3);
                }
                this.createDecCodec();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, TAG, exception);
                }
                this.mCodec = null;
            }
        } else {
            try {
                this.mBitRate = (Integer)map.get("bitrate");
                this.mFrameRate = (Integer)map.get("frame-rate");
                this.createEncCodec();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, TAG, exception);
                }
                this.mCodec = null;
            }
        }
        this.mDebugIndexMap = new LongSparseArray();
        if (this.mDebugDelay) {
            this.mDebugDelayMap = new LongSparseArray();
            this.mDebugDelayMap2 = new LongSparseArray();
            this.mDebugTag = mUseAsyncAPI ? "Async" : " Sync";
            this.mDebugTag = this.mDebugTag + (this.misdecoder ? "DEC" : "ENC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCodec() {
        block14: {
            if (this.mCodec != null) {
                try {
                    List<AndroidCodec.InputBufferData> list = this.mPendingInputBuffers;
                    synchronized (list) {
                        this.mCodersExit.set(true);
                        this.mPendingInputBuffers.clear();
                        this.mDebugIndexMap.clear();
                        if (this.mDebugDelay) {
                            this.mDebugDelayMap.clear();
                            this.mDebugDelayMap2.clear();
                        }
                        this.mCodec.stop();
                        this.mCodec.release();
                        this.mCodec = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "resetCodec", exception);
                    }
                    this.mCodec = null;
                }
            }
            try {
                if (this.misdecoder) {
                    this.createDecCodec();
                } else {
                    this.createEncCodec();
                }
                this.mTimeStamp = 0L;
                this.mLastEncFrameTime = 0L;
                this.mLastDecFrameTime = 0L;
                if (this.mCodec != null) {
                    this.mCodec.start();
                }
                this.mCodersExit.set(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!QLog.isColorLevel()) break block14;
                QLog.e(TAG, 0, "resetCodec", exception);
            }
        }
    }

    void createEncCodec() {
        if (this.mCodec == null) {
            try {
                int n2;
                int n3;
                MediaCodecInfo.CodecCapabilities codecCapabilities;
                List<MediaCodecInfo> list = AndroidCodec.getEndoderInfos(this.mMime);
                this.mColorFormat = 21;
                int n4 = 0;
                for (int i2 = 0; i2 < list.size() && (codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(i2), this.mMime)) != null; ++i2) {
                    if (ArrayUtils.contains(codecCapabilities.colorFormats, 21)) {
                        this.mColorFormat = 21;
                        n4 = i2;
                        break;
                    }
                    if (!ArrayUtils.contains(codecCapabilities.colorFormats, 19)) continue;
                    this.mColorFormat = 19;
                    n4 = i2;
                    break;
                }
                this.mCodec = new AndroidCodec();
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.mMime, (int)this.mWidth, (int)this.mHeight);
                mediaFormat.setInteger("color-format", this.mColorFormat);
                mediaFormat.setInteger("frame-rate", this.mFrameRate);
                mediaFormat.setInteger("bitrate", this.mBitRate);
                int n5 = 864000;
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "KEY_I_FRAME_INTERVAL = " + n5 + ", mFrameRate = " + this.mFrameRate);
                }
                if (Build.VERSION.SDK_INT < 19) {
                    mediaFormat.setInteger("i-frame-interval", n5);
                } else {
                    mediaFormat.setInteger("i-frame-interval", n5);
                }
                MediaCodecInfo.CodecCapabilities codecCapabilities2 = AndroidCodec.getCodecCapabilities(list.get(n4), this.mMime);
                if (codecCapabilities2 == null) {
                    this.mCodec = null;
                    return;
                }
                if (this.mMime.contains(AndroidCodec.AVC_CODEC_MIME)) {
                    block9: for (n3 = 0; n3 < codecCapabilities2.profileLevels.length; ++n3) {
                        switch (codecCapabilities2.profileLevels[n3].profile) {
                            case 1: {
                                n2 = 16;
                                mediaFormat.setInteger("profile", 1);
                                if (n2 < codecCapabilities2.profileLevels[n3].level) {
                                    n2 = codecCapabilities2.profileLevels[n3].level;
                                }
                                mediaFormat.setInteger("level", n2);
                                continue block9;
                            }
                        }
                    }
                }
                if (this.mMime.contains(AndroidCodec.HEVC_CODEC_MIME)) {
                    block10: for (n3 = 0; n3 < codecCapabilities2.profileLevels.length; ++n3) {
                        switch (codecCapabilities2.profileLevels[n3].profile) {
                            case 1: {
                                n2 = 16384;
                                mediaFormat.setInteger("profile", 1);
                                if (n2 < codecCapabilities2.profileLevels[n3].level) {
                                    n2 = codecCapabilities2.profileLevels[n3].level;
                                }
                                mediaFormat.setInteger("level", n2);
                                continue block10;
                            }
                        }
                    }
                }
                this.mFormat = mediaFormat;
                this.mFrameInverval = this.mFrameRate > 0 ? 1000000 / this.mFrameRate : 40000;
                this.mCodec.init(this.mFormat, list.get(n4).getName(), (IMediaCodecCallback)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "createEncCodec", exception);
                }
                this.mCodec = null;
            }
        }
    }

    private void createDecCodec() {
        this.mCodec = new AndroidCodec();
        if (this.misdecoder) {
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(this.mMime);
            MediaCodecInfo mediaCodecInfo = list.get(0);
            for (int i2 = 0; i2 < list.size() && (codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(i2), this.mMime)) != null; ++i2) {
                if (ArrayUtils.contains(codecCapabilities.colorFormats, 19)) {
                    mediaCodecInfo = list.get(i2);
                    this.mFormat.setInteger("color-format", 19);
                    break;
                }
                if (!ArrayUtils.contains(codecCapabilities.colorFormats, 21)) continue;
                mediaCodecInfo = list.get(i2);
                this.mFormat.setInteger("color-format", 21);
                break;
            }
            if (!this.mCodec.init(this.mFormat, mediaCodecInfo.getName(), (IMediaCodecCallback)this)) {
                this.mCodec = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
        int n3 = 0;
        ByteBuffer byteBuffer = this.mCodec.getInputBuffer(n2);
        if (byteBuffer == null) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "getInputBuffer null, index: " + n2);
            }
            return;
        }
        try {
            block39: {
                List<AndroidCodec.InputBufferData> list = this.mPendingInputBuffers;
                synchronized (list) {
                    block38: {
                        if (!this.mCodersExit.get()) break block38;
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "codec exit, return onInputBufferAvailable");
                        }
                        return;
                    }
                    this.mPendingInputBuffers.add(new AndroidCodec.InputBufferData(byteBuffer, n2));
                    this.mPendingInputBuffers.get((int)0).processing = true;
                }
                try {
                    if (this.misdecoder) {
                        n3 = this.writeInputData(this.mPendingInputBuffers.get((int)0).buffer, true);
                    } else {
                        if (QLog.isColorLevel()) {
                            QLog.d(TAG, 0, "call writeInputData2 in callback");
                        }
                        n3 = this.writeInputData2(this.mPendingInputBuffers.get((int)0).buffer, this.mColorFormat, true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!QLog.isColorLevel()) break block39;
                    QLog.e(TAG, 0, "input buffers cleared by other thread when writeInputData", exception);
                }
            }
            if (n3 > 0) {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "writeInputData, SampleSize:" + n3);
                }
                this.mLastEncFrameTime += (long)this.mFrameInverval;
                if (this.mDebugDelay) {
                    this.mDebugDelayMap.put(this.mLastEncFrameTime, (Object)System.currentTimeMillis());
                }
                try {
                    this.mCodec.queueInputBuffer(this.mPendingInputBuffers.get((int)0).index, n3, this.mLastEncFrameTime, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "input buffers cleared by other thread when queueInputBuffer", exception);
                    }
                }
            }
        }
        finally {
            List<AndroidCodec.InputBufferData> list = this.mPendingInputBuffers;
            synchronized (list) {
                block41: {
                    try {
                        this.mPendingInputBuffers.get((int)0).processing = false;
                        if (n3 > 0) {
                            this.mPendingInputBuffers.remove(0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!QLog.isColorLevel()) break block41;
                        QLog.e(TAG, 0, "input buffers cleared by other thread when processing=false", exception);
                    }
                }
            }
        }
    }

    @Override
    public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onOutputBufferAvailable");
            }
            return;
        }
        ByteBuffer byteBuffer = this.mCodec.getOutputBuffer(n2);
        if (byteBuffer != null && bufferInfo != null) {
            if (this.misdecoder) {
                MediaFormat mediaFormat = this.mCodec.getOutputFormat(n2);
                if (mediaFormat != null) {
                    this.calcDelay(false, bufferInfo);
                    this.setFrame(byteBuffer, bufferInfo.size, mediaFormat);
                } else if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "getOutputFormat null");
                }
            } else {
                if (bufferInfo.flags == 1) {
                    // empty if block
                }
                this.calcDelay(false, bufferInfo);
                this.readOutputStream(byteBuffer, bufferInfo.presentationTimeUs, bufferInfo.offset, bufferInfo.size, bufferInfo.flags);
            }
            this.mCodec.releaseOutputBuffer(n2);
        }
    }

    Long calcDelay(boolean bl, MediaCodec.BufferInfo bufferInfo) {
        Long l2 = (Long)this.mDebugIndexMap.get(bufferInfo.presentationTimeUs);
        if (this.mDebugDelay) {
            Long l3;
            Long l4 = (Long)this.mDebugDelayMap.get(bufferInfo.presentationTimeUs);
            if (l4 != null) {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, this.mDebugTag + "small, " + bufferInfo.presentationTimeUs + ", takes:" + (System.currentTimeMillis() - l4));
                }
                this.mDebugDelayMap.remove(bufferInfo.presentationTimeUs);
            }
            if (l2 != null && (l3 = (Long)this.mDebugDelayMap2.get(l2.longValue())) != null) {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, this.mDebugTag + "big, " + bufferInfo.presentationTimeUs + ", takes:" + (System.currentTimeMillis() - l3));
                }
                this.mDebugDelayMap2.remove(l2.longValue());
            }
        }
        this.mDebugIndexMap.remove(bufferInfo.presentationTimeUs);
        return l2;
    }

    @Override
    public void onError(MediaCodec mediaCodec, Exception exception) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onError", exception);
        }
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onError");
            }
            return;
        }
    }

    @Override
    public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onOutputFormatChanged");
        }
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onOutputFormatChanged");
            }
            return;
        }
    }

    private static void initAVCEncoderCaps() {
        List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(AndroidCodec.AVC_CODEC_MIME);
        gAVCEncoderCaps = new AVCCaps();
        if (list.isEmpty()) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(0), AndroidCodec.AVC_CODEC_MIME);
        if (codecCapabilities == null) {
            return;
        }
        block3: for (int i2 = 0; i2 < codecCapabilities.profileLevels.length; ++i2) {
            switch (codecCapabilities.profileLevels[i2].profile) {
                case 1: {
                    NativeCodec.gAVCEncoderCaps.profile = 3;
                    NativeCodec.setLevel(codecCapabilities.profileLevels[i2], gAVCEncoderCaps);
                    continue block3;
                }
            }
        }
    }

    private static void initHevcEncoderCaps() {
        List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(AndroidCodec.HEVC_CODEC_MIME);
        gHEVCEncoderCaps = new AVCCaps();
        if (list.isEmpty()) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(0), AndroidCodec.HEVC_CODEC_MIME);
        if (codecCapabilities == null) {
            return;
        }
        block3: for (int i2 = 0; i2 < codecCapabilities.profileLevels.length; ++i2) {
            switch (codecCapabilities.profileLevels[i2].profile) {
                case 1: {
                    NativeCodec.gHEVCEncoderCaps.profile = 1;
                    NativeCodec.setHevcLevel(codecCapabilities.profileLevels[i2], gHEVCEncoderCaps);
                    continue block3;
                }
            }
        }
    }

    private static void setLevel(MediaCodecInfo.CodecProfileLevel codecProfileLevel, AVCCaps aVCCaps) {
        switch (codecProfileLevel.level) {
            case 1: {
                if (aVCCaps.width >= 176 && aVCCaps.height >= 144) break;
                aVCCaps.width = 176;
                aVCCaps.height = 144;
                break;
            }
            case 4: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                aVCCaps.width = 352;
                aVCCaps.height = 288;
                break;
            }
            case 8: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                aVCCaps.width = 352;
                aVCCaps.height = 288;
                break;
            }
            case 16: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                aVCCaps.width = 352;
                aVCCaps.height = 288;
                break;
            }
            case 2: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                aVCCaps.width = 352;
                aVCCaps.height = 288;
                break;
            }
            case 32: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                aVCCaps.width = 352;
                aVCCaps.height = 288;
                break;
            }
            case 64: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 576) break;
                aVCCaps.width = 352;
                aVCCaps.height = 576;
                break;
            }
            case 128: {
                if (aVCCaps.width >= 720 && aVCCaps.height >= 576) break;
                aVCCaps.width = 720;
                aVCCaps.height = 576;
                break;
            }
            case 256: {
                if (aVCCaps.width >= 720 && aVCCaps.height >= 576) break;
                aVCCaps.width = 720;
                aVCCaps.height = 576;
                break;
            }
            case 512: {
                if (aVCCaps.width >= 1280 && aVCCaps.height >= 720) break;
                aVCCaps.width = 1280;
                aVCCaps.height = 720;
                break;
            }
            case 1024: {
                if (aVCCaps.width >= 1280 && aVCCaps.height >= 1024) break;
                aVCCaps.width = 1280;
                aVCCaps.height = 1024;
                break;
            }
            case 2048: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1024) break;
                aVCCaps.width = 2048;
                aVCCaps.height = 1024;
                break;
            }
            case 4096: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1024) break;
                aVCCaps.width = 2048;
                aVCCaps.height = 1024;
                break;
            }
            case 8192: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1088) break;
                aVCCaps.width = 2048;
                aVCCaps.height = 1088;
                break;
            }
            case 16384: {
                if (aVCCaps.width >= 3680 && aVCCaps.height >= 1536) break;
                aVCCaps.width = 3680;
                aVCCaps.height = 1536;
                break;
            }
            case 32768: {
                if (aVCCaps.width >= 4096 && aVCCaps.height >= 2304) break;
                aVCCaps.width = 4096;
                aVCCaps.height = 2304;
                break;
            }
        }
    }

    private static void setHevcLevel(MediaCodecInfo.CodecProfileLevel codecProfileLevel, AVCCaps aVCCaps) {
        if (codecProfileLevel.level == 1) {
            if (aVCCaps.width < 192 || aVCCaps.height < 144) {
                aVCCaps.width = 192;
                aVCCaps.height = 144;
            }
        } else if (codecProfileLevel.level == 4) {
            if (aVCCaps.width < 352 || aVCCaps.height < 288) {
                aVCCaps.width = 352;
                aVCCaps.height = 288;
            }
        } else if (codecProfileLevel.level == 16) {
            if (aVCCaps.width < 352 || aVCCaps.height < 576) {
                aVCCaps.width = 352;
                aVCCaps.height = 576;
            }
        } else if (codecProfileLevel.level == 64) {
            if (aVCCaps.width < 720 || aVCCaps.height < 576) {
                aVCCaps.width = 720;
                aVCCaps.height = 576;
            }
        } else if (codecProfileLevel.level == 256) {
            if (aVCCaps.width < 1280 || aVCCaps.height < 720) {
                aVCCaps.width = 1280;
                aVCCaps.height = 720;
            }
        } else if (codecProfileLevel.level == 1024) {
            if (aVCCaps.width < 1920 || aVCCaps.height < 1080) {
                aVCCaps.width = 1920;
                aVCCaps.height = 1080;
            }
        } else if (codecProfileLevel.level == 4096) {
            if (aVCCaps.width < 1920 || aVCCaps.height < 1080) {
                aVCCaps.width = 1920;
                aVCCaps.height = 1080;
            }
        } else if (codecProfileLevel.level == 16384) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                aVCCaps.width = 4096;
                aVCCaps.height = 2048;
            }
        } else if (codecProfileLevel.level == 65536) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                aVCCaps.width = 4096;
                aVCCaps.height = 2048;
            }
        } else if (codecProfileLevel.level == 262144) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                aVCCaps.width = 4096;
                aVCCaps.height = 2048;
            }
        } else if (codecProfileLevel.level == 0x100000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                aVCCaps.width = 4096;
                aVCCaps.height = 4096;
            }
        } else if (codecProfileLevel.level == 0x400000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                aVCCaps.width = 4096;
                aVCCaps.height = 4096;
            }
        } else if (codecProfileLevel.level == 0x1000000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                aVCCaps.width = 4096;
                aVCCaps.height = 4096;
            }
        } else {
            QLog.e(TAG, 0, "setHevcLevel level.level = " + codecProfileLevel.level);
        }
    }

    private static void initAVCDecoderCaps() {
        List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(AndroidCodec.AVC_CODEC_MIME);
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(0), AndroidCodec.AVC_CODEC_MIME);
        gAVCDecoderCaps = new AVCCaps();
        if (codecCapabilities == null) {
            return;
        }
        for (int i2 = 0; i2 < codecCapabilities.profileLevels.length; ++i2) {
            if (codecCapabilities.profileLevels[i2].profile <= 1) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 3) {
                    NativeCodec.gAVCDecoderCaps.profile = 3;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 4) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 5) {
                    NativeCodec.gAVCDecoderCaps.profile = 5;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 8) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 5) {
                    NativeCodec.gAVCDecoderCaps.profile = 5;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 16) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 5) {
                    NativeCodec.gAVCDecoderCaps.profile = 5;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 32) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 5) {
                    NativeCodec.gAVCDecoderCaps.profile = 5;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 2) {
                if (NativeCodec.gAVCDecoderCaps.profile <= 4) {
                    NativeCodec.gAVCDecoderCaps.profile = 4;
                }
            } else if (codecCapabilities.profileLevels[i2].profile >= 64 && NativeCodec.gAVCDecoderCaps.profile <= 5) {
                NativeCodec.gAVCDecoderCaps.profile = 5;
            }
            if (codecCapabilities.profileLevels[i2].level <= 1) {
                if (NativeCodec.gAVCDecoderCaps.width >= 176 && NativeCodec.gAVCDecoderCaps.height >= 144) continue;
                NativeCodec.gAVCDecoderCaps.width = 176;
                NativeCodec.gAVCDecoderCaps.height = 144;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 2) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 288) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 4) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 288) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 8) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 288) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 16) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 288) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 32) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 288) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 64) {
                if (NativeCodec.gAVCDecoderCaps.width >= 352 && NativeCodec.gAVCDecoderCaps.height >= 576) continue;
                NativeCodec.gAVCDecoderCaps.width = 352;
                NativeCodec.gAVCDecoderCaps.height = 576;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 128) {
                if (NativeCodec.gAVCDecoderCaps.width >= 720 && NativeCodec.gAVCDecoderCaps.height >= 576) continue;
                NativeCodec.gAVCDecoderCaps.width = 720;
                NativeCodec.gAVCDecoderCaps.height = 576;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 256) {
                if (NativeCodec.gAVCDecoderCaps.width >= 720 && NativeCodec.gAVCDecoderCaps.height >= 576) continue;
                NativeCodec.gAVCDecoderCaps.width = 720;
                NativeCodec.gAVCDecoderCaps.height = 576;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 512) {
                if (NativeCodec.gAVCDecoderCaps.width >= 1280 && NativeCodec.gAVCDecoderCaps.height >= 720) continue;
                NativeCodec.gAVCDecoderCaps.width = 1280;
                NativeCodec.gAVCDecoderCaps.height = 720;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 1024) {
                if (NativeCodec.gAVCDecoderCaps.width >= 1280 && NativeCodec.gAVCDecoderCaps.height >= 1024) continue;
                NativeCodec.gAVCDecoderCaps.width = 1280;
                NativeCodec.gAVCDecoderCaps.height = 1024;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 2048) {
                if (NativeCodec.gAVCDecoderCaps.width >= 2048 && NativeCodec.gAVCDecoderCaps.height >= 1024) continue;
                NativeCodec.gAVCDecoderCaps.width = 2048;
                NativeCodec.gAVCDecoderCaps.height = 1200;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 4096) {
                if (NativeCodec.gAVCDecoderCaps.width >= 2048 && NativeCodec.gAVCDecoderCaps.height >= 1024) continue;
                NativeCodec.gAVCDecoderCaps.width = 2048;
                NativeCodec.gAVCDecoderCaps.height = 1024;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 8192) {
                if (NativeCodec.gAVCDecoderCaps.width >= 2048 && NativeCodec.gAVCDecoderCaps.height >= 1088) continue;
                NativeCodec.gAVCDecoderCaps.width = 2048;
                NativeCodec.gAVCDecoderCaps.height = 1088;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 16384) {
                if (NativeCodec.gAVCDecoderCaps.width >= 3680 && NativeCodec.gAVCDecoderCaps.height >= 1536) continue;
                NativeCodec.gAVCDecoderCaps.width = 3680;
                NativeCodec.gAVCDecoderCaps.height = 1536;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 32768) {
                if (NativeCodec.gAVCDecoderCaps.width >= 4096 && NativeCodec.gAVCDecoderCaps.height >= 2304) continue;
                NativeCodec.gAVCDecoderCaps.width = 4096;
                NativeCodec.gAVCDecoderCaps.height = 2304;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level > 32768) {
                if (NativeCodec.gAVCDecoderCaps.width >= 4096 && NativeCodec.gAVCDecoderCaps.height >= 4096) continue;
                NativeCodec.gAVCDecoderCaps.width = 4096;
                NativeCodec.gAVCDecoderCaps.height = 4096;
                continue;
            }
            QLog.e(TAG, 0, "initAVCDecoderCaps caps.profileLevels[" + i2 + "].level = " + codecCapabilities.profileLevels[i2].level);
        }
    }

    private static void initHevcDecoderCaps() {
        List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(AndroidCodec.HEVC_CODEC_MIME);
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(0), AndroidCodec.HEVC_CODEC_MIME);
        gHEVCDecoderCaps = new AVCCaps();
        if (codecCapabilities == null) {
            return;
        }
        for (int i2 = 0; i2 < codecCapabilities.profileLevels.length; ++i2) {
            if (codecCapabilities.profileLevels[i2].profile <= 1) {
                if (NativeCodec.gHEVCDecoderCaps.profile <= 1) {
                    NativeCodec.gHEVCDecoderCaps.profile = 1;
                }
            } else if (codecCapabilities.profileLevels[i2].profile == 2) {
                if (NativeCodec.gHEVCDecoderCaps.profile <= 2) {
                    NativeCodec.gHEVCDecoderCaps.profile = 2;
                }
            } else if (codecCapabilities.profileLevels[i2].profile >= 2 && NativeCodec.gHEVCDecoderCaps.profile <= 2) {
                NativeCodec.gHEVCDecoderCaps.profile = 2;
            }
            if (codecCapabilities.profileLevels[i2].level <= 1) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 352 && NativeCodec.gHEVCDecoderCaps.height >= 288) continue;
                NativeCodec.gHEVCDecoderCaps.width = 352;
                NativeCodec.gHEVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 4) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 352 && NativeCodec.gHEVCDecoderCaps.height >= 288) continue;
                NativeCodec.gHEVCDecoderCaps.width = 352;
                NativeCodec.gHEVCDecoderCaps.height = 288;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 16) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 352 && NativeCodec.gHEVCDecoderCaps.height >= 576) continue;
                NativeCodec.gHEVCDecoderCaps.width = 352;
                NativeCodec.gHEVCDecoderCaps.height = 576;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 64) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 720 && NativeCodec.gHEVCDecoderCaps.height >= 576) continue;
                NativeCodec.gHEVCDecoderCaps.width = 720;
                NativeCodec.gHEVCDecoderCaps.height = 576;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 256) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 1280 && NativeCodec.gHEVCDecoderCaps.height >= 720) continue;
                NativeCodec.gHEVCDecoderCaps.width = 1280;
                NativeCodec.gHEVCDecoderCaps.height = 720;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 1024) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 2048 && NativeCodec.gHEVCDecoderCaps.height >= 1024) continue;
                NativeCodec.gHEVCDecoderCaps.width = 2048;
                NativeCodec.gHEVCDecoderCaps.height = 1024;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 4096) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 2048 && NativeCodec.gHEVCDecoderCaps.height >= 1024) continue;
                NativeCodec.gHEVCDecoderCaps.width = 2048;
                NativeCodec.gHEVCDecoderCaps.height = 1024;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 16384) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 4096 && NativeCodec.gHEVCDecoderCaps.height >= 2304) continue;
                NativeCodec.gHEVCDecoderCaps.width = 4096;
                NativeCodec.gHEVCDecoderCaps.height = 2304;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 65536) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 4096 && NativeCodec.gHEVCDecoderCaps.height >= 2304) continue;
                NativeCodec.gHEVCDecoderCaps.width = 4096;
                NativeCodec.gHEVCDecoderCaps.height = 2304;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 262144) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 4096 && NativeCodec.gHEVCDecoderCaps.height >= 2304) continue;
                NativeCodec.gHEVCDecoderCaps.width = 4096;
                NativeCodec.gHEVCDecoderCaps.height = 2304;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 0x100000) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 8192 && NativeCodec.gHEVCDecoderCaps.height >= 4320) continue;
                NativeCodec.gHEVCDecoderCaps.width = 8192;
                NativeCodec.gHEVCDecoderCaps.height = 4320;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level == 0x400000) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 8192 && NativeCodec.gHEVCDecoderCaps.height >= 4320) continue;
                NativeCodec.gHEVCDecoderCaps.width = 8192;
                NativeCodec.gHEVCDecoderCaps.height = 4320;
                continue;
            }
            if (codecCapabilities.profileLevels[i2].level > 0x1000000) {
                if (NativeCodec.gHEVCDecoderCaps.width >= 8192 && NativeCodec.gHEVCDecoderCaps.height >= 4320) continue;
                NativeCodec.gHEVCDecoderCaps.width = 8192;
                NativeCodec.gHEVCDecoderCaps.height = 4320;
                continue;
            }
            QLog.e(TAG, 0, "initHevcDecoderCaps caps.profileLevels[" + i2 + "].level = " + codecCapabilities.profileLevels[i2].level);
        }
    }

    private static int getIntValues(String string, String string2, boolean bl) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "getIntValues mime: " + string + ", key: " + string2);
        }
        if (Build.VERSION.SDK_INT < 16) {
            return 0;
        }
        if ("supportAsync".equalsIgnoreCase(string2)) {
            mUseAsyncAPI = DeviceCheck.isSupportAsyncAPI();
            return mUseAsyncAPI ? 1 : 0;
        }
        if (string.equalsIgnoreCase(AndroidCodec.AVC_CODEC_MIME)) {
            if (bl) {
                if (gAVCDecoderCaps == null) {
                    NativeCodec.initAVCDecoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gAVCDecoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gAVCDecoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gAVCDecoderCaps.profile;
                }
            } else {
                if (gAVCEncoderCaps == null) {
                    NativeCodec.initAVCEncoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gAVCEncoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gAVCEncoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gAVCEncoderCaps.profile;
                }
            }
        } else if (string.equalsIgnoreCase(AndroidCodec.HEVC_CODEC_MIME)) {
            if (bl) {
                if (gHEVCDecoderCaps == null) {
                    NativeCodec.initHevcDecoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gHEVCDecoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gHEVCDecoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gHEVCDecoderCaps.profile;
                }
            } else {
                if (gHEVCEncoderCaps == null) {
                    NativeCodec.initHevcEncoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gHEVCEncoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gHEVCEncoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gHEVCEncoderCaps.profile;
                }
            }
        }
        return 0;
    }

    private static boolean onAttach(String string, int n2, boolean bl, Map<String, Object> map) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onAttach");
        }
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        NativeCodec nativeCodec = new NativeCodec(string, map, bl);
        if (nativeCodec.mCodec == null) {
            nativeCodec = null;
            return false;
        }
        nativeCodec.mNativeContext = n2;
        nativeCodec.attachCodec(nativeCodec);
        nativeCodec.mTimeStamp = 0L;
        nativeCodec.mTryAgainLaterCount = 0;
        nativeCodec.mLastEncFrameTime = 0L;
        nativeCodec.mLastDecFrameTime = 0L;
        nativeCodec.mTotalDecInFrameNum = 0;
        nativeCodec.mTotalDecOutFrameNum = 0;
        return nativeCodec.mCodec.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onDetach(Object object) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onDetach");
        }
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        NativeCodec nativeCodec = (NativeCodec)object;
        if (nativeCodec != null) {
            nativeCodec.detachCodec();
            nativeCodec.mTryAgainLaterCount = 0;
            nativeCodec.mTimeStamp = 0L;
            nativeCodec.mFormat = null;
            nativeCodec.mLastEncFrameTime = 0L;
            nativeCodec.mLastDecFrameTime = 0L;
            nativeCodec.mTotalDecInFrameNum = 0;
            nativeCodec.mTotalDecOutFrameNum = 0;
            List<AndroidCodec.InputBufferData> list = nativeCodec.mPendingInputBuffers;
            synchronized (list) {
                nativeCodec.mCodersExit.set(true);
                nativeCodec.mPendingInputBuffers.clear();
                nativeCodec.mDebugIndexMap.clear();
                if (nativeCodec.mDebugDelay) {
                    nativeCodec.mDebugDelayMap.clear();
                    nativeCodec.mDebugDelayMap2.clear();
                }
                if (nativeCodec.mCodec != null) {
                    try {
                        nativeCodec.mCodec.stop();
                        nativeCodec.mCodec.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    nativeCodec.mCodec = null;
                }
                nativeCodec = null;
            }
        }
    }

    private boolean setFrame(ByteBuffer byteBuffer, int n2, MediaFormat mediaFormat) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = mediaFormat.getInteger("width");
        int n10 = mediaFormat.getInteger("height");
        int n11 = mediaFormat.getInteger(LEFT);
        int n12 = mediaFormat.getInteger(RIGHT);
        int n13 = mediaFormat.getInteger(TOP);
        int n14 = mediaFormat.getInteger(BOTTOM);
        int n15 = mediaFormat.getInteger(STRIDE);
        int n16 = mediaFormat.getInteger(SLICEHEIGHT);
        int n17 = mediaFormat.getInteger("color-format");
        QLog.d(TAG, 0, "setFrame, width: " + n9);
        QLog.d(TAG, 0, "setFrame, height: " + n10);
        QLog.d(TAG, 0, "setFrame, crop_left: " + n11);
        QLog.d(TAG, 0, "setFrame, crop_right: " + n12);
        QLog.d(TAG, 0, "setFrame, crop_top: " + n13);
        QLog.d(TAG, 0, "setFrame, crop_bottom: " + n14);
        QLog.d(TAG, 0, "setFrame, stride: " + n15);
        QLog.d(TAG, 0, "setFrame, slice_height: " + n16);
        QLog.d(TAG, 0, "setFrame, colorFormat: " + n17);
        if (n16 < n10) {
            n16 = n10;
        }
        if (n15 < n9) {
            n15 = n9;
        }
        if (n17 == 2130706688) {
            n16 -= n13 / 2;
            n13 = 0;
            n11 = 0;
        }
        int n18 = n15;
        int n19 = n10;
        if (n18 < n9) {
            n18 = n9;
        }
        if ((2141391876 == n17 || 2130706433 == n17 || 2130706944 == n17) && n19 < n16) {
            n19 = n16;
        }
        if (0 == (n8 = n11 + n12 + n13 + n14)) {
            n7 = 0;
            n6 = 0;
            n5 = n9 - 1;
            n4 = n10 - 1;
        } else {
            n3 = n12 - n11 + 1;
            int n20 = n14 - n13 + 1;
            if (n18 < n3) {
                n18 = n3;
            }
            if (n19 < n20) {
                n19 = n20;
            }
            n6 = n13;
            n7 = n11;
            n5 = n12;
            n4 = n14;
        }
        if (n18 <= 0 || n19 <= 0 || n5 <= 0 || n4 <= 0) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "error decoderInfomations.");
            }
            return false;
        }
        QLog.d(TAG, 0, "setFrame, picWidth: " + n18);
        QLog.d(TAG, 0, "setFrame, picHeight: " + n19);
        long l2 = SystemClock.elapsedRealtime();
        n3 = this.readOutputDataEx(byteBuffer, n2, n18, n19, n7, n6, n5 - n7 + 1, n4 - n6 + 1, n17);
        l2 = SystemClock.elapsedRealtime() - l2;
        return n3 > 0;
    }

    private void setParameters(String string, int n2) {
        if (this.mCodec == null) {
            return;
        }
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("frame-rate")) {
            if (n2 > 0) {
                this.mFrameRate = n2;
                this.mFrameInverval = 1000000 / this.mFrameRate;
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "HWENC setParameters mFrameRate = " + this.mFrameRate);
                }
            } else {
                return;
            }
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt(string, n2);
        this.mCodec.setParameters(bundle);
    }

    private boolean onCalcDelay(int n2) {
        if (this.mDebugDelay) {
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, this.mDebugTag + " frameIndex:" + n2);
            }
            this.mDebugDelayMap2.put((long)n2, (Object)System.currentTimeMillis());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onDoCodecAsync(int n2, int n3) {
        QLog.e(TAG, 0, "Enter onDoCodecAsync.");
        if (!mUseAsyncAPI) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "NOT in async mode.");
            }
            return -1;
        }
        List<AndroidCodec.InputBufferData> list = this.mPendingInputBuffers;
        synchronized (list) {
            if (this.mCodersExit.get()) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "hardware coders exit, return.");
                }
                return 2;
            }
            if (this.mPendingInputBuffers.size() > 0) {
                AndroidCodec.InputBufferData inputBufferData;
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "InputData pendingInputBuffers exist, size: " + this.mPendingInputBuffers.size());
                }
                if ((inputBufferData = this.mPendingInputBuffers.get(0)) == null) {
                    return 2;
                }
                if (inputBufferData.buffer == null) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "inputbuffer null, return");
                    }
                    return -1;
                }
                if (inputBufferData.processing) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "curr buffer is being processed by other thread, return");
                    }
                    return 2;
                }
                int n4 = 0;
                if (this.misdecoder) {
                    n4 = this.writeInputData(inputBufferData.buffer, false);
                } else {
                    if (QLog.isColorLevel()) {
                        QLog.d(TAG, 0, "call writeInputData2 in onDoCodec");
                    }
                    n4 = this.writeInputData2(inputBufferData.buffer, this.mColorFormat, false);
                }
                if (n4 > 0) {
                    this.mLastEncFrameTime += (long)this.mFrameInverval;
                    this.mPendingInputBuffers.remove(0);
                    if (this.mDebugDelay) {
                        this.mDebugDelayMap.put(this.mLastEncFrameTime, (Object)System.currentTimeMillis());
                    }
                    this.mDebugIndexMap.put(this.mLastEncFrameTime, (Object)n3);
                    this.mCodec.queueInputBuffer(inputBufferData.index, n4, this.mLastEncFrameTime, 0);
                    return 1;
                }
                if (n4 == 0 || n4 == -1) {
                    return 0;
                }
                return -1;
            }
            return 2;
        }
    }

    private boolean onDoCodec(int n2, int n3) {
        QLog.e(TAG, 0, "Enter onDoCodec.");
        if (this.mCodec == null) {
            return false;
        }
        if (this.mTryAgainLaterCount >= 16) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "try too many times!");
            }
            return false;
        }
        try {
            AndroidCodec.BufferData bufferData = this.mCodec.getInputBuffer();
            int n4 = 0;
            while (bufferData == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "inputbuffer not available");
                }
                try {
                    bufferData = this.mCodec.getInputBuffer();
                    ++n4;
                    if (bufferData == null) {
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "inputbuffer not available, try count = " + n4);
                        }
                        if (n4 <= 60) continue;
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "inputbuffer not available, return try count = " + n4);
                        }
                        return false;
                    }
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!QLog.isColorLevel()) continue;
                    QLog.e(TAG, 0, "onDoCodec Exception", exception);
                }
            }
            int n5 = 0;
            n5 = this.misdecoder ? this.writeInputData(bufferData.buffer, false) : this.writeInputData2(bufferData.buffer, this.mColorFormat, false);
            if (n5 < 0) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "writeInputData, sampleSize < 0");
                }
                return false;
            }
            this.mLastEncFrameTime += (long)this.mFrameInverval;
            if (this.mDebugDelay) {
                this.mDebugDelayMap.put(this.mLastEncFrameTime, (Object)System.currentTimeMillis());
            }
            this.mDebugIndexMap.put(this.mLastEncFrameTime, (Object)n3);
            if (this.misdecoder) {
                ++this.mTotalDecInFrameNum;
                this.mLastDecFrameTime += 15000L;
                this.mCodec.queueInputBuffer(bufferData.index, n5, this.mLastDecFrameTime, 0);
            } else {
                this.mCodec.queueInputBuffer(bufferData.index, n5, this.mLastEncFrameTime, 0);
            }
            if (this.misdecoder) {
                AndroidCodec.BufferData bufferData2;
                if (this.mTotalDecInFrameNum == 1) {
                    bufferData2 = this.mCodec.dequeueOutputBuffer_First(TIMEOUTDECFIST_8US);
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "dequeueOutputBuffer1 begin sampleSize = " + n5 + " buff.index = " + bufferData.index + " mTotalDecInFrameNum = " + this.mTotalDecInFrameNum + " mTotalDecOutFrameNum = " + this.mTotalDecOutFrameNum);
                    }
                } else {
                    if (this.mTotalDecInFrameNum - this.mTotalDecOutFrameNum > 1) {
                        int n6 = 0;
                        int n7 = 0;
                        while (this.mTotalDecInFrameNum - this.mTotalDecOutFrameNum > 1) {
                            AndroidCodec.BufferData bufferData3 = this.mCodec.dequeueOutputBuffer_First(TIMEOUTDECFIST_3US);
                            if (bufferData3 == null) {
                                QLog.e(TAG, 0, "onDoCodec output err!");
                                return true;
                            }
                            n7 = n6 == 0 ? 20 : 10;
                            if (bufferData3.index < 0) {
                                ++this.mTryDecLaterCount;
                                if (QLog.isColorLevel()) {
                                    QLog.e(TAG, 0, "dequeueOutputBuffer2, try again later, count = " + this.mTryDecLaterCount + "mTotalDecInFrameNum = " + this.mTotalDecInFrameNum + " mTotalDecOutFrameNum = " + this.mTotalDecOutFrameNum);
                                }
                                if (this.mTryDecLaterCount < n7) continue;
                                QLog.e(TAG, 0, "dequeueOutputBuffer2, error count = " + this.mTryDecLaterCount + "ulDecDelayNumThred = " + n7);
                                this.mTryDecLaterCount = 0;
                                return true;
                            }
                            this.mTryDecLaterCount = 0;
                            if (!bufferData3.success) {
                                if (QLog.isColorLevel()) {
                                    QLog.e(TAG, 0, "onDoCodec err!");
                                }
                                return false;
                            }
                            if (bufferData3.format == null || bufferData3.buffer == null) {
                                this.mCodec.releaseOutputBuffer(bufferData3.index);
                                return false;
                            }
                            int n8 = bufferData3.format.getInteger("color-format");
                            if (!HWColorFormat.isSupportedDecodeFormats(n8)) {
                                if (QLog.isColorLevel()) {
                                    QLog.e(TAG, 0, "onDoCodec don't support format!");
                                }
                                return false;
                            }
                            ++n6;
                            this.setFrame(bufferData3.buffer, bufferData3.info.size, bufferData3.format);
                            ++this.mTotalDecOutFrameNum;
                            this.mCodec.releaseOutputBuffer(bufferData3.index);
                            bufferData3.index = -1;
                            bufferData3.success = true;
                            if (n6 != 2) continue;
                            break;
                        }
                        return true;
                    }
                    bufferData2 = this.mCodec.dequeueOutputBuffer_First(TIMEOUTDECFIST_20US);
                }
                if (bufferData2 == null) {
                    QLog.e(TAG, 0, "onDoCodec output err!");
                    return true;
                }
                if (bufferData2.index < 0) {
                    ++this.mTryDecLaterCount;
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "dequeueOutputBuffer1, try again later, count = " + this.mTryDecLaterCount);
                    }
                    this.mTryDecLaterCount = 0;
                    return true;
                }
                if (!bufferData2.success) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "onDoCodec err!");
                    }
                    return false;
                }
                if (bufferData2.format == null || bufferData2.buffer == null) {
                    this.mCodec.releaseOutputBuffer(bufferData2.index);
                    return false;
                }
                int n9 = bufferData2.format.getInteger("color-format");
                if (!HWColorFormat.isSupportedDecodeFormats(n9)) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "onDoCodec don't support format!");
                    }
                    return false;
                }
                this.setFrame(bufferData2.buffer, bufferData2.info.size, bufferData2.format);
                ++this.mTotalDecOutFrameNum;
                this.mCodec.releaseOutputBuffer(bufferData2.index);
                return true;
            }
            AndroidCodec.BufferData bufferData4 = this.mCodec.dequeueOutputBuffer();
            QLog.e(TAG, 0, "dequeueOutputBuffer() begin sampleSize = " + n5 + " buff.index = " + bufferData.index + " mLastEncFrameTime = " + this.mLastEncFrameTime);
            if (bufferData4 != null) {
                if (bufferData4.index < 0) {
                    ++this.mTryAgainLaterCount;
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "dequeueOutputBuffer, try again later, count = " + this.mTryAgainLaterCount);
                    }
                    if (this.mTryAgainLaterCount >= 16) {
                        QLog.e(TAG, 0, "dequeueOutputBuffer, error count = " + this.mTryAgainLaterCount);
                        return false;
                    }
                    return true;
                }
                this.mTryAgainLaterCount = 0;
                if (!bufferData4.success) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "onDoCodec err!");
                    }
                    return false;
                }
                if (bufferData4.format == null || bufferData4.buffer == null) {
                    this.mCodec.releaseOutputBuffer(bufferData4.index);
                    return false;
                }
                if (bufferData4.info.flags == 1) {
                    QLog.e(TAG, 0, "onDoCodec err flags!");
                }
                if (bufferData4.info.flags == 2) {
                    this.mCodec.releaseOutputBuffer(bufferData4.index);
                    this.readOutputStream(bufferData4.buffer, bufferData4.info.presentationTimeUs, bufferData4.info.offset, bufferData4.info.size, bufferData4.info.flags);
                    bufferData4 = this.mCodec.dequeueOutputBuffer();
                    if (bufferData4 != null) {
                        if (bufferData4.index < 0) {
                            ++this.mTryAgainLaterCount2;
                            if (QLog.isColorLevel()) {
                                QLog.e(TAG, 0, "re-dequeue dequeueOutputBuffer, try again later, count = " + this.mTryAgainLaterCount2);
                            }
                            return this.mTryAgainLaterCount2 < 10;
                        }
                        this.mTryAgainLaterCount2 = 0;
                        if (!bufferData4.success) {
                            if (QLog.isColorLevel()) {
                                QLog.e(TAG, 0, "re-dequeue onDoCodec err!");
                            }
                            return false;
                        }
                        if (bufferData4.format == null || bufferData4.buffer == null) {
                            this.mCodec.releaseOutputBuffer(bufferData4.index);
                            return false;
                        }
                    }
                    if (QLog.isColorLevel()) {
                        QLog.d(TAG, 0, "re-dequeue success");
                    }
                }
                if (bufferData4 != null) {
                    Long l2 = this.calcDelay(true, bufferData4.info);
                    this.readOutputStream(bufferData4.buffer, l2, bufferData4.info.offset, bufferData4.info.size, bufferData4.info.flags);
                }
                this.mCodec.releaseOutputBuffer(bufferData4.index);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "onDoCodec Exception!", exception);
            }
            return false;
        }
    }

    void setParams_impl() {
        Bundle bundle;
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "setParams_impl");
        }
        if (this.setIFramePending) {
            bundle = new Bundle();
            bundle.putInt(AndroidCodec.ForceIFrame, 1);
            this.setIFramePending = false;
            if (this.setBitRatePending > 0) {
                bundle.putInt("bitrate", this.setBitRatePending);
            }
            this.mCodec.setParameters(bundle);
            this.setBitRatePending = 0;
        }
        if (this.setBitRatePending > 0) {
            bundle = new Bundle();
            bundle.putInt("bitrate", this.setBitRatePending);
            if (this.setIFramePending) {
                bundle.putInt(AndroidCodec.ForceIFrame, 1);
            }
            this.mCodec.setParameters(bundle);
            this.setBitRatePending = 0;
            this.setIFramePending = false;
        }
    }

    public native int writeInputData(ByteBuffer var1, boolean var2);

    public native int writeInputData2(ByteBuffer var1, int var2, boolean var3);

    public native int readOutputData(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public native int readOutputStream(ByteBuffer var1, long var2, int var4, int var5, int var6);

    public native int setAVCParams(ByteBuffer var1, ByteBuffer var2);

    public native int readOutputDataEx(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public native boolean attachCodec(Object var1);

    public static native void set_device_infos(String var0);

    public native void detachCodec();

    public static native int getVersion();

    public static native boolean putByteArray2ByteBuffer(ByteBuffer var0, int var1, byte[] var2, int var3, int var4, int var5, int var6);

    static class AVCCaps {
        public int width = 0;
        public int height = 0;
        public int profile = 3;

        AVCCaps() {
        }
    }
}

