/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.provider.Settings;
import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoCaptureContext {
    private static final String TAG = "VideoCaptureContext";
    private Context mContext;
    private EGLCoreContext mEglCore;
    private CaptureThread mCaptureThread;
    private Handler mCaptureHandler;
    private DeviceAutoRotationObserver mAutoRotateObserver;
    private WindowManager mWindowMgr;
    private Display mDefaultDisplay;
    private static final boolean gSupportQuitSafely = Build.VERSION.SDK_INT >= 18;
    private List<CaptureRunnable> mPending;
    private final Object mPendingLock = gSupportQuitSafely ? null : new Object();
    private static final boolean gDebug = Platform.debug();
    private Cleanup mCleanup;
    private static final int DELAY_CLEANUP_MILLIS = 1000;
    private boolean mLocked = true;
    private boolean mDestroyed = false;

    private VideoCaptureContext(Context context) {
        this.mContext = context;
        this.mCaptureThread = new CaptureThread("VideoCapture");
        this.mCaptureThread.start();
        this.mCaptureHandler = new Handler(this.mCaptureThread.getLooper());
        if (Platform.isDebugBuild) {
            Platform.logDebug(String.format(Locale.CHINA, "mCaptureThread.%h.mCaptureHandler.%h", new Object[]{this.mCaptureThread, this.mCaptureHandler}));
        }
        if (!gSupportQuitSafely) {
            this.mPending = new ArrayList<CaptureRunnable>();
        }
        this.mAutoRotateObserver = new DeviceAutoRotationObserver(this.mCaptureHandler, this.mContext);
        this.mAutoRotateObserver.startObserver();
        this.mWindowMgr = (WindowManager)context.getSystemService("window");
    }

    @WorkerThread
    private void cleanupOnCaptureThread() {
        Platform.logInfo("cleanup start");
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
        if (this.mAutoRotateObserver != null) {
            this.mAutoRotateObserver.stopObserver();
            this.mAutoRotateObserver = null;
        }
        this.mCleanup = null;
        this.mLocked = true;
        this.mDestroyed = true;
        Platform.logInfo("cleanup end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaptureRunnable runOnCaptureThreadInternal(CaptureThreadCallback captureThreadCallback, Object object, boolean bl) {
        if (gDebug && Thread.currentThread() == this.mCaptureThread) {
            throw new RuntimeException("can not called on capture thread.");
        }
        boolean bl2 = false;
        CaptureRunnable captureRunnable = new CaptureRunnable(captureThreadCallback, object, bl);
        if (this.mCaptureHandler != null) {
            Object object2;
            if (!gSupportQuitSafely) {
                object2 = this.mPendingLock;
                synchronized (object2) {
                    this.mPending.add(captureRunnable);
                }
            }
            if (!(bl2 = this.mCaptureHandler.post((Runnable)captureRunnable)) && !gSupportQuitSafely) {
                object2 = this.mPendingLock;
                synchronized (object2) {
                    this.mPending.remove(captureRunnable);
                    if (this.mPending.isEmpty()) {
                        this.mPendingLock.notify();
                    }
                }
            }
        }
        return bl2 ? captureRunnable : null;
    }

    private synchronized int unlock() {
        int n2 = -1;
        boolean bl = this.mLocked;
        if (!bl && this.mCleanup != null) {
            int n3 = n2 = this.mCleanup.hold() ? 0 : -1;
            if (n2 == 0) {
                this.mCleanup = null;
                this.mLocked = true;
            }
        }
        Platform.logInfo(String.format(Locale.CHINA, "%h.state.%d.locked.%b", this, n2, bl));
        if (n2 == -1 && this.mDestroyed) {
            n2 = -2;
        }
        return n2;
    }

    protected synchronized boolean available() {
        return !this.mLocked && !this.mDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Platform.logInfo(String.format(Locale.CHINA, "destroy.%h", this));
        CaptureRunnable captureRunnable = null;
        VideoCaptureContext videoCaptureContext = this;
        synchronized (videoCaptureContext) {
            boolean bl = false;
            if (this.mCleanup == null || (bl = this.mCleanup.hold())) {
                if (gDebug) {
                    Platform.logDebug(String.format(Locale.CHINA, "%h.hold.%b.mLocked.%b", this, bl, this.mLocked));
                }
                if (this.mCaptureHandler != null && this.mCaptureHandler.getLooper() != null) {
                    captureRunnable = this.runOnCaptureThreadInternal(new Cleanup(), null, true);
                }
            }
            this.mCleanup = null;
        }
        if (captureRunnable != null) {
            captureRunnable.waitFor();
        }
        if (this.mCaptureHandler != null) {
            videoCaptureContext = this.mCaptureHandler.getLooper();
            if (videoCaptureContext != null) {
                if (gSupportQuitSafely) {
                    videoCaptureContext.quitSafely();
                } else {
                    Object object = this.mPendingLock;
                    synchronized (object) {
                        while (!this.mPending.isEmpty()) {
                            try {
                                this.mPendingLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    videoCaptureContext.quit();
                }
            }
            this.mCaptureHandler = null;
        }
        if (Platform.isDebugBuild) assert (this.mCaptureThread != null);
        if (this.mCaptureThread != null) {
            try {
                if (!this.mCaptureThread.quit()) {
                    Platform.logInfo((Object)((Object)this.mCaptureThread) + " has quit");
                }
                this.mCaptureThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.mCaptureThread = null;
        }
        this.mContext = null;
        this.mCleanup = null;
    }

    @WorkerThread
    protected boolean isDeviceAutoRotate() {
        if (gDebug && !this.isCaptureThread()) {
            throw new RuntimeException("should called on capture thread.");
        }
        if (this.mAutoRotateObserver != null) {
            return this.mAutoRotateObserver.isAutoRotate();
        }
        return false;
    }

    @AnyThread
    protected Handler getHandler() {
        return this.mCaptureHandler;
    }

    @WorkerThread
    protected int getDeviceOrientation() {
        if (gDebug && !this.isCaptureThread()) {
            throw new RuntimeException("should called on capture thread.");
        }
        if (this.mDefaultDisplay == null) {
            this.mDefaultDisplay = this.mWindowMgr.getDefaultDisplay();
        }
        int n2 = 0;
        if (this.mDefaultDisplay != null) {
            switch (this.mDefaultDisplay.getRotation()) {
                case 1: {
                    n2 = 90;
                    break;
                }
                case 2: {
                    n2 = 180;
                    break;
                }
                case 3: {
                    n2 = 270;
                    break;
                }
            }
        }
        return n2;
    }

    @AnyThread
    protected boolean isCaptureThread() {
        return Thread.currentThread() == this.mCaptureThread;
    }

    @AnyThread
    protected boolean runOnCaptureThread(CaptureThreadCallback captureThreadCallback, Object object, boolean bl) {
        CaptureRunnable captureRunnable = this.runOnCaptureThreadInternal(captureThreadCallback, object, bl);
        if (captureRunnable != null && bl) {
            captureRunnable.waitFor();
        }
        return captureRunnable != null;
    }

    protected static VideoCaptureContext create(Context context) {
        return new VideoCaptureContext(context);
    }

    protected static synchronized void cleanup() {
    }

    private static class DeviceOrientationEventListener
    extends OrientationEventListener {
        int mOrientation = 0;
        int mLastOrientation = -25;

        public DeviceOrientationEventListener(Context context, int n2) {
            super(context, n2);
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        public void onOrientationChanged(int n2) {
            if (n2 == -1) {
                this.mLastOrientation = n2;
                return;
            }
            if (this.mLastOrientation < 0) {
                this.mLastOrientation = 0;
            }
            if (n2 - this.mLastOrientation < 20 && n2 - this.mLastOrientation > -20) {
                return;
            }
            this.mLastOrientation = n2;
            this.mOrientation = n2 > 314 || n2 < 45 ? 0 : (n2 < 135 ? 90 : (n2 < 225 ? 180 : 270));
        }
    }

    private static class DeviceAutoRotationObserver
    extends ContentObserver {
        ContentResolver mResolver;
        boolean mAutoRotate;

        DeviceAutoRotationObserver(Handler handler, Context context) {
            super(handler);
            this.mResolver = context.getContentResolver();
            this.mAutoRotate = this.getAutoRotate();
        }

        private boolean getAutoRotate() {
            return 1 == Settings.System.getInt((ContentResolver)this.mResolver, (String)"accelerometer_rotation", (int)0);
        }

        boolean isAutoRotate() {
            return this.mAutoRotate;
        }

        public void onChange(boolean bl) {
            super.onChange(bl);
            this.mAutoRotate = this.getAutoRotate();
        }

        void startObserver() {
            this.mResolver.registerContentObserver(Settings.System.getUriFor((String)"accelerometer_rotation"), false, (ContentObserver)this);
        }

        void stopObserver() {
            this.mResolver.unregisterContentObserver((ContentObserver)this);
        }
    }

    private class Cleanup
    implements CaptureThreadCallback {
        private boolean mReleased = false;
        private boolean mHolding = false;

        private Cleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hold() {
            Cleanup cleanup = this;
            synchronized (cleanup) {
                if (!this.mReleased) {
                    this.mHolding = true;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onCaptureThreadCallback(VideoCaptureContext videoCaptureContext, Object object) {
            VideoCaptureContext videoCaptureContext2 = VideoCaptureContext.this;
            synchronized (videoCaptureContext2) {
                boolean bl;
                Cleanup cleanup = this;
                synchronized (cleanup) {
                    this.mReleased = true;
                    bl = this.mHolding;
                }
                if (!bl) {
                    VideoCaptureContext.this.cleanupOnCaptureThread();
                }
            }
        }
    }

    private class CaptureRunnable
    implements Runnable {
        CaptureThreadCallback c;
        boolean wake;
        Object obj;
        volatile boolean waitable;

        private CaptureRunnable(CaptureThreadCallback captureThreadCallback, Object object, boolean bl) {
            this.c = captureThreadCallback;
            this.obj = object;
            this.waitable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.waitable) {
                object = this;
                synchronized (object) {
                    this.c.onCaptureThreadCallback(VideoCaptureContext.this, this.obj);
                    this.wake = true;
                    this.notify();
                }
            } else {
                this.c.onCaptureThreadCallback(VideoCaptureContext.this, this.obj);
            }
            if (!gSupportQuitSafely) {
                object = VideoCaptureContext.this.mPendingLock;
                synchronized (object) {
                    VideoCaptureContext.this.mPending.remove(this);
                    if (VideoCaptureContext.this.mPending.isEmpty()) {
                        VideoCaptureContext.this.mPendingLock.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitFor() {
            if (this.waitable) {
                CaptureRunnable captureRunnable = this;
                synchronized (captureRunnable) {
                    while (!this.wake) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private class CaptureThread
    extends HandlerThread {
        private CaptureThread(String string) {
            super(string);
        }

        protected void onLooperPrepared() {
            VideoCaptureContext.this.mEglCore = new EGLCore();
            VideoCaptureContext.this.mEglCore.createContext(EGLUtil.getOffscreenContext(), false);
            VideoCaptureContext.this.mEglCore.createSurface(null);
        }
    }

    protected static interface CaptureThreadCallback {
        public void onCaptureThreadCallback(VideoCaptureContext var1, Object var2);
    }
}

