/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import com.tencent.avlab.utils.QLog;
import com.tencent.sharp.jni.AudioDeviceInterface;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class TraeMediaPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    public static final int TRAE_MEDIAPLAER_DATASOURCE_RSID = 0;
    public static final int TRAE_MEDIAPLAER_DATASOURCE_URI = 1;
    public static final int TRAE_MEDIAPLAER_DATASOURCE_FILEPATH = 2;
    public static final int TRAE_MEDIAPLAER_STOP = 100;
    private MediaPlayer mMediaPlay = null;
    private OnCompletionListener mCallback;
    private Context _context;
    private int _streamType = 0;
    private boolean _hasCall = false;
    private boolean _loop = false;
    private int _durationMS = -1;
    int _loopCount = 0;
    boolean _ringMode = false;
    private Timer _watchTimer = null;
    private TimerTask _watchTimertask = null;
    private int _prevVolume = -1;

    public TraeMediaPlayer(Context context, OnCompletionListener onCompletionListener) {
        this._context = context;
        this.mCallback = onCompletionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playRing(int n2, int n3, Uri uri, String string, boolean bl, int n4, boolean bl2, boolean bl3, int n5) {
        block47: {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "TraeMediaPlay | playRing datasource:" + n2 + " rsid:" + n3 + " uri:" + uri + " filepath:" + string + " loop:" + (bl ? "Y" : "N") + " :loopCount" + n4 + " ringMode:" + (bl2 ? "Y" : "N") + " hasCall:" + bl3 + " cst:" + n5);
            }
            if (!bl && n4 <= 0) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "TraeMediaPlay | playRing err datasource:" + n2 + " loop:" + (bl ? "Y" : "N") + " :loopCount" + n4);
                }
                return false;
            }
            try {
                try {
                    if (this.mMediaPlay != null) {
                        if (this.mMediaPlay.isPlaying()) {
                            return false;
                        }
                        try {
                            this.mMediaPlay.release();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            this.mMediaPlay = null;
                        }
                    }
                    if (this._watchTimer != null) {
                        this._watchTimer.cancel();
                        this._watchTimer = null;
                        this._watchTimertask = null;
                    }
                    AudioManager audioManager = (AudioManager)this._context.getSystemService("audio");
                    this.mMediaPlay = new MediaPlayer();
                    if (null == this.mMediaPlay) {
                        this.mMediaPlay.release();
                        this.mMediaPlay = null;
                        return false;
                    }
                    this.mMediaPlay.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                    this.mMediaPlay.setOnErrorListener((MediaPlayer.OnErrorListener)this);
                    switch (n2) {
                        case 0: {
                            AssetFileDescriptor assetFileDescriptor;
                            if (QLog.isColorLevel()) {
                                QLog.e("TRAE", 0, "TraeMediaPlay | rsid:" + n3);
                            }
                            if ((assetFileDescriptor = this._context.getResources().openRawResourceFd(n3)) == null) {
                                if (QLog.isColorLevel()) {
                                    QLog.e("TRAE", 0, "TraeMediaPlay | afd == null rsid:" + n3);
                                }
                                this.mMediaPlay.release();
                                this.mMediaPlay = null;
                                return false;
                            }
                            this.mMediaPlay.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
                            assetFileDescriptor.close();
                            break;
                        }
                        case 1: {
                            if (QLog.isColorLevel()) {
                                QLog.e("TRAE", 0, "TraeMediaPlay | uri:" + uri);
                            }
                            this.mMediaPlay.setDataSource(this._context, uri);
                            break;
                        }
                        case 2: {
                            if (QLog.isColorLevel()) {
                                QLog.e("TRAE", 0, "TraeMediaPlay | FilePath:" + string);
                            }
                            this.mMediaPlay.setDataSource(string);
                            break;
                        }
                        default: {
                            if (QLog.isColorLevel()) {
                                QLog.e("TRAE", 0, "TraeMediaPlay | err datasource:" + n2);
                            }
                            this.mMediaPlay.release();
                            this.mMediaPlay = null;
                        }
                    }
                    if (this.mMediaPlay == null) {
                        return false;
                    }
                    this._ringMode = bl2;
                    int n6 = 0;
                    if (this._ringMode) {
                        this._streamType = 2;
                        n6 = 1;
                    } else {
                        this._streamType = 0;
                        if (Build.VERSION.SDK_INT >= 11) {
                            n6 = 3;
                        }
                    }
                    this._hasCall = bl3;
                    if (this._hasCall) {
                        this._streamType = n5;
                    }
                    this.mMediaPlay.setAudioStreamType(this._streamType);
                    this.mMediaPlay.prepare();
                    this.mMediaPlay.setLooping(bl);
                    this.mMediaPlay.start();
                    this._loop = bl;
                    if (this._loop) {
                        this._loopCount = 1;
                        this._durationMS = -1;
                    } else {
                        this._loopCount = n4;
                        this._durationMS = this._loopCount * this.mMediaPlay.getDuration();
                    }
                    --this._loopCount;
                    if (!this._hasCall) {
                        audioManager.setMode(n6);
                    }
                    if (this._durationMS > 0) {
                        this._watchTimer = new Timer();
                        this._watchTimertask = new TimerTask(){

                            @Override
                            public void run() {
                                if (TraeMediaPlayer.this.mMediaPlay != null) {
                                    if (QLog.isColorLevel()) {
                                        QLog.e("TRAE", 0, "TraeMediaPlay | play timeout");
                                    }
                                    if (null != TraeMediaPlayer.this.mCallback) {
                                        TraeMediaPlayer.this.mCallback.onCompletion();
                                    }
                                }
                            }
                        };
                        this._watchTimer.schedule(this._watchTimertask, this._durationMS + 1000);
                    }
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 0, "TraeMediaPlay | DurationMS:" + this.mMediaPlay.getDuration() + " loop:" + bl);
                    }
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    if (QLog.isColorLevel()) {
                        QLog.d("TRAE", 0, "TraeMediaPlay | IllegalStateException: " + illegalStateException.getLocalizedMessage() + " " + illegalStateException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    if (QLog.isColorLevel()) {
                        QLog.d("TRAE", 0, "TraeMediaPlay | IOException: " + iOException.getLocalizedMessage() + " " + iOException.getMessage());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        QLog.d("TRAE", 0, "TraeMediaPlay | IllegalArgumentException: " + illegalArgumentException.getLocalizedMessage() + " " + illegalArgumentException.getMessage());
                    }
                }
                catch (SecurityException securityException) {
                    if (QLog.isColorLevel()) {
                        QLog.d("TRAE", 0, "TraeMediaPlay | SecurityException: " + securityException.getLocalizedMessage() + " " + securityException.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block47;
                QLog.d("TRAE", 0, "TraeMediaPlay | Except: " + exception.getLocalizedMessage() + " " + exception.getMessage());
            }
        }
        try {
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        return false;
    }

    public void stopRing() {
        if (QLog.isColorLevel()) {
            QLog.d("TRAE", 0, "TraeMediaPlay stopRing ");
        }
        if (null == this.mMediaPlay) {
            return;
        }
        if (this.mMediaPlay.isPlaying()) {
            this.mMediaPlay.stop();
        }
        this.mMediaPlay.reset();
        try {
            if (this._watchTimer != null) {
                this._watchTimer.cancel();
                this._watchTimer = null;
                this._watchTimertask = null;
            }
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        this._durationMS = -1;
    }

    public int getStreamType() {
        return this._streamType;
    }

    public int getDuration() {
        return this._durationMS;
    }

    public boolean hasCall() {
        return this._hasCall;
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        AudioDeviceInterface.LogTraceEntry(" cb:" + this.mCallback + " loopCount:" + this._loopCount + " _loop:" + this._loop);
        if (this._loop) {
            if (QLog.isColorLevel()) {
                QLog.d("TRAE", 0, "loop play,continue...");
            }
            return;
        }
        try {
            if (this._loopCount <= 0) {
                this.volumeUndo();
                if (this.mMediaPlay.isPlaying()) {
                    this.mMediaPlay.stop();
                }
                this.mMediaPlay.reset();
                this.mMediaPlay.release();
                this.mMediaPlay = null;
                if (null != this.mCallback) {
                    this.mCallback.onCompletion();
                }
            } else {
                this.mMediaPlay.start();
                --this._loopCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        AudioDeviceInterface.LogTraceEntry(" cb:" + this.mCallback + " arg1:" + n2 + " arg2:" + n3);
        try {
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        if (null != this.mCallback) {
            this.mCallback.onCompletion();
        }
        AudioDeviceInterface.LogTraceExit();
        return false;
    }

    private void volumeDo() {
        if (this.mMediaPlay == null || !this._ringMode || this._streamType == 2) {
            return;
        }
        try {
            AudioManager audioManager = (AudioManager)this._context.getSystemService("audio");
            int n2 = audioManager.getStreamVolume(this._streamType);
            int n3 = audioManager.getStreamMaxVolume(this._streamType);
            int n4 = audioManager.getStreamVolume(2);
            int n5 = audioManager.getStreamMaxVolume(2);
            int n6 = (int)((double)n4 * 1.0 / (double)n5 * (double)n3);
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "TraeMediaPlay volumeDo currV:" + n2 + " maxV:" + n3 + " currRV:" + n4 + " maxRV:" + n5 + " setV:" + n6);
            }
            n6 = n6 + 1 >= n3 ? n3 : ++n6;
            audioManager.setStreamVolume(this._streamType, n6, 0);
            this._prevVolume = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void volumeUndo() {
        if (this.mMediaPlay == null || !this._ringMode || this._streamType == 2 || this._prevVolume == -1) {
            return;
        }
        try {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "TraeMediaPlay volumeUndo _prevVolume:" + this._prevVolume);
            }
            AudioManager audioManager = (AudioManager)this._context.getSystemService("audio");
            audioManager.setStreamVolume(this._streamType, this._prevVolume, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface OnCompletionListener {
        public void onCompletion();
    }
}

