/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tiw.logger.http;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClient {
    private static final String TAG = HttpClient.class.getSimpleName();
    public static final int HTTP_ACTION_REQUEST = 0;
    public static final int HTTP_ACTION_RESPONSE = 1;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAX_POOL_SIZE = 2 * CPU_COUNT + 1;
    private static final long KEEP_ALIVE = 5L;
    private static TrustManager[] mTrustManagers = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            try {
                chain[0].checkValidity();
            }
            catch (CertificateExpiredException e) {
                e.printStackTrace();
            }
            catch (CertificateNotYetValidException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            try {
                chain[0].checkValidity();
            }
            catch (CertificateExpiredException e) {
                e.printStackTrace();
            }
            catch (CertificateNotYetValidException e) {
                e.printStackTrace();
            }
        }
    }};
    private static HostnameVerifier mHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return hostname.contains("cloud") || hostname.contains("tim");
        }
    };
    private static final Executor mThreadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private static native void nativeProgressCallback(int var0, int var1, int var2, long var3);

    private static native void nativeResponseCallback(int var0, Map<String, String> var1, byte[] var2, long var3, long var5);

    private static void httpRequest(final String method, final String url, final Map<String, String> headers, final byte[] content, final String uploadFile, final String downloadFile, final HttpRequestListener listener, final String proxyHost, final int proxyPort, final int connectTimeout, final int recvTimeout) {
        Runnable requestRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection conn = null;
                InputStream responseInputStream = null;
                int code = 200;
                HashMap<String, String> rspHeaders = new HashMap<String, String>();
                byte[] response = null;
                try {
                    boolean hasDownloadFile;
                    int totalSize;
                    boolean hasOutput;
                    if (!proxyHost.isEmpty() && proxyPort != 0) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                        conn = (HttpURLConnection)new URL(url).openConnection(proxy);
                    } else {
                        conn = (HttpURLConnection)new URL(url).openConnection();
                    }
                    boolean useHttps = url.startsWith("https");
                    if (useHttps) {
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, mTrustManagers, null);
                        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conn;
                        httpsURLConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                        httpsURLConnection.setHostnameVerifier(mHostnameVerifier);
                    }
                    conn.setRequestMethod(method);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setReadTimeout(recvTimeout);
                    conn.setUseCaches(false);
                    conn.setDoInput(true);
                    if (headers != null) {
                        for (Map.Entry entry : headers.entrySet()) {
                            conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    boolean hasContent = content != null && content.length > 0;
                    boolean bl = uploadFile != null && uploadFile.length() != 0;
                    boolean bl2 = hasOutput = hasContent || bl;
                    if (!method.equalsIgnoreCase("GET") && hasOutput) {
                        conn.setDoOutput(true);
                        InputStream inputStream = null;
                        inputStream = bl ? new FileInputStream(uploadFile) : new ByteArrayInputStream(content);
                        if (inputStream != null) {
                            int len;
                            totalSize = inputStream.available();
                            conn.setFixedLengthStreamingMode(totalSize);
                            int bytesTransferred = 0;
                            byte[] buf = new byte[4096];
                            while ((len = inputStream.read(buf)) >= 0) {
                                bytesTransferred += len;
                                conn.getOutputStream().write(buf, 0, len);
                                if (listener == null) continue;
                                listener.onProgress(0, bytesTransferred, totalSize);
                            }
                            inputStream.close();
                        }
                    }
                    code = conn.getResponseCode();
                    int headerCount = conn.getHeaderFields().size();
                    if (headerCount > 0) {
                        for (int i = 0; i < headerCount; ++i) {
                            String key = conn.getHeaderFieldKey(i);
                            if (key == null) continue;
                            String value = conn.getHeaderField(i);
                            rspHeaders.put(key, value);
                        }
                    }
                    if ((totalSize = conn.getContentLength()) == -1) {
                        totalSize = 0;
                    }
                    boolean bl3 = hasDownloadFile = downloadFile != null && downloadFile.length() != 0;
                    if (code == 200) {
                        responseInputStream = new BufferedInputStream(conn.getInputStream());
                        OutputStream outputStream = null;
                        outputStream = hasDownloadFile ? new FileOutputStream(downloadFile) : new ByteArrayOutputStream();
                        if (outputStream != null) {
                            int len;
                            int bytesReceived = 0;
                            byte[] buf = new byte[4096];
                            while ((len = responseInputStream.read(buf)) >= 0) {
                                bytesReceived += len;
                                outputStream.write(buf, 0, len);
                                if (listener == null) continue;
                                listener.onProgress(1, bytesReceived, totalSize);
                            }
                            response = hasDownloadFile ? new byte[]{} : ((ByteArrayOutputStream)outputStream).toByteArray();
                            outputStream.close();
                        }
                    }
                }
                catch (UnknownHostException e) {
                    code = 404;
                }
                catch (Exception e) {
                    code = -1;
                    response = Log.getStackTraceString((Throwable)e).getBytes();
                }
                finally {
                    if (responseInputStream != null) {
                        try {
                            responseInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (listener != null) {
                        listener.onCompleted(code, rspHeaders, response);
                    }
                }
            }
        };
        mThreadPoolExecutor.execute(requestRunnable);
    }

    public static void httpRequest(String method, String url, Map<String, String> headers, byte[] content, String uploadFile, String downloadFile, final long progressCallback, final long responseCallback, String proxyHost, int proxyPort) {
        HttpClient.httpRequest(method, url, headers, content, uploadFile, downloadFile, new HttpRequestListener(){

            @Override
            public void onProgress(int action, int currentSize, int totalSize) {
                if (progressCallback != 0L) {
                    try {
                        HttpClient.nativeProgressCallback(action, currentSize, totalSize, progressCallback);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void onCompleted(int code, Map<String, String> headers, byte[] response) {
                if (responseCallback != 0L) {
                    try {
                        HttpClient.nativeResponseCallback(code, headers, response, progressCallback, responseCallback);
                    }
                    catch (UnsatisfiedLinkError e) {
                        Log.i((String)TAG, (String)"onCompleted: ");
                    }
                }
            }
        }, proxyHost, proxyPort, 5000, 10000);
    }

    public static interface HttpRequestListener {
        public void onProgress(int var1, int var2, int var3);

        public void onCompleted(int var1, Map<String, String> var2, byte[] var3);
    }
}

