/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tiw.logger;

import android.content.Context;
import android.util.Log;
import com.tencent.tiw.logger.TIWLogParam;
import com.tencent.tiw.logger.TIWLoggerConfig;
import com.tencent.tiw.logger.TIWReportParam;
import com.tencent.tiw.logger.logger.Logger;
import com.tencent.tiw.logger.util.Util;

public class TIWLoggerImpl {
    private Logger logger = new Logger();
    private Context context;

    public TIWLoggerImpl(Context context) {
        this.context = context.getApplicationContext();
        Util.init(this.context);
    }

    public void setConfig(TIWLoggerConfig config) {
        this.logger.setConfig(config);
    }

    public void log(int level, String tag, String content) {
        switch (level) {
            case 1: {
                Log.d((String)tag, (String)content);
                break;
            }
            case 2: {
                Log.i((String)tag, (String)content);
                break;
            }
            case 3: {
                Log.w((String)tag, (String)content);
                break;
            }
            case 4: {
                Log.e((String)tag, (String)content);
                break;
            }
            case 5: {
                Log.e((String)tag, (String)content);
                break;
            }
        }
        TIWLogParam param = new TIWLogParam();
        param.level = level;
        param.module = tag;
        param.content = content;
        param.funcName = "";
        param.fileName = "";
        this.logger.log(param);
    }

    public void reportStart(String label) {
        this.logger.reportStart(label);
    }

    public void reportEnded(String label, TIWReportParam param) {
        this.logger.reportEnded(label, param);
    }

    public void report(TIWReportParam param) {
        this.logger.report(param);
    }

    public static String getVersion() {
        return "1.0.1.11";
    }

    public String getSessionId() {
        return this.logger.getSessionId();
    }

    public String getGlobalRandom() {
        return this.logger.getGlobalRandom();
    }
}

