/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.ziputils.ziputil;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class AlignedZipOutputStream
extends DeflaterOutputStream {
    private static final long LOCSIG = 67324752L;
    private static final long EXTSIG = 134695760L;
    private static final long CENSIG = 33639248L;
    private static final long ENDSIG = 101010256L;
    private static final int LOCHDR = 30;
    private static final int EXTHDR = 16;
    private static final int MOD_DATE_CONST = 33;
    private static final int TIME_CONST = 0;
    private static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    private static final int GPBF_UTF8_FLAG = 2048;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte[] ONE_ELEM_BYTE_ARRAY = new byte[]{0};
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private static final int ZIPLocalHeaderVersionNeeded = 20;
    private byte[] commentBytes = EMPTY_BYTE_ARRAY;
    private final HashSet<String> entries = new HashSet();
    private int defaultCompressionMethod = 8;
    private int compressionLevel = -1;
    private ByteArrayOutputStream cDir = new ByteArrayOutputStream();
    private ZipEntry currentEntry;
    private final CRC32 crc = new CRC32();
    private long crcDataSize = 0L;
    private int offset = 0;
    private int nameLength;
    private byte[] nameBytes;
    private boolean finished = false;
    private boolean closed = false;
    private final int alignBytes;
    private int padding = 0;

    public AlignedZipOutputStream(OutputStream os) {
        this(os, 4);
    }

    public AlignedZipOutputStream(OutputStream os, int alignBytes) {
        super(os, new Deflater(-1, true));
        this.alignBytes = alignBytes;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.def.end();
            this.out.close();
            this.out = null;
            this.closed = true;
        }
    }

    public void closeEntry() throws IOException {
        this.checkOpen();
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry.getMethod() == 8) {
            super.finish();
        }
        if (this.currentEntry.getMethod() == 0) {
            if (this.crc.getValue() != this.currentEntry.getCrc()) {
                throw new ZipException("CRC mismatch");
            }
            if (this.currentEntry.getSize() != this.crcDataSize) {
                throw new ZipException("Size mismatch");
            }
        }
        int curOffset = 30;
        if (this.currentEntry.getMethod() != 0) {
            curOffset += 16;
            this.writeLong(this.out, 134695760L);
            this.currentEntry.setCrc(this.crc.getValue());
            this.writeLong(this.out, this.currentEntry.getCrc());
            this.currentEntry.setCompressedSize(this.def.getTotalOut());
            this.writeLong(this.out, this.currentEntry.getCompressedSize());
            this.currentEntry.setSize(this.def.getTotalIn());
            this.writeLong(this.out, this.currentEntry.getSize());
        }
        int flags = this.currentEntry.getMethod() == 0 ? 0 : 8;
        flags |= 0x800;
        this.writeLong(this.cDir, 33639248L);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, flags);
        this.writeShort(this.cDir, this.currentEntry.getMethod());
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 33);
        this.writeLong(this.cDir, this.crc.getValue());
        if (this.currentEntry.getMethod() == 8) {
            curOffset = (int)((long)curOffset + this.writeLong(this.cDir, this.def.getTotalOut()));
            this.writeLong(this.cDir, this.def.getTotalIn());
        } else {
            curOffset = (int)((long)curOffset + this.writeLong(this.cDir, this.crcDataSize));
            this.writeLong(this.cDir, this.crcDataSize);
        }
        curOffset += this.writeShort(this.cDir, this.nameLength);
        if (this.currentEntry.getExtra() != null) {
            curOffset += this.writeShort(this.cDir, this.currentEntry.getExtra().length);
        } else {
            this.writeShort(this.cDir, 0);
        }
        String comment = this.currentEntry.getComment();
        byte[] commentBytes = EMPTY_BYTE_ARRAY;
        if (comment != null) {
            commentBytes = comment.getBytes(Charset.forName("UTF-8"));
        }
        this.writeShort(this.cDir, commentBytes.length);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeLong(this.cDir, 0L);
        this.writeLong(this.cDir, this.offset);
        this.cDir.write(this.nameBytes);
        this.nameBytes = null;
        if (this.currentEntry.getExtra() != null) {
            this.cDir.write(this.currentEntry.getExtra());
        }
        this.offset += curOffset + this.padding;
        this.padding = 0;
        if (commentBytes.length > 0) {
            this.cDir.write(commentBytes);
        }
        this.currentEntry = null;
        this.crc.reset();
        this.crcDataSize = 0L;
        this.def.reset();
    }

    @Override
    public void finish() throws IOException {
        this.checkOpen();
        if (this.finished) {
            return;
        }
        if (this.entries.isEmpty()) {
            throw new ZipException("No entries");
        }
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        int cdirSize = this.cDir.size();
        this.writeLong(this.cDir, 101010256L);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, this.entries.size());
        this.writeShort(this.cDir, this.entries.size());
        this.writeLong(this.cDir, cdirSize);
        this.writeLong(this.cDir, this.offset + this.padding);
        this.writeShort(this.cDir, this.commentBytes.length);
        if (this.commentBytes.length > 0) {
            this.cDir.write(this.commentBytes);
        }
        this.cDir.writeTo(this.out);
        this.cDir = null;
        this.finished = true;
    }

    private int getPaddingByteCount(ZipEntry entry, int entryFileOffset) {
        if (entry.getMethod() != 0 || this.alignBytes == 0) {
            return 0;
        }
        return (this.alignBytes - entryFileOffset % this.alignBytes) % this.alignBytes;
    }

    private void makePaddingToStream(OutputStream os, int padding) throws IOException {
        if (padding <= 0) {
            return;
        }
        while (padding-- > 0) {
            os.write(0);
        }
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        int method;
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if ((method = ze.getMethod()) == -1) {
            method = this.defaultCompressionMethod;
        }
        if (method == 0) {
            if (ze.getCompressedSize() == -1L) {
                ze.setCompressedSize(ze.getSize());
            } else if (ze.getSize() == -1L) {
                ze.setSize(ze.getCompressedSize());
            }
            if (ze.getCrc() == -1L) {
                throw new ZipException("STORED entry missing CRC");
            }
            if (ze.getSize() == -1L) {
                throw new ZipException("STORED entry missing size");
            }
            if (ze.getSize() != ze.getCompressedSize()) {
                throw new ZipException("STORED entry size/compressed size mismatch");
            }
        }
        this.checkOpen();
        if (this.entries.contains(ze.getName())) {
            throw new ZipException("Entry already exists: " + ze.getName());
        }
        if (this.entries.size() == 65535) {
            throw new ZipException("Too many entries for the zip file format's 16-bit entry count");
        }
        this.nameBytes = ze.getName().getBytes(Charset.forName("UTF-8"));
        this.nameLength = this.nameBytes.length;
        if (this.nameLength > 65535) {
            throw new IllegalArgumentException("Name too long: " + this.nameLength + " UTF-8 bytes");
        }
        this.def.setLevel(this.compressionLevel);
        ze.setMethod(method);
        this.currentEntry = ze;
        this.entries.add(this.currentEntry.getName());
        int flags = method == 0 ? 0 : 8;
        this.writeLong(this.out, 67324752L);
        this.writeShort(this.out, 20);
        this.writeShort(this.out, flags |= 0x800);
        this.writeShort(this.out, method);
        if (this.currentEntry.getTime() == -1L) {
            this.currentEntry.setTime(System.currentTimeMillis());
        }
        this.writeShort(this.out, 0);
        this.writeShort(this.out, 33);
        if (method == 0) {
            this.writeLong(this.out, this.currentEntry.getCrc());
            this.writeLong(this.out, this.currentEntry.getSize());
            this.writeLong(this.out, this.currentEntry.getSize());
        } else {
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
        }
        this.writeShort(this.out, this.nameLength);
        int currDataOffset = this.offset + 30 + this.nameLength + (this.currentEntry.getExtra() != null ? this.currentEntry.getExtra().length : 0);
        this.padding = this.getPaddingByteCount(this.currentEntry, currDataOffset);
        if (this.currentEntry.getExtra() != null) {
            this.writeShort(this.out, this.currentEntry.getExtra().length + this.padding);
        } else {
            this.writeShort(this.out, this.padding);
        }
        this.out.write(this.nameBytes);
        if (this.currentEntry.getExtra() != null) {
            this.out.write(this.currentEntry.getExtra());
        }
        this.makePaddingToStream(this.out, this.padding);
    }

    public void setComment(String comment) {
        if (comment == null) {
            this.commentBytes = null;
            return;
        }
        byte[] newCommentBytes = comment.getBytes(Charset.forName("UTF-8"));
        if (newCommentBytes.length > 65535) {
            throw new IllegalArgumentException("Comment too long: " + newCommentBytes.length + " bytes");
        }
        this.commentBytes = newCommentBytes;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Bad level: " + level);
        }
        this.compressionLevel = level;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Bad method: " + method);
        }
        this.defaultCompressionMethod = method;
    }

    private long writeLong(OutputStream os, long i) throws IOException {
        os.write((int)(i & 0xFFL));
        os.write((int)(i >> 8) & 0xFF);
        os.write((int)(i >> 16) & 0xFF);
        os.write((int)(i >> 24) & 0xFF);
        return i;
    }

    private int writeShort(OutputStream os, int i) throws IOException {
        if (i > 65535) {
            throw new IllegalArgumentException("value " + i + " is too large for type 'short'.");
        }
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        return i;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = ONE_ELEM_BYTE_ARRAY;
        buf[0] = (byte)(b & 0xFF);
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int byteCount) throws IOException {
        this.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.currentEntry == null) {
            throw new ZipException("No active entry");
        }
        if (this.currentEntry.getMethod() == 0) {
            this.out.write(buffer, offset, byteCount);
        } else {
            super.write(buffer, offset, byteCount);
        }
        this.crc.update(buffer, offset, byteCount);
        this.crcDataSize += (long)byteCount;
    }

    private void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }
}

