/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.builder;

import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.util.ArrayList;

public class PatchBuilder {
    private static final String PATCH_NAME = "patch";
    private final Configuration config;
    private File unSignedApk;
    private File signedApk;
    private File signedWith7ZipApk;
    private File sevenZipOutPutDir;

    public PatchBuilder(Configuration config) {
        this.config = config;
        this.unSignedApk = new File(config.mOutFolder, "patch_unsigned.apk");
        this.signedApk = new File(config.mOutFolder, "patch_signed.apk");
        this.signedWith7ZipApk = new File(config.mOutFolder, "patch_signed_7zip.apk");
        this.sevenZipOutPutDir = new File(config.mOutFolder, "out_7zip");
    }

    public void buildPatch() throws Exception {
        File resultDir = this.config.mTempResultDir;
        if (!resultDir.exists()) {
            throw new IOException(String.format("Missing patch unzip files, path=%s\n", resultDir.getAbsolutePath()));
        }
        if (resultDir.listFiles().length == 0) {
            return;
        }
        this.generateUnsignedApk(this.unSignedApk);
        this.signApk(this.unSignedApk, this.signedApk);
        this.use7zApk(this.signedApk, this.signedWith7ZipApk, this.sevenZipOutPutDir);
        if (!this.signedApk.exists()) {
            Logger.e("Result: final unsigned patch result: %s, size=%d", this.unSignedApk.getAbsolutePath(), this.unSignedApk.length());
        } else {
            long length = this.signedApk.length();
            Logger.e("Result: final signed patch result: %s, size=%d", this.signedApk.getAbsolutePath(), length);
            if (this.signedWith7ZipApk.exists()) {
                long length7zip = this.signedWith7ZipApk.length();
                Logger.e("Result: final signed with 7zip patch result: %s, size=%d", this.signedWith7ZipApk.getAbsolutePath(), length7zip);
                if (length7zip > length) {
                    Logger.e("Warning: %s is bigger than %s %d byte, you should choose %s at these time!", this.signedWith7ZipApk.getName(), this.signedApk.getName(), length7zip - length, this.signedApk.getName());
                }
            }
        }
    }

    private String getSignatureAlgorithm() throws Exception {
        String signatureAlgorithm;
        FileInputStream fileIn = new FileInputStream(this.config.mSignatureFile);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fileIn, this.config.mStorePass.toCharArray());
        Key key = keyStore.getKey(this.config.mStoreAlias, this.config.mKeyPass.toCharArray());
        String keyAlgorithm = key.getAlgorithm();
        if (keyAlgorithm.equalsIgnoreCase("DSA")) {
            signatureAlgorithm = "SHA1withDSA";
        } else if (keyAlgorithm.equalsIgnoreCase("RSA")) {
            signatureAlgorithm = "SHA1withRSA";
        } else if (keyAlgorithm.equalsIgnoreCase("EC")) {
            signatureAlgorithm = "SHA1withECDSA";
        } else {
            throw new RuntimeException("private key is not a DSA or RSA key");
        }
        return signatureAlgorithm;
    }

    private void signApk(File input, File output) throws Exception {
        if (this.config.mUseSignAPk) {
            Logger.d("Signing apk: %s", output.getName());
            String signatureAlgorithm = this.getSignatureAlgorithm();
            Logger.d("Signing key algorithm is %s", signatureAlgorithm);
            if (output.exists()) {
                output.delete();
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("jarsigner");
            command.add("-sigalg");
            command.add(signatureAlgorithm);
            command.add("-digestalg");
            command.add("SHA1");
            command.add("-keystore");
            command.add(this.config.mSignatureFile.getAbsolutePath());
            command.add("-storepass");
            command.add(this.config.mStorePass);
            command.add("-keypass");
            command.add(this.config.mKeyPass);
            command.add("-signedjar");
            command.add(output.getAbsolutePath());
            command.add(input.getAbsolutePath());
            command.add(this.config.mStoreAlias);
            Process process = new ProcessBuilder(command).start();
            process.waitFor();
            process.destroy();
            if (!output.exists()) {
                throw new IOException("Can't Generate signed APK. Please check if your sign info is correct.");
            }
        }
    }

    private void generateUnsignedApk(File output) throws IOException {
        Logger.d("Generate unsigned apk: %s", output.getName());
        File tempOutDir = this.config.mTempResultDir;
        if (!tempOutDir.exists()) {
            throw new IOException(String.format("Missing patch unzip files, path=%s\n", tempOutDir.getAbsolutePath()));
        }
        FileOperation.zipInputDir(tempOutDir, output, null);
        if (!output.exists()) {
            throw new IOException(String.format("can not found the unsigned apk file path=%s", output.getAbsolutePath()));
        }
    }

    private void use7zApk(File inputSignedFile, File out7zipFile, File tempFilesDir) throws IOException {
        if (!this.config.mUseSignAPk) {
            return;
        }
        if (!inputSignedFile.exists()) {
            throw new IOException(String.format("can not found the signed apk file to 7z, if you want to use 7z, you must fill the sign data in the config file path=%s", inputSignedFile.getAbsolutePath()));
        }
        Logger.d("Try use 7za to compress the patch file: %s, will cost much more time", out7zipFile.getName());
        Logger.d("Current 7za path:%s", this.config.mSevenZipPath);
        FileOperation.unZipAPk(inputSignedFile.getAbsolutePath(), tempFilesDir.getAbsolutePath());
        if (!FileOperation.sevenZipInputDir(tempFilesDir, out7zipFile, this.config)) {
            return;
        }
        FileOperation.deleteDir(tempFilesDir);
        if (!out7zipFile.exists()) {
            throw new IOException(String.format("[use7zApk]7z repackage signed apk fail,you must install 7z command line version first, linux: p7zip, window: 7za, path=%s", out7zipFile.getAbsolutePath()));
        }
    }
}

