/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.tencent.tinker.build.aapt.AaptResourceCollector;
import com.tencent.tinker.build.aapt.FileUtil;
import com.tencent.tinker.build.aapt.ObjectUtil;
import com.tencent.tinker.build.aapt.RDotTxtEntry;
import com.tencent.tinker.build.aapt.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatchUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> readRTxt(String rTxtFullFilename) {
        HashMap<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap = new HashMap<RDotTxtEntry.RType, Set<RDotTxtEntry>>();
        if (StringUtil.isNotBlank(rTxtFullFilename) && FileUtil.isExist(rTxtFullFilename)) {
            BufferedReader bufferedReader = null;
            try {
                Pattern textSymbolLine = Pattern.compile("(\\S+) (\\S+) (\\S+) (.+)");
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(rTxtFullFilename)));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    Matcher matcher = textSymbolLine.matcher(line);
                    if (!matcher.matches()) continue;
                    RDotTxtEntry.IdType idType = RDotTxtEntry.IdType.from(matcher.group(1));
                    RDotTxtEntry.RType rType = RDotTxtEntry.RType.valueOf(matcher.group(2).toUpperCase());
                    String name = matcher.group(3);
                    String idValue = matcher.group(4);
                    RDotTxtEntry rDotTxtEntry = new RDotTxtEntry(idType, rType, name, idValue);
                    Set<RDotTxtEntry> hashSet = null;
                    if (rTypeResourceMap.containsKey((Object)rType)) {
                        hashSet = (Set)rTypeResourceMap.get((Object)rType);
                    } else {
                        hashSet = new HashSet();
                        rTypeResourceMap.put(rType, hashSet);
                    }
                    hashSet.add(rDotTxtEntry);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return rTypeResourceMap;
    }

    public static void generatePublicResourceXml(AaptResourceCollector aaptResourceCollector, String outputIdsXmlFullFilename, String outputPublicXmlFullFilename) {
        if (aaptResourceCollector == null) {
            return;
        }
        FileUtil.createFile(outputIdsXmlFullFilename);
        FileUtil.createFile(outputPublicXmlFullFilename);
        PrintWriter idsWriter = null;
        PrintWriter publicWriter = null;
        try {
            FileUtil.createFile(outputIdsXmlFullFilename);
            FileUtil.createFile(outputPublicXmlFullFilename);
            idsWriter = new PrintWriter(new File(outputIdsXmlFullFilename), "UTF-8");
            publicWriter = new PrintWriter(new File(outputPublicXmlFullFilename), "UTF-8");
            idsWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            publicWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            idsWriter.println("<resources>");
            publicWriter.println("<resources>");
            Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> map = aaptResourceCollector.getRTypeResourceMap();
            for (Map.Entry<RDotTxtEntry.RType, Set<RDotTxtEntry>> entry : map.entrySet()) {
                RDotTxtEntry.RType rType = entry.getKey();
                if (!rType.equals((Object)RDotTxtEntry.RType.STYLEABLE)) {
                    Set<RDotTxtEntry> set = entry.getValue();
                    for (RDotTxtEntry rDotTxtEntry : set) {
                        String rawName = aaptResourceCollector.getRawName(rType, rDotTxtEntry.name);
                        if (StringUtil.isBlank(rawName)) {
                            rawName = rDotTxtEntry.name;
                        }
                        publicWriter.println("<public type=\"" + (Object)((Object)rType) + "\" name=\"" + rawName + "\" id=\"" + rDotTxtEntry.idValue.trim() + "\" />");
                    }
                    Set<String> ignoreIdSet = aaptResourceCollector.getIgnoreIdSet();
                    for (RDotTxtEntry rDotTxtEntry : set) {
                        if (rType.equals((Object)RDotTxtEntry.RType.ID) && !ignoreIdSet.contains(rDotTxtEntry.name)) {
                            idsWriter.println("<item type=\"" + (Object)((Object)rType) + "\" name=\"" + rDotTxtEntry.name + "\"/>");
                            continue;
                        }
                        if (rType.equals((Object)RDotTxtEntry.RType.STYLE) && rDotTxtEntry.name.indexOf("_") <= 0) continue;
                    }
                }
                idsWriter.flush();
                publicWriter.flush();
            }
            idsWriter.println("</resources>");
            publicWriter.println("</resources>");
        }
        catch (Exception e) {
            throw new PatchUtilException(e);
        }
        finally {
            if (idsWriter != null) {
                idsWriter.flush();
                idsWriter.close();
            }
            if (publicWriter != null) {
                publicWriter.flush();
                publicWriter.close();
            }
        }
    }

    public static class PatchUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 5982003304074821184L;

        public PatchUtilException(String message) {
            super(message);
        }

        public PatchUtilException(Throwable cause) {
            super(cause);
        }

        public PatchUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PublicResourceEntry {
        private RDotTxtEntry.RType rType = null;
        private String resourceName = null;

        public PublicResourceEntry(RDotTxtEntry.RType rType, String resourceName) {
            this.rType = rType;
            this.resourceName = resourceName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PublicResourceEntry)) {
                return false;
            }
            PublicResourceEntry that = (PublicResourceEntry)obj;
            return ObjectUtil.equal((Object)this.rType, (Object)that.rType) && ObjectUtil.equal(this.resourceName, that.resourceName);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.rType, this.resourceName});
        }
    }
}

