/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.hotplug.UnsupportedEnvironmentException;
import com.tencent.tinker.loader.hotplug.handler.AMSInterceptHandler;
import com.tencent.tinker.loader.hotplug.handler.MHMessageHandler;
import com.tencent.tinker.loader.hotplug.handler.PMSInterceptHandler;
import com.tencent.tinker.loader.hotplug.interceptor.HandlerMessageInterceptor;
import com.tencent.tinker.loader.hotplug.interceptor.ServiceBinderInterceptor;
import com.tencent.tinker.loader.hotplug.interceptor.TinkerHackInstrumentation;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.lang.reflect.Field;

public final class ComponentHotplug {
    private static final String TAG = "Tinker.ComponentHotplug";
    private static volatile boolean sInstalled = false;
    private static ServiceBinderInterceptor sAMSInterceptor;
    private static ServiceBinderInterceptor sPMSInterceptor;
    private static HandlerMessageInterceptor sMHMessageInterceptor;
    private static TinkerHackInstrumentation sTinkerHackInstrumentation;

    public static synchronized void install(TinkerApplication app, ShareSecurityCheck checker) throws UnsupportedEnvironmentException {
        if (!sInstalled) {
            try {
                if (IncrementComponentManager.init((Context)app, checker)) {
                    sAMSInterceptor = new ServiceBinderInterceptor((Context)app, "activity", new AMSInterceptHandler((Context)app));
                    sPMSInterceptor = new ServiceBinderInterceptor((Context)app, "package", new PMSInterceptHandler());
                    sAMSInterceptor.install();
                    sPMSInterceptor.install();
                    if (Build.VERSION.SDK_INT < 27) {
                        Handler mH = ComponentHotplug.fetchMHInstance((Context)app);
                        sMHMessageInterceptor = new HandlerMessageInterceptor(mH, new MHMessageHandler((Context)app));
                        sMHMessageInterceptor.install();
                    } else {
                        sTinkerHackInstrumentation = TinkerHackInstrumentation.create((Context)app);
                        sTinkerHackInstrumentation.install();
                    }
                    sInstalled = true;
                    ShareTinkerLog.i(TAG, "installed successfully.", new Object[0]);
                }
            }
            catch (Throwable thr) {
                ComponentHotplug.uninstall();
                throw new UnsupportedEnvironmentException(thr);
            }
        }
    }

    public static synchronized void ensureComponentHotplugInstalled(TinkerApplication app) throws UnsupportedEnvironmentException {
        if (sInstalled) {
            try {
                sAMSInterceptor.install();
                sPMSInterceptor.install();
                if (Build.VERSION.SDK_INT < 27) {
                    sMHMessageInterceptor.install();
                }
                sTinkerHackInstrumentation.install();
            }
            catch (Throwable thr) {
                ComponentHotplug.uninstall();
                throw new UnsupportedEnvironmentException(thr);
            }
        } else {
            ShareTinkerLog.i(TAG, "method install() is not invoked, ignore ensuring operations.", new Object[0]);
        }
    }

    private static Handler fetchMHInstance(Context context) {
        Object activityThread = ShareReflectUtil.getActivityThread(context, null);
        if (activityThread == null) {
            throw new IllegalStateException("failed to fetch instance of ActivityThread.");
        }
        try {
            Field mHField = ShareReflectUtil.findField(activityThread, "mH");
            Handler mH = (Handler)mHField.get(activityThread);
            return mH;
        }
        catch (Throwable thr) {
            throw new IllegalStateException(thr);
        }
    }

    public static synchronized void uninstall() {
        if (sInstalled) {
            try {
                sAMSInterceptor.uninstall();
                sPMSInterceptor.uninstall();
                if (Build.VERSION.SDK_INT < 27) {
                    sMHMessageInterceptor.uninstall();
                } else {
                    sTinkerHackInstrumentation.uninstall();
                }
            }
            catch (Throwable thr) {
                ShareTinkerLog.e(TAG, "exception when uninstall.", thr);
            }
            sInstalled = false;
        }
    }

    private ComponentHotplug() {
        throw new UnsupportedOperationException();
    }
}

