/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerResourcePatcher;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareResPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.Serializable;

public class TinkerResourceLoader {
    protected static final String RESOURCE_META_FILE = "assets/res_meta.txt";
    protected static final String RESOURCE_FILE = "resources.apk";
    protected static final String RESOURCE_PATH = "res";
    private static final String TAG = "Tinker.ResourceLoader";
    private static ShareResPatchInfo resPatchInfo = new ShareResPatchInfo();

    private TinkerResourceLoader() {
    }

    public static boolean loadTinkerResources(TinkerApplication application, String directory, Intent intentResult) {
        if (resPatchInfo == null || TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        String resourceString = directory + "/" + RESOURCE_PATH + "/" + RESOURCE_FILE;
        File resourceFile = new File(resourceString);
        long start = System.currentTimeMillis();
        if (application.isTinkerLoadVerifyFlag()) {
            if (!SharePatchFileUtil.checkResourceArscMd5(resourceFile, TinkerResourceLoader.resPatchInfo.resArscMd5)) {
                ShareTinkerLog.e(TAG, "Failed to load resource file, path: " + resourceFile.getPath() + ", expect md5: " + TinkerResourceLoader.resPatchInfo.resArscMd5, new Object[0]);
                ShareIntentUtil.setIntentReturnCode(intentResult, -24);
                return false;
            }
            ShareTinkerLog.i(TAG, "verify resource file:" + resourceFile.getPath() + " md5, use time: " + (System.currentTimeMillis() - start), new Object[0]);
        }
        try {
            TinkerResourcePatcher.monkeyPatchExistingResources((Context)application, resourceString, false);
            ShareTinkerLog.i(TAG, "monkeyPatchExistingResources resource file:" + resourceString + ", use time: " + (System.currentTimeMillis() - start), new Object[0]);
        }
        catch (Throwable e) {
            ShareTinkerLog.e(TAG, "install resources failed", new Object[0]);
            try {
                SystemClassLoaderAdder.uninstallPatchDex(application.getClassLoader());
            }
            catch (Throwable throwable) {
                ShareTinkerLog.e(TAG, "uninstallPatchDex failed", e);
            }
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -23);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(Context context, String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String meta = securityCheck.getMetaContentMap().get(RESOURCE_META_FILE);
        if (meta == null) {
            return true;
        }
        ShareResPatchInfo.parseResPatchInfoFirstLine(meta, resPatchInfo);
        if (TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        if (!ShareResPatchInfo.checkResPatchInfo(resPatchInfo)) {
            intentResult.putExtra("intent_patch_package_patch_check", -8);
            ShareIntentUtil.setIntentReturnCode(intentResult, -8);
            return false;
        }
        String resourcePath = directory + "/" + RESOURCE_PATH + "/";
        File resourceDir = new File(resourcePath);
        if (!resourceDir.exists() || !resourceDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -21);
            return false;
        }
        File resourceFile = new File(resourcePath + RESOURCE_FILE);
        if (!SharePatchFileUtil.isLegalFile(resourceFile)) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -22);
            return false;
        }
        try {
            TinkerResourcePatcher.isResourceCanPatch(context);
        }
        catch (Throwable e) {
            ShareTinkerLog.e(TAG, "resource hook check failed.", e);
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -23);
            return false;
        }
        return true;
    }
}

