/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.util.HashMap;

public class TinkerLoadResult {
    private static final String TAG = "Tinker.TinkerLoadResult";
    public SharePatchInfo patchInfo;
    public String currentVersion;
    public String oatDir;
    public boolean versionChanged;
    public boolean useInterpretMode;
    public boolean systemOTA;
    public File patchVersionDirectory;
    public File patchVersionFile;
    public File dexDirectory;
    public File libraryDirectory;
    public File resourceDirectory;
    public File resourceFile;
    public HashMap<String, String> dexes;
    public HashMap<String, String> libs;
    public HashMap<String, String> packageConfig;
    public int loadCode;
    public long costTime;

    public boolean parseTinkerResult(Context context, Intent intentResult) {
        int errorCode;
        Throwable exception;
        Tinker tinker = Tinker.with(context);
        this.loadCode = ShareIntentUtil.getIntentReturnCode((Intent)intentResult);
        this.costTime = ShareIntentUtil.getIntentPatchCostTime((Intent)intentResult);
        this.systemOTA = ShareIntentUtil.getBooleanExtra((Intent)intentResult, (String)"intent_patch_system_ota", (boolean)false);
        this.oatDir = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_oat_dir");
        this.useInterpretMode = "interpet".equals(this.oatDir);
        boolean isMainProcess = tinker.isMainProcess();
        ShareTinkerLog.i((String)TAG, (String)"parseTinkerResult loadCode:%d, process name:%s, main process:%b, systemOTA:%b, fingerPrint:%s, oatDir:%s, useInterpretMode:%b", (Object[])new Object[]{this.loadCode, ShareTinkerInternals.getProcessName((Context)context), isMainProcess, this.systemOTA, Build.FINGERPRINT, this.oatDir, this.useInterpretMode});
        String oldVersion = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_old_version");
        String newVersion = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_new_version");
        File patchDirectory = tinker.getPatchDirectory();
        File patchInfoFile = tinker.getPatchInfoFile();
        if (oldVersion != null && newVersion != null) {
            this.currentVersion = isMainProcess ? newVersion : oldVersion;
            ShareTinkerLog.i((String)TAG, (String)"parseTinkerResult oldVersion:%s, newVersion:%s, current:%s", (Object[])new Object[]{oldVersion, newVersion, this.currentVersion});
            String patchName = SharePatchFileUtil.getPatchVersionDirectory((String)this.currentVersion);
            if (!ShareTinkerInternals.isNullOrNil((String)patchName)) {
                this.patchVersionDirectory = new File(patchDirectory.getAbsolutePath() + "/" + patchName);
                this.patchVersionFile = new File(this.patchVersionDirectory.getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile((String)this.currentVersion));
                this.dexDirectory = new File(this.patchVersionDirectory, "dex");
                this.libraryDirectory = new File(this.patchVersionDirectory, "lib");
                this.resourceDirectory = new File(this.patchVersionDirectory, "res");
                this.resourceFile = new File(this.resourceDirectory, "resources.apk");
            }
            boolean isProtectedApp = ShareIntentUtil.getBooleanExtra((Intent)intentResult, (String)"intent_is_protected_app", (boolean)false);
            this.patchInfo = new SharePatchInfo(oldVersion, newVersion, isProtectedApp, "", Build.FINGERPRINT, this.oatDir, false);
            boolean bl = this.versionChanged = !oldVersion.equals(newVersion);
        }
        if ((exception = ShareIntentUtil.getIntentPatchException((Intent)intentResult)) != null) {
            ShareTinkerLog.i((String)TAG, (String)"Tinker load have exception loadCode:%d", (Object[])new Object[]{this.loadCode});
            errorCode = -1;
            switch (this.loadCode) {
                case -20: {
                    errorCode = -1;
                    break;
                }
                case -14: {
                    errorCode = -2;
                    break;
                }
                case -23: {
                    errorCode = -3;
                    break;
                }
                case -25: {
                    errorCode = -4;
                    break;
                }
            }
            tinker.getLoadReporter().onLoadException(exception, errorCode);
            return false;
        }
        switch (this.loadCode) {
            case -10000: {
                ShareTinkerLog.e((String)TAG, (String)"can't get the right intent return code", (Object[])new Object[0]);
                throw new TinkerRuntimeException("can't get the right intent return code");
            }
            case -1: {
                ShareTinkerLog.w((String)TAG, (String)"tinker is disable, just return", (Object[])new Object[0]);
                break;
            }
            case -3: 
            case -2: {
                ShareTinkerLog.w((String)TAG, (String)"can't find patch file, is ok, just return", (Object[])new Object[0]);
                break;
            }
            case -4: {
                ShareTinkerLog.e((String)TAG, (String)"path info corrupted", (Object[])new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted(oldVersion, newVersion, patchInfoFile);
                break;
            }
            case -5: {
                ShareTinkerLog.e((String)TAG, (String)"path info blank, wait main process to restart", (Object[])new Object[0]);
                break;
            }
            case -6: {
                ShareTinkerLog.e((String)TAG, (String)"patch version directory not found, current version:%s", (Object[])new Object[]{this.currentVersion});
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionDirectory, 1, true);
                break;
            }
            case -7: {
                ShareTinkerLog.e((String)TAG, (String)"patch version file not found, current version:%s", (Object[])new Object[]{this.currentVersion});
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error load patch version file not exist, but file is null");
                }
                tinker.getLoadReporter().onLoadFileNotFound(this.patchVersionFile, 1, false);
                break;
            }
            case -8: {
                ShareTinkerLog.i((String)TAG, (String)"patch package check fail", (Object[])new Object[0]);
                if (this.patchVersionFile == null) {
                    throw new TinkerRuntimeException("error patch package check fail , but file is null");
                }
                errorCode = intentResult.getIntExtra("intent_patch_package_patch_check", -10000);
                tinker.getLoadReporter().onLoadPackageCheckFail(this.patchVersionFile, errorCode);
                break;
            }
            case -9: {
                if (this.dexDirectory != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch dex file directory not found:%s", (Object[])new Object[]{this.dexDirectory.getAbsolutePath()});
                    tinker.getLoadReporter().onLoadFileNotFound(this.dexDirectory, 3, true);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch dex file directory not found, warning why the path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch dex file directory not found, warning why the path is null!!!!");
            }
            case -10: {
                String dexPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_dex_path");
                if (dexPath != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch dex file not found:%s", (Object[])new Object[]{dexPath});
                    tinker.getLoadReporter().onLoadFileNotFound(new File(dexPath), 3, false);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch dex file not found, but path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch dex file not found, but path is null!!!!");
            }
            case -11: {
                String dexOptPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_dex_path");
                if (dexOptPath != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch dex opt file not found:%s", (Object[])new Object[]{dexOptPath});
                    tinker.getLoadReporter().onLoadFileNotFound(new File(dexOptPath), 4, false);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch dex opt file not found, but path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch dex opt file not found, but path is null!!!!");
            }
            case -17: {
                if (this.patchVersionDirectory != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch lib file directory not found:%s", (Object[])new Object[]{this.libraryDirectory.getAbsolutePath()});
                    tinker.getLoadReporter().onLoadFileNotFound(this.libraryDirectory, 5, true);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch lib file directory not found, warning why the path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch lib file directory not found, warning why the path is null!!!!");
            }
            case -18: {
                String libPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_missing_lib_path");
                if (libPath != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch lib file not found:%s", (Object[])new Object[]{libPath});
                    tinker.getLoadReporter().onLoadFileNotFound(new File(libPath), 5, false);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch lib file not found, but path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch lib file not found, but path is null!!!!");
            }
            case -12: {
                ShareTinkerLog.e((String)TAG, (String)"patch dex load fail, classloader is null", (Object[])new Object[0]);
                break;
            }
            case -13: {
                String mismatchPath = ShareIntentUtil.getStringExtra((Intent)intentResult, (String)"intent_patch_mismatch_dex_path");
                if (mismatchPath == null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch dex file md5 is mismatch, but path is null!!!!", (Object[])new Object[0]);
                    throw new TinkerRuntimeException("patch dex file md5 is mismatch, but path is null!!!!");
                }
                ShareTinkerLog.e((String)TAG, (String)"patch dex file md5 is mismatch: %s", (Object[])new Object[]{mismatchPath});
                tinker.getLoadReporter().onLoadFileMd5Mismatch(new File(mismatchPath), 3);
                break;
            }
            case -19: {
                ShareTinkerLog.i((String)TAG, (String)"rewrite patch info file corrupted", (Object[])new Object[0]);
                tinker.getLoadReporter().onLoadPatchInfoCorrupted(oldVersion, newVersion, patchInfoFile);
                break;
            }
            case -21: {
                if (this.patchVersionDirectory != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch resource file directory not found:%s", (Object[])new Object[]{this.resourceDirectory.getAbsolutePath()});
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceDirectory, 6, true);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch resource file directory not found, warning why the path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch resource file directory not found, warning why the path is null!!!!");
            }
            case -22: {
                if (this.patchVersionDirectory != null) {
                    ShareTinkerLog.e((String)TAG, (String)"patch resource file not found:%s", (Object[])new Object[]{this.resourceFile.getAbsolutePath()});
                    tinker.getLoadReporter().onLoadFileNotFound(this.resourceFile, 6, false);
                    break;
                }
                ShareTinkerLog.e((String)TAG, (String)"patch resource file not found, warning why the path is null!!!!", (Object[])new Object[0]);
                throw new TinkerRuntimeException("patch resource file not found, warning why the path is null!!!!");
            }
            case -24: {
                if (this.resourceFile == null) {
                    ShareTinkerLog.e((String)TAG, (String)"resource file md5 mismatch, but patch resource file not found!", (Object[])new Object[0]);
                    throw new TinkerRuntimeException("resource file md5 mismatch, but patch resource file not found!");
                }
                ShareTinkerLog.e((String)TAG, (String)"patch resource file md5 is mismatch: %s", (Object[])new Object[]{this.resourceFile.getAbsolutePath()});
                tinker.getLoadReporter().onLoadFileMd5Mismatch(this.resourceFile, 6);
                break;
            }
            case -15: {
                tinker.getLoadReporter().onLoadInterpret(1, ShareIntentUtil.getIntentInterpretException((Intent)intentResult));
                break;
            }
            case -16: {
                tinker.getLoadReporter().onLoadInterpret(2, ShareIntentUtil.getIntentInterpretException((Intent)intentResult));
                break;
            }
            case 0: {
                ShareTinkerLog.i((String)TAG, (String)"oh yeah, tinker load all success", (Object[])new Object[0]);
                tinker.setTinkerLoaded(true);
                this.dexes = ShareIntentUtil.getIntentPatchDexPaths((Intent)intentResult);
                this.libs = ShareIntentUtil.getIntentPatchLibsPaths((Intent)intentResult);
                this.packageConfig = ShareIntentUtil.getIntentPackageConfig((Intent)intentResult);
                if (this.useInterpretMode) {
                    tinker.getLoadReporter().onLoadInterpret(0, null);
                }
                if (isMainProcess && this.versionChanged) {
                    tinker.getLoadReporter().onLoadPatchVersionChanged(oldVersion, newVersion, patchDirectory, this.patchVersionDirectory.getName());
                }
                return true;
            }
        }
        return false;
    }

    public String getPackageConfigByName(String name) {
        if (this.packageConfig != null) {
            return this.packageConfig.get(name);
        }
        return null;
    }
}

