/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.Serializable;

public abstract class AbstractResultService
extends IntentService {
    private static final String TAG = "Tinker.AbstractResultService";
    private static final String RESULT_EXTRA = "result_extra";

    public AbstractResultService() {
        super("TinkerResultService");
    }

    public static void runResultService(Context context, PatchResult result, String resultServiceClass) {
        if (resultServiceClass == null) {
            throw new TinkerRuntimeException("resultServiceClass is null.");
        }
        try {
            Intent intent = new Intent();
            intent.setClassName(context, resultServiceClass);
            intent.putExtra(RESULT_EXTRA, (Serializable)result);
            context.startService(intent);
        }
        catch (Throwable throwable) {
            ShareTinkerLog.e((String)TAG, (String)("run result service fail, exception:" + throwable), (Object[])new Object[0]);
        }
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            ShareTinkerLog.e((String)TAG, (String)"AbstractResultService received a null intent, ignoring.", (Object[])new Object[0]);
            return;
        }
        PatchResult result = (PatchResult)ShareIntentUtil.getSerializableExtra((Intent)intent, (String)RESULT_EXTRA);
        this.onPatchResult(result);
    }

    public abstract void onPatchResult(PatchResult var1);
}

