/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.content.ContentResolver;
import android.net.Uri;
import com.tencent.qcloud.core.util.QCloudUtils;
import com.tencent.tac.storage.TACStorageDeleteTask;
import com.tencent.tac.storage.TACStorageDownloadTask;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageService;
import com.tencent.tac.storage.TACStorageUploadTask;
import com.tencent.tac.storage.a;
import java.io.InputStream;

public class TACStorageReference {
    private final Uri a;
    private final TACStorageService b;

    TACStorageReference(Uri uri, TACStorageService service) {
        this.b = service;
        this.a = uri;
    }

    public TACStorageReference child(String path) {
        Uri uri = this.a.buildUpon().appendEncodedPath(path).build();
        return new TACStorageReference(uri, this.b);
    }

    public TACStorageReference parent() {
        String string = this.a.getPath();
        if (string != null && !string.equals("/")) {
            int n = string.lastIndexOf(47);
            string = n == -1 ? "/" : string.substring(0, n);
            Uri uri = this.a.buildUpon().path(string).build();
            return new TACStorageReference(uri, this.b);
        }
        return null;
    }

    public TACStorageReference root() {
        Uri uri = this.a.buildUpon().path("").build();
        return new TACStorageReference(uri, this.b);
    }

    public String getPath() {
        return this.a.getPath();
    }

    public String getBucket() {
        return this.b.a();
    }

    public String getRegion() {
        return this.b.b();
    }

    public String getName() {
        String string = this.a.getPath();
        int n = string.lastIndexOf(47);
        return n != -1 ? string.substring(n + 1) : string;
    }

    public TACStorageUploadTask putData(byte[] data, TACStorageMetadata metadata) {
        TACStorageUploadTask tACStorageUploadTask = new TACStorageUploadTask(this.b, this, metadata, data);
        tACStorageUploadTask.a();
        return tACStorageUploadTask;
    }

    public TACStorageUploadTask putFile(Uri fileUri, TACStorageMetadata metadata, String uploadId) {
        long l = QCloudUtils.getUriContentLength((Uri)fileUri, (ContentResolver)this.b.c().getContentResolver());
        if (l < 0L) {
            throw new IllegalArgumentException("file not exists : " + fileUri);
        }
        TACStorageUploadTask tACStorageUploadTask = l <= 0x200000L ? new TACStorageUploadTask(this.b, this, metadata, fileUri) : new a(this.b, this, metadata, fileUri, l, uploadId);
        tACStorageUploadTask.a();
        return tACStorageUploadTask;
    }

    public TACStorageUploadTask putFile(Uri fileUri, TACStorageMetadata metadata) {
        return this.putFile(fileUri, metadata, null);
    }

    public TACStorageUploadTask putStream(InputStream inputStream, TACStorageMetadata metadata) {
        TACStorageUploadTask tACStorageUploadTask = new TACStorageUploadTask(this.b, this, metadata, this.b.c(), inputStream);
        tACStorageUploadTask.a();
        return tACStorageUploadTask;
    }

    public TACStorageDownloadTask downloadToFile(Uri fileUri) {
        TACStorageDownloadTask tACStorageDownloadTask = new TACStorageDownloadTask(this.b, this, fileUri);
        tACStorageDownloadTask.a();
        return tACStorageDownloadTask;
    }

    public TACStorageDeleteTask delete() {
        TACStorageDeleteTask tACStorageDeleteTask = new TACStorageDeleteTask(this.b, this);
        tACStorageDeleteTask.a();
        return tACStorageDeleteTask;
    }
}

