/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.util.Xml;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageReference;
import com.tencent.tac.storage.TACStorageTask;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;

public class TACStorageTaskSnapshot {
    private final TACStorageTask storageTask;
    private final long bytesTransferred;
    private final long totalByteCount;
    private final Exception exception;
    private String uploadId;

    TACStorageTaskSnapshot(TACStorageTask storageTask) {
        this.storageTask = storageTask;
        this.bytesTransferred = -1L;
        this.totalByteCount = -1L;
        this.exception = null;
    }

    TACStorageTaskSnapshot(TACStorageTask storageTask, long bytesTransferred, long totalByteCount) {
        this.bytesTransferred = bytesTransferred;
        this.totalByteCount = totalByteCount;
        this.storageTask = storageTask;
        this.exception = null;
    }

    TACStorageTaskSnapshot(TACStorageTask storageTask, Exception exception) {
        this.storageTask = storageTask;
        this.exception = exception;
        this.bytesTransferred = -1L;
        this.totalByteCount = -1L;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public TACStorageTask getTask() {
        return this.storageTask;
    }

    public TACStorageReference getStorage() {
        return this.storageTask.getReference();
    }

    public TACStorageMetadata getMetadata() {
        return this.storageTask.getMetadata();
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getTotalByteCount() {
        return this.totalByteCount;
    }

    public Exception getError() {
        if (this.exception != null) {
            return this.exception;
        }
        HttpTask httpTask = this.storageTask.getHttpTask();
        if (httpTask != null && httpTask.getException() != null) {
            return httpTask.getException();
        }
        if (httpTask != null && !httpTask.isSuccessful() && httpTask.getResult() != null) {
            QCloudServiceException serviceException = httpTask.getResult().asException();
            this.parseError((String)httpTask.getResult().content(), serviceException);
            return serviceException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseError(String contentString, QCloudServiceException exception) {
        try (StringReader reader = new StringReader(contentString);){
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput((Reader)reader);
            int eventType = xmlPullParser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String tagName = xmlPullParser.getName();
                        if (tagName.equalsIgnoreCase("Code")) {
                            xmlPullParser.next();
                            exception.setErrorCode(xmlPullParser.getText());
                            break;
                        }
                        if (tagName.equalsIgnoreCase("Message")) {
                            xmlPullParser.next();
                            exception.setErrorMessage(xmlPullParser.getText());
                            break;
                        }
                        if (!tagName.equalsIgnoreCase("RequestId")) break;
                        xmlPullParser.next();
                        exception.setRequestId(xmlPullParser.getText());
                    }
                }
                eventType = xmlPullParser.next();
            }
        }
    }
}

