/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.tac.storage.StorageProgressListener;
import com.tencent.tac.storage.StorageResultListener;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageReference;
import com.tencent.tac.storage.TACStorageService;
import com.tencent.tac.storage.TACStorageTaskResultForwarder;
import com.tencent.tac.storage.TACStorageTaskSnapshot;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class TACStorageTask<T> {
    static final String X_WWW_FORM_URLENCODE = "application/x-www-form-urlencoded";
    private final TACStorageReference reference;
    private final TACStorageService service;
    private final TACStorageMetadata metadata;
    private HttpTask<T> httpTask;

    protected TACStorageTask(TACStorageService service, TACStorageReference reference) {
        this.reference = reference;
        this.service = service;
        this.metadata = new TACStorageMetadata.Builder().build();
    }

    public TACStorageReference getReference() {
        return this.reference;
    }

    public TACStorageService getService() {
        return this.service;
    }

    public TACStorageMetadata getMetadata() {
        return this.metadata;
    }

    public void cancel() {
        this.httpTask.cancel();
    }

    public TACStorageTask<T> addResultListener(StorageResultListener<TACStorageTaskSnapshot> listener) {
        this.httpTask.addResultListener(new TACStorageTaskResultForwarder(this, listener));
        return this;
    }

    public TACStorageTask<T> removeResultListener(StorageResultListener<TACStorageTaskSnapshot> listener) {
        List listeners = this.httpTask.getAllResultListeners();
        for (QCloudResultListener resultListener : listeners) {
            if (((TACStorageTaskResultForwarder)resultListener).getResultListener() != listener) continue;
            this.httpTask.removeResultListener(resultListener);
            break;
        }
        return this;
    }

    public void removeAllListeners() {
        this.httpTask.removeAllListeners();
    }

    public TACStorageTask<T> addProgressListener(StorageProgressListener<TACStorageTaskSnapshot> listener) {
        this.httpTask.addProgressListener(new TACStorageTaskResultForwarder(this, listener));
        return this;
    }

    public TACStorageTask<T> removeProgressListener(StorageProgressListener<TACStorageTaskSnapshot> listener) {
        List listeners = this.httpTask.getAllProgressListeners();
        for (QCloudProgressListener progressListener : listeners) {
            if (((TACStorageTaskResultForwarder)progressListener).getProgressListener() != listener) continue;
            this.httpTask.removeProgressListener(progressListener);
            break;
        }
        return this;
    }

    abstract void enqueue();

    void scheduleRequest(QCloudHttpRequest<T> httpRequest) {
        this.httpTask = this.getService().schedule(httpRequest);
        this.httpTask.observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR);
    }

    void resolveRequest(QCloudHttpRequest<T> httpRequest) {
        this.httpTask = this.getService().resolveRequest(httpRequest);
    }

    HttpTask<T> getHttpTask() {
        return this.httpTask;
    }

    QCloudHttpRequest.Builder<T> newRequest() {
        String host = this.getHost();
        return new QCloudHttpRequest.Builder().scheme("http").host(host).tag((Object)"tac-storage").userAgent("tac-storage-0.8.2").setUseCache(false).addHeader("Host", host).signer("CosXmlSigner", (QCloudSignSourceProvider)new COSXmlSignSourceProvider(600L));
    }

    <TType> QCloudHttpRequest.Builder<TType> newRequest(Class<TType> type) {
        String host = this.getHost();
        return new QCloudHttpRequest.Builder().scheme("http").host(host).tag((Object)"tac-storage").userAgent("tac-storage-0.8.2").setUseCache(false).addHeader("Host", host).signer("CosXmlSigner", (QCloudSignSourceProvider)new COSXmlSignSourceProvider(600L));
    }

    private String getHost() {
        String bucket = this.service.getBucket();
        String region = this.service.getRegion();
        String suffix = "myqcloud.com";
        return bucket + ".cos." + region + "." + suffix;
    }
}

