/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.SessionCredentialProvider;
import com.tencent.qcloud.core.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class TACStorageOptions {
    private List<Pair<String, String>> buckets;
    private QCloudCredentialProvider credentialProvider;

    TACStorageOptions(Context context, JSONObject config) {
        String bucket = config.optString("bucket");
        if (bucket != null) {
            this.buckets = new ArrayList<Pair<String, String>>(1);
            this.buckets.add((Pair<String, String>)new Pair((Object)bucket, (Object)config.optString("region")));
        }
    }

    String[] getBucketNameAndAppId(String bucket) {
        String appId;
        int splitter;
        if (!TextUtils.isEmpty((CharSequence)bucket) && (splitter = bucket.lastIndexOf(45)) > 0 && TextUtils.isDigitsOnly((CharSequence)(appId = bucket.substring(splitter + 1)))) {
            return new String[]{bucket.substring(0, splitter), appId};
        }
        return null;
    }

    public String getDefaultBucket() {
        return this.buckets != null && this.buckets.size() > 0 ? (String)this.buckets.get((int)0).first : null;
    }

    public void setCredentialProvider(HttpRequest<String> credentialProvider) {
        this.credentialProvider = new SessionCredentialProvider(credentialProvider);
    }

    public void setCredentialProvider(QCloudCredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    QCloudCredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    String getRegion(String bucketName) {
        for (Pair<String, String> bucket : this.buckets) {
            if (!((String)bucket.first).equals(bucketName)) continue;
            return (String)bucket.second;
        }
        return null;
    }
}

