/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.text.TextUtils;
import android.util.SparseArray;
import android.util.Xml;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageReference;
import com.tencent.tac.storage.TACStorageService;
import com.tencent.tac.storage.TACStorageUploadTask;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

final class TACStorageMultiPartUploadTask
extends TACStorageUploadTask {
    private static final long PART_SIZE = 0x100000L;
    private static final String ERROR_ETAG_PLACEHOLDER = "error_placeholder";
    private final File uploadFile;
    private final long totalUploadLength;
    private final int partCount;
    private SparseArray<String> completeUploadRequestETags;
    private String uploadId;
    private AtomicLong bytesTransferred = new AtomicLong(0L);
    private AtomicBoolean isTerminated = new AtomicBoolean(false);
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private HttpTask<Void> placeHolderTask;
    private List<HttpTask<Void>> uploadTasks;
    private HttpTask<String> initTask;
    private HttpTask<Void> completeTask;
    private HttpTask<String> listPartsTask;
    private QCloudClientException mUploadPartsClientException;
    private QCloudServiceException mUploadPartsServiceException;
    private QCloudResultListener<HttpResult<String>> mInitListener = new QCloudResultListener<HttpResult<String>>(){

        public void onSuccess(HttpResult<String> result) {
            if (result.isSuccessful()) {
                TACStorageMultiPartUploadTask.this.parseUploadId((String)result.content());
                if (TextUtils.isEmpty((CharSequence)TACStorageMultiPartUploadTask.this.uploadId)) {
                    TACStorageMultiPartUploadTask.this.invokeErrorListeners(null, new QCloudServiceException("upload id is null"));
                } else {
                    TACStorageMultiPartUploadTask.this.startUploadParts();
                }
            } else {
                TACStorageMultiPartUploadTask.this.invokeErrorListeners(null, result.asException());
            }
        }

        public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
            TACStorageMultiPartUploadTask.this.invokeErrorListeners(clientException, serviceException);
        }
    };
    private QCloudResultListener<HttpResult<String>> mListPartsListener = new QCloudResultListener<HttpResult<String>>(){

        public void onSuccess(HttpResult<String> result) {
            if (result.isSuccessful()) {
                TACStorageMultiPartUploadTask.this.parseCompleteParts((String)result.content());
                if (TACStorageMultiPartUploadTask.this.isAllPartsUploadCompleted() && TACStorageMultiPartUploadTask.this.isAllPartsUploadSuccess()) {
                    TACStorageMultiPartUploadTask.this.sendCompleteUploadRequest();
                } else {
                    TACStorageMultiPartUploadTask.this.startUploadParts();
                }
            } else {
                TACStorageMultiPartUploadTask.this.invokeErrorListeners(null, result.asException());
            }
        }

        public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
            TACStorageMultiPartUploadTask.this.invokeErrorListeners(clientException, serviceException);
        }
    };

    TACStorageMultiPartUploadTask(TACStorageService service, TACStorageReference reference, TACStorageMetadata metadata, File uploadFile, String uploadId) {
        super(service, reference, metadata);
        this.uploadFile = uploadFile;
        this.totalUploadLength = uploadFile.length();
        this.uploadId = uploadId;
        this.partCount = (int)Math.ceil((double)this.totalUploadLength / 1048576.0);
        this.completeUploadRequestETags = new SparseArray(this.partCount + 1);
    }

    @Override
    public void cancel() {
        if (this.isTerminated.compareAndSet(false, true)) {
            this.pauseWork(true);
            this.sendAbortUploadRequest();
        }
    }

    @Override
    public void resume() {
        if (!this.isTerminated.get()) {
            this.continueWork();
        }
    }

    @Override
    public void pause() {
        if (!this.isTerminated.get()) {
            this.pauseWork(false);
        }
    }

    @Override
    void enqueue() {
        this.resolveRequest(this.newRequest().method("GET").build());
        this.placeHolderTask = this.getHttpTask();
        this.continueWork();
    }

    String getUploadId() {
        return this.uploadId;
    }

    private synchronized void continueWork() {
        if (this.isRunning.compareAndSet(false, true)) {
            if (TextUtils.isEmpty((CharSequence)this.uploadId)) {
                this.sendInitRequest();
            } else {
                this.sendListPartsRequest();
            }
        }
    }

    private synchronized void pauseWork(boolean cancel) {
        if (cancel || this.isRunning.compareAndSet(true, false)) {
            if (cancel) {
                if (this.initTask != null) {
                    this.initTask.cancel();
                }
                if (this.listPartsTask != null) {
                    this.listPartsTask.cancel();
                }
                if (this.completeTask != null) {
                    this.completeTask.cancel();
                }
            }
            if (this.uploadTasks != null) {
                for (HttpTask<Void> task : this.uploadTasks) {
                    if (!cancel && task.isExecuted()) continue;
                    task.cancel();
                }
            }
        }
    }

    private void sendInitRequest() {
        if (this.initTask == null || this.initTask.isCompleted()) {
            this.initTask = this.getService().schedule(this.initUploadRequest());
            this.initTask.addResultListener(this.mInitListener);
        }
    }

    private void sendListPartsRequest() {
        if (this.listPartsTask == null || this.listPartsTask.isCompleted()) {
            this.listPartsTask = this.getService().schedule(this.listPartsRequest(this.uploadId));
            this.listPartsTask.addResultListener(this.mListPartsListener);
        }
    }

    private synchronized void startUploadParts() {
        if (this.uploadTasks == null) {
            this.uploadTasks = new ArrayList<HttpTask<Void>>(this.partCount);
        } else {
            this.uploadTasks.clear();
        }
        for (int i = 1; i < this.partCount + 1; ++i) {
            String etag = (String)this.completeUploadRequestETags.get(i);
            if (ERROR_ETAG_PLACEHOLDER.equals(etag)) {
                this.completeUploadRequestETags.remove(i);
                etag = null;
            }
            if (etag != null) continue;
            QCloudLogger.d((String)"QCloudStorage", (String)"add upload task for part %d", (Object[])new Object[]{i});
            HttpTask<Void> uploadTask = this.getService().schedule(this.uploadPartRequest(i, this.uploadId));
            uploadTask.addResultListener((QCloudResultListener)new UploadPartListener(i)).addProgressListener((QCloudProgressListener)new UploadPartProgressListener());
            this.uploadTasks.add(uploadTask);
        }
    }

    private synchronized void addCompleteEtag(int partNumber, String eTag) {
        if (partNumber >= 0 && eTag != null) {
            QCloudLogger.d((String)"QCloudStorage", (String)"add complete tag %d : %s", (Object[])new Object[]{partNumber, eTag});
            this.completeUploadRequestETags.put(partNumber, (Object)eTag);
        }
    }

    private synchronized boolean isAllPartsUploadCompleted() {
        return this.completeUploadRequestETags.size() == this.partCount;
    }

    private synchronized boolean isAllPartsUploadSuccess() {
        for (int i = 1; i < this.partCount + 1; ++i) {
            if (!ERROR_ETAG_PLACEHOLDER.equals(this.completeUploadRequestETags.get(i))) continue;
            return false;
        }
        return true;
    }

    private void sendCompleteUploadRequest() {
        QCloudHttpRequest<Void> request = this.completeUploadRequest(this.uploadId);
        if (request != null) {
            super.scheduleRequest(request);
            this.completeTask = this.getHttpTask();
            this.completeTask.addResultListeners(this.placeHolderTask.getAllResultListeners());
            this.completeTask.addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<Void>>(){

                public void onSuccess(HttpResult<Void> result) {
                    TACStorageMultiPartUploadTask.this.isRunning.set(false);
                }

                public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                    TACStorageMultiPartUploadTask.this.isRunning.set(false);
                }
            });
        }
    }

    private void invokeErrorListeners(QCloudClientException clientException, QCloudServiceException serviceException) {
        this.isRunning.set(false);
        for (QCloudResultListener listener : this.placeHolderTask.getAllResultListeners()) {
            listener.onFailure(clientException, serviceException);
        }
    }

    private void sendAbortUploadRequest() {
        QCloudHttpRequest<Void> request = this.abortUploadRequest(this.uploadId);
        super.scheduleRequest(request);
    }

    private QCloudHttpRequest<String> initUploadRequest() {
        QCloudHttpRequest.Builder initRequestBuilder = this.newRequest(String.class).method("POST").path(this.getReference().getPath()).query("uploads", null).body(RequestBodySerializer.string((String)"text/plain", (String)""));
        this.addCustomMetadata(initRequestBuilder);
        return initRequestBuilder.build();
    }

    private QCloudHttpRequest<Void> uploadPartRequest(int partNumber, String uploadId) {
        return this.newRequest(Void.class).method("PUT").path(this.getReference().getPath()).query("partNumber", "" + partNumber).query("uploadId", uploadId).body(RequestBodySerializer.file((String)"text/plain", (File)this.uploadFile, (long)((long)(partNumber - 1) * 0x100000L), (long)0x100000L)).build();
    }

    private QCloudHttpRequest<String> listPartsRequest(String uploadId) {
        return this.newRequest(String.class).method("GET").path(this.getReference().getPath()).query("uploadId", uploadId).build();
    }

    private QCloudHttpRequest<Void> completeUploadRequest(String uploadId) {
        String body = this.buildCompleteMultipartUpload();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            return this.newRequest(Void.class).method("POST").path(this.getReference().getPath()).query("uploadId", uploadId).body(RequestBodySerializer.string((String)"application/x-www-form-urlencoded", (String)body)).build();
        }
        return null;
    }

    private QCloudHttpRequest<Void> abortUploadRequest(String uploadId) {
        return this.newRequest(Void.class).method("DELETE").path(this.getReference().getPath()).query("uploadId", uploadId).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUploadId(String contentString) {
        try (StringReader reader = new StringReader(contentString);){
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput((Reader)reader);
            int eventType = xmlPullParser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && xmlPullParser.getName().equalsIgnoreCase("UploadId")) {
                    xmlPullParser.next();
                    this.uploadId = xmlPullParser.getText();
                    break;
                }
                eventType = xmlPullParser.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCompleteParts(String contentString) {
        try (StringReader reader = new StringReader(contentString);){
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput((Reader)reader);
            int eventType = xmlPullParser.getEventType();
            int partNumber = -1;
            String eTag = null;
            long partSize = -1L;
            while (eventType != 1) {
                if (eventType == 2) {
                    String tagName = xmlPullParser.getName();
                    if (tagName.equalsIgnoreCase("PartNumber")) {
                        xmlPullParser.next();
                        partNumber = Integer.parseInt(xmlPullParser.getText());
                    } else if (tagName.equalsIgnoreCase("ETag")) {
                        xmlPullParser.next();
                        eTag = xmlPullParser.getText();
                    } else if (tagName.equalsIgnoreCase("Size")) {
                        xmlPullParser.next();
                        partSize = Long.parseLong(xmlPullParser.getText());
                    }
                } else if (eventType == 3 && xmlPullParser.getName().equalsIgnoreCase("Part")) {
                    this.addCompleteEtag(partNumber, eTag);
                    if (partSize > 0L) {
                        this.bytesTransferred.addAndGet(partNumber);
                    }
                    partNumber = -1;
                    eTag = null;
                    partSize = -1L;
                }
                eventType = xmlPullParser.next();
            }
        }
    }

    private synchronized String buildCompleteMultipartUpload() {
        try {
            StringWriter xmlContent = new StringWriter();
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
            xmlSerializer.setOutput((Writer)xmlContent);
            xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xmlSerializer.startDocument("UTF-8", null);
            xmlSerializer.startTag("", "CompleteMultipartUpload");
            if (this.completeUploadRequestETags != null) {
                for (int i = 1; i < this.completeUploadRequestETags.size() + 1; ++i) {
                    xmlSerializer.startTag("", "Part");
                    this.addElement(xmlSerializer, "PartNumber", String.valueOf(i));
                    this.addElement(xmlSerializer, "ETag", (String)this.completeUploadRequestETags.get(i));
                    xmlSerializer.endTag("", "Part");
                }
            }
            xmlSerializer.endTag("", "CompleteMultipartUpload");
            xmlSerializer.endDocument();
            return this.removeXMLHeader(xmlContent.toString());
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addElement(XmlSerializer xmlSerializer, String tag, String value) throws IOException {
        if (value != null) {
            xmlSerializer.startTag("", tag);
            xmlSerializer.text(value);
            xmlSerializer.endTag("", tag);
        }
    }

    private String removeXMLHeader(String xmlContent) {
        if (xmlContent != null && xmlContent.startsWith("<?xml")) {
            int index = xmlContent.indexOf("?>");
            xmlContent = xmlContent.substring(index + 2);
        }
        return xmlContent;
    }

    private class UploadPartProgressListener
    implements QCloudProgressListener {
        private long completeBytes;

        UploadPartProgressListener() {
        }

        public void onProgress(long complete, long target) {
            long delta = complete - this.completeBytes;
            this.completeBytes = complete;
            long currentBytes = TACStorageMultiPartUploadTask.this.bytesTransferred.addAndGet(delta);
            for (QCloudProgressListener progressListener : TACStorageMultiPartUploadTask.this.placeHolderTask.getAllProgressListeners()) {
                progressListener.onProgress(currentBytes, TACStorageMultiPartUploadTask.this.totalUploadLength);
            }
        }
    }

    private class UploadPartListener
    implements QCloudResultListener<HttpResult<Void>> {
        private int partNumber;

        UploadPartListener(int partNumber) {
            this.partNumber = partNumber;
        }

        public void onSuccess(HttpResult<Void> result) {
            if (result.isSuccessful()) {
                TACStorageMultiPartUploadTask.this.addCompleteEtag(this.partNumber, result.header("Etag"));
            } else {
                TACStorageMultiPartUploadTask.this.addCompleteEtag(this.partNumber, TACStorageMultiPartUploadTask.ERROR_ETAG_PLACEHOLDER);
                QCloudLogger.i((String)"QCloudStorage", (String)("upload part fails : " + result.asException()), (Object[])new Object[0]);
            }
            if (TACStorageMultiPartUploadTask.this.isAllPartsUploadCompleted()) {
                if (TACStorageMultiPartUploadTask.this.isAllPartsUploadSuccess()) {
                    TACStorageMultiPartUploadTask.this.sendCompleteUploadRequest();
                } else {
                    TACStorageMultiPartUploadTask.this.invokeErrorListeners(TACStorageMultiPartUploadTask.this.mUploadPartsClientException, TACStorageMultiPartUploadTask.this.mUploadPartsServiceException);
                }
            }
        }

        public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
            QCloudLogger.i((String)"QCloudStorage", (String)("upload part fails : " + (clientException != null ? clientException : serviceException)), (Object[])new Object[0]);
            TACStorageMultiPartUploadTask.this.addCompleteEtag(this.partNumber, TACStorageMultiPartUploadTask.ERROR_ETAG_PLACEHOLDER);
            TACStorageMultiPartUploadTask.this.mUploadPartsClientException = clientException;
            TACStorageMultiPartUploadTask.this.mUploadPartsServiceException = serviceException;
            if (TACStorageMultiPartUploadTask.this.isAllPartsUploadCompleted()) {
                if (TACStorageMultiPartUploadTask.this.isAllPartsUploadSuccess()) {
                    TACStorageMultiPartUploadTask.this.sendCompleteUploadRequest();
                } else {
                    TACStorageMultiPartUploadTask.this.invokeErrorListeners(TACStorageMultiPartUploadTask.this.mUploadPartsClientException, TACStorageMultiPartUploadTask.this.mUploadPartsServiceException);
                }
            }
        }
    }
}

