/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TACStorageMetadata {
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String Expect;
    private final String Expires;
    private final String ContentMD5;
    private final Map<String, List<String>> custom;

    private TACStorageMetadata(Builder builder) {
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.Expect = builder.Expect;
        this.Expires = builder.Expires;
        this.ContentMD5 = builder.ContentMD5;
        this.custom = builder.custom;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentMD5() {
        return this.ContentMD5;
    }

    public String getExpect() {
        return this.Expect;
    }

    public String getExpires() {
        return this.Expires;
    }

    public Map<String, List<String>> getCustomMetadata() {
        return this.custom;
    }

    public static final class Builder {
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String Expect;
        private String Expires;
        private String ContentMD5;
        private Map<String, List<String>> custom = new HashMap<String, List<String>>(5);

        public Builder cacheControl(String val) {
            this.cacheControl = val;
            return this;
        }

        public Builder contentDisposition(String val) {
            this.contentDisposition = val;
            return this;
        }

        public Builder contentEncoding(String val) {
            this.contentEncoding = val;
            return this;
        }

        public Builder contentLanguage(String val) {
            this.contentLanguage = val;
            return this;
        }

        public Builder Expect(String val) {
            this.Expect = val;
            return this;
        }

        public Builder Expires(String val) {
            this.Expires = val;
            return this;
        }

        public Builder ContentMD5(String val) {
            this.ContentMD5 = val;
            return this;
        }

        public Builder addCustomMetadata(String name, String value) {
            List<String> values = this.custom.get(name);
            if (values == null) {
                values = new ArrayList<String>(2);
                this.custom.put(name, values);
            }
            values.add(value.trim());
            return this;
        }

        public TACStorageMetadata build() {
            return new TACStorageMetadata(this);
        }
    }
}

