/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.content.Context;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.tac.storage.StorageProgressListener;
import com.tencent.tac.storage.StorageResultListener;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageReference;
import com.tencent.tac.storage.TACStorageService;
import com.tencent.tac.storage.TACStorageTask;
import com.tencent.tac.storage.TACStorageTaskSnapshot;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class TACStorageUploadTask
extends TACStorageTask<Void> {
    static final String TEXT_PLAIN = "text/plain";
    private final TACStorageMetadata metadata;
    private QCloudHttpRequest.Builder<Void> putObjectRequest;

    TACStorageUploadTask(TACStorageService service, TACStorageReference reference, TACStorageMetadata metadata, byte[] data) {
        this(service, reference, metadata);
        this.putObjectRequest = this.newRequest().method("PUT").addHeader("Content-Type", TEXT_PLAIN).path(reference.getPath()).body(RequestBodySerializer.bytes((String)TEXT_PLAIN, (byte[])data));
    }

    TACStorageUploadTask(TACStorageService service, TACStorageReference reference, TACStorageMetadata metadata, File uploadFile) {
        this(service, reference, metadata);
        this.putObjectRequest = this.newRequest().method("PUT").addHeader("Content-Type", TEXT_PLAIN).path(reference.getPath()).body(RequestBodySerializer.file((String)TEXT_PLAIN, (File)uploadFile));
    }

    TACStorageUploadTask(TACStorageService service, TACStorageReference reference, TACStorageMetadata metadata, Context context, InputStream inputStream) {
        this(service, reference, metadata);
        this.putObjectRequest = this.newRequest().method("PUT").addHeader("Content-Type", TEXT_PLAIN).path(reference.getPath()).body(RequestBodySerializer.stream((String)TEXT_PLAIN, (Context)context, (InputStream)inputStream));
    }

    TACStorageUploadTask(TACStorageService service, TACStorageReference reference, TACStorageMetadata metadata) {
        super(service, reference);
        this.metadata = metadata == null ? new TACStorageMetadata.Builder().build() : metadata;
    }

    @Override
    public TACStorageMetadata getMetadata() {
        return this.metadata;
    }

    void addCustomMetadata(QCloudHttpRequest.Builder httpRequest) {
        if (this.metadata.getCacheControl() != null) {
            httpRequest.addHeader("Cache-Control", this.metadata.getCacheControl());
        }
        if (this.metadata.getContentDisposition() != null) {
            httpRequest.addHeader("Content-Disposition", this.metadata.getContentDisposition());
        }
        if (this.metadata.getContentEncoding() != null) {
            httpRequest.addHeader("Content-Encoding", this.metadata.getContentEncoding());
        }
        if (this.metadata.getContentLanguage() != null) {
            httpRequest.addHeader("Content-Language", this.metadata.getContentLanguage());
        }
        if (this.metadata.getContentMD5() != null) {
            httpRequest.addHeader("Content-MD5", this.metadata.getContentMD5());
        }
        if (this.metadata.getExpect() != null) {
            httpRequest.addHeader("Expect", this.metadata.getExpect());
        }
        if (this.metadata.getExpires() != null) {
            httpRequest.addHeader("Expires", this.metadata.getExpires());
        }
        if (this.metadata.getCustomMetadata() != null) {
            for (String name : this.metadata.getCustomMetadata().keySet()) {
                List<String> values = this.metadata.getCustomMetadata().get(name);
                for (String value : values) {
                    httpRequest.addHeader(name, value);
                }
            }
        }
    }

    public TACStorageUploadTask addProgressListener(StorageProgressListener<TACStorageTaskSnapshot> listener) {
        return (TACStorageUploadTask)super.addProgressListener(listener);
    }

    public TACStorageUploadTask addResultListener(StorageResultListener<TACStorageTaskSnapshot> listener) {
        return (TACStorageUploadTask)super.addResultListener(listener);
    }

    public TACStorageUploadTask removeProgressListener(StorageProgressListener<TACStorageTaskSnapshot> listener) {
        return (TACStorageUploadTask)super.removeProgressListener(listener);
    }

    public TACStorageUploadTask removeResultListener(StorageResultListener<TACStorageTaskSnapshot> listener) {
        return (TACStorageUploadTask)super.removeResultListener(listener);
    }

    @Override
    void enqueue() {
        this.addCustomMetadata(this.putObjectRequest);
        super.scheduleRequest(this.putObjectRequest.build());
    }

    public void pause() {
    }

    public void resume() {
    }
}

