/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.tac.storage.StorageProgressListener;
import com.tencent.tac.storage.StorageResultListener;
import com.tencent.tac.storage.TACStorageMultiPartUploadTask;
import com.tencent.tac.storage.TACStorageTask;
import com.tencent.tac.storage.TACStorageTaskSnapshot;

class TACStorageTaskResultForwarder<T>
implements QCloudResultListener<HttpResult<T>>,
QCloudProgressListener {
    private final TACStorageTask storageTask;
    private final StorageResultListener<TACStorageTaskSnapshot> resultListener;
    private final StorageProgressListener<TACStorageTaskSnapshot> progressListener;

    TACStorageTaskResultForwarder(TACStorageTask storageTask, StorageResultListener<TACStorageTaskSnapshot> listener) {
        this.storageTask = storageTask;
        this.resultListener = listener;
        this.progressListener = null;
    }

    TACStorageTaskResultForwarder(TACStorageTask storageTask, StorageProgressListener<TACStorageTaskSnapshot> listener) {
        this.storageTask = storageTask;
        this.resultListener = null;
        this.progressListener = listener;
    }

    StorageResultListener<TACStorageTaskSnapshot> getResultListener() {
        return this.resultListener;
    }

    StorageProgressListener<TACStorageTaskSnapshot> getProgressListener() {
        return this.progressListener;
    }

    public void onSuccess(HttpResult<T> result) {
        if (this.resultListener != null) {
            if (result.isSuccessful()) {
                this.resultListener.onSuccess(new TACStorageTaskSnapshot(this.storageTask));
            } else {
                this.resultListener.onFailure(new TACStorageTaskSnapshot(this.storageTask));
            }
        }
    }

    public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
        if (this.resultListener != null) {
            this.resultListener.onFailure(new TACStorageTaskSnapshot(this.storageTask, (Exception)(clientException != null ? clientException : serviceException)));
        }
    }

    public void onProgress(long complete, long target) {
        if (this.progressListener != null) {
            TACStorageTaskSnapshot snapshot = new TACStorageTaskSnapshot(this.storageTask, complete, target);
            if (this.storageTask instanceof TACStorageMultiPartUploadTask) {
                snapshot.setUploadId(((TACStorageMultiPartUploadTask)this.storageTask).getUploadId());
            }
            this.progressListener.onProgress(snapshot);
        }
    }
}

